import React from 'react';
import PropTypes from 'prop-types';

const Amex = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="51px"
            height="36px"
            viewBox="0 0 51 36"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="rainbow-UniversalPicker-"
                    transform="translate(-359.000000, -222.000000)"
                    fillRule="nonzero"
                >
                    <g id="amex" transform="translate(359.750000, 222.950000)">
                        <path
                            d="M46.04875,33.85 L3.12730634,33.85 C1.53820423,33.85 0.25,32.5605141 0.25,30.9698532 L0.25,3.13005166 C0.25,1.53939073 1.53820423,0.25 3.12730634,0.25 L46.04875,0.25 C47.6379472,0.25 48.9260563,1.53948589 48.9260563,3.13005166 L48.9260563,30.9698532 C48.9260563,32.5605141 47.6378521,33.85 46.04875,33.85 Z"
                            id="Shape"
                            fill="#FBFBFC"
                        />
                        <path
                            d="M46.04875,1.88293825e-13 L3.12730634,1.88293825e-13 C1.40006551,1.88293825e-13 1.70530257e-13,1.40138703 1.70530257e-13,3.13005166 L1.70530257e-13,30.9698532 C1.70530257e-13,32.6985334 1.40008109,34.1 3.12730634,34.1 L46.04875,34.1 C47.7759753,34.1 49.1760563,32.6985334 49.1760563,30.9698532 L49.1760563,3.13005166 C49.1760563,1.40141901 47.7760228,1.88293825e-13 46.04875,1.88293825e-13 Z M3.12730634,0.5 L46.04875,0.5 C47.4997696,0.5 48.6760563,1.67745074 48.6760563,3.13005166 L48.6760563,30.9698532 C48.6760563,32.4225017 47.4997221,33.6 46.04875,33.6 L3.12730634,33.6 C1.67633423,33.6 0.5,32.4225017 0.5,30.9698532 L0.5,3.13005166 C0.5,1.67742386 1.67631354,0.5 3.12730634,0.5 Z"
                            id="border"
                            fill="#EDEFF2"
                        />
                        <g id="american-express" transform="translate(3.250000, 10.050000)">
                            <polygon
                                id="Path"
                                fill="#2FABF7"
                                points="3.68571429 3.71984127 5.18730159 3.71984127 4.43650794 1.80873016"
                            />
                            <path
                                d="M22.3190476,2.08174603 C22.1825397,2.01349206 21.9777778,2.01349206 21.7730159,2.01349206 L20.4079365,2.01349206 L20.4079365,3.10555556 L21.7730159,3.10555556 C21.9777778,3.10555556 22.1825397,3.10555556 22.3190476,3.03730159 C22.4555556,2.96904762 22.5238095,2.76428571 22.5238095,2.55952381 C22.5920635,2.28650794 22.4555556,2.15 22.3190476,2.08174603 Z"
                                id="Path"
                                fill="#228FE0"
                            />
                            <path
                                d="M36.9253968,0.0341269841 L36.9253968,0.853174603 L36.515873,0.0341269841 L33.3079365,0.0341269841 L33.3079365,0.853174603 L32.8984127,0.0341269841 L28.5301587,0.0341269841 C27.7793651,0.0341269841 27.1650794,0.170634921 26.6190476,0.443650794 L26.6190476,0.0341269841 L23.547619,0.0341269841 L23.547619,0.443650794 C23.2063492,0.170634921 22.7968254,0.0341269841 22.2507937,0.0341269841 L11.2619048,0.0341269841 L10.5111111,1.74047619 L9.76031746,0.0341269841 L6.27936508,0.0341269841 L6.27936508,0.853174603 L5.86984127,0.0341269841 L2.93492063,0.0341269841 L1.56984127,3.24206349 L0,6.79126984 L1.56984127,6.79126984 L3.48095238,6.79126984 L3.89047619,5.69920635 L4.84603175,5.69920635 L5.25555556,6.79126984 L9.21428571,6.79126984 L9.21428571,5.97222222 L9.55555556,6.79126984 L11.5349206,6.79126984 L11.8761905,5.97222222 L11.8761905,6.79126984 L21.3634921,6.79126984 L21.3634921,5.01666667 L21.5,5.01666667 C21.6365079,5.01666667 21.6365079,5.01666667 21.6365079,5.22142857 L21.6365079,6.72301587 L26.5507937,6.72301587 L26.5507937,6.31349206 C26.9603175,6.51825397 27.5746032,6.72301587 28.3936508,6.72301587 L30.4412698,6.72301587 L30.8507937,5.63095238 L31.8063492,5.63095238 L32.215873,6.72301587 L36.1746032,6.72301587 L36.1746032,5.69920635 L36.7888889,6.72301587 L39.9968254,6.72301587 L39.9968254,0.0341269841 L36.9253968,0.0341269841 L36.9253968,0.0341269841 Z M13.8555556,5.76746032 L12.6952381,5.76746032 L12.6952381,2.01349206 L11.0571429,5.76746032 L10.0333333,5.76746032 L8.3952381,2.01349206 L8.3952381,5.76746032 L6.07460317,5.76746032 L5.5968254,4.74365079 L3.27619048,4.74365079 L2.86666667,5.83571429 L1.56984127,5.83571429 L3.61746032,0.98968254 L5.32380952,0.98968254 L7.23492063,5.56269841 L7.23492063,0.98968254 L9.07777778,0.98968254 L10.5793651,4.26587302 L11.9444444,0.98968254 L13.8555556,0.98968254 L13.8555556,5.76746032 Z M18.4968254,2.01349206 L15.8349206,2.01349206 L15.8349206,2.90079365 L18.4285714,2.90079365 L18.4285714,3.85634921 L15.8349206,3.85634921 L15.8349206,4.81190476 L18.4968254,4.81190476 L18.4968254,5.83571429 L14.6746032,5.83571429 L14.6746032,0.98968254 L18.4968254,0.98968254 L18.4968254,2.01349206 Z M23.615873,3.99285714 C23.752381,4.26587302 23.8206349,4.47063492 23.8206349,4.88015873 L23.8206349,5.83571429 L22.6603175,5.83571429 L22.6603175,5.22142857 C22.6603175,4.9484127 22.6603175,4.53888889 22.4555556,4.26587302 C22.2507937,4.06111111 22.0460317,4.06111111 21.6365079,4.06111111 L20.4079365,4.06111111 L20.4079365,5.83571429 L19.247619,5.83571429 L19.247619,0.98968254 L21.8412698,0.98968254 C22.4555556,0.98968254 22.8650794,0.98968254 23.2063492,1.19444444 C23.547619,1.39920635 23.752381,1.74047619 23.752381,2.28650794 C23.752381,3.03730159 23.2746032,3.4468254 22.9333333,3.58333333 C23.2746032,3.6515873 23.4793651,3.85634921 23.615873,3.99285714 Z M25.6634921,5.76746032 L24.5031746,5.76746032 L24.5031746,0.921428571 L25.6634921,0.921428571 L25.6634921,5.76746032 Z M39.1095238,5.76746032 L37.4714286,5.76746032 L35.2873016,2.15 L35.2873016,5.76746032 L32.9666667,5.76746032 L32.5571429,4.74365079 L30.168254,4.74365079 L29.7587302,5.83571429 L28.4619048,5.83571429 C27.915873,5.83571429 27.2333333,5.69920635 26.8238095,5.28968254 C26.4142857,4.88015873 26.2095238,4.33412698 26.2095238,3.4468254 C26.2095238,2.76428571 26.3460317,2.08174603 26.8238095,1.53571429 C27.1650794,1.12619048 27.7793651,0.98968254 28.5301587,0.98968254 L29.6222222,0.98968254 L29.6222222,2.01349206 L28.5301587,2.01349206 C28.1206349,2.01349206 27.915873,2.08174603 27.6428571,2.28650794 C27.4380952,2.49126984 27.3015873,2.90079365 27.3015873,3.37857143 C27.3015873,3.92460317 27.3698413,4.26587302 27.6428571,4.53888889 C27.847619,4.74365079 28.1206349,4.81190476 28.4619048,4.81190476 L28.9396825,4.81190476 L30.5095238,1.05793651 L32.215873,1.05793651 L34.1269841,5.63095238 L34.1269841,1.05793651 L35.8333333,1.05793651 L37.8126984,4.40238095 L37.8126984,1.05793651 L38.9730159,1.05793651 L38.9730159,5.76746032 L39.1095238,5.76746032 L39.1095238,5.76746032 Z"
                                id="Shape"
                                fill="#0571C1"
                            />
                            <g id="Group" transform="translate(17.148810, 1.791667)" fill="#228FE0">
                                <polygon
                                    id="Path"
                                    points="13.4289683 1.9281746 14.9988095 1.9281746 14.2480159 0.0170634921"
                                />
                                <polygon
                                    id="Path"
                                    points="1.82579365 11.756746 1.82579365 7.86626984 0.0511904762 9.77738095"
                                />
                            </g>
                            <polygon
                                id="Path"
                                fill="#2FABF7"
                                points="11.6714286 10.1357143 11.6714286 11.0230159 14.1968254 11.0230159 14.1968254 11.9785714 11.6714286 11.9785714 11.6714286 13.002381 14.4698413 13.002381 15.7666667 11.5690476 14.5380952 10.1357143"
                            />
                            <path
                                d="M21.568254,10.1357143 L20.1349206,10.1357143 L20.1349206,11.3642857 L21.6365079,11.3642857 C22.0460317,11.3642857 22.3190476,11.1595238 22.3190476,10.75 C22.2507937,10.3404762 21.9777778,10.1357143 21.568254,10.1357143 Z"
                                id="SVGCleanerId_0"
                                fill="#228FE0"
                            />
                            <path
                                d="M42.6587302,11.2960317 L42.6587302,8.22460317 L41.8396825,8.22460317 L39.7920635,8.22460317 C39.1777778,8.22460317 38.7,8.36111111 38.3587302,8.63412698 L38.3587302,8.22460317 L35.2190476,8.22460317 C34.7412698,8.22460317 34.1269841,8.36111111 33.8539683,8.63412698 L33.8539683,8.22460317 L28.3253968,8.22460317 L28.3253968,8.63412698 C27.915873,8.29285714 27.1650794,8.22460317 26.8238095,8.22460317 L23.1380952,8.22460317 L23.1380952,8.63412698 C22.7968254,8.29285714 21.9777778,8.22460317 21.568254,8.22460317 L17.4730159,8.22460317 L16.5174603,9.2484127 L15.6301587,8.22460317 L9.48730159,8.22460317 L9.48730159,14.9134921 L15.4936508,14.9134921 L16.4492063,13.8896825 L17.3365079,14.9134921 L21.0222222,14.9134921 L21.0222222,13.3436508 L21.5,13.3436508 C21.9777778,13.3436508 22.5920635,13.3436508 23.0698413,13.1388889 L23.0698413,14.981746 L26.1412698,14.981746 L26.1412698,13.2071429 L26.2777778,13.2071429 C26.4825397,13.2071429 26.4825397,13.2071429 26.4825397,13.4119048 L26.4825397,14.981746 L35.7650794,14.981746 C36.3793651,14.981746 36.9936508,14.8452381 37.3349206,14.5722222 L37.3349206,14.981746 L40.2698413,14.981746 C40.884127,14.981746 41.4984127,14.9134921 41.9079365,14.6404762 L41.9079365,14.6404762 C42.5904762,14.2309524 43,13.4801587 43,12.5928571 C43,12.1150794 42.8634921,11.6373016 42.6587302,11.2960317 Z M21.5,12.3880952 L20.1349206,12.3880952 L20.1349206,14.0261905 L17.9507937,14.0261905 L16.5857143,12.4563492 L15.152381,14.0261905 L10.647619,14.0261905 L10.647619,9.18015873 L15.2206349,9.18015873 L16.5857143,10.75 L18.0190476,9.18015873 L21.6365079,9.18015873 C22.5238095,9.18015873 23.547619,9.4531746 23.547619,10.75 C23.4793651,12.1150794 22.5238095,12.3880952 21.5,12.3880952 Z M28.3253968,12.1150794 C28.4619048,12.3198413 28.5301587,12.5928571 28.5301587,13.002381 L28.5301587,13.9579365 L27.3698413,13.9579365 L27.3698413,13.3436508 C27.3698413,13.0706349 27.3698413,12.5928571 27.1650794,12.3880952 C27.0285714,12.1833333 26.7555556,12.1833333 26.3460317,12.1833333 L25.1174603,12.1833333 L25.1174603,13.9579365 L23.9571429,13.9579365 L23.9571429,9.11190476 L26.5507937,9.11190476 C27.0968254,9.11190476 27.5746032,9.11190476 27.915873,9.31666667 C28.2571429,9.52142857 28.5301587,9.86269841 28.5301587,10.4087302 C28.5301587,11.1595238 28.052381,11.5690476 27.7111111,11.7055556 C28.052381,11.8420635 28.2571429,11.9785714 28.3253968,12.1150794 Z M33.0349206,10.1357143 L30.3730159,10.1357143 L30.3730159,11.0230159 L32.9666667,11.0230159 L32.9666667,11.9785714 L30.3730159,11.9785714 L30.3730159,12.934127 L33.0349206,12.934127 L33.0349206,13.9579365 L29.2126984,13.9579365 L29.2126984,9.11190476 L33.0349206,9.11190476 L33.0349206,10.1357143 Z M35.9015873,13.9579365 L33.7174603,13.9579365 L33.7174603,12.934127 L35.9015873,12.934127 C36.1063492,12.934127 36.2428571,12.934127 36.3793651,12.797619 C36.447619,12.7293651 36.515873,12.5928571 36.515873,12.4563492 C36.515873,12.3198413 36.447619,12.1833333 36.3793651,12.1150794 C36.3111111,12.0468254 36.1746032,11.9785714 35.9698413,11.9785714 C34.8777778,11.9103175 33.5809524,11.9785714 33.5809524,10.4769841 C33.5809524,9.79444444 33.9904762,9.04365079 35.2190476,9.04365079 L37.4714286,9.04365079 L37.4714286,10.2039683 L35.3555556,10.2039683 C35.1507937,10.2039683 35.0142857,10.2039683 34.8777778,10.2722222 C34.7412698,10.3404762 34.7412698,10.4769841 34.7412698,10.6134921 C34.7412698,10.818254 34.8777778,10.8865079 35.0142857,10.9547619 C35.1507937,11.0230159 35.2873016,11.0230159 35.4238095,11.0230159 L36.0380952,11.0230159 C36.652381,11.0230159 37.0619048,11.1595238 37.3349206,11.4325397 C37.5396825,11.6373016 37.6761905,11.9785714 37.6761905,12.4563492 C37.6761905,13.4801587 37.0619048,13.9579365 35.9015873,13.9579365 Z M41.7714286,13.4801587 C41.4984127,13.7531746 41.0206349,13.9579365 40.3380952,13.9579365 L38.1539683,13.9579365 L38.1539683,12.934127 L40.3380952,12.934127 C40.5428571,12.934127 40.6793651,12.934127 40.815873,12.797619 C40.884127,12.7293651 40.952381,12.5928571 40.952381,12.4563492 C40.952381,12.3198413 40.884127,12.1833333 40.815873,12.1150794 C40.747619,12.0468254 40.6111111,11.9785714 40.4063492,11.9785714 C39.3142857,11.9103175 38.0174603,11.9785714 38.0174603,10.4769841 C38.0174603,9.79444444 38.4269841,9.04365079 39.6555556,9.04365079 L41.9079365,9.04365079 L41.9079365,10.2039683 L39.8603175,10.2039683 C39.6555556,10.2039683 39.5190476,10.2039683 39.3825397,10.2722222 C39.2460317,10.3404762 39.2460317,10.4769841 39.2460317,10.6134921 C39.2460317,10.818254 39.3142857,10.8865079 39.5190476,10.9547619 C39.6555556,11.0230159 39.7920635,11.0230159 39.9285714,11.0230159 L40.5428571,11.0230159 C41.1571429,11.0230159 41.5666667,11.1595238 41.8396825,11.4325397 C41.9079365,11.4325397 41.9079365,11.5007937 41.9079365,11.5007937 C42.1126984,11.7738095 42.1809524,12.1150794 42.1809524,12.4563492 C42.1809524,12.865873 42.0444444,13.2071429 41.7714286,13.4801587 Z"
                                id="Shape"
                                fill="#0571C1"
                            />
                            <path
                                d="M27.0968254,10.2722222 C26.9603175,10.2039683 26.7555556,10.2039683 26.5507937,10.2039683 L25.1857143,10.2039683 L25.1857143,11.2960317 L26.5507937,11.2960317 C26.7555556,11.2960317 26.9603175,11.2960317 27.0968254,11.2277778 C27.2333333,11.1595238 27.3015873,10.9547619 27.3015873,10.75 C27.3698413,10.4769841 27.2333333,10.3404762 27.0968254,10.2722222 Z"
                                id="SVGCleanerId_1"
                                fill="#228FE0"
                            />
                            <g id="Group" transform="translate(17.148810, 1.791667)" fill="#228FE0">
                                <path
                                    d="M5.1702381,0.290079365 C5.03373016,0.221825397 4.82896825,0.221825397 4.62420635,0.221825397 L3.25912698,0.221825397 L3.25912698,1.31388889 L4.62420635,1.31388889 C4.82896825,1.31388889 5.03373016,1.31388889 5.1702381,1.24563492 C5.30674603,1.17738095 5.375,0.972619048 5.375,0.767857143 C5.44325397,0.49484127 5.30674603,0.358333333 5.1702381,0.290079365 Z"
                                    id="Path"
                                />
                                <polygon
                                    id="Path"
                                    points="13.4289683 1.9281746 14.9988095 1.9281746 14.2480159 0.0170634921"
                                />
                                <polygon
                                    id="Path"
                                    points="1.82579365 11.756746 1.82579365 7.86626984 0.0511904762 9.77738095"
                                />
                            </g>
                            <path
                                d="M21.568254,10.1357143 L20.1349206,10.1357143 L20.1349206,11.3642857 L21.6365079,11.3642857 C22.0460317,11.3642857 22.3190476,11.1595238 22.3190476,10.75 C22.2507937,10.3404762 21.9777778,10.1357143 21.568254,10.1357143 Z"
                                id="SVGCleanerId_0_1_"
                                fill="#228FE0"
                            />
                            <path
                                d="M27.0968254,10.2722222 C26.9603175,10.2039683 26.7555556,10.2039683 26.5507937,10.2039683 L25.1857143,10.2039683 L25.1857143,11.2960317 L26.5507937,11.2960317 C26.7555556,11.2960317 26.9603175,11.2960317 27.0968254,11.2277778 C27.2333333,11.1595238 27.3015873,10.9547619 27.3015873,10.75 C27.3698413,10.4769841 27.2333333,10.3404762 27.0968254,10.2722222 Z"
                                id="SVGCleanerId_1_1_"
                                fill="#228FE0"
                            />
                            <g id="Group" fill="#2FABF7">
                                <polygon
                                    id="Path"
                                    points="21.0904762 13.8214286 20.1349206 12.797619 20.1349206 13.9579365 17.8825397 13.9579365 16.5174603 12.3880952 15.015873 13.9579365 10.5111111 13.9579365 10.5111111 9.18015873 15.084127 9.18015873 16.5174603 10.75 17.2 9.93095238 15.4936508 8.22460317 9.48730159 8.22460317 9.48730159 14.9134921 15.4936508 14.9134921 16.5174603 13.8896825 17.4047619 14.9134921 21.0904762 14.9134921"
                                />
                                <polygon
                                    id="Path"
                                    points="13.9920635 6.72301587 13.1047619 5.76746032 12.6952381 5.76746032 12.6952381 5.35793651 11.6714286 4.33412698 10.9888889 5.76746032 10.0333333 5.76746032 8.3952381 2.01349206 8.3952381 5.76746032 6.07460317 5.76746032 5.5968254 4.74365079 3.27619048 4.74365079 2.7984127 5.76746032 1.56984127 5.76746032 3.61746032 0.98968254 5.32380952 0.98968254 7.23492063 5.56269841 7.23492063 0.98968254 8.25873016 0.98968254 7.3031746 0.0341269841 6.27936508 0.0341269841 6.27936508 0.853174603 5.93809524 0.0341269841 2.93492063 0.0341269841 1.56984127 3.24206349 0 6.72301587 1.56984127 6.72301587 3.54920635 6.72301587 3.95873016 5.69920635 4.91428571 5.69920635 5.39206349 6.72301587 9.21428571 6.72301587 9.21428571 5.90396825 9.55555556 6.72301587 11.5349206 6.72301587 11.8761905 5.90396825 11.8761905 6.72301587"
                                />
                                <polygon
                                    id="Path"
                                    points="10.852381 3.58333333 9.76031746 2.49126984 10.5793651 4.26587302"
                                />
                            </g>
                            <g id="Group" transform="translate(6.740079, 0.085317)" fill="#228FE0">
                                <path
                                    d="M35.1678571,14.4869048 C35.7821429,14.077381 36.1916667,13.3948413 36.2599206,12.6440476 L35.3043651,11.6884921 C35.372619,11.893254 35.440873,12.0980159 35.440873,12.3710317 C35.440873,12.7805556 35.3043651,13.1218254 35.0313492,13.3948413 C34.7583333,13.6678571 34.2805556,13.872619 33.5980159,13.872619 L31.4138889,13.872619 L31.4138889,12.8488095 L33.5980159,12.8488095 C33.8027778,12.8488095 33.9392857,12.8488095 34.0757937,12.7123016 C34.1440476,12.6440476 34.2123016,12.5075397 34.2123016,12.3710317 C34.2123016,12.2345238 34.1440476,12.0980159 34.0757937,12.0297619 C34.0075397,11.9615079 33.8710317,11.893254 33.6662698,11.893254 C32.5742063,11.825 31.277381,11.893254 31.277381,10.3916667 C31.277381,9.70912698 31.6869048,9.09484127 32.7107143,8.95833333 L31.9599206,8.20753968 C31.8234127,8.27579365 31.7551587,8.34404762 31.6869048,8.34404762 L31.6869048,7.93452381 L28.5472222,7.93452381 C28.0694444,7.93452381 27.4551587,8.07103175 27.1821429,8.34404762 L27.1821429,7.93452381 L21.5853175,7.93452381 L21.5853175,8.34404762 C21.1757937,8.00277778 20.425,7.93452381 20.0837302,7.93452381 L16.3980159,7.93452381 L16.3980159,8.34404762 C16.056746,8.00277778 15.2376984,7.93452381 14.8281746,7.93452381 L10.7329365,7.93452381 L9.77738095,8.95833333 L8.89007937,7.93452381 L8.13928571,7.93452381 L10.1869048,9.98214286 L11.2107143,8.89007937 L14.8281746,8.89007937 C15.7154762,8.89007937 16.7392857,9.16309524 16.7392857,10.4599206 C16.7392857,11.825 15.7837302,12.0980159 14.7599206,12.0980159 L13.3948413,12.0980159 L13.3948413,13.1218254 L14.4186508,14.1456349 L14.4186508,13.1218254 L14.7599206,13.1218254 C15.2376984,13.1218254 15.8519841,13.1218254 16.3297619,12.9170635 L16.3297619,14.7599206 L19.4011905,14.7599206 L19.4011905,12.9853175 L19.5376984,12.9853175 C19.7424603,12.9853175 19.7424603,12.9853175 19.7424603,13.1900794 L19.7424603,14.7599206 L29.025,14.7599206 C29.6392857,14.7599206 30.2535714,14.6234127 30.5948413,14.3503968 L30.5948413,14.7599206 L33.5297619,14.7599206 C34.0757937,14.8281746 34.6900794,14.7599206 35.1678571,14.4869048 L35.1678571,14.4869048 Z M21.5853175,12.0297619 C21.7218254,12.2345238 21.7900794,12.5075397 21.7900794,12.9170635 L21.7900794,13.872619 L20.6297619,13.872619 L20.6297619,13.2583333 C20.6297619,12.9853175 20.6297619,12.5075397 20.425,12.3027778 C20.2884921,12.0980159 20.0154762,12.0980159 19.6059524,12.0980159 L18.377381,12.0980159 L18.377381,13.872619 L17.2170635,13.872619 L17.2170635,9.0265873 L19.8107143,9.0265873 C20.356746,9.0265873 20.8345238,9.0265873 21.1757937,9.23134921 C21.5170635,9.43611111 21.7900794,9.77738095 21.7900794,10.3234127 C21.7900794,11.0742063 21.3123016,11.4837302 20.9710317,11.6202381 C21.3123016,11.756746 21.5170635,11.893254 21.5853175,12.0297619 Z M26.2948413,10.0503968 L23.6329365,10.0503968 L23.6329365,10.9376984 L26.2265873,10.9376984 L26.2265873,11.893254 L23.6329365,11.893254 L23.6329365,12.8488095 L26.2948413,12.8488095 L26.2948413,13.872619 L22.472619,13.872619 L22.472619,9.0265873 L26.2948413,9.0265873 L26.2948413,10.0503968 Z M29.1615079,13.872619 L26.977381,13.872619 L26.977381,12.8488095 L29.1615079,12.8488095 C29.3662698,12.8488095 29.5027778,12.8488095 29.6392857,12.7123016 C29.7075397,12.6440476 29.7757937,12.5075397 29.7757937,12.3710317 C29.7757937,12.2345238 29.7075397,12.0980159 29.6392857,12.0297619 C29.5710317,11.9615079 29.4345238,11.893254 29.2297619,11.893254 C28.1376984,11.825 26.840873,11.893254 26.840873,10.3916667 C26.840873,9.70912698 27.2503968,8.95833333 28.4789683,8.95833333 L30.7313492,8.95833333 L30.7313492,10.1186508 L28.6154762,10.1186508 C28.4107143,10.1186508 28.2742063,10.1186508 28.1376984,10.1869048 C28.0011905,10.2551587 28.0011905,10.3916667 28.0011905,10.5281746 C28.0011905,10.7329365 28.1376984,10.8011905 28.2742063,10.8694444 C28.4107143,10.9376984 28.5472222,10.9376984 28.6837302,10.9376984 L29.2980159,10.9376984 C29.9123016,10.9376984 30.3218254,11.0742063 30.5948413,11.3472222 C30.7996032,11.5519841 30.9361111,11.893254 30.9361111,12.3710317 C30.9361111,13.3948413 30.3218254,13.872619 29.1615079,13.872619 Z"
                                    id="Shape"
                                />
                                <path
                                    d="M32.4376984,10.5281746 C32.4376984,10.7329365 32.5059524,10.8011905 32.7107143,10.8694444 C32.8472222,10.9376984 32.9837302,10.9376984 33.1202381,10.9376984 L33.7345238,10.9376984 C34.1440476,10.9376984 34.4170635,11.0059524 34.6900794,11.1424603 L33.6662698,10.1186508 L33.0519841,10.1186508 C32.8472222,10.1186508 32.7107143,10.1186508 32.5742063,10.1869048 C32.5059524,10.2551587 32.4376984,10.3916667 32.4376984,10.5281746 Z"
                                    id="Path"
                                />
                                <polygon
                                    id="Path"
                                    points="30.0488095 6.43293651 30.1853175 6.63769841 30.2535714 6.63769841"
                                />
                                <polygon
                                    id="Path"
                                    points="26.2948413 2.67896825 27.4551587 5.47738095 27.4551587 3.83928571"
                                />
                                <path
                                    d="M14.6234127,4.93134921 L14.7599206,4.93134921 C14.8964286,4.93134921 14.8964286,4.93134921 14.8964286,5.13611111 L14.8964286,6.63769841 L19.8107143,6.63769841 L19.8107143,6.2281746 C20.2202381,6.43293651 20.8345238,6.63769841 21.6535714,6.63769841 L23.7011905,6.63769841 L24.1107143,5.54563492 L25.0662698,5.54563492 L25.4757937,6.63769841 L29.4345238,6.63769841 L29.4345238,5.95515873 L28.4789683,4.99960317 L28.4789683,5.75039683 L26.1583333,5.75039683 L25.8170635,4.65833333 L23.4281746,4.65833333 L23.0186508,5.75039683 L21.7218254,5.75039683 C21.1757937,5.75039683 20.493254,5.61388889 20.0837302,5.20436508 C19.6742063,4.79484127 19.4694444,4.24880952 19.4694444,3.36150794 C19.4694444,2.67896825 19.6059524,1.99642857 20.0837302,1.45039683 C20.425,1.04087302 21.0392857,0.904365079 21.7900794,0.904365079 L22.8821429,0.904365079 L22.8821429,1.9281746 L21.7900794,1.9281746 C21.3805556,1.9281746 21.1757937,1.99642857 20.9027778,2.20119048 C20.6980159,2.40595238 20.5615079,2.81547619 20.5615079,3.29325397 C20.5615079,3.83928571 20.6297619,4.18055556 20.9027778,4.45357143 C21.1075397,4.65833333 21.3805556,4.7265873 21.7218254,4.7265873 L22.1996032,4.7265873 L23.7694444,0.972619048 L24.4519841,0.972619048 L23.4964286,0.0170634921 L21.7218254,0.0170634921 C20.9710317,0.0170634921 20.356746,0.153571429 19.8107143,0.426587302 L19.8107143,0.0170634921 L16.8075397,0.0170634921 L16.8075397,0.426587302 C16.4662698,0.153571429 16.056746,0.0170634921 15.5107143,0.0170634921 L4.5218254,0.0170634921 L3.77103175,1.7234127 L3.0202381,0.0170634921 L0.0170634921,0.0170634921 L0.972619048,0.972619048 L2.33769841,0.972619048 L3.49801587,3.49801587 L3.90753968,3.90753968 L5.13611111,0.904365079 L7.04722222,0.904365079 L7.04722222,5.75039683 L5.88690476,5.75039683 L5.88690476,1.99642857 L4.7265873,4.7265873 L6.70595238,6.70595238 L14.5551587,6.70595238 L14.6234127,4.93134921 Z M17.7630952,0.904365079 L18.9234127,0.904365079 L18.9234127,5.75039683 L17.7630952,5.75039683 L17.7630952,0.904365079 Z M11.756746,1.9281746 L9.09484127,1.9281746 L9.09484127,2.81547619 L11.6884921,2.81547619 L11.6884921,3.77103175 L9.09484127,3.77103175 L9.09484127,4.7265873 L11.756746,4.7265873 L11.756746,5.75039683 L7.93452381,5.75039683 L7.93452381,0.904365079 L11.756746,0.904365079 L11.756746,1.9281746 Z M13.6678571,5.68214286 L12.5075397,5.68214286 L12.5075397,0.836111111 L15.1011905,0.836111111 C15.7154762,0.836111111 16.125,0.836111111 16.4662698,1.04087302 C16.8075397,1.24563492 17.0123016,1.58690476 17.0123016,2.13293651 C17.0123016,2.88373016 16.5345238,3.29325397 16.193254,3.4297619 C16.4662698,3.49801587 16.6710317,3.70277778 16.7392857,3.83928571 C16.8757937,4.11230159 16.9440476,4.31706349 16.9440476,4.7265873 L16.9440476,5.68214286 L15.7837302,5.68214286 L15.7837302,5.06785714 C15.7837302,4.79484127 15.7837302,4.38531746 15.5789683,4.11230159 C15.5107143,3.97579365 15.3059524,3.97579365 14.8964286,3.97579365 L13.6678571,3.97579365 L13.6678571,5.68214286 L13.6678571,5.68214286 Z"
                                    id="Shape"
                                />
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Amex.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Amex.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Amex;
