import React from 'react';
import PropTypes from 'prop-types';

function SvgUsVirginIslands({ className, style }) {
    return (
        <svg width={33} height={32} className={className} style={style}>
            <defs>
                <circle id="us-virgin-islands_svg__a" cx={16.5} cy={16} r={16} />
            </defs>
            <g fill="none" fillRule="evenodd">
                <mask id="us-virgin-islands_svg__b" fill="#fff">
                    <use xlinkHref="#us-virgin-islands_svg__a" />
                </mask>
                <use fill="#D8D8D8" xlinkHref="#us-virgin-islands_svg__a" />
                <g fillRule="nonzero" mask="url(#us-virgin-islands_svg__b)">
                    <path
                        d="M34 27.125V6.875A7.875 7.875 0 0026.125-1H5.875A7.875 7.875 0 00-2 6.873v20.254A7.875 7.875 0 005.875 35h20.25A7.875 7.875 0 0034 27.125z"
                        fill="#F5F5F5"
                    />
                    <path
                        fill="#4173CD"
                        d="M24.224 18.29l.173.607L25 17.11l-1.669.88.627.074-2.003 2.353-.017-.05 1.6-3.312.32.544.131-1.882-1.392 1.273.625-.087-1.6 3.312-.05.017.599-3.031.447.445-.348-1.854-1.026 1.583.583-.242-.645 3.269-.21.436-.227.152-.093.473-.793.932.619-.05-.113.57.22-.147.02.262.377-.442.346.516.236-1.2.313-.368-.022-.272.21-.436z"
                    />
                    <path
                        d="M9.817 16.513c.068-.306.025-.593-.091-.77-.18.111-.34.353-.408.659a1.28 1.28 0 00-.025.402l-.375-.558c.153-.125.284-.338.344-.606.068-.305.026-.592-.09-.768-.181.11-.34.352-.409.657-.036.163-.04.32-.018.457l-.253-.377a1.104 1.104 0 00-.188-.647c-.168-.264-.4-.437-.608-.48-.05.206.009.49.177.754.143.225.332.378.513.446l.232.385a1.251 1.251 0 00-.422-.177c-.306-.068-.593-.025-.77.091.111.18.353.34.659.408.268.06.516.031.693-.054l.347.575a1.279 1.279 0 00-.375-.147c-.305-.069-.592-.026-.768.09.11.18.352.34.658.408.256.057.495.033.67-.043l.32.53a1.284 1.284 0 00-.333-.127c-.306-.068-.593-.026-.77.09.111.181.353.34.659.409.245.054.475.035.648-.033l.308.511a1.299 1.299 0 00-.29-.105c-.306-.068-.593-.026-.77.09.111.181.353.34.658.409.234.052.456.039.626-.022l.28.466a1.32 1.32 0 00-.249-.084c-.305-.068-.592-.026-.768.09.11.18.352.34.658.408.222.05.434.04.601-.014l.891 1.48.379-.241-.962-1.435a1.17 1.17 0 00.268-.538c.068-.306.025-.593-.091-.77-.18.111-.34.353-.408.659a1.33 1.33 0 00-.03.261l-.303-.452c.128-.128.233-.323.285-.557.068-.306.026-.592-.09-.769-.18.11-.34.352-.408.658a1.3 1.3 0 00-.028.308l-.333-.496c.136-.128.25-.328.305-.573.068-.306.026-.592-.091-.769-.18.11-.34.352-.408.658a1.283 1.283 0 00-.026.355l-.345-.514c.144-.126.267-.332.324-.588z"
                        fill="#73AF00"
                    />
                    <g fill="#FFE15A">
                        <path d="M13.691 16.463l-.474-2.846h-.073a.63.63 0 01-.599-.83l.002-.005a.63.63 0 00-.389-.794l-6.512-2.3a.45.45 0 00-.563.602l.706 1.648c.203.474.556.869 1.003 1.125L8.6 14.095c.54.308 1.15.47 1.772.47l.162.325a2.846 2.846 0 002.546 1.573h.612zM19.383 16.463l.475-2.846h.073a.63.63 0 00.598-.83l-.001-.005a.63.63 0 01.388-.794l6.51-2.298a.45.45 0 01.565.602l-.706 1.646a2.372 2.372 0 01-1.003 1.125l-1.806 1.032c-.54.308-1.15.47-1.772.47l-.163.325a2.846 2.846 0 01-2.545 1.573h-.613zM18.435 13.142l-1.177-2.745a.949.949 0 00-.872-.575h-.323l-.474.475h-.475l-.474.474h.662c.168 0 .28.171.215.326l-.877 2.046h3.795zM15.114 17.886l-.948-1.423-.869.868a3.32 3.32 0 00-.802 1.298l-.227.68-.474.474h-.616a.537.537 0 00-.481.297l-.134.268a.265.265 0 00.238.384h.993l.316-.633 1.513-.756a.474.474 0 00.123-.089l1.368-1.368zM17.96 17.886l.949-1.423.869.868c.364.365.639.81.802 1.298l.226.68.475.474h.616c.204 0 .39.115.48.297l.134.268a.265.265 0 01-.237.384h-.993l-.317-.633-1.512-.756a.474.474 0 01-.123-.089l-1.369-1.368zM15.114 18.36l-1.152 1.921a.613.613 0 00.133.787l1.75 1.459c.401.334.983.334 1.384 0l1.75-1.46a.613.613 0 00.134-.786L17.96 18.36h-2.846z" />
                    </g>
                    <path
                        d="M16.537 12.668s-1.423.474-3.32 0v1.897c0 .949.474 3.795 3.32 4.744 2.846-.95 3.32-3.795 3.32-4.744v-1.897c-1.897.474-3.32 0-3.32 0z"
                        fill="#F5F5F5"
                    />
                    <path
                        d="M16.537 12.668s-1.423.474-3.32 0v1.897h6.64v-1.897c-1.897.474-3.32 0-3.32 0z"
                        fill="#41479B"
                    />
                    <g fill="#FF4B55">
                        <path d="M14.209 17.6v-3.035h-.518v2.112c.135.309.304.621.518.923zM15.244 14.565h-.518v3.641c.157.155.328.303.518.44v-4.08zM18.866 17.6a5.12 5.12 0 00.517-.923v-2.112h-.517V17.6zM16.279 14.565h-.518v4.403c.162.087.335.167.518.239v-4.642zM18.348 14.565h-.517v4.082c.19-.138.36-.286.517-.44v-3.642zM17.313 18.968v-4.403h-.517v4.642c.183-.072.355-.152.517-.24z" />
                    </g>
                    <path fill="#73AF00" d="M11.55 20.169l-.337.207.566.94.379-.241z" />
                    <g fill="#4173CD">
                        <path d="M22.052 20.852l-.297-.595h-.545l-.029.144-.21.436-.227.152-.093.473-.793.932.619-.05-.113.57.22-.147.02.262.377-.442.346.516.236-1.2.313-.368-.022-.272zM7.322 14.565h-1.22l.11.329-.72 2.517-.719-2.517.11-.329h-1.22l.328.438 1.001 3.503-.11.328h1.22l-.11-.328 1.002-3.503zM27.989 14.87l.203-.305h-1.22l.204.305v3.66l-.204.304h1.22l-.203-.305z" />
                    </g>
                </g>
            </g>
        </svg>
    );
}
SvgUsVirginIslands.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgUsVirginIslands.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgUsVirginIslands;
