import React from 'react';
import PropTypes from 'prop-types';

function SvgTurkmenistan({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <g fill="#496E2D">
                    <path d="M16 0c-1.195 0-2.358.132-3.478.38L11.826 16l.696 15.62c1.12.248 2.283.38 3.478.38 8.837 0 16-7.163 16-16S24.837 0 16 0zM4.174 5.223A15.941 15.941 0 000 16c0 4.151 1.581 7.933 4.174 10.777L4.87 16 4.174 5.223z" />
                </g>
                <g fill="#F0F0F0">
                    <path d="M23.401 12.069a4.87 4.87 0 00-1.995-5.77 4.87 4.87 0 11-3.212 8.954A4.87 4.87 0 0023.4 12.07zM19.035 5.698l-.684.884-1.052-.377.63.923-.684.884 1.072-.313.63.924.033-1.117 1.073-.313-1.052-.377z" />
                    <path d="M20.882 8.578l-.684.884-1.052-.377.63.923-.684.884 1.072-.313.63.924.033-1.117 1.073-.313-1.052-.378zM15.779 6.747l-.684.884-1.052-.377.63.923-.685.884 1.073-.313.63.924.033-1.117 1.073-.313-1.052-.378zM15.704 10.046l-.684.884-1.052-.378.63.924-.685.884 1.073-.313.63.923.033-1.117 1.073-.312-1.052-.378zM18.843 11.172l-.684.884-1.052-.377.63.923-.685.884 1.073-.313.63.924.033-1.117 1.073-.313-1.052-.378z" />
                </g>
                <path
                    d="M4.174 5.223v21.554a15.983 15.983 0 008.348 4.843V.38a15.983 15.983 0 00-8.348 4.843z"
                    fill="#D80027"
                />
                <path
                    fill="#F0F0F0"
                    d="M7.36 8.424L5.962 7.383V5.91L7.36 4.87h1.976l1.398 1.04v1.473L9.336 8.424z"
                />
                <g fill="#FF9811">
                    <path d="M8.348 4.87H7.36L5.962 5.91v.72h2.386zM8.348 8.424h.988l1.398-1.041v-.751H8.348z" />
                </g>
                <path
                    fill="#F0F0F0"
                    d="M7.36 27.13l-1.398-1.04v-1.473l1.398-1.041h1.976l1.398 1.04v1.473L9.336 27.13z"
                />
                <g fill="#FF9811">
                    <path d="M8.348 23.576H7.36l-1.398 1.04v.72h2.386zM8.348 27.13h.988l1.398-1.04v-.752H8.348z" />
                </g>
                <g fill="#496E2D">
                    <path d="M7.36 17.777l-1.398-1.04v-1.473l1.398-1.041h1.976l1.398 1.04v1.473l-1.398 1.041zM10.783 20.068h-.61v-.609H9.105l-.756-.756-.757.756h-1.07v.609h-.608v1.217h.609v.609h1.07l.756.756.756-.756h1.07v-.609h.609zM10.783 10.715h-.61v-.61H9.105l-.756-.756-.757.757h-1.07v.609h-.608v1.217h.609v.609h1.07l.756.756.756-.756h1.07v-.609h.609z" />
                </g>
                <g transform="translate(7.625 10.625)" fill="#D80027">
                    <path d="M.027 4.679h1.391V6.07H.027z" />
                    <circle cx={0.723} cy={0.698} r={1} />
                    <circle cx={0.723} cy={10.052} r={1} />
                </g>
            </g>
        </svg>
    );
}
SvgTurkmenistan.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgTurkmenistan.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgTurkmenistan;
