import React from 'react';
import PropTypes from 'prop-types';

function SvgSaintPierreAndMiquelon({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <defs>
                <circle id="saint-pierre-and-miquelon_svg__a" cx={16} cy={16} r={16} />
            </defs>
            <g fill="none" fillRule="evenodd">
                <mask id="saint-pierre-and-miquelon_svg__b" fill="#fff">
                    <use xlinkHref="#saint-pierre-and-miquelon_svg__a" />
                </mask>
                <use fill="#D8D8D8" xlinkHref="#saint-pierre-and-miquelon_svg__a" />
                <g fillRule="nonzero" mask="url(#saint-pierre-and-miquelon_svg__b)">
                    <path
                        d="M29.123-1.82H-9.485A5.51 5.51 0 00-15 3.685V28.46a5.51 5.51 0 005.515 5.505h38.608a5.51 5.51 0 005.516-5.505V3.685a5.51 5.51 0 00-5.516-5.505z"
                        fill="#0092C8"
                    />
                    <path
                        d="M17.058 20.417c-1.372 0-2.504-.185-3.452-.47l.706-2.441c.137.022.268.03.42.071 2.19.602 4.53 2.69 4.542 2.7-.667.089-1.4.14-2.216.14M31.536 10.18c-1.636-.56-3.49-.646-3.49-.646l-1.206 2.366s3.577.075 3.577.295c0 .153-.814 1.497-1.323 2.324a3.312 3.312 0 00-.962-.125c-1.551 0-2.154.344-2.8 1.29-.647.947 0 1.333 0 1.333s-.8 1.772-3.795 2.756l.983-3.39c1.12-.187 2.08.377 2.08.377s-.734-2.151.172-5.376c.904-3.226 4.266-5.635 4.266-5.635l-3.759 1.108.957-3.302s.474-1.032 0-1.333c-.308-.196-.469.223-.545.543a2.211 2.211 0 00-1.523.102c-.947.43-3.145-.191-3.145-.191s.861.965 1.508 1.137c-.69.344-2.026.216-2.026.216s1.639.945 2.736.601c.73-.228 1.537-.248 2.002-.235l-.804 2.711-3.417 1.008s-1.55 1.248-2.068 4.904c-.517 3.655 1.336 6.365 1.336 6.365s-.194-1.766 1.288-2.638c-.401 1.353-.743 2.506-.973 3.29-.413.095-.848.18-1.33.241-.01-.024-1.784-4-1.485-7.344.302-3.355 3.232-6.782 3.232-6.782l-3.834 1.391 1.348-4.674s.848-.559.116-.903-.59.757-.59.757a2.186 2.186 0 00-1.335.146c-.949.43-3.145-.191-3.145-.191s.862.965 1.507 1.137c-.69.344-2.024.216-2.024.216s1.636.945 2.735.601a5.575 5.575 0 011.711-.25L16.367 7.84l-3.489 1.265s-.604.86-1.853 3.356c-1.249 2.494.517 6.064.517 6.064s.522-.79 1.625-1.016l-.67 2.022c-2.768-1.269-3.367-3.459-3.367-3.459s.474-.085.474-.601c0-.497-.214-.752-1.65-.771l.35-1.239a4.589 4.589 0 011.085.935s-.604-2.237.645-4.474c1.25-2.236 4.18-4.171 4.309-4.171.069 0-2.14.626-4.212 1.21l.866-3.078s.631-.929-.057-1.144c-.69-.214-.578.973-.578.973v.002a2.154 2.154 0 00-1.176.17c-.947.43-3.145-.19-3.145-.19s.862.964 1.508 1.136c-.69.344-2.025.215-2.025.215s1.636.947 2.735.603a5.664 5.664 0 011.615-.25l-.514 1.78c-1.485.419-2.729.765-2.729.765s-.561.86-1.208 2.927c-.645 2.064.475 3.74.475 3.74s.344-1.461 1.423-1.461c.102 0 .2.02.3.04l-.441 1.529c-1.031.074-1.195.356-1.195.795 0 .517.56.56.56.56s-.13.904.215 2.023c.344 1.117-.43.902-1.724.257-.084-.041-.168-.065-.254-.095l.009-.008-3.245-1.446s-.69-.99-1.034-.301c-.344.688.775.846.775.846l1.86.936c-.363.189-.543.492-.351.799.431.688 1.378 0 3.318 1.892 1.256 1.228 5.386 5.764 11.547 5.764h6.981c5.43 0 4.61-4.645 1.896-5.721 2.068-1.849 2.198-4 2.198-4s.56 0 1.034-.947c.237-.473.215-.893-.06-1.195.657-1.277 2.278-4.41 2.688-5.126.517-.903 0-1.334-.862.43"
                        fill="#FFCC4D"
                    />
                    <path
                        d="M32.828 22.998c-1.077-.775-2.068-.517-2.283.234-.215.75-1.207.41-2.284-.364-1.077-.773-1.81-.645-2.025.215-.215.86-1.422.775-2.543-.043-1.12-.817-2.24-.214-2.67.4-.43.613-.775.675-2.16-.185-1.384-.86-2.365-.344-2.752.387-.389.732-.949.56-2.113-.233-1.162-.794-2.24-.498-2.8 0-.56.497-1.336.664-2.37 0-1.034-.665-1.853-.626-2.37-.095-.518.533-1.12 1.317-2.757.05-1.638-1.268-2.5-.194-3.319.365-.819.559-1.594-.86-1.594-.86v10.205H32.15a5.503 5.503 0 002.49-4.614v-5.033s-.733.344-1.81-.43z"
                        fill="#000"
                    />
                    <path
                        d="M32.828 23.9c-1.077-.774-2.068-.515-2.283.235-.215.75-1.207.41-2.284-.363-1.077-.774-1.81-.646-2.025.214-.215.86-1.422.775-2.543-.042-1.12-.818-2.24-.215-2.67.399-.43.614-.775.676-2.16-.185-1.384-.86-2.365-.344-2.752.387-.389.732-.949.56-2.113-.232-1.162-.795-2.24-.499-2.8 0-.56.496-1.336.663-2.37 0-1.034-.665-1.853-.627-2.37-.095-.518.532-1.12 1.317-2.757.05-1.638-1.268-2.5-.195-3.319.364-.819.559-1.594-.86-1.594-.86v10.193h30.346a5.507 5.507 0 005.505-5.505v-4.13s-.733.344-1.81-.43z"
                        fill="#BBDDF5"
                    />
                    <path
                        d="M32.828 24.761c-1.077-.775-2.068-.516-2.283.234-.215.75-1.207.41-2.284-.363-1.077-.774-1.81-.646-2.025.215-.215.86-1.422.775-2.543-.043-1.12-.818-2.24-.215-2.67.4-.43.613-.775.675-2.16-.185-1.384-.86-2.365-.344-2.752.386-.389.733-.949.56-2.113-.232-1.162-.794-2.24-.498-2.8 0-.56.497-1.336.663-2.37 0-1.034-.665-1.853-.626-2.37-.095-.518.533-1.12 1.317-2.757.05-1.638-1.268-2.5-.195-3.319.364-.819.56-1.594-.86-1.594-.86v9.333h30.346a5.507 5.507 0 005.505-5.505v-3.27s-.733.345-1.81-.429z"
                        fill="#0091C8"
                    />
                    <g fill="#BBDDF5">
                        <path d="M1.762 27.04c.73-.827 1.853-.73 2.715 0 .861.731 1.249.178 2.068-.298.818-.475 1.981-.505 2.24.176.258.681-1.078-.246-1.895.476-.82.722-2.146.936-3.103 0-.958-.936-2.672.377-2.025-.353M11.37 27.206c.787.267 1.853.35 2.8-.252.95-.602 1.639-.32 2.673.508 1.034.826 1.809.549 2.757 0 .948-.55 1.724-1.239 3.06-.636 1.335.601 1.981.663 2.498.461.518-.204 0 .7-1.292.484-1.293-.214-2.197-1.032-3.361-.257-1.164.774-2.672 1.498-3.877.468-1.207-1.028-1.854-.885-2.587-.44-.732.444-1.551.488-1.982.272-.431-.215-1.323-.823-.69-.608M27.96 27.206c.5.301 1.034.38 1.552 0 .517-.38 1.034-.072 1.68.29.647.362.775.768 0 .522-.776-.247-1.078-.794-1.68-.456-.604.339-1.25.435-1.552 0-.302-.436-.373-.582 0-.356M5.769 29.234c.708-.376 1.853-.903 2.67 0 .82.903 1.208.43 1.854 0 .646-.43 1.206-.946 2.198-.301.99.645 1.464.467 1.853.256.387-.212.732-.084 0 .346-.734.43-1.466.387-2.026-.044-.56-.429-1.034-.644-1.766.087s-1.681.948-2.37.26c-.69-.69-.905-.747-1.594-.396-.69.35-1.53.167-.82-.208M18.954 29.442c.867-.457 2.026-1.24 2.973-.337.949.903 1.509.48 2.285-.04.775-.519 1.507-1.269 2.628-.378 1.12.892 1.852.805 2.413.547.56-.258.3.237-.389.398-.69.161-1.636.161-2.283-.398-.647-.56-1.25-.53-1.939.208-.69.738-2.413.946-3.06.282-.646-.662-1.464-.275-2.068-.018-.603.26-1.426.193-.56-.264M.857 30.125c.515-.473 1.206-.289 2.068.571.862.86 1.25.688 2.026.258.774-.43 1.809-.517 2.24-.043.43.473.258.623-.259.398-.517-.226-1.013-.356-1.712.247-.701.602-1.95.731-2.554 0-.603-.73-.947-1.161-1.422-.99-.473.173-1.077.192-.387-.441M12.793 30.964c.502-.539 1.508-.98 2.498 0 .992.98 1.164.85 1.94.334.775-.516 1.68-1.108 2.628-.231.948.876 1.336.704 2.154.231.82-.473 1.551-.892 2.457-.231.905.662 1.594.834 2.37.36.775-.473.946-.262.216.344-.604.5-1.7.689-2.456-.042-.95-.916-1.553-.646-2.328-.087-.776.559-1.983.688-2.672-.043-.69-.73-1.162-.516-1.809 0s-1.757 1.044-2.542-.042c-.785-1.086-1.552-.603-1.94-.388-.386.216-1.248.578-.516-.205" />
                    </g>
                </g>
            </g>
        </svg>
    );
}
SvgSaintPierreAndMiquelon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgSaintPierreAndMiquelon.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgSaintPierreAndMiquelon;
