import React from 'react';
import PropTypes from 'prop-types';

function SvgSaintHelena({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <defs>
                <circle id="saint-helena_svg__a" cx={16} cy={16} r={16} />
            </defs>
            <g fill="none" fillRule="evenodd">
                <mask id="saint-helena_svg__b" fill="#fff">
                    <use xlinkHref="#saint-helena_svg__a" />
                </mask>
                <use fill="#D8D8D8" xlinkHref="#saint-helena_svg__a" />
                <g fillRule="nonzero" mask="url(#saint-helena_svg__b)">
                    <path fill="#00247D" d="M54 33V-1h-68v34z" />
                    <path
                        fill="#FFF"
                        d="M-14 4.664h7.171L-14 1.066V-1h4.103L.134 4v-5h5.649v5l10.031-5h4.138v2.066l-7.206 3.598h7.206v5.67h-7.206l7.206 3.598v2.066h-4.138L5.783 10.997v5.001H.134v-5.001l-10.031 5.001H-14v-2.066l7.171-3.599H-14z"
                    />
                    <path
                        fill="#CF142B"
                        d="M17.283-1L5.951 4.668h2.713L19.952-1zM19.952 15.998l-11.3-5.665h2.724l8.576 4.315zM-2.669 10.333L-14 15.998h2.711L.044 10.333z"
                    />
                    <path
                        fill="#CF142B"
                        d="M-14 5.84H1.337V-1h3.32v6.84h15.295v3.32H4.657v6.838h-3.32V9.16H-14z"
                    />
                    <path
                        d="M30 16c-.008 2.702-.441 5.613-4 7-3.559-1.387-3.992-4.298-4-7h8z"
                        fill="#5F7DBD"
                    />
                    <path
                        d="M26.546 23c1.76-.593 2.82-1.48 3.454-2.512a5.8 5.8 0 01-.38-.007c-.095-.005-3.724-.314-4.154-.448-.374-.117-1.8.099-2.466.3.621 1.098 1.697 2.045 3.546 2.667z"
                        fill="#E8ECE9"
                    />
                    <path
                        d="M23.473 22a.521.521 0 01.199-.006c.048.009.057.013.074-.04.018-.055.057-.041.087-.014.031.027.11.013.14-.032.03-.045.04-.04.07-.009.03.032.043.023.074.014a.21.21 0 00.11-.095c.025-.05.065-.068.086-.04.022.026.044.04.075.035.03-.004.039.028.035.068-.005.04.013.05.087-.013.065.067.087.04.087-.032 0-.072-.017-.338-.043-.374a.534.534 0 01-.057-.221c-.008-.154-.009-.163-.188-.257 0-.054-.013-.077-.14-.068.005-.018-.017-.072-.043-.095-.026-.022-.03-.031-.018-.094.053.004.11-.005.14-.05.03-.045.13-.036.192-.009.061.027.14.032.257.014.044-.037.118-.077.197-.122.078-.045.1-.063.105-.127a.945.945 0 00-.088-.432c-.043-.086-.056-.194-.118-.33-.066-.147-.065-.185-.14-.275-.02-.025-.043-.045-.047-.094a.26.26 0 00-.074-.167c-.132-.125-.184-.528-.236-.826-.03-.17-.009-.572-.079-.635-.117-.1-.174-.082-.253-.113-.057-.081-.083-.244-.135-.388-.083.014-.14.104-.196.135-.057.032-.066.032-.066.113s-.044.194-.122.32c-.079.126-.21.09-.319.28-.24-.302-.244-.388-.262-.474-.017-.085-.056-.103-.191-.225 0-.036-.018-.18-.005-.262-.1-.085-.174-.072-.222-.009-.048.063-.083.158-.158.194-.044.059-.178.206-.288.382.1 1.57.443 3.127 1.473 4.373z"
                        fill="#9B7463"
                    />
                    <path
                        d="M30 16c.003-1.138-.055-2.243-.028-3.212C28.642 12.134 26.892 12 26 12c-.892 0-2.642.134-3.972.788.027.969-.03 2.074-.028 3.212h8z"
                        fill="#F2D049"
                    />
                    <path
                        d="M25.491 13.166c-.122.004-.387.006-.442.041-.056.035-.08.05.017.07.098.02.262.072.353.134.09.062.166.172.14.33-.074.471.147.925.467 1.096.03.017.038.03.031.093a.74.74 0 01-.045.199c-.018.027-.026.072.03.05a4.35 4.35 0 01-.15.28c-.256-.034-.464.005-.483.304-.002.03.007.076.046.002.04-.074.086-.144.195-.163a.448.448 0 00-.075.274c.01.064.026.103.054.021a.482.482 0 01.134-.204c.021-.018.035-.021.02.03-.016.05.006.159.038.196.03.036.047.02.038-.04-.009-.06.005-.186.071-.225.096-.056.177-.027.216.047.038.074.07.004.03-.08-.043-.084-.086-.142-.156-.148l.148-.295c.016-.03.04-.043.061-.026.021.018.035.016.056-.033.02-.048.057-.192.11-.25.025-.009.067-.02.083-.036.067.111.128.234.144.26.015.028.033.04.017.096-.015.057-.07.236-.078.275-.19.007-.276.011-.337.13-.027.052.016.072.06.045.046-.028.11-.051.143-.045.033.006.049.025.016.043-.117.064-.19.145-.184.258.001.041.016.061.045.006.04-.078.113-.155.201-.177-.005.095.014.235.066.265.053.029.056 0 .037-.057a.246.246 0 01.04-.227c.082-.102.268.038.303.074.034.034.066.05.046-.041-.026-.12-.179-.19-.309-.21.036-.197.134-.594.186-.73.077.047.136-.076.264-.023.216.09.539.315.595.366.055.05.076.038.104.011.028-.027.077 0 .115.008.038.008.073.02.024-.09a1.203 1.203 0 00-.365-.447c.118.012.278.012.278-.023s-.184-.101-.26-.109a.49.49 0 00.236-.132c.03-.04-.006-.048-.115-.05-.334-.009-.5-.006-.674-.118-.278-.178-.438-.367-.574-.447-.073-.043-.118-.141-.146-.227-.09-.272-.086-.395-.298-.484-.212-.09-.456.02-.567.133z"
                        fill="#000"
                    />
                    <path
                        d="M23 17.61c.055.076.155.205.166.276.039-.068.07-.099.078-.141.008-.043.066-.126.044-.17-.022-.045-.039-.08.022-.048.06.033.05.09.036.175-.036.231-.15.278-.166.434.163.328.041.446.218.767.028.014.102-.011.124-.007.094-.056.164-.036.297-.012.133.023.205.103.205.174s0 .09.028.132c.027.043.083.109.072.156-.011.047.01.075.027.099.017.024-.005.076-.022.109-.016.033-.01.075.056.146.066.07.22.368.22.542 0 .175.012.255.095.288.083.033.11.061.1.137-.011.075.038.467.05.528.01.062.038.047.071.08.034.033.056.071.166.071.111 0 .218-.013.29-.003.1.118.16.278.183.377.022.1.02.235.059.235.039 0 .077.004.066-.118-.01-.123-.022-.142-.072-.203-.05-.061-.077-.09-.05-.128a.191.191 0 00.023-.146c-.012-.047-.028-.118.066-.023.094.094.122.118.15.15.027.034.038.095.033.152-.006.056.005.08.044.051.039-.028.088.02.066.08-.022.062.006.1.072.119.067.018.094.033.111.075.017.043.072.061.072-.024a1.09 1.09 0 00-.066-.32.89.89 0 01-.056-.25c-.005-.071-.022-.09-.06-.104-.04-.014-.073-.038-.078-.07-.006-.034-.039-.046-.064-.046s-.047-.016-.06-.04c-.014-.023-.028-.026-.056-.028-.028-.002-.072.012-.086-.026-.014-.038-.033-.092-.06-.123-.028-.03-.053-.04-.056-.146-.003-.106-.006-.12-.044-.158a1.419 1.419 0 01-.133-.18c-.028-.042-.055-.084-.055.006 0 .09 0 .136.066.17.066.032.083.032.055.08-.028.047 0 .08.011.113s.033.066 0 .099-.066.023-.06-.028a.26.26 0 00-.045-.156c-.027-.043-.05-.07-.083-.047-.033.023-.06-.005-.039-.024.023-.019.017-.033 0-.047-.016-.014-.022-.028.006-.057.028-.028.028-.042.011-.108s-.138-.396-.194-.472c-.055-.075-.05-.132.022-.057.072.076.133.142.139.203.005.062.022.1.044.123.022.024.039.014.05-.038.011-.052.055-.033-.022-.132-.078-.099-.222-.264-.277-.561-.055-.297-.078-.496-.133-.576-.055-.08-.072-.099-.077-.174-.006-.076 0-.151-.04-.208-.038-.056-.066-.066-.071.02-.006.084.005.273.033.306.028.033.011.118.006.165-.006.047-.093.094.088.189.072.037.061.09.05.122-.011.033-.022.028-.06-.023a.587.587 0 00-.117-.123c-.039-.028-.044-.047-.039-.113.006-.066.022-.114 0-.137-.022-.024-.033-.005-.044.033-.011.038-.022.141-.044.17-.023.028-.034.01-.05-.052-.017-.062.005-.156.044-.264a.608.608 0 00.028-.364c-.034-.141-.017-.184-.144-.301-.127-.118-.271-.232-.332-.378s-.072-.273-.139-.34a.885.885 0 00-.221-.174v-.217c0-.052-.028-.085-.1-.075-.072.009-.116.061-.16.132-.044.07-.078.037-.138.16-.061.123-.15.184-.15.316z"
                        fill="#B38C79"
                    />
                    <path
                        d="M23.018 19.052c.045.023.088.039.156.01.067-.027.147-.107.237-.028a.44.44 0 01.14.31c0 .102 0 .291.14.398.14.106.214.217.22.356.005.14.067.352.083.408.017.055.056.12.101.157.045.037.079.144.085.255.005.11-.017.19 0 .245.016.056 0 .102-.05.074a.187.187 0 01-.09-.088c-.029-.046-.062-.037-.034.033.028.069.112.134.185.134s.095.009.14.046c.045.037.05.056.129.056.078 0 .09 0 .163.018.073.019.073.01.112 0 .04-.01.078.019.106.079.028.06.096.227.096.273 0 .046 0 .092.039.139.04.046.028.092-.017.065-.045-.028-.045-.019-.078-.014-.034.004-.057-.01-.101-.033-.045-.023-.017-.018-.062-.074-.045-.055-.073-.074-.073-.032 0 .041-.005.092-.04.07-.033-.024-.05-.024-.078 0-.028.022-.039.04-.073-.005-.033-.047-.073-.047-.106-.056-.034-.01-.034-.01-.05-.05-.017-.043-.068-.052-.113-.052s-.067-.018-.073-.046c-.005-.028-.033-.046-.056-.06-.022-.014-.011-.046-.017-.079-.005-.032-.039-.018-.061-.028-.023-.009-.04-.004-.04-.05 0-.047-.022-.06-.039-.093s0-.065.011-.102c.011-.037.006-.06-.028-.093-.033-.032-.005-.064-.095-.13-.09-.064-.135-.009-.163-.161-.028-.153-.084-.468-.134-.519-.051-.05-.084-.088-.135-.102-.05-.013-.084-.004-.09-.092-.005-.088-.039-.2-.106-.255-.068-.055-.096-.074-.13-.097-.033-.023-.044-.065 0-.143.046-.08.029-.186.023-.237-.006-.05-.022-.115-.011-.17a.304.304 0 00-.011-.163c-.017-.037-.04-.046-.012-.074zM24.404 17.388c-.068.07-.141.128-.236.181-.094.054-.216.096-.149.187.068.09.122.102.136.17.013.07.033.129.1.145.068.016.095.005.095.117s0 .155.061.198c.06.042.054.085.081.187.027.1.027.32.108.47.081.148.263.431.243.49-.02.059-.047.101.034.17.08.07.135.171.142.23.006.059.02.08.1.059.082-.021.122-.043.15-.07.026-.026.08-.02.155.011.074.032.189.064.256.032.068-.032.101-.08.162-.08.095-.053.128-.165.149-.197.02-.032.006-.032-.034-.064s-.02-.086-.027-.139a.59.59 0 00-.115-.25c-.08-.118-.128-.262-.182-.3-.054-.037-.081-.128-.088-.17-.006-.043-.067-.08-.108-.113-.04-.031-.08-.08-.128-.266a3.385 3.385 0 01-.081-.352c0-.032-.007-.038-.047-.048-.04-.011-.061-.065-.048-.091.014-.027-.013-.053-.027-.086-.013-.032 0-.09.027-.122s.02-.123-.006-.198c-.027-.074-.054-.138-.162-.15-.108-.01-.129-.031-.17-.1-.04-.07-.08-.193-.094-.22-.013-.026-.033-.031-.114.022s-.108.071-.108.17a.17.17 0 00.04.124c.027.037.034.048.054.149.02.101.135.261-.013.352-.149.09-.129.112-.122.176.007.064-.04.107-.067.016-.027-.09 0-.144.08-.186.082-.043.156-.097.102-.155-.054-.059-.074-.198-.081-.262-.007-.064-.02-.085-.068-.037z"
                        fill="#B38C79"
                    />
                    <path
                        d="M23.128 19.058c-.014.089.032.186.048.265.019.09.076.278-.076.417-.152.139-.114.212 0 .253l.018.007c.31-.045.35-.194.266-.266-.088-.076-.062-.169.038-.245.102-.076.102-.12.013-.174-.089-.055-.089-.055.013-.207.089-.135-.136-.134-.32-.05z"
                        fill="#DABCB0"
                    />
                    <path
                        d="M23.473 19.928a1.681 1.681 0 01-.072-.342c-.005-.117-.067-.21-.187-.3-.094-.07-.114-.181-.119-.268-.07-.035-.1-.019-.094.046.006.07.093.104.08.205-.013.1-.013.075.048.124.06.05.083.096.051.117-.032.02-.035.057.01.07.045.013.048.052.041.088-.006.036.036.044.061.07.026.026.03.088.004.124-.026.036-.03.094.016.063.044-.032.064-.003.099.046.03.043.056.03.089.016a.29.29 0 01-.027-.059zM23.924 20.917c-.027.054-.06.036-.087.009-.028-.028-.06-.028-.046-.078.014-.05.009-.06-.028-.087a.277.277 0 00-.013-.008h-.042c-.065 0-.07-.019-.106-.055a.309.309 0 00-.023-.02v.033c0 .05 0 .041-.05.055-.051.014-.042-.05-.051-.091a.15.15 0 00-.008-.025c-.056-.01-.114-.068-.135-.13-.023-.069.005-.078.028-.032.023.045.032.06.073.087.042.027.056-.019.042-.074a.23.23 0 01-.005-.06.089.089 0 00-.041-.04c-.074-.032-.051-.041-.046-.1.004-.06-.01-.06-.056-.028s-.05-.004-.05-.095c0-.092-.06-.092-.074-.028-.014.064-.037.023-.064-.068-.028-.092-.065-.114-.07-.028-.003.074-.024.091-.072.05l.022.142c.023.15.06.096.134.16.073.064.05.095.078.127.027.032.032.055.023.092-.01.036-.023.068-.01.1.014.032.033.046.033.091 0 .046.014.041.032.05.011.006.026.003.037.007.012-.015.023-.034.037-.048.055-.054.138.005.165.073.028.069.06.087.102.032.041-.054.027-.045.073.005.046.05.065.041.065.041s.046-.018.078.01c.032.027.05.022.11-.065.06-.086-.027-.06-.055-.004zM24.073 18.99c.017-.158.005-.318.057-.376.051-.057.114-.173.108.073-.005.246-.011.232-.05.29-.041.057-.075.072-.035.166.04.094.045.101.04.246-.006.145-.006.203.04.275.045.073.057.08.068.16.012.08.052.188.103.246a.7.7 0 01.114.34c.006.116.086.145.16.224.074.08-.017.138-.074.102-.057-.036-.034 0-.069.05-.034.051-.045.058-.074-.029-.028-.087-.126-.144-.171-.166-.046-.022-.086-.116-.126-.21-.034-.081-.102-.14-.164-.146a.362.362 0 01.021.131c-.017.08-.04.138.029.232a.701.701 0 01.12.311c.006.08.017.109.085.08.069-.029.103-.058.126-.094.023-.036.069-.029.132.014.062.044.16.087.216.044.058-.044.086-.109.138-.109.08-.072.108-.224.125-.268.017-.043.006-.043-.028-.086-.035-.044-.018-.116-.023-.189a1.093 1.093 0 00-.097-.34c-.069-.16-.109-.355-.154-.405-.046-.051-.069-.174-.075-.232-.005-.058-.057-.109-.091-.152-.034-.043-.069-.109-.109-.362a14.178 14.178 0 01-.064-.43c-.041.083-.07.103-.084.046-.017-.065-.04-.101-.063-.058-.023.044-.028-.036-.028-.072s-.006-.043-.035-.043c-.028 0-.005-.058-.017-.167-.011-.109-.028-.123-.04.007-.011.13-.068.21-.045.24.022.028.01.086-.012.173a.317.317 0 00.006.195c.017.058-.012.167-.023.261s.046.188.063.029zM23.5 17.357c-.06.004-.102.049-.067.207.021.098-.065.077-.098.028-.032-.049-.057-.153-.122-.244-.065-.09-.032.063-.04.146-.009.084.056.084.113.153.057.07.008.098-.057.098s-.032.111-.016.188c.016.076-.016.09-.065.028-.049-.063-.016-.16-.008-.279.008-.118.016-.09-.073-.118-.09-.028-.074-.042-.041-.111.032-.07.065-.105.024-.14-.04-.034-.032-.055.033-.062.065-.007.04-.049.098-.063.057-.014.081.007.089-.083.007-.076.036-.122.103-.1.04.117.092.298.127.352z"
                        fill="#DABCB0"
                    />
                    <path
                        d="M24.007 18.1c0 .1 0 .138.068.176.068.038.06.076.09.166.03.09.03.284.12.416.027.04.064.09.102.142a.323.323 0 00.109-.09c.022-.033-.045-.1-.098-.156-.053-.057.007-.076.06-.147.053-.07-.007-.075-.09-.094-.083-.02-.083-.067-.128-.142-.045-.076-.037-.11-.007-.152.03-.043.007-.076-.053-.085-.06-.01-.045-.038-.022-.085.022-.048.037-.057-.053-.043-.068.01-.085.019-.105.034a.182.182 0 01.007.06z"
                        fill="#DABCB0"
                    />
                    <path
                        d="M25.047 19.043c-.01.053-.009.08-.034.097-.026.018-.009.045.017.072.026.026.043.062.017.11-.026.05.017.09.068.103.052.013.078 0 .06.062-.017.062.052.129.112.155.06.027.103.071.094.098-.008.026.043.053.103.066.06.014.051.018.051.036s.026.018.095.027a.45.45 0 01.197.08c.077.048.188.075.171.022-.017-.054 0-.09-.103-.116-.102-.026-.18-.155-.223-.244a.56.56 0 00-.257-.23c-.008-.063.01-.094-.068-.125-.077-.031-.103-.071-.103-.102s-.043-.071-.077-.08c-.034-.009-.052-.031-.052-.058 0-.026-.06-.022-.068.027z"
                        fill="#B38C79"
                    />
                    <path
                        d="M24 22.314c.158-.023.586-.244.631-.314.106.128.29.302.369.302-.151.058-.25.024-.29-.023.02.081.073.21.106.221-.145-.012-.31-.07-.362-.163-.125.093-.336.116-.454-.023z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M24 22c.057.027.341.104.378.104-.094.131-.014.257.144.236-.077.016-.161.064-.104.082.137.044.508-.12.582-.187-.127.269-.746.516-1-.235zM25 22.18c.107-.301.374-.2.5.126-.14.277-.416.277-.5-.126z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25 22.054c.104-.094.396.281.5-.054-.035.496-.22.563-.283.456-.063-.107-.124-.241-.166-.228.022-.067-.016-.08-.051-.174z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25 22.243c.104.054.475-.1.589-.243.12.132.357.341.411.32-.114.23-.331.098-.401 0-.201.22-.365.286-.599-.077z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.093 22.1c.146.084.271.024.415-.1.045.05.151.11.25.098.067.097.156.233.242.25-.09.093-.416 0-.482-.094-.165.009-.449.102-.518.246a.843.843 0 01.093-.4z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.099 22.24c.124.1.573.053.802-.208.09-.103.147.07.043.156-.372.313-.666.435-.881.157-.085-.11-.094-.209.036-.105z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26 22c-.312.255-.52.332-.953.1-.04-.023-.069 0-.024.049.044.049.283.162.34.17.057.006.037.052.002.07-.034.018-.044.06.002.028.047-.032.308-.044.414.053.047.043.059.036.055.004-.004-.032.02-.053.054-.06.035-.007.055-.029.029-.046-.027-.018-.03-.029-.01-.046.02-.018.022-.036-.008-.046-.03-.01-.051-.025-.023-.05a.25.25 0 01.104-.05c.008-.038-.006-.14.018-.176zM26.04 21.457c.185.024.526-.132.707-.457.063.07.151.147.198.162.046.016.088.093.017.093a.422.422 0 01-.22-.093c-.24.271-.52.36-.699.333-.05-.007-.063-.046-.004-.038zM25.409 21c.067.05.186.134.341.122.077.064.196.12.25.131-.103.046-.216.084-.245.12-.047-.048-.108-.04-.124-.065-.045.039-.038.062-.009.082.03.019.257.06.313.043.056-.017.071.032.025.05-.122.045-.358.002-.439-.136-.08-.14-.15-.192-.37-.065-.025-.067-.025-.084-.068-.084-.043 0-.122-.06-.06-.057.06.002.24-.026.386-.141z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.444 21.006c-.067.034-.257.25-.325.268-.069.016-.19.217-.065.226.125.008.286-.277.374-.302.089-.025.097-.234.016-.192z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.465 21.004c-.033.015-.174.103-.213.095-.039-.007-.078.022-.075.096.003.073.014.117-.044.102-.058-.014-.108.045-.122.089-.014.044-.025.088.033.102.058.015.089.03.155-.05.067-.082.13-.207.202-.214.072-.007.144-.257.064-.22z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.117 21.033c.099.09.586.325.762.306.176-.02.143.1.01.14-.276.082-.612-.087-.84-.344-.112-.127-.008-.172.068-.102z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M25.973 21.012c-.146.132-.294.085-.354.04-.06-.045-.115-.055-.074.055.04.11.17.186.245.13-.263.171-.332.156-.397.126a.452.452 0 00-.24-.01c-.038.01-.091-.005-.114-.045-.023-.04-.03-.116.039-.096.068.02.077-.02.017-.045-.06-.025-.142.045-.061.191.08.146.259-.01.372.08.112.09.352.156.58-.366.01-.027.03-.1-.013-.06z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.007 21.103a1.11 1.11 0 010 .289c-.013.072-.013.165.042.062.054-.103.088-.227.142-.155.054.072.192.062.255.041.063-.02.084-.051-.008-.144s-.184-.124-.235-.114c-.05.01-.112-.02-.154-.062-.042-.041-.055-.02-.042.083z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.258 21.31c-.048.004-.133-.045-.179-.076-.045-.03-.11-.035-.062.067.048.102.259.16.332.11.074-.048.043-.101.117-.03.074.07.15.119.204.119.054 0 .074 0 .015-.053-.06-.053-.088-.067-.094-.11-.006-.045-.014-.072.04-.045.054.026.116.075.159.04.042-.036.122-.115.193-.115L27 21.15c-.102-.013-.168.036-.196.053a.184.184 0 01-.134.014c-.054-.014-.125-.023-.142-.045-.017-.022-.017-.04.029-.053.045-.013.06-.062-.003-.044a.589.589 0 01-.318-.036c-.088-.044-.125-.048-.162-.026-.037.022-.032.084.022.088.054.005.177.022.22.085.042.062.036.066-.012.035s-.137-.013-.046.089zM27.014 21.191l-.014.113c.087-.007.298.06.365.196.066-.166.054-.219.101-.188.047.03.105.083.131.037.026-.045.045-.037.073-.022.028.015.089-.023.124-.09.035-.069.108-.159.15-.159.042 0 .093-.03.016-.068-.077-.037-.194.038-.234.083-.04.045-.16.075-.23.075s-.166.113-.245.046c-.08-.068-.19-.023-.237-.023z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27.921 21.044c-.236.277-.52.34-.86.377-.098.011-.068.056.017.07.354.056.765-.152.899-.378.039-.066.034-.174-.056-.07z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27 21.217c.063.008.283.2.354.283.053-.017.068-.058.058-.125-.01-.067-.017-.142.08-.125.098.017.323.008.364.008.034-.05.11-.25.144-.258-.088.017-.454.083-.5.067-.046-.017-.07 0-.1.058s-.046.083-.083.033c-.037-.05-.102-.116-.139-.041-.036.075-.112.008-.178.1zM28 21.188c.038-.02.121-.097.159-.1.07-.007.15.029.189.035.037.007.078-.003.05-.039-.026-.036-.002-.098.109-.081.11.016.166.039.274.026.108-.013.157.084.361-.013-.016.097.022.104.06.084.037-.02.08-.013.145.046.065.058.458.065.55.045.091-.02.14.04.07.065-.07.027-.087.066-.07.092.016.025.032.058-.054.045-.086-.013-.103.02-.146.058-.043.04-.054.053-.172.027-.119-.027-.14-.007-.205.006-.065.013-.08.013-.145-.013a.483.483 0 00-.291-.02c-.087.033-.151.066-.227.04-.075-.026-.08-.013-.032-.072s.06-.052.15-.065c.093-.013.163-.045.098-.091s-.086-.039-.173.013c-.086.052-.129.084-.226.02-.097-.066-.145-.053-.21-.033-.065.02-.172-.026-.264-.075z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M28.427 21.26c-.15.097-.19-.336-.347-.248-.052.03-.14.322-.02.278.122-.044.252.25.37.205.118-.044.066-.279-.003-.235z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M28.058 21.053c.086-.182.265.167.34.083.075-.083.146.187.068.333-.079.145-.269-.27-.355-.125-.086.145-.171-.041-.053-.29zM27.061 22.454c.072.005.333-.016.436-.424.008-.032.015-.045.048-.005.033.041.153.176.379.213.063.01.131.07.004.053-.127-.016-.328-.082-.396-.16-.114.336-.319.375-.471.368-.092-.004-.07-.049 0-.045z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27.695 21c-.046.072-.204.196-.275.202a1.268 1.268 0 01-.342-.039c-.054-.023-.12-.016-.043.046a.55.55 0 00.347.085c.078-.02.167-.05.227-.007.06.043.172.124.238.108a.51.51 0 01.244.006c.043.023.118.092.006.053-.112-.04-.204-.007-.256-.033.058.091.188.238.299.238.026 0 .043.053-.012.082.055.03.18.052.247-.016-.017.026-.009.042.02.058.029.017.063.04.011.046-.051.007-.169.023-.203.007a.945.945 0 00.697.146c.056-.012.086-.039-.006-.036-.19.007-.2.004-.235-.019-.034-.023-.029-.042.026-.062a1.08 1.08 0 01.25-.042c.057 0 .114-.027-.004-.027-.117 0-.26 0-.318-.022-.057-.023-.1-.053-.04-.098.06-.046.123-.033.152-.075-.19-.004-.422-.118-.293-.222.03-.025.02-.026-.028-.033a.898.898 0 01-.253-.091c-.06-.04-.02-.072.029-.082-.112.023-.336-.046-.485-.173z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M28.535 21a.607.607 0 01-.45.296c-.1 0-.113.078-.035.101.078.024.163.047.197.024.034-.024.054-.032.105.023.05.054.16.086.254.015a.55.55 0 01.315-.093c.065.008.136.016.007-.07-.128-.086-.339-.023-.39.008-.05.03-.19.008-.115-.047a.657.657 0 00.176-.21c-.027-.016-.044-.031-.064-.047zM28.372 22a.627.627 0 01-.372.184c.128.059.235.228.317.22-.04.031-.088.078-.14.086.08.028.213-.004.323-.082.183.067.42.023.5-.063a.49.49 0 01-.326-.126c.058 0 .112-.047.14-.09-.137.032-.372-.054-.442-.129z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M28.82 22.485c.066-.011.129-.075.18-.118-.13.059-.697-.065-.866-.27-.17-.203-.17-.048-.05.098.117.145.326.365.735.29z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M29 22c-.064.083-.37.132-.47.083-.1-.05-.143-.025-.118.066.025.091.036.174-.046.15-.082-.026-.228.016-.289.065-.06.05-.135.174-.007.124.128-.05.246-.107.342-.05.096.059.438.075.506.01.068-.067.021-.067-.01-.067-.033 0-.047-.05 0-.1.046-.05.081-.19.092-.281zM27.07 22.008a1.9 1.9 0 01-.477.194c-.102.07-.182.109-.233.109.035.047.172.093.228.07-.03.046-.101.1-.127.124.081-.016.177.015.218.023a.438.438 0 01-.33.11c.026.053.062.108.107.108-.096.039-.213.039-.274.008.026.077.051.124.087.132-.082.015-.183.039-.269-.039.066.132.213.178.43.14a.861.861 0 00.452-.249.827.827 0 01-.274.008c.122-.047.385-.218.43-.288a.189.189 0 01-.136-.062c.071.016.32-.03.395-.077a.321.321 0 01-.172-.171c.32.155.675.104.846.039.041-.016.046-.095-.035-.086-.142.016-.416-.047-.487-.101a.446.446 0 00.203.14c-.132.054-.314.093-.583-.132z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.84 22.309c.031-.018.117-.06.154-.095a.472.472 0 01-.276-.054c.061 0 .16-.03.282-.083-.22-.006-.374-.006-.454-.048-.08-.042-.227-.03-.282-.018-.055.012-.037.101.196.078-.098.065-.362.089-.46.065.025.077.043.155.018.196.13.072.467.16.632.149-.147-.054-.227-.113-.104-.125.123-.012.19-.036.295-.065z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.068 22.398c.25-.029.586-.035.852-.35.068-.08.114-.053.047.03-.14.174-.491.415-.826.422-.136.003-.199-.088-.073-.102zM27.4 22a.557.557 0 01-.236.055c-.043-.01-.105-.013-.139.02-.034.031-.036.05.01.057a.736.736 0 00.137.01.295.295 0 00-.072.096c.068-.025.194.02.23.052-.028.013-.06-.003-.083-.023.115.184.457.184.512.152-.026.029-.05.058-.075.067a.321.321 0 00.316-.074c-.036.01-.145-.006-.173-.01a.209.209 0 01.083-.074c-.042-.012-.177-.006-.209.02.013-.039.037-.087.062-.103-.168 0-.373-.003-.448-.065.12.02.252-.087.307-.087-.093-.003-.196-.035-.221-.093z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27.386 22c-.113.074-.285.222-.332.306-.047.083-.096.13.006.13.102 0 .379.036.44.064a1.173 1.173 0 00-.405-.093c-.041 0-.088-.009-.012-.083.076-.074.175-.24.303-.324z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27 22.183c.062 0 .333 0 .44-.183.11.166.324.4.461.4.138 0 .125.07.005.097-.12.026-.355-.113-.475-.288-.16.114-.293.018-.431-.026zM26 23c.101.074.235.129.333.068.056.092.17.098.232.073.062-.024.118-.037.187.006.068.043.209.046.248.107-.036.004-.113 0-.13.01-.019.009-.009.03.024.064-.111-.012-.303.077-.361.172.02-.095.086-.224.19-.224-.06-.04-.248-.043-.308.028a.476.476 0 01-.04-.123c-.1.107-.297-.046-.375-.181zM25.052 23.314c.257-.06.432-.19.509-.314.045.067.233.134.439.034-.042.05-.045.145-.028.196a1.115 1.115 0 00-.48.184c-.088.073-.343.123-.426.05-.084-.072-.087-.134-.014-.15z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.36 22.542a.99.99 0 00-.36.107.46.46 0 01.023.12c.188-.084.618-.136.783-.104-.079.007-.227.107-.31.12.203-.02.401.033.453.049.052.016.063.065.024.11-.04.046-.058.052.026.056.083.003.255-.01.334-.104-.032-.043-.113-.026-.136-.056a.36.36 0 00.14-.107 1.027 1.027 0 01-.24-.02c-.046-.012-.08-.028-.023-.067a.363.363 0 00.102-.098c-.102.036-.26.065-.394-.064.05.016.167.006.209-.017-.045-.029-.08-.052-.117-.052.106-.065.318-.123.578.007a.972.972 0 01.37.026c.042-.052.131-.176.178-.208-.308.032-.86-.039-.85-.24-.1.162-.329.253-.428.227-.01.058.032.13.068.169-.104.026-.282.045-.365.026.047.058.136.11.188.104-.11 0-.167.026-.253.016zM27 23.36c.068.004.208-.01.272-.108-.026-.045-.091-.028-.11-.058a.316.316 0 00.114-.113c.178-.023.338-.01.414-.047.076-.037.272-.017.31-.034-.17.044-.204.068-.212.112-.009.044.055.082.095.082-.076-.007-.172.122-.18.173-.102-.095-.151.017-.162.055-.042-.027-.182-.02-.254.078-.094-.044-.155-.068-.249-.044.058-.02.047-.082-.038-.096z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27.208 23.006c.083-.006.263.012.327-.006a.578.578 0 00-.11.16c.208-.05.492-.08.575-.055-.1-.031-.205.098-.257.166-.052.068-.021.11.05.13.07.018.164.128.036.092a1.242 1.242 0 00-.443-.019c-.062.019-.095-.043-.007-.068a.403.403 0 00.193-.135c-.074.037-.214.037-.257.012-.043-.024-.07-.074-.021-.098.049-.025.015-.062-.037-.05-.052.013-.184.124-.257.265.08-.166.15-.314.208-.394z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M27.07 23.05c.091.21.2.329.371.34.036.002.103.102.017.108-.233.017-.35-.096-.452-.403-.021-.063.018-.151.064-.046zM28.067 21.027c.185.186.557.348.847.321.05-.004.152.11.025.134-.327.063-.62-.035-.893-.356-.076-.09-.05-.17.02-.099z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M28.087 21.252c.219-.026.383-.013.45.248.126-.157.351-.248.403-.209.051.04.11-.052-.01-.17-.12-.116-.396-.155-.483-.09-.087.065-.357.104-.447.065.039.026.064.052.087.156zM29 21.147c.11-.192.429-.012.526-.147-.07.27.222.293.474.079-.097.203-.304.237-.394.36-.09.125-.139.035-.208-.067-.07-.101-.246-.304-.398-.225z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M29.753 21.414c-.19.127-.41.114-.357-.046-.073.08-.313-.027-.396.086.086-.133.151-.026.213-.3.04.02.13.033.162-.074.055.034.151.094.18.167.028.074.072-.02.036-.133.086-.08.031.095.232-.034A.837.837 0 0130 21c-.068.14-.148.294-.247.414z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.993 19.81L27 20l-.273-.01-.291-.009-.197-.007-.239-.01v-3.69c0-.161.194-.264.406-.273.23-.01.438.094.438.273a53.091 53.091 0 00.074 1.983l.075 1.553zm-.516-.18l.008.168h.022v-.167l-.03-.001zM27.491 20.76l.237-.012v-.018l-.13-.158-.061.036.139.17h.004l-.002-.209-.2.002v.013l.013.177zm-.23-4.332h.134v-.214l-.134.007v.207zM28 20.853l-.176.105-.142.039-.443.003L27 16h.63l.37 4.853zM28.983 19.779L29 20l-.272-.004-.145.001h-.018l-.128.002h-.24l-.011-.195c-.024-.393-.06-1.017-.093-1.596-.049-.87-.082-1.54-.093-1.901-.005-.17.153-.294.343-.306.201-.013.378.106.389.285.047.79.163 2.364.25 3.493zm-.407-.191h-.018l-.093.001.016.203.206-.008-.012-.197-.1.001z"
                        fill="#000"
                    />
                    <path
                        d="M25.297 17.894c-.236-.097-.34-.355-.281-.682l.037-.212 1.915.045.025.218c.027.236-.023.455-.148.59a.353.353 0 01-.409.097.42.42 0 01-.348 0c-.134.08-.291.064-.44-.045a.523.523 0 01-.35-.01zm1.207-.397c.037-.036.1-.029.1-.028l-.082-.098a.27.27 0 01-.018.126zm0 .002l.002-.003-.003.003zm-.275-.002l.023-.035c.012.019-.013.02-.023.035zm-.368-.006l.02-.035c.025.046-.026.044-.02.035z"
                        fill="#000"
                    />
                    <path
                        d="M25.167 17.865c-.217-.163-.215-.479-.036-.76l.067-.105 1.802.01-.047.298c-.075.473-.301.663-.561.577-.13.115-.29.155-.435.069a.412.412 0 01-.342-.067c-.154.075-.319.074-.448-.022zm.99-.368c-.007-.009-.013-.012-.014-.018l.013.018zm-.668-.093c-.044.068-.047.062-.073.042l.073-.042z"
                        fill="#000"
                    />
                    <path
                        d="M25.317 18.855c-.227-.072-.334-.303-.315-.615l.016-.24 1.969.025.012.238a.806.806 0 01-.128.486c-.1.137-.24.186-.374.147a.378.378 0 01-.36.027.45.45 0 01-.577-.062.453.453 0 01-.243-.006zm1.195-.565a.324.324 0 01-.03.151c.047-.053.16-.047.177-.023l-.09-.131-.057.003zm-.03.151l.003-.003-.003.003zm-.238.011c-.003.007.068-.003.046-.028l-.02-.024-.026.052zm-.785-.084c-.01-.003.01-.01.02-.017l.004-.005c-.003.028-.008.027-.024.022zM25.163 19.831c-.15-.117-.197-.322-.139-.56l.043-.176 1.816.04.06.122c.21.435-.196.856-.596.67-.146.084-.31.084-.423-.007a.3.3 0 01-.088 0 .389.389 0 01-.17.075.314.314 0 01-.276-.085.375.375 0 01-.227-.079zm1.058-.25c-.01-.05-.075-.056-.048-.088l.034-.039.014.127zm-.52-.012l.007.035a.068.068 0 00-.024-.035l-.453-.01.216-.173a1.429 1.429 0 00-.004.017l.2-.15.015.08.056-.156.169.221.272-.398.052.454.11-.128.161.148c.07.064.099.04.076-.007l.19.125-.523-.011v0l-.52-.012zm.252-.079c-.038-.05-.11-.033-.125-.011l.055-.081.07.092zm-.252.079h-.017a.11.11 0 00-.086-.028c-.015.002-.017.004-.02.01l.08-.218.043.236zm-.279-.109c-.019-.014-.037-.014-.055 0l.076-.057c-.013.055-.012.065-.02.057zM27.043 19.295L27 19l1.994.024.006.246c.004.2-.06.43-.182.572-.154.179-.361.203-.554.087a.565.565 0 01-.54-.03c-.33.195-.603-.077-.68-.604zm.504.094l.006-.006c-.006.082-.038.042-.006.006z"
                        fill="#000"
                    />
                    <path
                        d="M27.206 18.969c-.126-.08-.192-.335-.2-.694L27 18l.982.09.014.209c.034.478-.169.806-.342.632-.076.09-.17.095-.25-.004-.06.065-.13.085-.198.042zm.552-.529c.007.022-.011.044-.02-.063l.02.063zm-.02-.075l.122.219-.73-.068.137-.262c.004.157.017.223.02.235-.003-.008.007-.021.02-.059l.128-.356.096.382.096-.426.11.347v-.012zm-.205.098c.01.039-.014.044-.006.01l.004-.017.002.007zm-.246.026l-.002-.002.002.002zM27.013 17.357L27 17.121h1.888l.065.133c.108.219.022.47-.173.614a.489.489 0 01-.482.07.529.529 0 01-.238.062.41.41 0 01-.302-.119c-.347.126-.722-.115-.745-.524zm1.502.175c-.003-.005-.048-.01-.043-.013a.103.103 0 00.021-.022l.022.035zm-.009-.095l.224.133h-1.472l.245-.236c.007.142.068.166.152.067l.338-.401.097.499c.007.036.007.048-.002.052-.011-.017.005-.03.017-.045l.226-.274.162.265c.016-.02.02-.045.013-.06zm-.418.114c-.006.003-.017 0-.033 0-.002 0 .003-.003.011-.009l.022.009zM27.149 16.95c-.103-.092-.157-.29-.148-.514l.007-.183.983-.037.008.191c.014.363-.123.618-.275.525a.215.215 0 01-.019.017c-.063.05-.12.045-.167.002a.156.156 0 01-.169.004c-.065.058-.144.063-.22-.005zm.583-.383c-.008.01 0-.041-.004-.136l.075.1c-.015-.002-.042 0-.071.036zm.135.05l-.727.028.12-.171.11-.469.087.428.092-.433.084.37.037-.137.144.3-.011-.002.064.086zm-.186-.032c.004.015-.039-.037-.104.014-.013.01-.004-.01 0-.025l.056-.204.048.215zm-.19.015c-.006-.027-.065-.022-.068-.012l.034-.155.033.167zm-.22-.142a.391.391 0 00.017.15c-.027-.022-.06.003-.056-.016l.028-.118.011-.016zm.017.15a.04.04 0 010 0z"
                        fill="#000"
                    />
                    <path
                        d="M28 17.3l.007-.235 1.973.027.017.216c.037.462-.3.762-.639.61a.493.493 0 01-.547 0 .412.412 0 01-.47-.138c-.189-.037-.347-.232-.34-.48zm.725.21c0-.032-.056-.049-.053-.052l.053-.06v.113zm.164-.298l.159.289c.016.03.051.031.066-.001l.146-.31.233.249c.053.056.052.057.04-.093l.229.219-1.532-.022.003-.237.132.003.36-.309v.398l.164-.186zm-.517.097a.12.12 0 00-.03.02l.023-.02h.007zm.091.003l-.09-.003c.043-.018.08 0 .09.003zM28.011 18.294L28 18.037l1.98.009.018.224c.025.319-.176.606-.454.604a.479.479 0 01-.604.036.4.4 0 01-.406-.11c-.253.026-.509-.18-.523-.506zm.864.159c-.001-.01-.055-.023-.059-.02l.049-.046.01.066zm.131-.203l.158.214c.042.058.065.058.093.012l.107-.176.184.08c-.017-.007-.015-.008-.02-.07l.235-.02-.001.246-1.516-.007.236-.257c.002.038.002.039 0 .04l.323-.312.06.387.141-.137zM28 19.3v-.243l1 .045-.01.247c-.023.509-.224.775-.398.594-.082.079-.177.06-.256-.048-.156.103-.336-.157-.336-.595zm.482.151c.022.083-.027.075-.02.048l.017-.06.003.012zm.092-.351l.135.377c.018.052-.008.074.002-.162l.135.254-.71-.032.13-.215.1-.322.113.44.095-.34zm-.295.2c0 .157-.043.12-.048.136l.035-.114.013-.022z"
                        fill="#000"
                    />
                    <path
                        d="M27.283 19.938c.037-.061.061-.1.08-.128.025-.04.048-.076.07-.108a.43.43 0 01.09-.098.341.341 0 01.145-.066l.022-.005c.03-.007.21-.037.344-.06a.539.539 0 01.124-.179l.112-.044c.394-.01.942-.03 1.495-.053l.12-.005.055.117c.036.08.066.21.059.306l-.01.15-.087.022.014.017.044.162-.035.286h-.071l-.055.16c-.04.112-.099.168-.197.199a.63.63 0 01-.183.245l-.074.06-.09-.027a.652.652 0 00-.244.004 1.13 1.13 0 01-.497.03 1.521 1.521 0 00-.406.015.975.975 0 01-.364.007c-.043-.01-.099-.004-.214.024-.185.045-.373.047-.511-.031a1.427 1.427 0 01-.442-.037c-.074-.02-.159-.003-.275.045-.205.085-.432 0-.654-.272a2.581 2.581 0 00-.543-.503l-.098-.07a193.24 193.24 0 01-.864-.614c-.135-.097-.203-.27-.075-.41.087-.097.221-.097.325-.03a115.065 115.065 0 01.968.621c.241.157.332.193.64.243.28.046.668.057 1.268.048l.014-.021zm1.075-.25l-.021.147-.134.024c-.119.022-.409.07-.435.075l-.02.005c-.007-.002-.01.001-.015.01a2.823 2.823 0 00-.063.095l-.078.126c-.032.05-.056.087-.079.119l-.055.076-.09.002c-.673.013-1.101.002-1.422-.05a4.674 4.674 0 01-.105-.019l.087.103c.126.155.195.18.241.161.181-.074.33-.104.496-.06.113.03.283.037.368.021l.089-.017.068.067c.018.018.147.023.26-.004.163-.04.262-.05.37-.025.044.01.136.005.23-.012.152-.026.367-.038.517-.014.12.018.254.01.336-.018.09-.03.229-.037.34-.026a.284.284 0 00.037-.092l.032-.136.127-.018c.047-.006.021.009.01.034.047-.131.08-.232.09-.27l.007-.03-.043-.165.027-.18c-.426.017-.837.032-1.161.04a.154.154 0 00-.011.031zm1.415-.27l-.003-.015-.165.09a.355.355 0 01.02.09l.154.013-.006-.179zm-.18.604l.081.012.087-.083v-.015l-.172-.025-.012.092.015.019z"
                        fill="#000"
                    />
                    <path
                        d="M29.664 19.893l-.053.103-.173-.002-.048.001h-.017c-.024.002-.024.002-.05.002L29 20l.098-.195c.042-.082.146-.29.325-.651.05-.101.188-.173.358-.15.18.026.254.14.204.244-.147.3-.248.502-.321.645zm-.222-.046l.005-.147c-.04 0-.04 0-.078.002h-.015l-.037.001.003.12.122.024zM29.182 18.192l.082-.04c.095-.046.224-.036.333.006.007.002.041-.008.171-.075L29.93 18l.051.175c.033.11.02.282-.013.372-.005.015-.007.037-.008.034.03.089-.003.204-.07.29l-.048.062-.08-.004-.022-.001a.785.785 0 00-.072-.002c-.024 0-.036.004-.024-.009-.097.103-.34.102-.51.042L29 18.912l.039-.136c.038-.134.085-.3.14-.502l.003-.082zm.307.247a.263.263 0 00-.04-.011l-.075.272c.032.003.055.006.05.011.059-.062.135-.082.234-.086h.005a.402.402 0 01.02-.178.284.284 0 01-.194-.008zM25.578 17l.422.144c-.29.816-1.181 2.367-1.685 2.856L24 19.689c.45-.436 1.308-1.93 1.578-2.689z"
                        fill="#000"
                    />
                    <path
                        d="M25.203 19L25 18.747c.543-.398 1.541-1.397 1.691-1.747l.309.12c-.179.417-1.21 1.45-1.797 1.88z"
                        fill="#000"
                    />
                    <path
                        d="M25.492 18l.508.073A37.51 37.51 0 0125.503 20L25 19.905c.218-.782.403-1.487.492-1.905z"
                        fill="#000"
                    />
                    <path
                        d="M25.689 19l.311.307a7.117 7.117 0 00-.324.325l-.038.04c-.15.152-.25.25-.345.328L25 19.677c.078-.065.172-.155.31-.297l.039-.039c.251-.258.258-.266.34-.341zM27.507 18l.374.363-.097.1c-.089.09-.158.158-.228.219a1.126 1.126 0 01-.406.249l-.15-.5a.697.697 0 00.213-.142c.058-.05.119-.11.199-.19l.095-.099z"
                        fill="#000"
                    />
                    <path
                        d="M27 18.336l.399-.336c.179.213.38.382.5.419l-.152.498c-.242-.073-.507-.297-.747-.581zM27.58 17l.38.356c-.24.258-.527.477-.788.568L27 17.432c.166-.058.39-.23.58-.432z"
                        fill="#000"
                    />
                    <path
                        d="M27 18.362l.375-.362c.047.049.095.103.183.204.12.136.197.209.27.248l-.249.458c-.142-.077-.254-.181-.412-.361a5.133 5.133 0 00-.167-.187zM27.196 17.89L27 17.405c.164-.067.4-.25.507-.406l.43.295c-.168.243-.484.49-.74.594z"
                        fill="#000"
                    />
                    <path
                        d="M27 17.293l.431-.293c.112.165.365.347.518.4l-.17.493a1.777 1.777 0 01-.779-.6zM27.163 16.858L27 16.363a.705.705 0 00.416-.363l.473.22a1.222 1.222 0 01-.726.638z"
                        fill="#000"
                    />
                    <path
                        d="M27 16.34l.396-.34c.18.21.41.401.486.411l-.069.517c-.251-.033-.548-.28-.813-.589zM28.319 17l.448.266c-.197.333-.49.636-.767.627l.016-.52c.005 0 .205-.207.303-.373z"
                        fill="#000"
                    />
                    <path
                        d="M28 17.246l.46-.246c.08.149.282.361.311.366l-.083.514c-.235-.038-.538-.354-.688-.634z"
                        fill="#000"
                    />
                    <path
                        d="M28.192 17.894L28 17.41c.195-.077.445-.259.553-.41l.424.304c-.171.238-.502.478-.785.59zM28 18.246l.46-.246c.057.107.292.35.367.38l-.194.485c-.204-.082-.523-.414-.633-.62zM28.152 19.831L28 19.333c.084-.026.287-.206.329-.333l.495.164c-.1.297-.434.595-.672.667z"
                        fill="#000"
                    />
                    <path
                        d="M28 18.289l.434-.289c.1.15.314.371.393.405l-.209.478c-.192-.084-.468-.368-.618-.594zM25.105 19L25 18.596c.2-.076.572-.367.735-.596l.265.277c-.207.29-.635.624-.895.723zM26 19.39l.346-.39c.28.25.514.41.654.44l-.114.51c-.255-.058-.541-.254-.886-.56z"
                        fill="#000"
                    />
                    <path
                        d="M25.261 18.876l-.261-.45c.178-.104.348-.25.473-.426l.425.302a2.037 2.037 0 01-.637.574zM26 18.26l.448-.26c.041.073.466.367.552.37l-.01.52c-.282-.005-.864-.409-.99-.63zM25.487 17l.402.331c-.173.211-.51.502-.696.577L25 17.424c.088-.035.365-.275.487-.424zM26 17.36l.377-.36c.225.235.47.42.56.42v.52c-.295 0-.604-.231-.937-.58zM25.442 16l.406.327c-.247.307-.462.513-.692.585L25 16.415c.093-.03.263-.193.442-.415zM26 16.25l.457-.25c.081.148.313.352.405.369l-.096.512c-.266-.05-.617-.358-.766-.631zM28 17.191l.38-.191c.375.634 1.027 1.319 1.62 1.662l-.23.338c-.66-.382-1.361-1.118-1.77-1.809zM27 17.218l.364-.218c.083.101.43.537.468.584.219.271.404.493.592.707.477.543.91.956 1.314 1.227.09.061.177.114.262.159l-.234.323a3.317 3.317 0 01-.304-.183c-.439-.297-.895-.73-1.393-1.298-.192-.218-.38-.445-.602-.72-.04-.049-.386-.482-.467-.581z"
                        fill="#000"
                    />
                    <path
                        d="M28.717 19l.283.21c-.204.29-.46.554-.807.79L28 19.701c.31-.21.536-.444.717-.701zM30 18.8l-.313.2c-.19-.305-.328-.653-.487-1.192a45.917 45.917 0 01-.2-.706l.357-.102c.103.37.15.539.198.7.15.51.277.83.445 1.1zM26 19.114l.49-.114.508.886-.49.114z"
                        fill="#000"
                    />
                    <path fill="#000" d="M26 19.11l.492-.11.5.89-.492.11z" />
                    <path fill="#000" d="M26 19.102l.494-.102.5.898L26.5 20z" />
                    <path
                        fill="#000"
                        d="M26 19.106l.493-.106.5.894L26.5 20zM26 20.521V20h.5v.521z"
                    />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26 20.521V20h.5v.521z" />
                    <path fill="#000" d="M26 20.521V20h.5v.521zM26 19.521V19h.5v.521z" />
                    <path fill="#000" d="M26 19.521V19h.5v.521z" />
                    <path fill="#000" d="M26 19.521V19h.5v.521z" />
                    <path fill="#000" d="M26 19.521V19h.5v.521z" />
                    <path fill="#000" d="M26 19.521V19h.5v.521z" />
                    <path fill="#000" d="M26 19.521V19h.5v.521zM25.5 19l.479.15-.5.85-.479-.15z" />
                    <path
                        fill="#000"
                        d="M25.5 19l.483.138-.5.862-.483-.138zM26.5 19l.487.125-.5.875-.487-.125z"
                    />
                    <path fill="#000" d="M26.5 19l.49.116-.5.884-.49-.116zM26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.528 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20z" />
                    <path fill="#000" d="M26.5 20v.521H26V20zM26.5 19v.521H26V19z" />
                    <path fill="#000" d="M26.5 19v.521H26V19z" />
                    <path fill="#000" d="M26.5 19v.521H26V19z" />
                    <path fill="#000" d="M26.5 19v.521H26V19z" />
                    <path fill="#000" d="M26.5 19v.521H26V19z" />
                    <path fill="#000" d="M26.521 20H26v-1h.521z" />
                    <path fill="#000" d="M26.672 19l.328.22-.672 1.78-.328-.22z" />
                    <path fill="#000" d="M26.629 19l.371.188L26.371 21 26 20.812z" />
                    <path
                        fill="#000"
                        d="M26.566 19l.434.152L26.434 21 26 20.848zM27.499 19l.501.126L27.501 21 27 20.874z"
                    />
                    <path fill="#000" d="M26.601 20v.521H26V20z" />
                    <path fill="#000" d="M26.56 20v.521H26V20zM27.515 20v.521H27V20z" />
                    <path fill="#000" d="M27.5 20v.521H27V20z" />
                    <path fill="#000" d="M27.5 20v.521H27V20z" />
                    <path fill="#000" d="M27.5 20v.521H27V20zM27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path fill="#000" d="M27.5 19v.521H27V19z" />
                    <path
                        fill="#000"
                        d="M27 19.124l.487-.124.5.876L27.5 20zM28 19.134l.484-.134.507.866-.484.134z"
                    />
                    <path fill="#000" d="M28 19.155l.441-.155.559.845-.441.155z" />
                    <path
                        fill="#000"
                        d="M29 19.817l-.409.183-.591-.817.409-.183zM28.52 20v.521H28V20z"
                    />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19v.521H28V19z" />
                    <path fill="#000" d="M28.5 19l.482.14-.5.86-.482-.14z" />
                    <path fill="#000" d="M28.5 19l.484.134-.5.866-.484-.134z" />
                    <path fill="#000" d="M28.48 20l-.48-.148.5-.852.48.148z" />
                    <path fill="#000" d="M28.5 19l.476.16-.5.84-.476-.16zM28 20.521V20h.5v.521z" />
                    <path fill="#000" d="M28 20.521V20h.5v.521zM28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.521V19h.5v.521z" />
                    <path fill="#000" d="M28 19.243l.447-.243.5.757L28.5 20z" />
                    <path
                        fill="#000"
                        d="M28 19.23l.452-.23.5.77-.452.23zM29 19.23l.452-.23.5.77-.452.23z"
                    />
                    <path fill="#000" d="M29 19.25l.445-.25.5.75-.445.25z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path fill="#000" d="M29.5 19v.521H29V19z" />
                    <path
                        d="M26 21.156c.163-.237.441-.19.583.047.168-.213.473-.154.615.13.215-.331.4-.379.61-.059.162-.26.414-.284.609.024.189-.202.4-.367.583.071-.11-.178-.347-.332-.583.084-.184-.416-.504-.262-.61.023-.136-.368-.425-.427-.599.024-.189-.356-.472-.368-.625-.095-.12-.214-.3-.391-.583-.25z"
                        fill="#5C5568"
                    />
                    <path
                        d="M28.986 20.9c-.794.202-2.523.059-2.902-.081-.13-.048-.095-.118.015-.08.437.145 1.37.146 1.883.11.1-.195.257-.526.305-.618.047-.091.068-.1.167-.124.177-.045.278-.068.432-.107.002.03.002.066.002.088-.012.015-.025.04-.035.048 0 .15.02.518.04.65.02-.004.045-.015.058-.018.035-.015.07.117.035.132z"
                        fill="#5C5568"
                    />
                    <path
                        d="M29.559 20.722l.124-.002c.038 0 .092-.018.116-.058.023-.04.096-.186.123-.247l-.095-.096c.021-.078.048-.185.05-.207l.121-.03c.006-.018-.005-.066-.03-.082-.404.01-1.614.039-1.835.04-.054 0-.077-.001-.098.05-.112.281.043.676.467.903.03.016.067.003.017-.027a1.198 1.198 0 01-.254-.221l.301-.004c.024.066.1.207.114.23.015.024.052.028.034-.008-.04-.083-.062-.178-.08-.224.077 0 .222 0 .31-.003.005.075.017.176.02.204.003.027.038.03.039-.002 0-.032.002-.166.001-.205l.275-.005c-.007.043-.019.181-.024.203-.006.033.019.048.03.002a2.17 2.17 0 00.043-.206l.19-.004c-.005.042-.064.17-.082.204-.018.034.011.035.031.003a.899.899 0 00.092-.208z"
                        fill="#5C5568"
                    />
                    <path
                        d="M28.148 20.5c-.034-.069-.139-.314-.148-.492l.422-.008c.016.134.056.423.078.492l-.352.008zM29 20.01c.014.101.078.45.088.49.111-.005.368-.006.412-.01l-.025-.49-.475.01z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M28.021 20.014a3.02 3.02 0 00-.019.485c.131.003.453-.005.498-.01L28.46 20c-.106.005-.368.012-.439.014zM29 20.016c.004.116.026.398.033.484l.467-.013-.021-.487c-.145.004-.387.015-.479.016z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M29 20.017c.005.106.019.406.015.483.133-.003.388-.006.467-.012.007-.107.024-.41.016-.488l-.498.017z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M29.013 20.02c0 .087-.01.396-.013.48l.436-.017c.018-.103.053-.37.064-.483l-.487.02z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M29.42 20l-.382.012c-.01.156-.03.426-.038.488.107-.002.322-.01.37-.01.035-.075.112-.306.13-.377-.027-.043-.047-.068-.08-.113z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M29 20.01c0 .055.014.456.018.49.107-.002.384-.005.425-.008.02-.156.051-.455.057-.492l-.5.01zM28.483 20l-.143.025c-.066.107-.31.437-.34.475.17-.005.436-.01.5-.016a26.84 26.84 0 01-.017-.484z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M28 20.045l.026.455c.132-.004.375-.014.474-.019-.023-.13-.064-.443-.073-.481l-.427.045z"
                        fill="#7E7B80"
                    />
                    <path
                        d="M26.992 19.438a.63.63 0 010 .209c-.023.149-.07.252-.25.234l-1.527-.197c-.152-.015-.187-.103-.208-.24A.646.646 0 0125 19.34c.001-.049.001-.049.008-.104.027-.16.066-.253.25-.232l1.53.197c.152.018.182.095.204.238zM27.74 18.681v0zm.152-.175a.19.19 0 00-.007-.003l.007.003zm-.631-.165zm.63.009l.006.003c.073.04.087.106.099.226l.004.099a.956.956 0 01-.005.104c-.003.035-.003.035-.018.096-.035.1-.035.1-.146.122l-.723-.333c-.076-.036-.093-.112-.104-.23a1.034 1.034 0 01-.004-.102c0-.047 0-.047.005-.101.018-.166.05-.28.164-.216l.722.332zM26.764 18.266a1.694 1.694 0 00-.095-.006l.095.006zm-1.493-.104l.15.01a.604.604 0 00-.15-.01zm1.488-.058h.008c.167.018.2.095.225.238.007.054.007.054.008.102a.576.576 0 01-.008.107c-.026.15-.077.252-.264.235l-1.472-.103c-.18 0-.224-.095-.248-.239a.584.584 0 01-.008-.106c.001-.048.001-.048.009-.102.027-.153.063-.237.262-.236l1.488.104zM26.992 17.314c.007.054.007.054.008.102a.603.603 0 01-.007.106c-.024.143-.067.238-.251.238l-1.494-.076c-.174 0-.217-.096-.24-.239A.6.6 0 0125 17.34c.001-.048.001-.048.009-.103.028-.16.07-.253.249-.233l1.5.074c.172.002.208.086.234.237z"
                        fill="#000"
                    />
                    <path
                        d="M26.787 17.389a.478.478 0 00-.041-.006l.04.006zm-1.313-.04v-.01.01zm1.518.114c.007.054.007.054.008.102a.584.584 0 01-.008.107c-.027.157-.083.268-.276.232l-1.502-.217c-.151-.028-.186-.11-.207-.239a.605.605 0 01-.007-.105c.001-.049.001-.049.01-.104.03-.167.08-.271.274-.23l1.49.216c.163.018.194.095.218.238zM27.995 16.236c.004.054.004.054.005.103 0 .049-.001.072-.004.106-.013.136-.034.224-.126.239l-.717.118c-.106.018-.134-.085-.149-.234A1.034 1.034 0 0127 16.46c0-.048 0-.048.005-.102.013-.143.031-.22.125-.238l.717-.118c.108-.02.132.073.148.233zM28.737 17c.188 0 .226.085.254.236a.568.568 0 01.001.209c-.025.143-.07.238-.255.238h-1.474c-.184 0-.23-.095-.255-.238A.568.568 0 0127 17.34c.001-.048.001-.048.009-.103.028-.151.066-.236.254-.236h1.474zM29.751 18c.178 0 .214.085.24.236a.6.6 0 01.001.209c-.023.143-.066.238-.24.238h-1.503c-.175 0-.218-.095-.242-.238A.6.6 0 0128 18.34c.001-.048.001-.048.009-.103.026-.151.062-.236.24-.236h1.502z"
                        fill="#000"
                    />
                    <path
                        d="M29.775 17.15c.162.018.193.095.217.238a.67.67 0 010 .209c-.025.15-.073.252-.257.235l-1.51-.148c-.159-.015-.196-.103-.218-.24A.617.617 0 0128 17.34c.001-.048.001-.048.009-.103.028-.16.069-.254.256-.233l1.51.147zM28.752 19.252a1.59 1.59 0 00-.117-.007l.117.007zm-.007-.162h.01c.176.018.21.095.236.238.008.054.008.054.009.103a.548.548 0 01-.008.106c-.028.15-.081.252-.276.235l-1.468-.087c-.175-.016-.216-.104-.24-.24A.562.562 0 0127 19.34c.001-.048.001-.048.01-.103.03-.16.075-.253.274-.233l1.461.087z"
                        fill="#000"
                    />
                    <path
                        d="M28.164 19.165l.066.014a.373.373 0 00-.066-.014zm.831.229a.99.99 0 010 .209c-.015.149-.044.252-.159.233l-.7-.152c-.096-.016-.119-.104-.132-.24a1.017 1.017 0 01-.004-.106c0-.048 0-.048.005-.103.017-.16.042-.253.159-.232l.703.153c.095.018.114.096.128.238zM30 19.091l-.047.313a.604.604 0 01-.021.097.134.134 0 00-.006.034l-.004.108-.091.04a.36.36 0 01-.152.033.092.092 0 00.028-.013.13.13 0 01-.026.021l-.003.016a.43.43 0 01-.083.18l.01-.01c-.063.072-.158.093-.278.09l-.324-.008.174-.22a.46.46 0 01-.021-.004l-.156-.04.043-.167.036-.142.043-.165.15.051a.254.254 0 00.019.006c.006-.04.01-.082.012-.11l.01-.201.179.048a.535.535 0 01.065.022l.005-.002.136-.03.04.146a.334.334 0 01.008.039L30 19.09zm-.277.598a.201.201 0 01-.014.014l.014-.014zm-.047.026h-.01l.013.001h-.003zm-.33-.106l.197.006.012-.223-.14.035-.021.138-.005.039a1.403 1.403 0 01-.006.05.272.272 0 00.065-.01l.097-.092a1.15 1.15 0 00.057-.268l-.01-.053-.146.048a.464.464 0 01-.004.1l.007.002a.28.28 0 00.173.013l-.001-.006a.216.216 0 00-.104.057c.017-.017.027-.02.038-.018l-.128-.01-.08.192zm.3-.221a.49.49 0 00-.024.133l.152.007-.057-.154-.028.01a.226.226 0 00-.042 0 .05.05 0 01-.001.004zm-.137.065zm-.308.1l-.011.053.146.044.037-.141-.147-.045-.025.088zM25.394 13.105a.49.49 0 01.384-.097c.222.038.388.188.33.36l.064.014-.006.08.252.124-.157.081.105.08-.211.119c-.096.053-.11.213-.043.28.153.15.297.168.813.134l.105-.007.07.009c.035.01.071.023.109.039.005-.002.01-.002.017-.003.033-.003.033-.003.054-.003a10.853 10.853 0 01.266.004.337.337 0 01.167.043l.027.017c.044.028.145.116.192.165.058.06.09.14.05.21a.24.24 0 01.006.022c.018.089-.02.14-.116.192-.052.014-.052.014-.076.015a.293.293 0 01-.205-.052 1.893 1.893 0 00-.4-.19.664.664 0 00-.25-.017l-.038.024-.031.091a.226.226 0 01-.067.109.203.203 0 01-.308-.044l-.052-.078-.004-.007a3.537 3.537 0 01-.006-.01.746.746 0 01-.712-.193l-.623-.57.291.108a.138.138 0 01.002-.038v-.01a.103.103 0 01-.017-.056l-.028-.017.012-.097c.04-.334.041-.327-.078-.403a.275.275 0 01-.079-.072.607.607 0 00-.04-.007c-.03-.003-.03-.003-.073-.017-.1-.043-.1-.043-.08-.25.045-.056.09-.069.154-.074a2.015 2.015 0 01.218.001.816.816 0 01.012-.01zm-.027.1a.33.33 0 01.085.01.143.143 0 00-.054-.003l-.031-.007zm.196 1a.41.41 0 01.002.001l-.002-.002zm.079-.292l-.004-.001h.004zm-.008.42zm-.005-.294a.236.236 0 01.004 0h-.004zm.218.097h-.003.003zm.1.06h-.011.011zm.585.582a.146.146 0 00.031-.007l-.015.005-.016.002zm1.347-.147a3.353 3.353 0 01-.002-.003l.002.003zm-.34.182a.986.986 0 01-.005-.004l.005.004zm-1.74-1.496a.364.364 0 00-.013-.009l.012.01zm-.457.091a.2.2 0 00.006.03l.011.001.079.005.128-.043a.78.78 0 01.073-.055c-.003-.062-.051-.11-.114-.14-.108.004-.198.06-.183.202zm.077.13a.2.2 0 00.183-.083.206.206 0 00.034-.074.784.784 0 00-.148-.115c.061.039.11.116.016.215-.034.036-.064.05-.091.053a.205.205 0 00.006.005zm.196.047a.134.134 0 01-.036-.01.113.113 0 00.016.011h.02zm-.003 0zm-.04-.014zm.156.295a.259.259 0 01.008.004.496.496 0 01.11-.188c0-.012 0-.024.003-.036a.23.23 0 01-.018-.023.418.418 0 01-.095.005 1.48 1.48 0 01-.008.238zm.134-.25a.14.14 0 01-.034 0 .216.216 0 00.004.006.518.518 0 00.03-.006zm-.008 0a.094.094 0 00.008 0h-.008zm.09.054l.038-.16-.093-.005c-.052.069-.04.161.017.229-.057-.067-.024-.177.056-.213-.063.029-.098.07-.11.114a.267.267 0 00.091.035zm.018.063l.048-.08-.044-.065a.5.5 0 00-.102.075.35.35 0 00.098.07zm-.239.184c.065.04.102.116 0 .217a.486.486 0 00.023.078c.118-.13.117-.131.047-.255a.216.216 0 00-.068-.046.516.516 0 00-.002.006zm0 .005v-.005.005zm-.01.074a.149.149 0 01.018.174.172.172 0 00.094-.183c-.057-.046-.135-.055-.22-.047.003 0 .01.001.03.007.015.005.03.012.042.02l.04.003a5.812 5.812 0 00-.005.026zm-.001.046c.009.012.018.027.027.046.04.084.043.134.026.165a.458.458 0 00.012.023c.086-.035.15-.12.107-.213a.56.56 0 00-.17-.004c.045.004.095.029.119.112a.136.136 0 01-.05.154c.09-.035.123-.093.098-.182-.026-.096-.078-.126-.17-.134v.033zm.58.56a.152.152 0 00.016-.101c-.13.02-.228-.022-.33-.115l-.055.05c.11.09.22.141.369.166zm.436.016a.552.552 0 01-.017-.029.301.301 0 00-.043-.067.207.207 0 00-.05-.041 6.263 6.263 0 00-.049.14l.159-.003zm.326-.02l-.07-.008a.957.957 0 01.035.012c.013-.086.005-.16-.045-.207a.545.545 0 00-.235.059l.101.135.12.016.094-.006zm.299.016c-.053.025-.053.025-.07.026a10.494 10.494 0 01.25.004c-.028.085.019.155.097.22.003.003.013.014.005-.028-.03-.144.038-.17.126-.178a.088.088 0 01.044.01 2.177 2.177 0 00-.383-.195c.01.053-.006.071-.07.14zm.304.14a.294.294 0 01-.006-.007l.006.007zm-1.857-.168a.518.518 0 01-.003-.008l.003.008zm.367-.018c-.022.077-.122.154-.247.09a.125.125 0 01-.035-.02c.02.028.041.048.063.063.099.02.194-.044.219-.133zm-.097-.224c.077-.003.17.029.152.17-.009.076-.044.102-.084.115.106-.035.153-.133.124-.216a.24.24 0 00-.192-.07zm.1-.03a.315.315 0 00-.089-.028c.072.025.141.093.07.218-.026.044-.048.056-.072.062.106-.026.171-.124.146-.21a.21.21 0 00-.056-.041zm-.054-.068a.383.383 0 00-.12-.026c.059.004.11.023.125.127.014.092-.02.136-.07.157.008-.003.028-.017.072-.047.046-.128.055-.152.014-.201a.28.28 0 00-.021-.01zm-.074.263a.156.156 0 01-.05.01.213.213 0 00.06-.015l-.01.005zm-.124-.354c-.01-.001-.01-.001.012.005.075.023.075.023.083.224-.026.043-.038.057-.061.064a.541.541 0 00.062-.029c.092-.112.099-.12.027-.236a.513.513 0 00-.123-.028zm-.066-.047c.04 0 .086.014.12.088.04.09.012.148-.036.18.082-.035.113-.09.097-.172a.173.173 0 00-.022-.058.272.272 0 00-.159-.038zm-.158-.047l.02-.002-.02.002zm-.034-.052a1.47 1.47 0 01-.004-.002l.004.002zm-.017.23h-.017.024-.007zm.002-.352a.234.234 0 01.078.03v-.007a.364.364 0 00-.078-.023zm-.442-.45a.496.496 0 01.008 0h-.008z"
                        fill="#000"
                    />
                    <path
                        d="M26.317 13.498a.526.526 0 00.084.213c.008.01.015.022.02.033a.31.31 0 01.133.086.398.398 0 01.084.055.419.419 0 01.044.041.403.403 0 01.107.072l.047.043c.025.012.051.029.08.05.028.02.084.057.212.141.137.09.182.119.22.146.131.092.212.199.09.325L28 15l-1.057-.133c-.027-.003.11-.004-.569.004-.447.006-.756-.235-.777-.605a.331.331 0 01.02-.145.277.277 0 01.01-.097.245.245 0 01.057-.112H25l.65-.278a.258.258 0 01-.05-.1c-.026-.108.01-.234.13-.293a.161.161 0 00-.082.187c-.056-.054-.062-.12-.05-.183a.215.215 0 01.009-.095c.04-.126.172-.175.29-.138a.702.702 0 01.257.161c.09.094.125.176.163.325zm-.408.214a.294.294 0 00.04-.015.145.145 0 01-.036.011l-.004.004zm-.21-.131a.228.228 0 01.005-.094.17.17 0 00-.002.079l-.003.015zm.1.154a.238.238 0 00-.007-.004l.007.004zm.145.101zm.133.398a.106.106 0 00.008-.003l-.008.003zm.98.353l-.068.052.064-.048.002-.002.001-.002zm-.66-.398a.473.473 0 00-.001-.002v.002zm.063-.049zm-.347-.247c.032-.027.067-.067.115-.086.06-.024.108-.01.128.008.069.062.065.223-.092.255.179-.036.227-.194.158-.326-.14-.048-.304.003-.31.15zm-.028.207a.361.361 0 00.051.038c.047-.045.07-.108.043-.197a.192.192 0 00-.144-.143c.022.025.053.06.068.117.019.068.001.108-.024.139a.13.13 0 01-.063.036v.004c.105.011.19-.022.239-.091a.268.268 0 00-.017-.028.246.246 0 00-.239-.118.264.264 0 00.086.243zm.425-.068c.023-.04.028-.093-.002-.161a.21.21 0 01.01.145l-.008.016zm-.602.241a.156.156 0 00.19 0h-.002l-.02.018a.325.325 0 01-.062.037c.027.062.083.108.168.134a.386.386 0 01.172-.107.189.189 0 01.01-.02.267.267 0 01-.063-.066.288.288 0 01-.063-.03c-.082.116-.231.112-.33.034zm.647-.038a.235.235 0 00-.145.05.256.256 0 00.145-.05zm-.106-.026a.228.228 0 00.052.191c.098.026.202.003.258-.085a5.248 5.248 0 01-.062-.033.3.3 0 01-.103.015c-.058 0-.06-.001-.069-.008-.023-.02-.046-.048-.049-.082a.174.174 0 01-.027.002zm-.035-.262l-.004.002.004-.002zm-.026.405a.098.098 0 01.008-.006l.019-.01-.035.01a.328.328 0 00.008.006zm.396.127c.116-.001.172 0 .21.004l-.015.118a74.212 74.212 0 00-.27-.178c.037.02.08.02.165-.045.063-.048.083-.08.083-.117h.005c.031.194-.198.283-.353.22l.175-.002zm-.035-.14l-.002.003.026-.02-.005-.003a.298.298 0 00-.019.02zm.032-.013a.52.52 0 01.03-.033l-.038.029.008.004zm-.039.292c.003-.059.012-.125.072-.183.035-.034.059-.04.08-.042.016 0-.043-.031-.113-.067-.094.113-.089.215-.039.292zm-.178.074l-.004-.002.004.002zm-.641-.464h.003-.003zm.1-.423a.155.155 0 00-.066-.018.38.38 0 01.078.01l-.012.008zm.078-.298a.192.192 0 00-.118-.056.23.23 0 01.145.062l-.027-.006zm-.013-.01c.009.028.01.057.003.085a.206.206 0 000-.105l-.003.02zm-.137-.287a.242.242 0 00-.002-.002l.002.002zm-.169.175a.104.104 0 00-.008-.004l.008.004z"
                        fill="#000"
                    />
                    <path
                        d="M26.31 13c-.061.093-.084.09-.2.166-.141.094-.173.363.065.331a.494.494 0 00.325-.199c-.052-.1-.114-.2-.19-.298z"
                        fill="#A89078"
                    />
                    <path
                        d="M26.116 13c-.123.164-.145.238-.082.238.075 0 .043.014-.01.132-.054.117.107.176.17.088.065-.088.076-.118.108 0 .026.095.131.005.198-.088a1.897 1.897 0 00-.384-.37z"
                        fill="#A89078"
                    />
                    <path
                        d="M26.065 13.117c-.114.058-.076.366.098.279.057-.03.103-.018.091.029a.104.104 0 00.011.075.532.532 0 00.19-.14c.108-.123.008-.115-.152-.115-.161 0-.207-.031-.054-.124.137-.083.047-.141-.142-.114.027.039.014.082-.042.11z"
                        fill="#A89078"
                    />
                    <path
                        d="M26.367 13.314c-.087-.056-.032-.084.062-.111a.126.126 0 00.05-.026c-.026-.061-.047-.12-.076-.177-.049.008-.107.073-.123.105-.024.047-.047.074-.126.06-.07-.012-.14.034-.154.084a.31.31 0 00.05.006c.033.002.049.028.039.056.213-.005.25.082.285.141.04.065.087.056.118.02.032-.038-.039-.103-.125-.158z"
                        fill="#A89078"
                    />
                    <path
                        d="M26.454 14.023c-.022.063-.023.057-.097.062-.073.006-.166.022-.207.075-.022.028-.15.035-.15.105 0 .07 0 .128.055.132.056.004.062.013.042.064-.021.051-.035.136.062.145.097.008.166-.03.19.038.024.068-.002.177.018.218.019.04.084.066.186.105.067.026.322.04.401.03.078-.012.049-.07-.03-.079-.078-.008-.136-.022-.154-.093-.018-.071-.035-.108.01-.168.043-.06.087-.105.062-.205-.026-.1-.067-.216-.16-.247-.092-.031-.063-.187-.154-.202-.035-.006-.065-.006-.074.02z"
                        fill="#F2D049"
                    />
                    <path
                        d="M26.153 14.048c.058.007.108.031.06.049-.047.018-.072.056-.012.063.06.007.11.039.065.06-.045.021-.055.06.003.056.057-.003.08.043.04.074-.04.032-.068.053-.093-.003-.025-.056-.04-.074-.048-.032-.007.042-.025.014-.045-.05-.02-.062-.055-.08-.045-.03.01.049-.035.056-.078.03.042.06.09.119.143.168.062-.03.13-.005.153-.002a.424.424 0 01.146.06c.043.032.07-.025.053-.088-.018-.063-.02-.042-.043-.007-.023.035-.028-.014-.025-.088.002-.062-.028-.046-.038-.007-.01.039-.033-.025-.02-.063.013-.039-.002-.053-.025-.042-.023.01-.025 0-.028-.07-.002-.071-.025-.06-.032-.033-.008.029-.028-.01-.058-.066-.026-.05-.057-.02-.11.009.007.005.02.01.037.012z"
                        fill="#A89078"
                    />
                    <path
                        d="M27 15.238c-.442.459-.76.255-1-.152.1-.087.21-.013.248-.003.04.01.166.083.235.176.068.093.113-.073.085-.259.06.197.105.331.177.321a.725.725 0 00.255-.083zM26.494 14.106c-.016-.069-.032-.085-.062-.08-.03.003-.042-.005-.075-.02-.033-.017-.075.003-.082.075-.006.073-.042.11-.091.153-.05.044-.079.08-.079.153 0 .072-.013.092-.045.145-.015.023-.035.05-.055.077.021.016.041.03.062.043.034.021.024.051-.012.04-.037-.013-.071.014-.013.03.06.015.086.048.03.045-.057-.003-.123.057-.012.042.11-.015.154.048.024.051-.13.003-.08.054-.012.054.122 0 .086.043.054.043-.032 0-.047.051.034.042h.004a.157.157 0 00.026-.057c.013-.049.026-.19.072-.23a.197.197 0 00.069-.136c0-.04.068-.217.114-.261.046-.045.066-.141.05-.21z"
                        fill="#F2D049"
                    />
                    <path
                        d="M26.414 14.014c-.065-.03-.128-.012-.128.043 0 .056-.041.071-.096.09-.055.018-.105.065-.114.108-.01.043.009.07-.037.105-.046.034-.05.061-.018.08.032.018.032.022.046.05.013.027.09-.004.09-.035 0-.03.02-.03.07-.049.05-.019.132-.108.114-.133-.018-.024-.064-.046-.005-.08.06-.034.124-.037.124-.07 0-.035.018-.047.037-.06.018-.012-.042-.03-.083-.049z"
                        fill="#A89078"
                    />
                    <path
                        d="M26.26 14.011c-.254-.092-.405.404-.053.48.352.076.407-.354.053-.48z"
                        fill="#000"
                    />
                    <path
                        d="M26.267 14.01c-.205.044-.433.513-.093.432.34-.08.48-.513.093-.432z"
                        fill="#000"
                    />
                    <path
                        d="M26.128 14.154c-.205.143-.166.522.135.25.3-.271.376-.605-.135-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.128 14.154c-.206.142-.165.522.135.251.3-.272.375-.607-.135-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.095 14.154c-.196.143-.072.522.215.25.288-.271.273-.605-.215-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.095 14.154c-.196.143-.072.522.215.25.288-.271.273-.605-.215-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.095 14.154c-.196.143-.072.522.215.25.288-.271.273-.605-.215-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.096 14.154c-.197.143-.072.522.214.25.288-.271.273-.605-.214-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.095 14.155c-.196.141-.072.521.215.25.288-.273.273-.606-.215-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.095 14.154c-.196.143-.072.522.215.25.288-.271.273-.605-.215-.25z"
                        fill="#000"
                    />
                    <path
                        d="M26.093 14c-.086.012-.141.139-.033.165.108.025.133.034.133.12s.033.206.15.215c.116.009.216-.13.116-.172-.1-.043-.191-.078-.2-.172-.008-.095-.1-.164-.166-.155z"
                        fill="#A89078"
                    />
                    <path
                        d="M27.001 14.07c.01.01.021.02.035.03.05.034.144 0 .133-.028-.012-.028-.065-.117.057-.043.122.074.56.308.7.391.14.083.05.093-.019.068a5.731 5.731 0 01-.369-.145c-.114-.052-.126-.034-.145-.015-.016.015-.003.053.04.084-.069.008-.18-.004-.21-.063-.039-.07-.13-.157-.195-.225-.024-.025-.031-.04-.027-.054z"
                        fill="#F2D049"
                    />
                    <path
                        d="M29.16 21.771c-.092.044-.215.121-.133.229l.028-.011c.362-.305.672-.625.937-.957A.575.575 0 0030 21a1.51 1.51 0 01-.333.139c.044.082-.163.19-.274.22.045.052.03.13-.067.145.023.046-.051.046-.14.072-.09.026-.134.046-.163.077a.337.337 0 01.152-.026c.037.008.044.047-.023.057a.258.258 0 00-.133.056c.096-.025.233-.012.14.031z"
                        fill="#9CB8C5"
                    />
                    <path
                        d="M26.387 14.46c0 .003.002.005.003.008a.05.05 0 01-.002-.022l-.001.014zm.077-.137a1.416 1.416 0 00.012-.003l-.012.003zm-.051-.207c.108-.153.29-.14.403-.044a.508.508 0 01.114.15c.12.22.08.439-.079.575a1.167 1.167 0 01-.5.2c-.225.025-.383-.152-.346-.357.026-.141.136-.277.308-.277a.512.512 0 00.047-.01.316.316 0 01.053-.237zm.098.3zm.363-.1a.57.57 0 010-.006v.006zm-.392.15c.001.002.003 0 .006-.004-.016-.014-.014-.01-.006.004z"
                        fill="#000"
                    />
                    <path
                        d="M26.487 14.246a1.07 1.07 0 010 0zm.103-.227c.175-.057.246.02.342.189.051.09.076.185.065.276a.282.282 0 01-.158.226c-.099.114-.351.282-.51.29-.171.008-.326-.103-.329-.3a.32.32 0 01.25-.317s.033-.016.074-.039l.03-.017.054-.032c-.011-.131.024-.225.182-.276zm.316.585l.002-.008-.001.003-.001.005zm-.432-.214zm.412-.102z"
                        fill="#000"
                    />
                    <path
                        d="M26.86 14.108c.212.193.18.557-.075.604a2.7 2.7 0 01-.093.098.788.788 0 01-.182.138.439.439 0 01-.148.049c-.202.026-.39-.106-.358-.333.016-.117.099-.22.203-.269a.815.815 0 00.09-.06c-.096-.314.321-.446.563-.227zm-.52.323a.635.635 0 00.026.04.128.128 0 01-.02-.046l-.006.006zm.08.433zM26.398 13.048c-.267-.182-.572.198-.277.407.259.182.532-.234.277-.407z"
                        fill="#000"
                    />
                    <path
                        d="M26.005 13l.145.013c-.03.196.12.493.35.42-.185.184-.545-.026-.495-.433zM26.008 15c.087.027.39.06.492.065-.051.115-.097.191-.128.273-.031.081-.046.087-.052-.038-.005-.126-.071-.207-.132-.077-.062.131-.093.18-.123.235-.031.054-.077.076-.062-.06.015-.137.01-.278.005-.398z"
                        fill="#FFF"
                    />
                    <path
                        d="M22.767 16.755c.072 3.364.999 5.314 3.733 6.432 2.734-1.118 3.661-3.068 3.733-6.432h-7.466zM31 16.38c-.011 3.93-1.06 6.28-4.36 7.567L26.5 24l-.14-.054c-3.298-1.288-4.348-3.637-4.359-7.567L22 16h9l-.001.379z"
                        fill="#000"
                    />
                    <path
                        d="M31 16.576l-.001.424H22v-.424c-.002-.419.003-.769.017-1.468.02-.992.024-1.377.011-1.852l-.007-.286.234-.115C23.453 12.26 25.06 12 26.5 12c1.439 0 3.047.261 4.244.855l.234.115-.007.286c-.013.474-.01.858.01 1.85.015.7.02 1.05.019 1.47zm-.78-1.452a48.238 48.238 0 01-.017-1.6c-1.059-.461-2.455-.674-3.703-.674-1.248 0-2.644.213-3.703.674.005.386 0 .798-.017 1.603-.01.45-.015.753-.017 1.023h7.474c-.002-.27-.008-.574-.017-1.026z"
                        fill="#000"
                    />
                </g>
            </g>
        </svg>
    );
}
SvgSaintHelena.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgSaintHelena.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgSaintHelena;
