import React from 'react';
import PropTypes from 'prop-types';

function SvgSaintBarthelemy({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fill="none" fillRule="evenodd">
                <g fillRule="nonzero">
                    <path
                        d="M.485 12.202C2.602 3.644 11.248-1.568 19.806.549c8.558 2.118 13.77 10.764 11.653 19.322-2.118 8.55-10.764 13.77-19.322 11.652C3.587 29.398-1.633 20.752.485 12.202"
                        fill="#F1F2F2"
                    />
                    <path
                        d="M10.626 1.002C5.754 2.739 1.818 6.804.485 12.202c-1.988 8.04 2.497 16.162 10.141 18.869V1.002z"
                        fill="#223C72"
                    />
                    <path
                        d="M21.341 1.01v30.045c4.857-1.746 8.784-5.802 10.118-11.192 1.987-8.025-2.49-16.138-10.118-18.853"
                        fill="#EF3827"
                    />
                </g>
                <path
                    d="M22.078 18.612c.344.808.196 1.444 0 2.064.495-.18 1.547-.672 1.421-1.286-.22-.538-.907-.67-1.42-.778"
                    fill="#CE0F25"
                    fillRule="nonzero"
                />
                <path
                    d="M22.078 18.612c.344.808.196 1.444 0 2.064.495-.18 1.547-.672 1.421-1.286-.22-.538-.907-.67-1.42-.778z"
                    stroke="#221B0F"
                />
                <path
                    d="M20.324 22.108c.312-.101.526-.216 1.043-.288.213-.03.787.006 1.12-.098.32-.1.505-.194.514-.355.016-.288.11-.618.223-.918.16-.427.356-.771.387-.887.028-.109-.02-.218-.093-.318-.281-.39-.911-.674-1.473-.674l.024.096c.432.008 1.287.332 1.338.765.078.652-2.128.751-3.353.993 0 0-.316.079-.424.19-.076.078-.115.282-.036.357.56.533.73 1.137.73 1.137"
                    fill="#FAF8F0"
                    fillRule="nonzero"
                />
                <path
                    d="M20.324 22.108c.312-.101.526-.216 1.043-.288.213-.03.787.006 1.12-.098.32-.1.505-.194.514-.355.016-.288.11-.618.223-.918.16-.427.356-.771.387-.887.028-.109-.02-.218-.093-.318-.281-.39-.911-.674-1.473-.674l.024.096c.432.008 1.287.332 1.338.765.078.652-2.128.751-3.353.993 0 0-.316.079-.424.19-.076.078-.115.282-.036.357.56.533.73 1.137.73 1.137z"
                    stroke="#221B0F"
                />
                <path
                    d="M23.407 19.835c-.825.533-1.939.572-2.912.66l-.62.63.568.837s.633-.207.96-.258c.232-.036.492-.004.723-.041.198-.033.374-.015.506-.166.154-.175.146-.494.228-.712.051-.14.134-.255.242-.42.173-.265.305-.53.305-.53"
                    fill="#F6E4BE"
                    fillRule="nonzero"
                />
                <path
                    d="M20.025 22.466c.152-.735-.32-1.025-.573-1.47 0 0 .273.112.418.132.272.036.428.03.821-.033.322-.052.592-.214.816-.11.031.014.055.049.06.083.014.105-.046.212-.108.299-.335.473-1.434 1.1-1.434 1.1"
                    fill="#CE0F25"
                    fillRule="nonzero"
                />
                <path
                    d="M20.025 22.466c.152-.735-.32-1.025-.573-1.47 0 0 .273.112.418.132.272.036.428.03.821-.033.322-.052.592-.214.816-.11.031.014.055.049.06.083.014.105-.046.212-.108.299-.335.473-1.434 1.1-1.434 1.1z"
                    stroke="#221B0F"
                />
                <path
                    d="M9.903 18.612c-.343.808-.196 1.444 0 2.064-.495-.18-1.547-.672-1.42-1.286.22-.538.906-.67 1.42-.778"
                    fill="#CE0F25"
                    fillRule="nonzero"
                />
                <path
                    d="M9.903 18.612c-.343.808-.196 1.444 0 2.064-.495-.18-1.547-.672-1.42-1.286.22-.538.906-.67 1.42-.778z"
                    stroke="#221B0F"
                />
                <path
                    d="M11.657 22.108c-.312-.101-.526-.216-1.043-.288-.213-.03-.786.006-1.119-.098-.32-.1-.506-.194-.515-.355-.016-.288-.11-.618-.222-.918-.162-.427-.357-.771-.387-.887-.029-.109.02-.218.092-.318.282-.39.912-.674 1.473-.674l-.024.096c-.432.008-1.287.332-1.338.765-.078.652 2.128.751 3.354.993 0 0 .315.079.423.19.076.078.115.282.036.357a2.78 2.78 0 00-.73 1.137"
                    fill="#FAF8F0"
                    fillRule="nonzero"
                />
                <path
                    d="M11.657 22.108c-.312-.101-.526-.216-1.043-.288-.213-.03-.786.006-1.119-.098-.32-.1-.506-.194-.515-.355-.016-.288-.11-.618-.222-.918-.162-.427-.357-.771-.387-.887-.029-.109.02-.218.092-.318.282-.39.912-.674 1.473-.674l-.024.096c-.432.008-1.287.332-1.338.765-.078.652 2.128.751 3.354.993 0 0 .315.079.423.19.076.078.115.282.036.357a2.78 2.78 0 00-.73 1.137z"
                    stroke="#221B0F"
                />
                <path
                    d="M8.575 19.835c.824.533 1.938.572 2.912.66l.62.63-.569.837s-.632-.207-.96-.258c-.232-.036-.492-.004-.723-.041-.198-.033-.374-.015-.506-.166-.154-.175-.146-.494-.227-.712-.052-.14-.135-.255-.243-.42a6.004 6.004 0 01-.304-.53"
                    fill="#F6E4BE"
                    fillRule="nonzero"
                />
                <path
                    d="M11.956 22.466c-.152-.735.32-1.025.574-1.47 0 0-.274.112-.419.132-.271.036-.428.03-.82-.033-.322-.052-.593-.214-.817-.11a.113.113 0 00-.06.083c-.014.105.047.212.108.299.336.473 1.434 1.1 1.434 1.1"
                    fill="#CE0F25"
                    fillRule="nonzero"
                />
                <path
                    d="M11.956 22.466c-.152-.735.32-1.025.574-1.47 0 0-.274.112-.419.132-.271.036-.428.03-.82-.033-.322-.052-.593-.214-.817-.11a.113.113 0 00-.06.083c-.014.105.047.212.108.299.336.473 1.434 1.1 1.434 1.1z"
                    stroke="#221B0F"
                />
                <path
                    d="M10.764 23.373c-.143-.092-.305-.182-.396-.32a.437.437 0 01-.06-.335c.166-.643.13-.987.015-1.473-.037-.158-.075-.395.121-.384.505.027 1.07.188 1.477.173.166-.006.414-.039.436-.22.025-.215-.527-.406-.527-.406.328.038.6.174.693.366.038.078.02.188-.029.26-.096.141-.28.18-.449.202-.337.046-.91-.047-1.233-.109-.147-.028-.198-.05-.223-.03-.064.05.023.152.227.342.412.386.893.7 1.389.97 1.35.734 2.383.969 3.786.969 1.402 0 2.435-.235 3.786-.97.496-.27.976-.583 1.389-.969.203-.19.291-.292.227-.343-.026-.02-.077.003-.223.031-.324.062-.896.155-1.234.11-.17-.023-.353-.062-.449-.203-.049-.072-.066-.182-.028-.26.093-.192.364-.328.693-.366 0 0-.553.191-.527.406.021.181.27.214.435.22.407.015.972-.146 1.477-.173.197-.011.159.226.121.384-.115.486-.15.83.016 1.473.029.11.001.24-.06.335-.091.138-.254.228-.397.32-1.66 1.064-3.525 1.61-5.226 1.61s-3.567-.546-5.227-1.61"
                    fill="#FAF8F0"
                    fillRule="nonzero"
                />
                <path
                    d="M10.764 23.373c-.143-.092-.305-.182-.396-.32a.437.437 0 01-.06-.335c.166-.643.13-.987.015-1.473-.037-.158-.075-.395.121-.384.505.027 1.07.188 1.477.173.166-.006.414-.039.436-.22.025-.215-.527-.406-.527-.406.328.038.6.174.693.366.038.078.02.188-.029.26-.096.141-.28.18-.449.202-.337.046-.91-.047-1.233-.109-.147-.028-.198-.05-.223-.03-.064.05.023.152.227.342.412.386.893.7 1.389.97 1.35.734 2.383.969 3.786.969 1.402 0 2.435-.235 3.786-.97.496-.27.976-.583 1.389-.969.203-.19.291-.292.227-.343-.026-.02-.077.003-.223.031-.324.062-.896.155-1.234.11-.17-.023-.353-.062-.449-.203-.049-.072-.066-.182-.028-.26.093-.192.364-.328.693-.366 0 0-.553.191-.527.406.021.181.27.214.435.22.407.015.972-.146 1.477-.173.197-.011.159.226.121.384-.115.486-.15.83.016 1.473.029.11.001.24-.06.335-.091.138-.254.228-.397.32-1.66 1.064-3.525 1.61-5.226 1.61s-3.567-.546-5.227-1.61z"
                    stroke="#221B0F"
                />
                <path
                    d="M21.387 23.124s.111-.112.132-.206c.052-.236-.068-.48-.074-.722-.005-.26.045-.78.045-.78-.646.616-2.425 2.175-5.5 2.175a7.931 7.931 0 01-5.498-2.175s.05.52.044.78c-.006.242-.125.486-.074.722.02.094.133.206.133.206 1.692 1.087 3.5 1.752 5.396 1.752 1.895 0 3.703-.665 5.396-1.752"
                    fill="#F6E4BE"
                    fillRule="nonzero"
                />
                <path
                    d="M12.7 23.607c.06-.168.249-.346.55-.24.252.087.358.284.28.509-.079.225-.302.347-.558.258a.401.401 0 01-.271-.527m.675.256c.077-.22-.006-.402-.17-.46-.117-.04-.27-.023-.356.222-.07.205-.012.407.182.474.07.025.245.048.344-.236M13.734 23.855c.036-.154.043-.182.049-.215.006-.035.002-.053-.03-.069a.224.224 0 00-.04-.012c-.012-.003-.018-.006-.016-.014.002-.007.01-.007.025-.003.055.013.12.032.15.04.026.005.092.018.129.027.016.003.022.007.02.014-.001.007-.008.008-.018.005a.167.167 0 00-.03-.004c-.03-.001-.043.014-.053.049a4 4 0 00-.054.214l-.034.142c-.035.146-.02.215.021.268a.201.201 0 00.12.073c.046.01.105.01.156-.02.07-.043.096-.133.12-.237l.031-.127c.037-.154.044-.182.05-.215.006-.035.001-.053-.031-.068a.214.214 0 00-.037-.012c-.011-.003-.017-.007-.015-.014.001-.007.01-.007.024-.004.052.013.117.032.118.032l.12.025c.014.004.02.007.019.015-.002.007-.009.007-.021.004-.012-.003-.018-.003-.031-.004-.03-.002-.042.014-.052.049-.01.031-.017.06-.054.214l-.026.108c-.027.112-.067.23-.171.281a.324.324 0 01-.234.021c-.055-.013-.153-.04-.213-.125-.042-.059-.063-.143-.028-.29l.036-.148zM14.66 24.279c-.004 0-.007.001-.01.007l-.077.133a.199.199 0 00-.025.06c-.003.02.005.034.038.039l.016.002c.012.002.015.004.014.01-.001.009-.008.01-.02.008l-.11-.02c-.012 0-.07-.006-.126-.014-.013-.002-.02-.005-.018-.013 0-.006.005-.008.014-.006l.033.002c.05.001.074-.031.103-.08l.356-.6c.017-.029.025-.04.036-.038.01.002.014.012.021.037.018.06.127.497.172.663.027.099.056.118.077.126a.238.238 0 00.044.01c.008.002.013.003.012.01 0 .009-.01.01-.05.004a7.99 7.99 0 01-.199-.03c-.019-.004-.031-.006-.03-.014 0-.006.005-.007.016-.007.008 0 .016-.009.013-.022l-.054-.225c-.002-.005-.004-.008-.01-.008l-.235-.034zm.224-.02c.005 0 .006-.003.006-.006l-.059-.267c0-.005 0-.01-.004-.01-.003 0-.006.004-.008.008l-.133.239c-.002.004 0 .007.003.008l.195.027zM15.435 24.496c0 .08.013.108.034.117a.173.173 0 00.055.009c.011 0 .018.003.018.009 0 .008-.01.01-.025.01-.07-.003-.112-.008-.132-.009h-.116c-.013-.001-.023-.002-.023-.012 0-.006.007-.008.018-.008.014 0 .033 0 .048-.003.028-.007.033-.037.038-.128l.031-.612c.001-.021.005-.036.015-.035.012 0 .021.014.039.033.012.014.168.187.318.343.07.074.208.229.226.246h.005l.006-.467c.002-.064-.007-.084-.032-.095a.18.18 0 00-.057-.009c-.012 0-.017-.003-.016-.01 0-.008.012-.009.028-.008.055.002.106.007.128.008h.105c.014 0 .025.002.024.01 0 .007-.006.01-.02.01-.01-.001-.018-.001-.031.001-.03.008-.04.03-.043.087l-.035.656c-.001.023-.006.033-.015.032-.012 0-.025-.012-.036-.024-.065-.065-.196-.206-.303-.317-.112-.117-.226-.248-.244-.268h-.004l-.004.434zM16.454 24.376c-.006 0-.008.003-.01.01l-.047.146a.197.197 0 00-.01.064c0 .019.011.032.044.03l.016-.002c.013 0 .016.001.017.007 0 .009-.006.011-.018.012l-.113.005c-.011 0-.07.008-.125.012-.014.001-.02 0-.021-.009 0-.006.004-.008.012-.009.01 0 .025-.003.033-.004.048-.01.066-.047.084-.1l.22-.664c.01-.03.016-.043.026-.043.01-.001.017.008.03.031.03.055.23.458.31.611.046.09.078.103.101.106a.242.242 0 00.045.001c.008 0 .014 0 .014.008.001.008-.008.01-.048.014-.038.002-.116.008-.201.012-.02 0-.032.001-.032-.006-.001-.006.003-.008.014-.01.007-.003.014-.013.008-.025l-.101-.208c-.003-.005-.006-.006-.011-.006l-.237.017zm.213-.067c.005 0 .006-.004.005-.007l-.115-.249c-.001-.004-.003-.009-.006-.009s-.005.006-.005.01l-.08.262c0 .004 0 .007.005.007l.196-.014zM17.296 24.25c.021.131.032.202.057.217.02.013.049.016.131.003.056-.009.097-.016.119-.048a.129.129 0 00.018-.066c0-.01 0-.016.009-.017.007-.002.009.003.01.016.003.01.008.09.004.12-.003.024-.007.03-.062.039-.076.012-.131.018-.179.025a2.62 2.62 0 00-.189.027l-.072.014c-.014.002-.022 0-.023-.007 0-.005.003-.01.016-.011a.181.181 0 00.037-.01c.02-.008.022-.031.022-.062-.002-.044-.015-.125-.03-.22l-.028-.18c-.024-.157-.029-.186-.036-.218-.008-.035-.019-.05-.055-.052-.009 0-.021 0-.035.003-.012.001-.018 0-.02-.007 0-.007.007-.01.022-.013.05-.008.117-.015.145-.02.025-.003.102-.019.143-.025.015-.002.022-.001.023.006.002.007-.004.01-.017.012a.279.279 0 00-.04.01c-.028.01-.034.028-.03.064.003.034.007.062.032.219l.028.18zM17.883 24.177c-.005 0-.006.003-.007.01l-.022.152a.198.198 0 00-.001.066c.004.018.017.029.05.02l.015-.003c.012-.003.016-.002.017.004.002.009-.004.012-.015.015-.033.008-.078.016-.11.023-.012.003-.068.02-.122.033-.014.003-.02.003-.022-.005-.002-.006.002-.01.01-.011a.304.304 0 00.032-.01c.046-.018.057-.057.066-.113l.108-.69c.005-.032.009-.045.02-.047.008-.003.017.005.033.026.038.05.302.414.406.552.061.081.095.088.118.088a.241.241 0 00.044-.007c.008-.002.014-.002.016.005.002.008-.007.013-.046.022-.037.009-.113.027-.196.045-.019.004-.031.007-.033 0-.002-.006.002-.01.012-.013.007-.004.012-.015.004-.026l-.134-.188c-.003-.004-.006-.006-.012-.004l-.23.056zm.2-.102c.005-.002.005-.005.003-.008l-.153-.226c-.002-.004-.005-.008-.008-.008-.003.001-.004.007-.004.01l-.035.272c0 .004.002.007.006.006l.19-.046zM18.43 23.911c-.057-.168-.017-.425.286-.528.251-.086.456.003.533.229.077.226-.023.46-.28.547a.401.401 0 01-.538-.248m.69-.214c-.076-.22-.253-.313-.418-.257-.116.04-.227.148-.143.393.07.205.241.328.435.262.07-.024.223-.113.125-.398"
                    fill="#000"
                    fillRule="nonzero"
                />
                <path fill="#666" fillRule="nonzero" d="M20.221 10.305h-8.458v.599h8.458z" />
                <path stroke="#520" d="M20.221 10.305h-8.458v.599h8.458z" />
                <g>
                    <path
                        d="M11.763 10.904l-.958-2.253-.16.048-.352-.805.646-.19.146.378.311-.093-.133-.37.658-.152.116.386.324-.062-.112-.39.66-.115.09.393.436-.062.038.198.162-.02-.033-.198.334-.043.034.2.164-.016-.025-.202.332-.03.028.202.323-.025-.059-.6.669-.033.022.394.319-.005-.006-.398h.672l-.01.403.325.006.023-.4.668.029-.061.608.323.022.028-.2.33.03-.026.2.167.017.03-.196.334.036-.032.2.165.023.04-.2.43.064.092-.396.659.115-.102.397.31.061.121-.39.656.148-.136.386.313.085.15-.386.649.185-.352.805-.277-.091-.975 2.302c-2.693-.775-5.888-.778-8.488 0"
                        stroke="#806600"
                        strokeWidth={2}
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M15.793 9.04v-.714c0-.286.514-.286.514 0v.714M12.042 9.525l-.222-.69c-.088-.276.408-.386.497-.11l.221.69M19.52 9.388l.222-.69c.089-.276.585-.165.496.111l-.222.69"
                        stroke="#520"
                        fill="#5E520E"
                        fillRule="nonzero"
                    />
                    <path
                        d="M17.533 9.826l-.092.248m-5.789.563a15.845 15.845 0 018.718-.035m-8.82-.192a16.19 16.19 0 018.914-.037m-9.005-.192a16.534 16.534 0 019.108-.034m-9.201-.176c3-.88 6.267-.894 9.277-.04m-2.005.027l-.1.242m1.544.073l-.1.226m-.51-.378l-.1.23m-.768-.641l-.1.239m.6-.153l-.1.23m.677-.111l-.1.229m.74-.066l-.1.227m-.67-.65l-.1.209m.831-.04l-.1.22m-.175-.286l-.1.211m-1.008-.433l-.1.217m-.281-.29l-.1.228m-1.26.113l-.068.24m.943-.164l-.1.234m-.977-.568l-.052.242m.513-.218l-.08.24m.833-.154l-.1.231m-.057-.485l-.1.219m-.351-.259l-.086.225m-.627-.282l-.044.224m-4.13.6l.1.223m3.868-.577l-.036.247m-4.378.211l.1.227m2.522-.648l.079.242m.528-.269l.04.235m-1.365-.142l.1.24m1.634-.343l.013.239m-2.62-.003l.1.237m-.912-.323l.1.232m.474-.35l.1.23m.259-.294l.1.238m.421-.316l.1.234m.62-.305l.093.24m.47-.283l.06.246m.444-.263l.024.239m.698-.254l-.02.239m-4.49.303l.1.232m4.273-.997l-.012.23m-.506-.224l.019.22m-.485-.202l.046.22m-.912-.153l.098.224m-.775-.148l.1.216m-.573-.146l.1.22m-.656-.118l.1.211m-.928-.033l.1.224m6.809-.78l.257-1.194m-7.787 1.66c3.068-.898 6.41-.91 9.486-.034M17.21 8.17c.596.038 1.194.104 1.781.198m-1.559-.675l-.022.185a19.258 19.258 0 00-2.654 0l-.023-.19m-1.603.68a18.891 18.891 0 011.777-.196m-1.852-.102l.274 1.19m1.666-.185l-.116-1.205m2.383-.003l-.1 1.209M13.08 7.667l.083.388c-.862.133-1.694.395-2.519.645m8.348-1.04l-.081.384c.884.134 1.747.393 2.592.65"
                        stroke="#806600"
                    />
                </g>
                <path
                    d="M11.763 10.904a142.845 142.845 0 000 4.326c.02 1.39.088 2.474.7 3.322.737 1.021 1.965 1.758 3.544 2.482 1.58-.724 2.807-1.46 3.544-2.482.611-.848.68-1.932.7-3.322.021-1.442.023-2.884 0-4.326h-8.488z"
                    stroke="#540"
                    strokeWidth={2}
                    fill="#1353B4"
                    fillRule="nonzero"
                />
                <path
                    d="M20.133 17.034c.003-.36.078-.532.078-.892.037-.724.051-1.443.04-2.164h-8.488c-.012.721.003 1.434.04 2.164 0 .36.077.532.08.892h8.25z"
                    fill="#CE0F25"
                    fillRule="nonzero"
                />
                <path d="M11.75 13.96h8.513m-8.385 3.074h8.255" stroke="#540" strokeWidth={2} />
                <path
                    stroke="#000"
                    strokeWidth={0.805}
                    fill="#FFF"
                    fillRule="nonzero"
                    d="M14.949 15.948l1.03-.42-.42 1.031.459-.305.458.305-.42-1.03 1.03.42-.304-.459.305-.458-1.03.42.42-1.03-.459.305-.458-.306.42 1.031-1.031-.42.305.458z"
                />
                <g>
                    <path
                        d="M9.201 18.73c-.011 1.25-.022 1.294-.022 1.294.547.536.612.732.774.906.21-.304.536-.182.536-.182.066-.288.415-.536.415-.536-.487-.039-1.327-.288-1.393-.387-.22-.33.083-1.332.083-1.332l-.393.237z"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.201 18.73c-.011 1.25-.022 1.294-.022 1.294.547.536.612.732.774.906.21-.304.536-.182.536-.182.066-.288.415-.536.415-.536-.487-.039-1.327-.288-1.393-.387-.22-.33.083-1.332.083-1.332l-.393.237z"
                        stroke="#806600"
                    />
                    <path fill="#EACE24" fillRule="nonzero" d="M10.4 20.773l-.538-.5.64.462" />
                    <path stroke="#806600" d="M10.4 20.773l-.538-.5.64.462" />
                    <path
                        d="M9.6 18.138s.676-.276 1.369.21c.066.02.114.013.167.004.134-.143.438-.565.672-.51.017-.357-.023-1.783-.023-1.783-.102-.004-.137.195-.137.195.058.407-.176 2.877-1.138 1.243l-.68.07-.23.57z"
                        stroke="#000"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.6 18.138s.676-.276 1.369.21c.066.02.114.013.167.004.134-.143.438-.565.672-.51.017-.357-.023-1.783-.023-1.783-.102-.004-.137.195-.137.195.058.407-.176 2.877-1.138 1.243l-.68.07-.23.57z"
                        stroke="#806600"
                    />
                    <path
                        d="M9.23 12.424c.58.21.588.32 1.163.83.459.182 1.142.629 1.18.728l-.037.146c.089.055.172-.149.172-.149-.088-.503-1.704-2.018-1.704-2.018l-.711.15-.063.313z"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.23 12.424c.58.21.588.32 1.163.83.459.182 1.142.629 1.18.728l-.037.146c.089.055.172-.149.172-.149-.088-.503-1.704-2.018-1.704-2.018l-.711.15-.063.313z"
                        stroke="#806600"
                    />
                    <path
                        stroke="#000"
                        d="M9.776 12.198l1.819 1.67.038.121M10.174 12.818c.182.367.52.5.52.5"
                    />
                    <path
                        d="M9.44 11.77c-.008-.602.703-1 .703-1.055-.07-.43-1.087.594-1.141.727-.063.194.078.43.078.43M9.752 10.98c-.276.173-.5.735-.5.735"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.111 11.762c-.086-.578.352-1.078.32-1.094-.268-.135-.617.578-.719.813l.133.797M9.352 11.285c-1.004.282.072.665.072.665"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M8.933 12.067c-.156-.14-.009-1.149-.052-1.149-.33 0-.502.97-.433 1.173.225.659.407.774.407.774M8.62 11.723c-.054.297.497.665.497.665"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M8.814 12.81c-.375-.352-.44-1.296-.492-1.392-.402.079-.196 1.08-.196 1.08.008.077.532.703.532.703M8.275 12.044c-.136.265.48 1.055.48 1.055"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.283 15.046s-.102-1.36.07-1.564l-.508-.75-.656 1.305.594 1.087.5-.078z"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M9.283 15.046s-.102-1.36.07-1.564l-.508-.75-.656 1.305.594 1.087.5-.078z"
                        stroke="#000"
                    />
                    <path
                        d="M8.805 18.01c.222.285.331.928.331.928l.067-.21c.03.02.05.183.094.183.02 0 .016-.168.06-.177.02-.004.007.232.05.232.035 0 .038-.168.05-.16.028.018.033.223.055.116-.031-1.099 2.122-1.997 2.079-3.229.054-1.274-1.316-1.757-2.156-2.83 0 0-.236-.703.199-.392.352-.055.32-.404.32-.404h.194c.086-.75-.669-.574-.669-.574-.7 0-.763.724-.763.724-.18.942 1.041 2.064 1.041 2.064.18.39-.002 1.064-.002 1.064l-1.698 1.6"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M8.076 16.933c-.094.114-.575.685-.693.884-.166.183.157.132.157.132s-.477.504-.71.652c.072.213.53-.096.53-.096s-.446.273-.422.328c.136.104.531-.187.531-.187s-.094.132-.015.18c.133 0 .437-.243.437-.243s-.062.14.008.164c.127-.08.923-.742.923-.742"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path d="M8.75 16.595s-.894.582-.29.49" stroke="#000" />
                    <path
                        d="M8.35 15.777c-.193.376-.44.996-.171 1.271.088.028.324-.883.508-.967l.15-.508M8.806 15.733c.153 0-.304.21-.469.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M8.731 15.805c-.149.702-.01.851.05.857.089-.045.243-.686.42-.725M7.974 12.555c-.619-.58-.702-1.244-.768-1.25-.292-.024.1 1.178.1 1.178l.74.591M7.922 12.7s-.327-.226-.5-.531"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.974 12.975c-.918-.509-1.028-1.338-1.105-1.31-.283.111.077.873.077.873.05.21.78.868.78.868M7.798 13.216s-.391-.289-.704-.766"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.692 13.345c-1.1-.608-1.122-1.305-1.244-1.26-.26.708.697 1.376 1.371 1.88M7.75 13.646s-.5-.18-.812-.656"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.797 13.947c-.956-.304-1.418-1.195-1.537-1.15-.276.106.305.852.305.852.47.437 1.243.757 1.243.757M7.821 14.092s-.664-.127-1.024-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.803 14.351c-1.531-.492-1.592-.973-1.736-.934-.273.207.603.895.603.895.11.166 1.227.47 1.227.47M7.923 14.678s-.774.03-1.102-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.875 14.777c-1.465-.31-1.68-.741-1.797-.713-.183.248.702.79.702.79.547.315 1.288.36 1.288.36M8.04 15.287s-.516.047-.844-.5M7.83 15.738c-.409.376-.64 1.078-.43 1.123.115.005.43-.819.89-.935l.292-.254M8.415 15.632c.102 0-.531.205-.64.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.615 15.396c-.597.447-.788.977-.702 1.006.132.044.663-.508.857-.542.094-.017.652-.315.652-.315M7.978 15.452c.1 0-.415.195-.524.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M8.04 15.202c-.652.078-1.796-.619-1.818-.558-.284.333.945.89 1.216.862l.962.061M8.298 15.733s-.79.025-1.15-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M10.088 15.28s0-.367-.18-.383c0 0-.406-.031-.86.047-1.037-.62-.224-1.414-.367-1.689-.047-.422-.743-1.055-.743-1.055-.07.063.015.457-.039.43-.14-.07-.054.24-.094.32-.132-.046-.126.155-.093.305-.11.016-.07.204-.047.337-.215-.118.065.334-.008.32-.328-.047.047.313.047.313-.188.07-.1.21.031.266-.164.117.004.304.063.312-.149.078.016.191.101.274-.133.125.11.178.227.227-.094.148.016.18.117.226-.062.117.092.109.188.094-.117.125.078.18.156.164 0 0 .042.162.18.102-.039.125.242.11.242.11 0 .124.415.078.415.078"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <g stroke="#000">
                        <path d="M8.071 13.157s.23.5.5.5M7.915 12.622s.26.5.5.5M7.821 12.92s.118.5.5.5M7.712 13.24s.229.5.5.5M7.657 13.568s.24.5.5.5M7.665 13.896s.303.5.5.5M7.696 14.233s.309.5.5.5M7.735 14.498s.309.5.5.5M7.774 14.788s.353.5.5.5M7.884 15.061s.364.367.5.367M8.107 15.428s.346-.152.5-.152M8.24 15.904s.306-.844.5-.152M8.422 16.031s.306-.844.5-.152M8.566 16.201s.293-.16.5-.5M8.76 16.284s.185.318.5-.433M8.991 16.423s.17-.035.5-.5M9.964 12.234c-.16-.451-.327-.402-.327-.402-.082 0-.11.082-.204.082-.116 0-.089-.18-.089-.18" />
                    </g>
                    <path
                        d="M9.81 11.806a.362.362 0 01-.245.269s.04.215.196.225c.285.045.378-.183.243-.382-.049-.052-.195-.112-.195-.112"
                        fill="#000"
                        fillRule="nonzero"
                    />
                    <path
                        d="M10.162 12.059c.019.111-.077.267-.213.348-.137.082-.263.056-.282-.055-.019-.113.077-.269.214-.35.136-.08.262-.055.281.056"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M7.59 17.93c-.05.082.184.104.247.008 0 .133.18.138.246.074.027.086.154.064.234-.015.014.037.129.116.171.101.083-.03.407-.488.477-.527m-1.704.997s.372-.362.615-.555m-.488.688s.49-.452.733-.645m-.263.557s.325-.335.568-.529m-.891-.145s.363-.433.606-.626m-.323.637s.306-.35.654-.598m-.375.65s.144-.275.582-.613m-.36.61s.167-.29.47-.506m-.489.545c-.248.254-.447.425-.447.425m.088-.403c-.249.254-.503.459-.503.459m.26-.531c-.249.254-.315.276-.315.276m.56-1.146c-.052.082.063.28.308.162-.077.205.038.15.197.075-.045.174.154.064.234-.016.014.037.018.128.094.135.087.008.18-.245.25-.284m-.783.094l.444-.407m-.68.428l.216-.329m.22.376l.267-.293m-.036.287l.14-.154m-.569.199c-.055.06-.182.155-.182.155m.42-.094a3.347 3.347 0 00-.227.193m.614-.1c-.249.255-.194.189-.194.189m.061-.293c-.121.094-.193.165-.193.165m.442-.784c-.354.442.155.088.155.088m-.61.122s-.208.038.03-.25m.403-.21l-.1.106m-.01-3.016c-.063.18.109.36.109.36m-.243-.258c-.062.18.227.476.227.476m-.282-.172c-.062.18.258.329.258.329m-.117.125c.016.133.25.101.25.101m-.584-1.56s.02.151.094.36c-.117.115-.139.292-.139.292m-.356-.558s.086.227.188.227m-.238.055s.086.226.188.226m-.282.011s.108.15.21.15m-.171.149s.108.15.21.15m-.133.165s.12.087.221.087m-.149.134s.025.018.127.018m-.005-1.577s-.015.128.1.128m.018 1.9s.127-.015.105-.114m-.293-.063s.221-.065.2-.164m.265.595s.12-.258.05-.357m.254.561s-.04-.34-.117-.384m.454.467c-.083-.287-.194-.418-.271-.445m.597.429a.63.63 0 00-.382-.424m.769.435a.63.63 0 00-.382-.424m.111.807c-.298.11-.436.381-.436.381m.035-4.025c-.078 0-.102.1-.102.1m-.152.36c-.053.095.113.224.086.196m-.068-.953c-.093 0-.1.15-.1.15m.503 1.144l.11.143m-.055.277l.116.132m.37.315l.139.15"
                        stroke="#000"
                    />
                    <path
                        d="M10.734 14.646s.066.182.112.198c0 0 .054.017.089-.006.032-.021 0-.066 0-.066-.043-.063-.201-.126-.201-.126zm-.28.092s-.01.192.026.225c0 0 .042.037.084.03.038-.007.026-.061.026-.061-.015-.075-.136-.194-.136-.194zm.192.68s-.011.192.026.225c0 0 .042.037.083.03.038-.007.026-.061.026-.061-.015-.075-.135-.194-.135-.194zm.473.193l-.004.01h-.011a.022.022 0 01-.017-.009c-.02-.023-.011-.126-.004-.19-.02-.027-.066-.092-.06-.127a.03.03 0 01.014-.02l.01-.007.009.008c.012.01.115.103.122.154a.726.726 0 01-.06.18zm-1.045.565c-.036 0-.067.106-.043.15 0 0 .026.05.067.057.038.006.046-.048.046-.048.012-.075 0-.16-.07-.16zm-.212 1.553a.321.321 0 01-.087.07l-.01.006-.008-.007c-.022-.017-.01-.062.036-.133 0-.031.003-.114.03-.138a.03.03 0 01.024-.008l.012.001.002.012c.003.015.027.152.001.197zm-.496.145c-.009.015-.024.02-.04.02a.104.104 0 01-.038-.008l-.004-.002c-.026-.02-.014-.085-.007-.114 0-.03.003-.117.03-.141a.03.03 0 01.024-.008h.011l.003.012c.008.032.046.196.021.24zm.41-.755c-.009.016-.024.02-.04.02a.11.11 0 01-.038-.008l-.004-.002c-.026-.02-.013-.088-.006-.116.006-.016.034-.09.08-.084l.013.001.002.012c.002.014.019.133-.007.177zm.642-.556s-.078.176-.055.22c0 0 .026.05.068.057.037.007.045-.048.045-.048.013-.075-.058-.23-.058-.23zm-.227.456c-.116.038-.14.175-.132.224 0 0 .01.055.047.075.034.018.058-.032.058-.032.035-.067.109-.205.027-.267zm-.626-.682c-.078.053-.078.099-.079.148 0 0 0 .056.033.082.03.024.133-.02.133-.02.047-.06-.083-.062-.087-.21zm.837-.754c-.078.052-.079.043-.08.148 0 0 .028.083.06.11.03.023.064-.052.064-.052.046-.06.022-.187-.044-.206zm.575.417c-.036 0-.067.106-.044.15 0 0 .027.05.068.057.038.007.046-.048.046-.048.012-.075 0-.16-.07-.16zm-.243.3c-.05.163-.109.213-.086.256 0 0 .057.015.1.022.037.007.045-.048.045-.048.012-.075-.047-.053-.059-.23zm-1.368 1.893c-.035 0-.066.107-.043.15 0 0 .026.05.068.057.038.007.046-.048.046-.048.012-.074 0-.159-.07-.159z"
                        fill="#000"
                        fillRule="nonzero"
                    />
                </g>
                <g>
                    <path
                        d="M22.815 18.73c.011 1.25.022 1.294.022 1.294-.547.536-.612.732-.774.906-.21-.304-.536-.182-.536-.182-.066-.288-.415-.536-.415-.536.487-.039 1.327-.288 1.393-.387.22-.33-.083-1.332-.083-1.332l.393.237z"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.815 18.73c.011 1.25.022 1.294.022 1.294-.547.536-.612.732-.774.906-.21-.304-.536-.182-.536-.182-.066-.288-.415-.536-.415-.536.487-.039 1.327-.288 1.393-.387.22-.33-.083-1.332-.083-1.332l.393.237z"
                        stroke="#806600"
                    />
                    <path fill="#EACE24" fillRule="nonzero" d="M21.615 20.773l.54-.5-.642.462" />
                    <path stroke="#806600" d="M21.615 20.773l.54-.5-.642.462" />
                    <path
                        d="M22.416 18.138s-.676-.276-1.369.21a.336.336 0 01-.167.004c-.134-.143-.438-.565-.672-.51-.017-.357.023-1.783.023-1.783.102-.004.137.195.137.195-.058.407.176 2.877 1.138 1.243l.68.07.23.57z"
                        stroke="#000"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.416 18.138s-.676-.276-1.369.21a.336.336 0 01-.167.004c-.134-.143-.438-.565-.672-.51-.017-.357.023-1.783.023-1.783.102-.004.137.195.137.195-.058.407.176 2.877 1.138 1.243l.68.07.23.57z"
                        stroke="#806600"
                    />
                    <path
                        d="M22.786 12.424c-.58.21-.588.32-1.163.83-.459.182-1.142.629-1.18.728l.037.146c-.089.055-.172-.149-.172-.149.088-.503 1.704-2.018 1.704-2.018l.711.15.063.313z"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.786 12.424c-.58.21-.588.32-1.163.83-.459.182-1.142.629-1.18.728l.037.146c-.089.055-.172-.149-.172-.149.088-.503 1.704-2.018 1.704-2.018l.711.15.063.313z"
                        stroke="#806600"
                    />
                    <path
                        stroke="#000"
                        d="M22.24 12.198l-1.819 1.67-.038.121M21.842 12.818c-.182.367-.52.5-.52.5"
                    />
                    <path
                        d="M22.577 11.77c.007-.602-.704-1-.704-1.055.07-.43 1.087.594 1.141.727.063.194-.078.43-.078.43M22.264 10.98c.276.173.5.735.5.735"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.905 11.762c.086-.578-.352-1.078-.32-1.094.268-.135.617.578.719.813l-.133.797M22.664 11.285c1.004.282-.072.665-.072.665"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M23.083 12.067c.156-.14.009-1.149.052-1.149.33 0 .502.97.433 1.173-.225.659-.407.774-.407.774M23.395 11.723c.055.297-.496.665-.496.665"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M23.202 12.81c.375-.352.44-1.296.492-1.392.402.079.196 1.08.196 1.08-.008.077-.532.703-.532.703M23.741 12.044c.136.265-.48 1.055-.48 1.055"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.733 15.046s.102-1.36-.07-1.564l.508-.75.656 1.305-.594 1.087-.5-.078z"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M22.733 15.046s.102-1.36-.07-1.564l.508-.75.656 1.305-.594 1.087-.5-.078z"
                        stroke="#000"
                    />
                    <path
                        d="M23.211 18.01c-.222.285-.331.928-.331.928l-.067-.21c-.031.02-.05.183-.094.183-.02 0-.016-.168-.06-.177-.02-.004-.007.232-.05.232-.035 0-.038-.168-.05-.16-.028.018-.033.223-.055.116.031-1.099-2.122-1.997-2.079-3.229-.054-1.274 1.316-1.757 2.156-2.83 0 0 .236-.703-.199-.392-.352-.055-.32-.404-.32-.404h-.194c-.086-.75.669-.574.669-.574.7 0 .763.724.763.724.18.942-1.041 2.064-1.041 2.064-.18.39.002 1.064.002 1.064l1.698 1.6"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M23.94 16.933c.094.114.575.685.693.884.166.183-.157.132-.157.132s.477.504.71.652c-.072.213-.53-.096-.53-.096s.446.273.422.328c-.136.104-.531-.187-.531-.187s.094.132.015.18c-.133 0-.437-.243-.437-.243s.062.14-.008.164c-.127-.08-.923-.742-.923-.742"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path d="M23.266 16.595s.894.582.29.49" stroke="#000" />
                    <path
                        d="M23.666 15.777c.193.376.44.996.171 1.271-.088.028-.324-.883-.508-.967l-.15-.508M23.21 15.733c-.153 0 .304.21.469.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M23.285 15.805c.149.702.01.851-.05.857-.089-.045-.243-.686-.42-.725M24.042 12.555c.619-.58.702-1.244.768-1.25.292-.024-.1 1.178-.1 1.178l-.74.591M24.093 12.7s.328-.226.5-.531"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.042 12.975c.918-.509 1.028-1.338 1.105-1.31.283.111-.077.873-.077.873-.05.21-.78.868-.78.868M24.218 13.216s.391-.289.704-.766"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.324 13.345c1.1-.608 1.122-1.305 1.244-1.26.26.708-.697 1.376-1.371 1.88M24.265 13.646s.5-.18.813-.656"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.219 13.947c.956-.304 1.418-1.195 1.537-1.15.276.106-.305.852-.305.852-.47.437-1.243.757-1.243.757M24.195 14.092s.664-.127 1.024-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.213 14.351c1.531-.492 1.592-.973 1.736-.934.273.207-.603.895-.603.895-.11.166-1.227.47-1.227.47M24.093 14.678s.774.03 1.102-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.141 14.777c1.465-.31 1.68-.741 1.797-.713.183.248-.702.79-.702.79-.547.315-1.288.36-1.288.36M23.976 15.287s.516.047.844-.5M24.186 15.738c.409.376.64 1.078.43 1.123-.115.005-.43-.819-.89-.935l-.292-.254M23.6 15.632c-.1 0 .532.205.642.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.401 15.396c.597.447.788.977.702 1.006-.132.044-.663-.508-.857-.542-.094-.017-.652-.315-.652-.315M24.038 15.452c-.101 0 .415.195.524.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M23.976 15.202c.652.078 1.796-.619 1.818-.558.284.333-.945.89-1.216.862l-.962.061M23.718 15.733s.79.025 1.15-.5"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M21.928 15.28s0-.367.18-.383c0 0 .406-.031.86.047 1.037-.62.224-1.414.367-1.689.047-.422.743-1.055.743-1.055.07.063-.015.457.039.43.14-.07.054.24.094.32.132-.046.126.155.093.305.11.016.07.204.047.337.215-.118-.065.334.008.32.328-.047-.047.313-.047.313.188.07.1.21-.031.266.164.117-.004.304-.063.312.149.078-.016.191-.101.274.133.125-.11.178-.227.227.094.148-.017.18-.117.226.062.117-.092.109-.188.094.117.125-.078.18-.156.164 0 0-.042.162-.18.102.039.125-.242.11-.242.11 0 .124-.415.078-.415.078"
                        stroke="#000"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <g stroke="#000">
                        <path d="M23.945 13.157s-.23.5-.5.5M24.101 12.622s-.26.5-.5.5M24.195 12.92s-.118.5-.5.5M24.304 13.24s-.229.5-.5.5M24.359 13.568s-.24.5-.5.5M24.351 13.896s-.303.5-.5.5M24.32 14.233s-.309.5-.5.5M24.28 14.498s-.308.5-.5.5M24.242 14.788s-.353.5-.5.5M24.132 15.061s-.364.367-.5.367M23.91 15.428s-.347-.152-.5-.152M23.777 15.904s-.307-.844-.5-.152M23.594 16.031s-.306-.844-.5-.152M23.45 16.201s-.293-.16-.5-.5M23.257 16.284s-.186.318-.5-.433M23.025 16.423s-.17-.035-.5-.5M22.052 12.234c.16-.451.327-.402.327-.402.082 0 .11.082.204.082.116 0 .089-.18.089-.18" />
                    </g>
                    <path
                        d="M22.207 11.806c.058.225.244.269.244.269s-.04.215-.196.225c-.285.045-.378-.183-.243-.382.049-.052.195-.112.195-.112"
                        fill="#000"
                        fillRule="nonzero"
                    />
                    <path
                        d="M21.854 12.059c-.019.111.077.267.213.348.137.082.263.056.282-.055.019-.113-.077-.269-.214-.35-.137-.08-.262-.055-.281.056"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M24.426 17.93c.05.082-.184.104-.247.008 0 .133-.18.138-.246.074-.027.086-.154.064-.234-.015-.014.037-.129.116-.171.101-.083-.03-.407-.488-.477-.527m1.704.997s-.372-.362-.615-.555m.488.688s-.49-.452-.733-.645m.263.557s-.325-.335-.568-.529m.891-.145s-.363-.433-.606-.626m.323.637s-.306-.35-.654-.598m.375.65s-.144-.275-.582-.613m.36.61s-.167-.29-.47-.506m.489.545c.248.254.447.425.447.425m-.088-.403c.249.254.503.459.503.459m-.26-.531c.249.254.315.276.315.276m-.56-1.146c.052.082-.063.28-.308.162.077.205-.038.15-.197.075.045.174-.154.064-.234-.016-.014.037-.018.128-.094.135-.087.008-.18-.245-.25-.284m.783.094l-.444-.407m.68.428l-.216-.329m-.22.376l-.267-.293m.036.287l-.14-.154m.569.199c.055.06.182.155.182.155m-.42-.094c.122.094.227.193.227.193m-.614-.1c.249.255.194.189.194.189m-.061-.293c.121.094.193.165.193.165m-.442-.784c.354.442-.155.088-.155.088m.61.122s.208.038-.03-.25m-.403-.21l.1.106m.01-3.016c.063.18-.109.36-.109.36m.243-.258c.062.18-.227.476-.227.476m.282-.172c.062.18-.258.329-.258.329m.117.125c-.016.133-.25.101-.25.101m.584-1.56s-.02.151-.094.36a.563.563 0 01.139.292m.356-.558s-.086.227-.188.227m.238.055s-.086.226-.188.226m.282.011s-.108.15-.21.15m.171.149s-.108.15-.21.15m.133.165s-.12.087-.221.087m.149.134s-.025.018-.127.018m.005-1.577s.015.128-.1.128m-.018 1.9s-.127-.015-.105-.114m.293-.063s-.221-.065-.2-.164m-.265.595s-.12-.258-.05-.357m-.254.561s.04-.34.117-.384m-.454.467c.083-.287.194-.418.271-.445m-.597.429a.63.63 0 01.382-.424m-.769.435a.63.63 0 01.382-.424m-.111.807c.298.11.436.381.436.381m-.035-4.025c.078 0 .102.1.102.1m.152.36c.053.095-.113.224-.087.196m.069-.953c.093 0 .1.15.1.15m-.503 1.144l-.11.143m.055.277l-.116.132m-.37.315l-.139.15"
                        stroke="#000"
                    />
                    <path
                        d="M21.282 14.646s-.066.182-.112.198c0 0-.054.017-.089-.006-.032-.021 0-.066 0-.066.043-.063.201-.126.201-.126zm.28.092s.01.192-.026.225c0 0-.042.037-.084.03-.038-.007-.026-.061-.026-.061.015-.075.136-.194.136-.194zm-.192.68s.011.192-.026.225c0 0-.042.037-.083.03-.038-.007-.026-.061-.026-.061.015-.075.135-.194.135-.194zm-.473.193l.004.01h.011a.022.022 0 00.017-.009c.02-.023.011-.126.004-.19.02-.027.066-.092.06-.127a.03.03 0 00-.014-.02l-.01-.007-.009.008c-.012.01-.115.103-.122.154a.726.726 0 00.06.18zm1.045.565c.036 0 .067.106.043.15 0 0-.026.05-.067.057-.038.006-.046-.048-.046-.048-.012-.075 0-.16.07-.16zm.212 1.553a.321.321 0 00.087.07l.01.006.008-.007c.022-.017.01-.062-.036-.133 0-.031-.003-.114-.03-.138a.03.03 0 00-.024-.008l-.012.001-.002.012c-.003.015-.027.152-.001.197zm.496.145c.009.015.024.02.04.02a.104.104 0 00.038-.008l.004-.002c.026-.02.014-.085.007-.114 0-.03-.003-.117-.03-.141a.03.03 0 00-.024-.008h-.011l-.003.012c-.008.032-.046.196-.021.24zm-.41-.755c.009.016.024.02.04.02a.11.11 0 00.038-.008l.004-.002c.026-.02.013-.088.006-.116-.006-.016-.034-.09-.08-.084l-.013.001-.002.012c-.002.014-.019.133.007.177zm-.642-.556s.078.176.055.22c0 0-.026.05-.068.057-.037.007-.045-.048-.045-.048-.013-.075.058-.23.058-.23zm.227.456c.116.038.14.175.132.224 0 0-.01.055-.047.075-.034.018-.058-.032-.058-.032-.035-.067-.109-.205-.027-.267zm.626-.682c.078.053.078.099.079.148 0 0 0 .056-.033.082-.03.024-.133-.02-.133-.02-.047-.06.083-.062.087-.21zm-.837-.754c.078.052.079.043.08.148 0 0-.028.083-.06.11-.03.023-.064-.052-.064-.052-.046-.06-.022-.187.044-.206zM21.04 16c.036 0 .067.106.044.15 0 0-.027.05-.068.057-.038.007-.046-.048-.046-.048-.012-.075 0-.16.07-.16zm.243.3c.05.163.109.213.086.256 0 0-.057.015-.1.022-.037.007-.045-.048-.045-.048-.012-.075.047-.053.059-.23zm1.368 1.893c.035 0 .066.107.043.15 0 0-.026.05-.068.057-.038.007-.046-.048-.046-.048-.012-.074 0-.159.07-.159z"
                        fill="#000"
                        fillRule="nonzero"
                    />
                </g>
                <g fill="#EACE24" fillRule="nonzero" stroke="#806600">
                    <path d="M15.795 12.872c.01-.095.004-.275-.044-.357-.017-.027-.057-.06-.089-.058-.03.001-.073.01-.088.039a.252.252 0 00-.019.11c.005.04.05.124.05.124s-.164-.034-.22-.078a.414.414 0 01-.132-.195c-.006-.024-.03-.1 0-.192a.439.439 0 01.11-.161c.105-.093.308-.066.35-.043.055.03.122.096.144.156a1.898 1.898 0 01.094.474c.006.07.021.132.007.2-.008.038-.017.122-.038.178-.021.056-.054.084-.082.108-.056.051-.239.078-.239.078s.1-.13.126-.188c.03-.069.062-.12.07-.195M16.24 12.872c-.01-.095-.004-.275.045-.357.016-.027.056-.06.088-.058.03.001.073.01.088.039a.25.25 0 01.019.11c-.005.04-.05.124-.05.124s.164-.034.22-.078a.414.414 0 00.132-.195c.006-.024.03-.1 0-.192a.44.44 0 00-.11-.161c-.105-.093-.308-.066-.35-.043a.352.352 0 00-.144.156 1.904 1.904 0 00-.094.474c-.006.07-.021.132-.007.2.008.038.017.122.038.178.021.056.054.084.082.108.056.051.239.078.239.078s-.1-.13-.126-.188c-.03-.069-.062-.12-.07-.195" />
                    <path d="M16.016 13.58s.147-.124.172-.264c.022-.127-.076-.275-.083-.335-.03-.238.033-.556.038-.582.023-.103.051-.147.066-.18.01-.025.042-.073.073-.12.017-.027.057-.077.077-.128a.415.415 0 00.002-.271.284.284 0 00-.11-.139l-.132-.083c-.063-.041-.102-.177-.103-.177 0 0-.04.136-.102.177l-.13.083a.283.283 0 00-.11.139.412.412 0 00.002.27c.02.052.06.102.077.129.031.047.062.095.073.12.015.033.043.077.066.18.005.026.068.344.038.582-.007.06-.107.208-.085.335.024.14.171.265.171.265" />
                    <path d="M16.347 12.965l-.071-.25h-.517l-.07.25.07.25h.517z" />
                </g>
                <g fill="#EACE24" fillRule="nonzero" stroke="#806600">
                    <path d="M13.014 12.872c.01-.095.005-.275-.044-.357-.017-.027-.057-.06-.088-.058-.031.001-.074.01-.088.039a.252.252 0 00-.02.11c.005.04.051.124.051.124s-.164-.034-.22-.078a.414.414 0 01-.132-.195c-.006-.024-.03-.1 0-.192a.439.439 0 01.11-.161c.104-.093.307-.066.35-.043.054.03.121.096.144.156a1.898 1.898 0 01.094.474c.006.07.02.132.006.2-.007.038-.017.122-.038.178-.02.056-.053.084-.081.108-.057.051-.24.078-.24.078s.1-.13.127-.188c.03-.069.061-.12.069-.195M13.46 12.872c-.01-.095-.005-.275.044-.357.016-.027.057-.06.088-.058.031.001.074.01.088.039a.25.25 0 01.019.11c-.004.04-.05.124-.05.124s.164-.034.22-.078a.414.414 0 00.132-.195c.006-.024.03-.1 0-.192a.44.44 0 00-.11-.161c-.104-.093-.308-.066-.35-.043a.352.352 0 00-.144.156 1.904 1.904 0 00-.094.474c-.006.07-.021.132-.007.2.008.038.018.122.039.178.02.056.053.084.08.108.058.051.24.078.24.078s-.1-.13-.126-.188c-.03-.069-.061-.12-.069-.195" />
                    <path d="M13.236 13.58s.147-.124.171-.264c.022-.127-.075-.275-.083-.335-.03-.238.033-.556.039-.582.022-.103.05-.147.065-.18.011-.025.042-.073.073-.12.018-.027.057-.077.077-.128a.415.415 0 00.002-.271.284.284 0 00-.11-.139l-.131-.083c-.064-.041-.102-.177-.103-.177-.001 0-.04.136-.103.177-.02.013-.067.044-.13.083a.283.283 0 00-.109.139.412.412 0 00.002.27c.02.052.06.102.077.129.03.047.062.095.072.12.015.033.044.077.066.18.006.026.068.344.039.582-.008.06-.107.208-.086.335.025.14.172.265.172.265" />
                    <path d="M13.566 12.965l-.07-.25h-.517l-.071.25.07.25h.517z" />
                </g>
                <g fill="#EACE24" fillRule="nonzero" stroke="#806600">
                    <path d="M18.575 12.872c.01-.095.005-.275-.044-.357-.016-.027-.057-.06-.088-.058-.03.001-.074.01-.088.039a.252.252 0 00-.019.11c.004.04.05.124.05.124s-.164-.034-.22-.078a.414.414 0 01-.132-.195c-.006-.024-.03-.1 0-.192a.439.439 0 01.11-.161c.104-.093.308-.066.35-.043.054.03.121.096.144.156a1.898 1.898 0 01.094.474c.006.07.02.132.007.2-.008.038-.018.122-.039.178-.02.056-.053.084-.08.108-.058.051-.24.078-.24.078s.1-.13.126-.188c.03-.069.061-.12.07-.195M19.021 12.872c-.01-.095-.004-.275.044-.357.017-.027.057-.06.088-.058.031.001.074.01.088.039a.25.25 0 01.02.11c-.005.04-.051.124-.051.124s.164-.034.22-.078a.414.414 0 00.132-.195c.006-.024.03-.1 0-.192a.44.44 0 00-.11-.161c-.104-.093-.307-.066-.35-.043a.352.352 0 00-.144.156 1.904 1.904 0 00-.094.474c-.006.07-.02.132-.006.2.007.038.017.122.038.178.02.056.053.084.081.108.057.051.24.078.24.078s-.1-.13-.127-.188c-.03-.069-.061-.12-.069-.195" />
                    <path d="M18.797 13.58s.147-.124.171-.264c.022-.127-.075-.275-.083-.335-.03-.238.033-.556.039-.582.022-.103.05-.147.066-.18.01-.025.041-.073.072-.12.018-.027.057-.077.077-.128a.415.415 0 00.002-.271.284.284 0 00-.11-.139l-.131-.083c-.063-.041-.102-.177-.103-.177 0 0-.04.136-.103.177-.019.013-.067.044-.13.083a.283.283 0 00-.109.139.412.412 0 00.002.27c.02.052.06.102.077.129.031.047.062.095.073.12.015.033.043.077.065.18.006.026.068.344.039.582-.008.06-.107.208-.085.335.024.14.171.265.171.265" />
                    <path d="M19.127 12.965l-.07-.25h-.517l-.07.25.07.25h.516z" />
                </g>
                <g transform="translate(15.009 18.921)">
                    <path
                        d="M.229 1.132h1.557v.364H.229v-.364zm0-.08C.226.71.178.359.032.058a.2.2 0 01.241.268A.2.2 0 11.316.7C.33.834.4.936.482.936c.064 0 .12-.06.15-.15.028.09.084.15.148.15C.869.937.942.819.949.67A.2.2 0 11.834.307a.2.2 0 11.346 0 .2.2 0 11-.114.363c.007.15.08.267.169.267.064 0 .12-.06.148-.15.03.09.085.15.15.15.082 0 .151-.102.166-.237a.2.2 0 11.043-.376.2.2 0 01.24-.267c-.145.3-.194.653-.196.996H.229z"
                        stroke="#806600"
                        fill="#EACE24"
                        fillRule="nonzero"
                    />
                    <path
                        fill="#806600"
                        fillRule="nonzero"
                        d="M1.053.713l.212-.057-.223-.06-.035-.383-.035.383-.223.06.213.057zM.222 1.192c.059 0 .117.007.162.02a.16.16 0 01.052.025l.266.177c.027.018.025.039 0 .057l-.272.18a.433.433 0 01-.208.041v-.5zM.304.782L.646.658l-.38.006-.12-.382.09.48z"
                    />
                    <path
                        d="M.208.456h.016L.26.457C.29.459.317.463.34.47l.002.001C.369.48.394.488.418.498L.426.5C.45.511.473.521.49.53l.008.004C.61.593.677.667.677.747h.001v.001c0 .031-.01.06-.028.088L.648.84.64.849.637.854H.636L.635.857a.331.331 0 01-.064.06.166.166 0 01-.057.024H.511L.473.95l-.03.006a3.709 3.709 0 00-.265-.5H.21z"
                        fill="#806600"
                        fillRule="nonzero"
                    />
                    <path fill="#FF8080" fillRule="nonzero" d="M.859 1.477l.25-.25.25.25-.25.25z" />
                    <path
                        stroke="#9E7800"
                        strokeLinejoin="round"
                        d="M.859 1.477l.25-.25.25.25-.25.25z"
                    />
                    <path fill="#FF8080" fillRule="nonzero" d="M.859 1.477l.25-.25.25.25-.25.25z" />
                    <path fill="#BA0028" fillRule="nonzero" d="M1.498 1.31l-.49.49-.01.01v-.5z" />
                    <path fill="#CF1E45" fillRule="nonzero" d="M1.359 1.31v.5l-.5-.5z" />
                    <path
                        fill="#FF083C"
                        fillRule="nonzero"
                        d="M.998 1.227v.5h.5l-.011-.012-.453-.452z"
                    />
                    <path fill="#F9C" fillRule="nonzero" d="M.146 1.474l.344-.25.156.25-.156.25z" />
                    <path fill="red" fillRule="nonzero" d="M.146 1.307h.5l-.156.5z" />
                    <path
                        d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25"
                        fill="#CCC"
                        fillRule="nonzero"
                    />
                    <path
                        d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25z"
                        stroke="#9E7800"
                    />
                    <path
                        d="M.368.504a.25.25 0 11-.001.5.25.25 0 010-.5"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        fill="#806600"
                        fillRule="nonzero"
                        d="M1.913.782L1.57.658l.379.006.121-.382-.09.48z"
                    />
                    <path
                        d="M2.236.456H2.22l-.035.001a.31.31 0 00-.08.013h-.001l-.001.001a1.081 1.081 0 00-.076.027L2.018.5a.69.69 0 00-.065.029l-.007.004c-.112.059-.18.133-.18.213v.001c0 .031.01.06.029.088l.002.003.007.01.004.005.002.002c.017.02.038.041.063.06.014.01.034.018.058.024h.003l.038.01.03.006a3.71 3.71 0 01.264-.5h-.03z"
                        fill="#806600"
                        fillRule="nonzero"
                    />
                    <path
                        d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25"
                        fill="#CCC"
                        fillRule="nonzero"
                    />
                    <path
                        d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25z"
                        stroke="#9E7800"
                    />
                    <path
                        d="M2.065.492a.25.25 0 100 .5.25.25 0 000-.5"
                        fill="#FFF"
                        fillRule="nonzero"
                    />
                    <path
                        d="M2.224 1.192a.588.588 0 00-.163.02.162.162 0 00-.052.025l-.265.177c-.028.018-.026.039 0 .057l.27.18c.039.026.122.041.21.041v-.5z"
                        fill="#806600"
                        fillRule="nonzero"
                    />
                    <path
                        fill="#FF083C"
                        fillRule="nonzero"
                        d="M2.248 1.474l-.343-.25-.157.25.157.25z"
                    />
                    <path fill="#BA0028" fillRule="nonzero" d="M2.248 1.307h-.5l.157.5z" />
                    <circle
                        stroke="#9E7800"
                        strokeWidth={0.5}
                        fill="#CCC"
                        fillRule="nonzero"
                        cx={1.184}
                        cy={0.649}
                        r={1}
                    />
                    <circle fill="#FFF" fillRule="nonzero" cx={1.213} cy={0.668} r={1} />
                    <circle
                        stroke="#9E7800"
                        strokeWidth={0.5}
                        fill="#CCC"
                        fillRule="nonzero"
                        cx={0.839}
                        cy={1.433}
                        r={1}
                    />
                    <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.449} r={1} />
                    <circle
                        stroke="#9E7800"
                        strokeWidth={0.5}
                        fill="#CCC"
                        fillRule="nonzero"
                        cx={0.839}
                        cy={1.588}
                        r={1}
                    />
                    <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.604} r={1} />
                    <circle
                        stroke="#9E7800"
                        strokeWidth={0.5}
                        fill="#CCC"
                        fillRule="nonzero"
                        cx={1.577}
                        cy={1.433}
                        r={1}
                    />
                    <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.449} r={1} />
                    <circle
                        stroke="#9E7800"
                        strokeWidth={0.5}
                        fill="#CCC"
                        fillRule="nonzero"
                        cx={1.577}
                        cy={1.588}
                        r={1}
                    />
                    <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.604} r={1} />
                </g>
                <g>
                    <g transform="translate(13.437 17.159)">
                        <path
                            d="M.229 1.132h1.557v.364H.229v-.364zm0-.08C.226.71.178.359.032.058a.2.2 0 01.241.268A.2.2 0 11.316.7C.33.834.4.936.482.936c.064 0 .12-.06.15-.15.028.09.084.15.148.15C.869.937.942.819.949.67A.2.2 0 11.834.307a.2.2 0 11.346 0 .2.2 0 11-.114.363c.007.15.08.267.169.267.064 0 .12-.06.148-.15.03.09.085.15.15.15.082 0 .151-.102.166-.237a.2.2 0 11.043-.376.2.2 0 01.24-.267c-.145.3-.194.653-.196.996H.229z"
                            stroke="#806600"
                            fill="#EACE24"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#806600"
                            fillRule="nonzero"
                            d="M1.053.713l.212-.057-.223-.06-.035-.383-.035.383-.223.06.213.057zM.222 1.192c.059 0 .117.007.162.02a.16.16 0 01.052.025l.266.177c.027.018.025.039 0 .057l-.272.18a.433.433 0 01-.208.041v-.5zM.304.782L.646.658l-.38.006-.12-.382.09.48z"
                        />
                        <path
                            d="M.208.456h.016L.26.457C.29.459.317.463.34.47l.002.001C.369.48.394.488.418.498L.426.5C.45.511.473.521.49.53l.008.004C.61.593.677.667.677.747h.001v.001c0 .031-.01.06-.028.088L.648.84.64.849.637.854H.636L.635.857a.331.331 0 01-.064.06.166.166 0 01-.057.024H.511L.473.95l-.03.006a3.709 3.709 0 00-.265-.5H.21z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#FF8080"
                            fillRule="nonzero"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            stroke="#9E7800"
                            strokeLinejoin="round"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            fill="#FF8080"
                            fillRule="nonzero"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            fill="#BA0028"
                            fillRule="nonzero"
                            d="M1.498 1.31l-.49.49-.01.01v-.5z"
                        />
                        <path fill="#CF1E45" fillRule="nonzero" d="M1.359 1.31v.5l-.5-.5z" />
                        <path
                            fill="#FF083C"
                            fillRule="nonzero"
                            d="M.998 1.227v.5h.5l-.011-.012-.453-.452z"
                        />
                        <path
                            fill="#F9C"
                            fillRule="nonzero"
                            d="M.146 1.474l.344-.25.156.25-.156.25z"
                        />
                        <path fill="red" fillRule="nonzero" d="M.146 1.307h.5l-.156.5z" />
                        <path
                            d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25"
                            fill="#CCC"
                            fillRule="nonzero"
                        />
                        <path
                            d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25z"
                            stroke="#9E7800"
                        />
                        <path
                            d="M.368.504a.25.25 0 11-.001.5.25.25 0 010-.5"
                            fill="#FFF"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#806600"
                            fillRule="nonzero"
                            d="M1.913.782L1.57.658l.379.006.121-.382-.09.48z"
                        />
                        <path
                            d="M2.236.456H2.22l-.035.001a.31.31 0 00-.08.013h-.001l-.001.001a1.081 1.081 0 00-.076.027L2.018.5a.69.69 0 00-.065.029l-.007.004c-.112.059-.18.133-.18.213v.001c0 .031.01.06.029.088l.002.003.007.01.004.005.002.002c.017.02.038.041.063.06.014.01.034.018.058.024h.003l.038.01.03.006a3.71 3.71 0 01.264-.5h-.03z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25"
                            fill="#CCC"
                            fillRule="nonzero"
                        />
                        <path
                            d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25z"
                            stroke="#9E7800"
                        />
                        <path
                            d="M2.065.492a.25.25 0 100 .5.25.25 0 000-.5"
                            fill="#FFF"
                            fillRule="nonzero"
                        />
                        <path
                            d="M2.224 1.192a.588.588 0 00-.163.02.162.162 0 00-.052.025l-.265.177c-.028.018-.026.039 0 .057l.27.18c.039.026.122.041.21.041v-.5z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#FF083C"
                            fillRule="nonzero"
                            d="M2.248 1.474l-.343-.25-.157.25.157.25z"
                        />
                        <path fill="#BA0028" fillRule="nonzero" d="M2.248 1.307h-.5l.157.5z" />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.184}
                            cy={0.649}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.213} cy={0.668} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={0.839}
                            cy={1.433}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.449} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={0.839}
                            cy={1.588}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.604} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.577}
                            cy={1.433}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.449} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.577}
                            cy={1.588}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.604} r={1} />
                    </g>
                </g>
                <g>
                    <g transform="translate(16.58 17.159)">
                        <path
                            d="M.229 1.132h1.557v.364H.229v-.364zm0-.08C.226.71.178.359.032.058a.2.2 0 01.241.268A.2.2 0 11.316.7C.33.834.4.936.482.936c.064 0 .12-.06.15-.15.028.09.084.15.148.15C.869.937.942.819.949.67A.2.2 0 11.834.307a.2.2 0 11.346 0 .2.2 0 11-.114.363c.007.15.08.267.169.267.064 0 .12-.06.148-.15.03.09.085.15.15.15.082 0 .151-.102.166-.237a.2.2 0 11.043-.376.2.2 0 01.24-.267c-.145.3-.194.653-.196.996H.229z"
                            stroke="#806600"
                            fill="#EACE24"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#806600"
                            fillRule="nonzero"
                            d="M1.053.713l.212-.057-.223-.06-.035-.383-.035.383-.223.06.213.057zM.222 1.192c.059 0 .117.007.162.02a.16.16 0 01.052.025l.266.177c.027.018.025.039 0 .057l-.272.18a.433.433 0 01-.208.041v-.5zM.304.782L.646.658l-.38.006-.12-.382.09.48z"
                        />
                        <path
                            d="M.208.456h.016L.26.457C.29.459.317.463.34.47l.002.001C.369.48.394.488.418.498L.426.5C.45.511.473.521.49.53l.008.004C.61.593.677.667.677.747h.001v.001c0 .031-.01.06-.028.088L.648.84.64.849.637.854H.636L.635.857a.331.331 0 01-.064.06.166.166 0 01-.057.024H.511L.473.95l-.03.006a3.709 3.709 0 00-.265-.5H.21z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#FF8080"
                            fillRule="nonzero"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            stroke="#9E7800"
                            strokeLinejoin="round"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            fill="#FF8080"
                            fillRule="nonzero"
                            d="M.859 1.477l.25-.25.25.25-.25.25z"
                        />
                        <path
                            fill="#BA0028"
                            fillRule="nonzero"
                            d="M1.498 1.31l-.49.49-.01.01v-.5z"
                        />
                        <path fill="#CF1E45" fillRule="nonzero" d="M1.359 1.31v.5l-.5-.5z" />
                        <path
                            fill="#FF083C"
                            fillRule="nonzero"
                            d="M.998 1.227v.5h.5l-.011-.012-.453-.452z"
                        />
                        <path
                            fill="#F9C"
                            fillRule="nonzero"
                            d="M.146 1.474l.344-.25.156.25-.156.25z"
                        />
                        <path fill="red" fillRule="nonzero" d="M.146 1.307h.5l-.156.5z" />
                        <path
                            d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25"
                            fill="#CCC"
                            fillRule="nonzero"
                        />
                        <path
                            d="M.408.478c.01 0 .022 0 .033.002a.34.34 0 01.174.287C.615.83.595.89.56.941a.33.33 0 01-.153.037C.246.978.115.866.115.728s.131-.25.293-.25z"
                            stroke="#9E7800"
                        />
                        <path
                            d="M.368.504a.25.25 0 11-.001.5.25.25 0 010-.5"
                            fill="#FFF"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#806600"
                            fillRule="nonzero"
                            d="M1.913.782L1.57.658l.379.006.121-.382-.09.48z"
                        />
                        <path
                            d="M2.236.456H2.22l-.035.001a.31.31 0 00-.08.013h-.001l-.001.001a1.081 1.081 0 00-.076.027L2.018.5a.69.69 0 00-.065.029l-.007.004c-.112.059-.18.133-.18.213v.001c0 .031.01.06.029.088l.002.003.007.01.004.005.002.002c.017.02.038.041.063.06.014.01.034.018.058.024h.003l.038.01.03.006a3.71 3.71 0 01.264-.5h-.03z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25"
                            fill="#CCC"
                            fillRule="nonzero"
                        />
                        <path
                            d="M1.996.478c-.012 0-.023 0-.034.002a.34.34 0 00-.173.287c0 .063.019.122.053.174a.332.332 0 00.154.037c.161 0 .293-.112.293-.25s-.132-.25-.293-.25z"
                            stroke="#9E7800"
                        />
                        <path
                            d="M2.065.492a.25.25 0 100 .5.25.25 0 000-.5"
                            fill="#FFF"
                            fillRule="nonzero"
                        />
                        <path
                            d="M2.224 1.192a.588.588 0 00-.163.02.162.162 0 00-.052.025l-.265.177c-.028.018-.026.039 0 .057l.27.18c.039.026.122.041.21.041v-.5z"
                            fill="#806600"
                            fillRule="nonzero"
                        />
                        <path
                            fill="#FF083C"
                            fillRule="nonzero"
                            d="M2.248 1.474l-.343-.25-.157.25.157.25z"
                        />
                        <path fill="#BA0028" fillRule="nonzero" d="M2.248 1.307h-.5l.157.5z" />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.184}
                            cy={0.649}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.213} cy={0.668} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={0.839}
                            cy={1.433}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.449} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={0.839}
                            cy={1.588}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={0.861} cy={1.604} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.577}
                            cy={1.433}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.449} r={1} />
                        <circle
                            stroke="#9E7800"
                            strokeWidth={0.5}
                            fill="#CCC"
                            fillRule="nonzero"
                            cx={1.577}
                            cy={1.588}
                            r={1}
                        />
                        <circle fill="#FFF" fillRule="nonzero" cx={1.6} cy={1.604} r={1} />
                    </g>
                </g>
            </g>
        </svg>
    );
}
SvgSaintBarthelemy.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgSaintBarthelemy.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgSaintBarthelemy;
