import React from 'react';
import PropTypes from 'prop-types';

function SvgMexico({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M31.448 12.156C29.331 3.576 20.684-1.65 12.125.473 3.567 2.595-1.645 11.265.471 19.845 2.59 28.417 11.236 33.65 19.795 31.528c8.55-2.131 13.77-10.8 11.653-19.372"
                    fill="#F1F2F2"
                />
                <path
                    d="M21.325.924a15.952 15.952 0 0110.142 11.228c1.988 8.06-2.497 16.202-10.142 18.916V.924z"
                    fill="#006847"
                />
                <path
                    d="M10.61.932v30.12c-4.856-1.75-8.784-5.817-10.117-11.22C-1.495 11.787 2.982 3.654 10.61.932"
                    fill="#CE1126"
                />
                <g>
                    <path
                        d="M20.039 16.333c0 2.276-1.8 4.12-4.023 4.12-2.221 0-4.022-1.844-4.022-4.12h-.805c0 2.73 2.161 4.943 4.827 4.943s4.827-2.213 4.827-4.943h-.804z"
                        fill="#A6D388"
                    />
                    <g fill="#5C913B">
                        <path d="M12.43 18.202a.4.4 0 00-.54-.18.418.418 0 00-.177.555c.073.145.153.288.238.425l.004.005.007.01.003.005v.002l.004.004c0 .002.002.003.003.005v.002l.003.004v.001l.004.004v.001l.003.004.001.002.002.003.002.002.002.004a564.94 564.94 0 00.006.008v.002c0 .002.001.003.003.004l.006.01h.001c0 .002.003.004.004.006.041.064.085.125.13.188.082.112.21.17.338.164a.388.388 0 00.222-.081.417.417 0 00.083-.576 4.212 4.212 0 01-.351-.583M12.034 16.898a4.161 4.161 0 01-.036-.686.408.408 0 00-.39-.423h-.03a.407.407 0 00-.384.4c-.002.086-.002.171 0 .257v.06l.002.006v.032l.001.003V16.588c.002.005.002.011.002.016a.02.02 0 000 .007v.008h.001c.007.133.02.264.037.394a.404.404 0 00.453.35.41.41 0 00.344-.465M16.29 20.444a.01.01 0 01-.005.001l-.1.007a4 4 0 01-.571-.018.408.408 0 00-.44.37.41.41 0 00.359.45l.1.01H15.642a.01.01 0 01.005 0h.005l.002.001h.013l.005.001.004.001h.016c.004.002.007 0 .011 0 .122.01.245.013.37.01.005 0 .01.002.016 0h.07a.01.01 0 01.005 0h.011c.002 0 .004 0 .005-.002h.005l.002.001H16.198l.004-.001h.016l.005-.001h.003l.004-.001h.016c.034 0 .068-.004.102-.006a.404.404 0 00.365-.433.414.414 0 00-.423-.39M14.328 20.073a4.056 4.056 0 01-.583-.339.394.394 0 00-.56.107.418.418 0 00.105.572c.002 0 .004.002.005.003l.005.005h.001c.002 0 .003.002.005.003l.005.005c.214.148.441.279.678.39.06.03.123.041.186.039a.403.403 0 00.348-.238.417.417 0 00-.195-.547M18.374 19.745a.395.395 0 00-.2.066c-.187.122-.386.23-.59.318a.414.414 0 00-.215.54.403.403 0 00.526.22c.037-.017.071-.032.107-.05h.002a.015.015 0 00.005-.003h.002l.003-.002h.003c.002 0 .002-.002.003-.002 0 0 .002 0 .002-.002h.004l.002-.001c0-.002.001-.002.002-.002l.004-.001.002-.001.004-.002h.002l.004-.002.002-.001c.002-.002.002-.003.004-.003h.001a.017.017 0 00.004-.003h.002c.002-.002.003-.002.005-.002l.005-.003h.001l.004-.003h.002c.002 0 .003-.002.005-.003v-.001l.006-.001c.002 0 .003-.002.005-.003l.002-.001.003-.003h.001l.005-.002c.004 0 .005 0 .007-.002l.005-.003.006-.003v-.001a.058.058 0 01.011-.005l.006-.003.011-.006.007-.003.004-.002a.05.05 0 01.012-.006l.004-.002h.001l.017-.01.006-.002.011-.006.006-.004.006-.001c0-.003.002-.004.004-.005l.007-.002.004-.003a.183.183 0 00.012-.005l.006-.004.004-.003c.003 0 .005-.002.006-.003l.005-.003h.002l.005-.003.005-.003.001-.001c.002 0 .003-.002.005-.003l.004-.002h.002c.001-.002.001-.002.003-.002l.002-.002c.002 0 .003 0 .004-.002h.002l.004-.003h.002l.004-.003h.001l.005-.003h.002s0-.002.002-.003h.002l.004-.003.002-.001c0-.002.002-.002.003-.003h.003l.003-.002s.002 0 .002-.002l.004-.001.002-.002s.002 0 .002-.002l.003-.002h.003l.003-.002h.002l.003-.002.003-.003h.002l.003-.002.004-.003.002-.001.004-.001.002-.002.003-.001.002-.002.002-.002.003-.001.003-.003h.002c.002-.001.005-.001.007-.003-.002-.001-.002-.001 0-.001l.003-.002.005-.003.002-.002.006-.001v-.001c.002-.003.005-.003.009-.005l.006-.004a.074.074 0 01.016-.01c.052-.03.104-.063.153-.096a.418.418 0 00.122-.568.403.403 0 00-.357-.191M20.443 15.94h-.019a.408.408 0 00-.385.411c0 .228-.02.46-.058.683a.41.41 0 00.412.482.408.408 0 00.381-.343v-.006l.002-.002-.001-.002v-.002l.001-.002v-.002l.001-.002v-.007c.002-.001.002-.003.002-.004v-.004c.017-.107.031-.214.042-.322h-.001v-.003l.001-.004V16.802l.002-.003v-.005-.005l.002-.001-.002-.003v-.002c.002-.001.002-.002.002-.003v-.005-.01l.001-.003c.01-.135.016-.27.017-.408a.408.408 0 00-.4-.414M20.087 18.161a.402.402 0 00-.212-.05.402.402 0 00-.335.212 3.99 3.99 0 01-.373.57.42.42 0 00.066.579.399.399 0 00.566-.066c.093-.121.181-.246.265-.375.001-.006.005-.011.008-.016v-.001l.004-.005.003-.007c.002 0 .003-.002.003-.004l.001.001c0-.002.002-.003.003-.005a.009.009 0 00.003-.006l.001-.001.004-.005.002-.005.004-.006v-.001l.002-.004.002-.001.002-.005h.001l.002-.004v-.002l.004-.003v-.002l.003-.004.001-.003c.002 0 .002-.001.003-.002 0-.001 0-.002.002-.003v-.003h.002l.003-.005v-.002l.003-.005.001-.001.002-.004.002-.002.001-.002.001-.003c.002 0 .002-.002.003-.004v-.002l.002-.003s0-.002.002-.002l.001-.002c.002 0 .002-.002.002-.003l.001-.003.003-.003.002-.004v-.002l.002-.002.002-.004.003-.002v-.003l.003-.004v-.002c.002 0 .002-.001.002-.003l.002-.001c0-.001 0-.002.002-.003l.002-.004.002-.002v-.002c0-.002 0-.003.002-.004 0-.001 0-.002.002-.003v-.002l.003-.004.001-.003.002-.002c0-.001 0-.002.002-.003l.001-.001.002-.005.002-.001.001-.005.002-.001.001-.003.002-.002c0-.002 0-.003.002-.004l.001-.002.002-.005c.002 0 0-.001 0-.001l.003-.004.001-.001.002-.004v-.001l.003-.005.001-.002.002-.005.004-.005.002-.005.004-.005.001-.001.02-.039a.42.42 0 00-.157-.56" />
                    </g>
                    <path
                        d="M18.43 18.805c0 .455-1.08.824-2.414.824-1.333 0-2.413-.369-2.413-.824 0-.456 1.08-.824 2.413-.824 1.333 0 2.414.368 2.414.824"
                        fill="#55ACEE"
                    />
                    <path
                        d="M17.625 18.805c0 .455-.54.824-1.207.824-.666 0-1.206-.369-1.206-.824 0-.456.54-.824 1.206-.824.667 0 1.207.368 1.207.824"
                        fill="#FFCC4D"
                    />
                    <g fill="#5C913B">
                        <path d="M15.772 17.722c-.016 0-.035 0-.052-.003a5.509 5.509 0 01-.85-.182.414.414 0 01-.27-.513l.004-.015-.009.019a.398.398 0 01-.547.158 3.329 3.329 0 01-.73-.561.42.42 0 010-.583.396.396 0 01.569 0c.158.163.344.305.553.425a.417.417 0 01.185.492.4.4 0 01.475-.211c.222.067.466.12.724.154a.41.41 0 01.347.462.406.406 0 01-.399.358m1.143 1.31a.397.397 0 01-.192-.051.417.417 0 01-.162-.558 5.65 5.65 0 01.404-.655 7.847 7.847 0 01-.345.007.426.426 0 01-.425-.413c0-.226.157-.412.38-.412l.065.002c.238-.001.482-.015.701-.036a.394.394 0 01.33.128l.035-.025c.08-.055.156-.099.226-.133a.376.376 0 01.198-.083.964.964 0 01.3-.058.4.4 0 01.323.168c.076.105.098.24.06.366-.065.219-.212.268-.47.321a1.043 1.043 0 00-.192.105.398.398 0 01-.482-.028.42.42 0 01-.002.506c-.136.178-.27.39-.399.632a.4.4 0 01-.353.216M13.8 15.794c-.343 0-.786-.136-1.055-.46-.411-.499-.654-1.136-.616-1.626.01-.13-.115-.235-.237-.268-.07-.02-.194-.032-.251.096a.2.2 0 01-.267.1.208.208 0 01-.099-.273c.126-.28.407-.404.717-.322.288.077.565.342.538.7-.03.38.18.913.523 1.327.179.217.492.305.704.314.173.009.26-.032.28-.05-.046-.11-.642-.43-.896-.567-.216-.117-.28-.276-.297-.389-.054-.374.322-.754.686-1.12.128-.13.25-.251.314-.342.075-.101.063-.169.049-.21-.057-.155-.296-.307-.586-.373-.268-.061-.449-.194-.537-.394-.116-.265-.055-.61.188-1.059a.199.199 0 01.274-.08.21.21 0 01.078.28c-.23.422-.207.613-.174.69.034.076.12.13.259.16.34.078.749.285.874.633a.63.63 0 01-.102.6c-.085.115-.217.247-.355.388-.208.21-.594.6-.57.767.005.034.05.064.086.084.604.326 1.005.56 1.087.847a.383.383 0 01-.033.296c-.078.14-.24.225-.471.246a1.219 1.219 0 01-.111.005" />
                    </g>
                    <g fill="#FFCC4D">
                        <path d="M17.625 16.333c0 .456-.18.824-.402.824-.222 0-.402-.368-.402-.824 0-.455.18-.824.402-.824.222 0 .402.37.402.824M15.446 15.663c0 .238-.278.43-.62.43-.342 0-.62-.192-.62-.43 0-.237.278-.429.62-.429.342 0 .62.192.62.43M14.496 11.852c.04.175-.183.379-.498.456-.315.076-.604-.004-.644-.178-.04-.176.182-.38.497-.457.316-.076.604.004.645.179" />
                    </g>
                    <path
                        d="M19.663 16.3c.072.058.195-.6.177-.806 0-.014-.024-.45.067-.76.055-.106.058-.894-.027-1.1.068-.006.148-.028.159-.113-.313.119-.386-.673-.686-1.127-.291-.455-.652-.72-1.03-.997a.809.809 0 01.13-.223c-.462.237-1.183-.622-2.248-.558-.239.024-.351.039-.413.189-.2.016-.401.063-.401.33 0 .065.057.182.184.182.174.052.316.012.434.26l.031.258s-.156-.203-.241-.236l.052-.11c-.08-.046-.223-.009-.223-.009s-.308-.148-.557-.108l-.048-.206c-.044.126-.141.12-.155.24-.027-.087-.063-.193-.09-.278-.088.122-.061.253-.093.38-.034.03-.103.031-.121-.05-.009-.101-.02-.11-.02-.23-.064.113-.14.168-.164.362l-.067-.215c.002.253-.21.405-.412.583-.056.107.01.108.014.163l.106.054.19-.014c.031.04.006.044.088.07.222.063.5-.21.716.22-.099.085-.2.285-.168.323.04 0-.08.058.082.005-.17.168-.284.39-.284.402-.019.048.069-.006.05.08l.04-.005c-.386.427-.012.886-.053 1.132.064.107.071-.002.152-.013.067.303.262.487.38.726l-.25.004c.006.113.107.221.187.321l-.169.054c-.12.064-.2.13-.284.226-.055.14.268.172.424.196l-.005.168c.243.023.525-.05.525-.065l.061-.047.138.077c.046 0 .117-.188.084-.333.089.108.173.282.262.39l.083-.01c.075.122.18.244.256.367l.083.033c.05-.017.091-.024.118-.122l.038.07.134-.094.094-.02.07.118c.04-.017.081-.108.083-.205.042.085.053.079.084.1l.062-.133.334.32.253.015c.09.063.337.101.379 0 .202.09.441-.01.43-.11.186.076.473.025.473.013.035-.005.123-.094.04-.16-.617-.44-1.533-1.17-1.885-1.345 0-.13-.096-.599-.199-.727l.083-.144c.24.23.328.207.456.244.137.112.184.28.321.435l.123.023a2.172 2.172 0 00-.446-.72c.132.068.35.248.498.378.096.166.124.299.213.506.064.042.13.196.121.068-.015-.24-.18-.62-.18-.647.263.213.26.544.339.746.066.102.1.239.13.207l-.077-.623-.045-.229c.194.115.263.552.354 1.076 0 .083.033.174.028.228.04.053.09.198.088.112 0 0 0-.852-.057-1.046-.014-.105.024-.276.024-.276.071.354.147.737.22 1.09v.259l.105.109c.02-.214.044-.427.065-.64l-.08-.762v-.217c0-.077.07-.063.113.025.01.186.01.332.018.519.032.212.053.368.069.639.008.222.017.747.063.738"
                        fill="#C1694F"
                    />
                </g>
            </g>
        </svg>
    );
}
SvgMexico.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgMexico.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgMexico;
