import React from 'react';
import PropTypes from 'prop-types';

function SvgGeorgia({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <circle fill="#FFF" cx={15.99} cy={15.99} r={15.989} />
                <g fill="#F3F4F5">
                    <path d="M13.507.193C6.664 1.259 1.26 6.664.193 13.507h13.314V.193zM.193 18.472c1.067 6.842 6.472 12.247 13.314 13.314V18.472H.193z" />
                </g>
                <g fill="#DA1E37">
                    <path d="M7.517 5.556h1.366v5.428H7.517z" />
                    <path d="M5.486 7.588h5.428v1.366H5.486zM7.517 21.335h1.366v5.428H7.517z" />
                    <path d="M5.486 23.367h5.428v1.366H5.486z" />
                </g>
                <g fill="#F3F4F5">
                    <path d="M21.94 23.366h4.627v1.366h-4.93c-.69 2.776-1.744 5.043-3.165 6.263v.79c6.842-1.066 12.247-6.471 13.313-13.313h-9.973c-.098 1.696.43 3.353.127 4.894zM21.72 7.587h4.847v1.367h-4.563c.265 1.443-.094 2.981-.003 4.553h9.784C30.72 6.664 25.314 1.26 18.472.193v.79c1.479 1.271 2.561 3.673 3.247 6.604z" />
                </g>
                <g fill="#CF2028">
                    <path d="M15.093 32.11zM14.593.233zM15.257.139C15.5.058 15.745 0 15.989 0c-.246 0-.49.054-.732.139zM31.785 13.507h-9.784a43.195 43.195 0 010 4.964h9.784a16.082 16.082 0 000-4.964zM15.989 31.978a16.1 16.1 0 002.483-.193v-.79c-.731.629-1.558.983-2.483.983zM18.472.193A16.1 16.1 0 0015.989 0c.925 0 1.752.355 2.483.983v-.79zM15.989 32.095zM26.567 8.954V7.587h-5.081c.104.445.199.9.284 1.367h4.797zM26.567 24.732v-1.366h-4.86c-.091.468-.192.923-.302 1.366h5.162z" />
                </g>
                <g fill="#FFF">
                    <path d="M14.962.15c.166-.047.333-.1.5-.131-.166.032-.333.082-.5.13zM15.462 32.076c-.167-.033-.333-.084-.5-.134.167.046.334.1.5.134z" />
                </g>
                <g fill="#F3F4F5">
                    <path d="M18.472 30.995c1.421-1.22 2.476-3.487 3.165-6.263h-.498v-1.366h.8c.302-1.541.501-3.198.6-4.895h-4.067v12.524zM21.139 8.954V7.587h.58c-.686-2.93-1.768-5.333-3.247-6.604v12.524h4.067a37.308 37.308 0 00-.535-4.553h-.865z" />
                </g>
                <g fill="#DA1E37">
                    <path d="M18.472 18.472h4.067a43.195 43.195 0 000-4.965h-4.067V.983C17.741.355 16.914 0 15.989 0c-.244 0-.488.008-.732.019-.103.004-.206.011-.309.017a16.554 16.554 0 00-1.44.157v13.313H.192a16.093 16.093 0 000 4.965h13.314v13.315a16.346 16.346 0 001.441.156c.103.006.206.014.309.018.244.01.488.018.732.018.925 0 1.752-.355 2.483-.983V18.472zM21.139 8.954h.865c-.086-.467-.18-.922-.285-1.367h-.58v1.367zM21.139 24.732h.498c.11-.443.211-.899.302-1.366h-.8v1.366z" />
                </g>
                <g fill="#CF2028">
                    <path d="M23.17 21.335h1.366v5.428H23.17zM23.17 5.556h1.366v5.428H23.17z" />
                </g>
            </g>
        </svg>
    );
}
SvgGeorgia.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgGeorgia.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgGeorgia;
