import React from 'react';
import PropTypes from 'prop-types';

function SvgCroatia({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M32 16c0-1.957-.352-3.832-.995-5.565L16 9.739l-15.005.696A15.966 15.966 0 000 16c0 1.957.352 3.832.995 5.565L16 22.261l15.005-.696C31.648 19.832 32 17.957 32 16z"
                    fill="#F0F0F0"
                />
                <path
                    d="M16 32c6.88 0 12.744-4.342 15.005-10.435H.995C3.255 27.658 9.121 32 16 32z"
                    fill="#0052B4"
                />
                <path
                    d="M.995 10.435h30.01C28.745 4.342 22.879 0 16 0 9.12 0 3.256 4.342.995 10.435z"
                    fill="#D80027"
                />
                <g fill="#338AF3">
                    <path d="M20.174 11.13H17.39l.464-3.478 1.855-1.391 1.855 1.391v2.783zM11.826 11.13h2.783l-.464-3.478-1.855-1.391-1.855 1.391v2.783z" />
                </g>
                <path fill="#0052B4" d="M17.855 11.13h-3.71V7.652L16 6.261l1.855 1.391z" />
                <path
                    d="M10.435 10.435v7.652a5.56 5.56 0 002.237 4.458l.974-.243 1.23 1.236a5.569 5.569 0 002.243.001l1.403-1.168.806.172a5.558 5.558 0 002.237-4.456v-7.652h-11.13z"
                    fill="#F0F0F0"
                />
                <g fill="#D80027">
                    <path d="M10.435 10.435h2.226v2.226h-2.226zM14.887 10.435h2.226v2.226h-2.226zM19.339 10.435h2.226v2.226h-2.226z" />
                    <path d="M12.661 12.661h2.226v2.226h-2.226zM17.113 12.661h2.226v2.226h-2.226z" />
                    <path d="M10.435 14.886h2.226v2.226h-2.226zM12.661 17.112h2.226v2.226h-2.226zM14.887 14.886h2.226v2.226h-2.226zM19.339 14.886h2.226v2.226h-2.226zM17.113 17.112h2.226v2.226h-2.226zM14.887 19.338h2.226v2.226h-2.226zM12.66 19.339h-2.082a5.548 5.548 0 001.082 2.226h1v-2.226zM19.34 21.565h1a5.547 5.547 0 001.082-2.226h-2.083v2.226zM12.66 21.565v.971a5.543 5.543 0 002.227 1.004v-1.975H12.66zM17.113 21.565v1.975a5.54 5.54 0 002.226-1.004v-.971h-2.226z" />
                </g>
            </g>
        </svg>
    );
}
SvgCroatia.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgCroatia.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgCroatia;
