import React from 'react';
import PropTypes from 'prop-types';

function SvgBrazil({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M.516 12.195C2.628 3.643 11.276-1.572 19.829.548c8.552 2.112 13.767 10.76 11.647 19.313-2.12 8.552-10.76 13.767-19.313 11.647C3.62 29.388-1.604 20.748.516 12.195"
                    fill="#54B948"
                />
                <path fill="#FFD203" d="M1.153 16.089l14.726 9.406 14.727-9.406L15.879 6.69z" />
                <path
                    d="M15.88 9.785a6.304 6.304 0 016.302 6.312c0 3.482-2.82 6.311-6.303 6.311a6.31 6.31 0 01-6.311-6.311 6.306 6.306 0 016.311-6.312"
                    fill="#2E3192"
                />
                <path
                    d="M22.15 16.725a15.287 15.287 0 00-10.084-3.337c-.669.025-1.338.097-1.982.202a6.609 6.609 0 00-.33.975c.757-.153 1.539-.25 2.345-.274a14.382 14.382 0 019.866 3.442c.088-.322.153-.661.185-1.008"
                    fill="#FFF"
                />
                <path
                    d="M10.39 13.993l.072.145.13.032.112-.072.024-.17-.064-.153-.129-.032-.113.073-.032.177zm-.129.024l.008-.161.04-.089.073-.064.129-.04.226.056.112.218-.048.241-.202.113-.225-.056-.113-.218zM11.228 13.84l.089-.008.113-.016.032-.033.008-.048-.016-.048-.048-.016-.09.008-.096.008.008.153zm-.097.363l-.056-.613.258-.024h.145l.073.048.032.097-.032.113-.121.064.072.049.08.096.09.113-.146.016-.104-.129-.073-.08-.04-.025h-.089l.024.258-.113.017zM12.01 13.63l.008.411h.097l.072-.008.049-.024.032-.064.008-.113-.016-.113-.04-.057-.057-.024h-.105l-.048-.008zm-.129-.105l.226-.008.12.008.097.057.065.097.024.145-.016.129-.065.112-.088.049-.113.016-.234.008-.016-.613zM12.655 14.122l.009-.613.49.008v.105l-.361-.008v.137l.327.008v.105l-.327-.008-.009.17h.37v.104zM13.372 14.138l.04-.613.186.017.08.427.146-.411.185.008-.048.62-.113-.008.032-.483-.153.475-.121-.008-.089-.5-.032.484zM14.606 14.259l.088-.613.452.073-.017.105-.33-.057-.016.137.306.049-.016.104-.306-.048-.024.161.338.057-.016.104zM15.911 13.977l-.04.17.065.015.096.016.049-.024.024-.04-.008-.057-.04-.04-.081-.024-.065-.016zm-.241.467l.137-.604.193.048.145.04.073.081.008.129-.04.089-.065.048-.073.016-.129-.024-.08-.016-.049.226-.12-.033zM16.588 14.307l.09.024.112.025.04-.016.024-.04v-.05l-.04-.031-.089-.025-.088-.024-.049.137zm-.217.307l.17-.597.249.073.137.056.056.073v.104l-.072.097-.137.016.048.065.04.113.04.137-.144-.04-.049-.154-.04-.105-.032-.032-.057-.024-.024-.008-.072.25-.113-.024zM17.298 14.573l-.008.17.096.088.13-.016.096-.137.008-.17-.097-.088-.137.008-.088.145zm-.121-.04l.08-.137.081-.065.097-.024.137.024.177.154v.25l-.153.193-.234.008-.177-.153v-.25h-.008zM18.217 15l.04-.096.25.105-.097.225-.129.016-.153-.032-.137-.097-.056-.153.032-.16.096-.146.154-.065.153.033.145.113.024.153-.12-.024-.017-.09-.073-.056h-.145l-.104.121-.017.17.097.104.08.017.081-.009.025-.072zM18.878 15.146l.08.04.105.04.04-.008.033-.032.008-.048-.033-.04-.08-.041-.089-.04-.064.129zm-.266.274l.266-.557.233.113.121.08.04.082-.016.096-.08.089h-.137l.04.072.024.121.016.145-.137-.064-.024-.161-.016-.113-.024-.04-.057-.033-.024-.008-.113.234-.112-.056zM19.297 15.75l.29-.54.403.218-.048.088-.299-.16-.064.12.274.153-.048.089-.275-.145-.072.145.298.161-.048.097zM19.998 15.903l.105.057-.008.096.064.073.089.024.056-.032.008-.04-.024-.049-.072-.072-.081-.121.016-.137.065-.065.096-.008.113.04.13.138-.025.145-.105-.057.008-.08-.056-.057-.089-.024-.032.024-.008.04.08.09.09.112.023.089-.024.096-.08.073-.105.008-.13-.048-.12-.137zM20.61 16.29l.113.057-.016.096.057.073.088.032.065-.032.008-.04-.024-.04-.065-.081-.088-.13.024-.136.072-.057.105-.008.105.049.12.137-.023.153-.105-.065.008-.08-.057-.057-.08-.032-.04.016-.008.048.072.097.089.113.024.089-.032.096-.089.065-.105.008-.12-.056-.122-.146zM21.384 16.693l-.056.161.064.113.13.032.136-.096.057-.153-.065-.113-.129-.032-.137.088zm-.104-.072l.12-.105.097-.032h.097l.12.064.122.202-.08.233-.202.137-.226-.064-.12-.202.072-.233z"
                    fill="#0C9C51"
                />
                <path
                    fill="#FFF"
                    d="M17.882 13.695l.066.198h.188l-.155.112.057.19-.156-.112-.156.112.066-.19-.156-.112h.189zM15.911 18.797l.059.193h.191l-.15.114.059.193-.159-.114-.158.114.058-.193-.15-.114h.192zM20.38 18.168l.066.187h.189l-.156.118.058.195-.156-.118-.156.118.058-.195-.148-.118h.189zM21.352 18.313l.063.198h.187l-.162.118.062.184-.15-.118-.15.118.05-.184-.15-.118h.188zM20.667 18.765l.056.196h.194l-.157.117.065.187-.158-.118-.157.118.065-.187-.158-.117h.195zM20.28 19.289l.058.19h.192l-.154.12.068.19-.164-.12-.154.12.058-.19-.154-.12h.193zM19.815 19.668l.06.192h.196l-.159.115.061.193-.158-.129-.147.129.061-.193-.158-.115h.195zM19.16 19.539l.062.197h.188l-.15.118.062.185-.162-.119-.15.119.062-.185-.162-.118h.2zM18.44 19.756l.058.195h.186l-.15.11.057.195-.15-.122-.164.122.059-.195-.152-.11h.186zM19.174 20.796l.049.192h.195l-.159.116.061.192-.146-.115-.159.115.061-.192-.158-.116h.195zM17.822 20.248l.053.189h.197l-.16.122.062.189-.152-.123-.152.123.054-.189-.152-.122h.187zM17.387 19.587l.059.195h.19l-.154.11.06.195-.155-.122-.155.122.047-.195-.142-.11h.19zM19.136 20.103l.064.196h.186l-.158.117.065.187-.157-.118-.149.118.056-.187-.157-.117h.194zM16.065 21.118l.05.185h.2l-.15.131.05.184-.15-.131-.15.131.05-.184-.15-.131h.2zM17.644 15.613l.057.202h.193l-.159.108.057.19-.148-.107-.159.107.057-.19-.148-.108h.182zM15.955 17.008l.063.193h.192l-.16.113.064.194-.16-.114-.148.114.063-.194-.16-.113h.192zM16.685 17.58l.06.191h.19l-.15.117.06.192-.16-.117-.15.117.06-.192-.16-.117h.2zM15.347 17.604l.063.19h.187l-.162.12.062.19-.15-.122-.15.122.05-.19-.15-.12h.188zM15.71 18.12l.058.2h.192l-.154.1.058.2-.154-.12-.154.12.058-.2-.154-.1h.192zM10.668 14.799l.057.19h.197l-.156.112.058.198-.156-.12-.156.12.066-.198-.156-.112h.189zM13.482 16.226l.051.198h.194l-.153.114.061.188-.153-.115-.163.115.061-.188-.153-.114h.194zM11.24 17.475l.058.19h.196l-.155.12.057.19-.156-.12-.155.12.057-.19-.148-.12h.189zM11.986 17.21l.05.189h.2l-.15.12.05.19-.15-.12-.15.12.05-.19-.15-.12h.183zM12.615 18.144l.057.19h.193l-.154.12.058.19-.154-.12-.154.12.058-.19-.154-.12h.192zM13.328 19.32l.057.19h.197l-.156.121.058.19-.156-.12-.156.12.066-.19-.156-.12h.189zM12.405 18.78l.067.19h.183l-.154.12.058.19-.154-.12-.154.12.058-.19-.154-.12h.192zM10.535 18.128l.063.184h.187l-.15.119.05.197-.15-.118-.15.118.05-.197-.15-.119h.188z"
                />
                <path
                    d="M16.54 14.017l-.17.597.122.032.072-.25.024.008.057.024.032.032.04.105.049.153.145.04-.04-.136-.04-.113-.05-.065.138-.016.072-.097v-.104l-.056-.073-.137-.056-.258-.08zm.25.339l-.113-.025-.089-.024.049-.153.088.024.09.025.04.032v.048l-.025.04-.04.033zM17.427 14.3l-.097.023-.08.065-.081.137v.25l.177.153.234-.008.153-.194v-.25l-.177-.153-.13-.024zm-.04.531l-.097-.088.008-.17.096-.137.137-.008.105.089-.008.17-.097.136-.145.008zM18.217 14.597l-.154.065-.096.145-.032.161.056.153.137.097.153.032.13-.016.096-.225-.25-.105-.04.097.129.056-.025.072-.08.009-.08-.017-.098-.104.017-.17.104-.12h.145l.073.056.016.089.121.024-.024-.153-.145-.113zM18.878 14.863l-.266.557.112.056.113-.234.024.008.057.033.024.04.016.113.024.161.137.064-.016-.145-.024-.12-.04-.073h.137l.08-.089.017-.096-.04-.081-.122-.08-.233-.114zm.185.371l-.105-.04-.08-.04.064-.137.089.04.08.04.033.04-.008.049-.033.032-.04.016zM19.587 15.21l-.29.54.41.226.05-.097-.3-.161.073-.145.275.145.048-.089-.274-.153.064-.12.299.16.048-.088zM20.312 15.63l-.096.007-.065.065-.016.137.08.12.073.073.024.049-.008.04-.056.032-.089-.024-.064-.073.008-.096-.105-.057-.016.178.12.137.13.048.105-.008.08-.073.024-.096-.024-.089-.089-.113-.08-.089.008-.04.032-.024.089.024.056.057-.008.08.105.057.024-.145-.129-.137zM20.95 16.024l-.106.008-.072.057-.024.137.088.129.065.08.024.04-.008.04-.065.033-.088-.032-.057-.073.016-.096-.112-.057-.025.17.121.145.121.056.105-.008.089-.065.032-.096-.024-.089-.089-.113-.072-.097.008-.048.04-.016.08.032.057.057-.008.08.105.065.024-.153-.121-.137zM21.49 16.476l-.098.032-.12.105-.073.233.12.202.227.064.201-.137.08-.233-.12-.202-.121-.064h-.097zm.031.523l-.129-.032-.064-.113.056-.16.137-.098.13.033.064.113-.057.153-.137.104z"
                    fill="#118543"
                />
            </g>
        </svg>
    );
}
SvgBrazil.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgBrazil.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgBrazil;
