import React from 'react';
import PropTypes from 'prop-types';

function SvgAlbania({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M.55 12.178C2.666 3.62 11.312-1.592 19.87.525c8.558 2.117 13.77 10.764 11.653 19.321-2.117 8.55-10.763 13.77-19.321 11.653C3.652 29.382-1.568 20.735.549 12.178"
                    fill="#EF3827"
                />
                <path
                    d="M15.943 28.089c-.38-.46-.961-.962-.8-1.632l.38-.59.033-.518c-.291.316-.558.695-.986.849-.291.121-.623.032-.857-.162l-.024-.315c.307-.21.743-.161.994-.46.266-.275.323-.671.275-1.035-.453.227-.752.784-1.301.8-.396.097-.833-.161-.881-.573.404-.243.897-.21 1.325-.396.259-.13.364-.437.299-.712-.388.146-.735.493-1.18.404-.355.04-.719-.25-.695-.614.267-.056.526-.089.792-.137.493-.121.881-.493 1.172-.897.412-.614.703-1.325.76-2.06l-.178-.526c-.356-.048-.517.307-.703.525-.437.647-.84 1.334-1.083 2.085-.364 0-.663-.194-.962-.388l-.55.065c-.5.218-1.017.38-1.518.598l.557.226.63.081.372.38.049.55-.25-.26c-.098-.104-.235-.088-.373-.064-.145.016-.29.04-.387-.089-.235-.315-.607-.46-.954-.598l-.331-.024c-.315.162-.63.34-.873.614l-.372.428-.55.09-.298.565c-.218-.331-.057-.735.04-1.083.081-.315.445-.315.711-.34.364.033.663-.225.93-.42-.615 0-1.22.041-1.827.122l-.582-.21-.638.04.34-.372c.234-.08.492-.113.743-.177.29-.081.517.17.784.226.404.073.816.08 1.228.073-.34-.275-.711-.534-1.164-.55-.242-.008-.339-.267-.55-.34l-.597-.048.299-.372c.137-.016.267 0 .404.017.121.016.25.032.38.024l.598.202c.258.444.703.711 1.14.945l.298-.04c.59-.234 1.172-.453 1.737-.727l-.428-.534c.711-.371 1.455-.783 1.907-1.462.243-.364.51-.776.453-1.22-.332.484-.59 1.123-1.22 1.284l-.316-.347c.13-.21.332-.364.42-.598.13-.234.13-.517.162-.776l-.412.049c-.186.315-.267.687-.444 1.002-.259.468-.501 1.01-.994 1.26-.275.09-.808-.072-.679-.46.283-.315.72-.493.913-.897.21-.404.501-.913.226-1.35-.42.364-.638.897-1.018 1.301-.5.558-.93 1.212-1.624 1.544-.331.153-.703.274-1.067.202-.347-.04-.703-.227-.864-.542l.194-.38c.258-.097.517.009.775.017.437.04.849-.178 1.172-.437.647-.598 1.091-1.382 1.39-2.19l-.121-.145c-.477.525-.954 1.067-1.568 1.43-.404.243-.897.428-1.374.3-.363-.074-.767-.332-.767-.736.032-.25.331-.267.525-.235.485.057 1.018.106 1.454-.145.566-.315.954-.848 1.342-1.35.178-.282.46-.549.42-.913-.622.324-1.075.897-1.697 1.229-.469.323-1.107.412-1.632.177-.25-.105-.437-.387-.396-.662l.275-.388c.525.024 1.05.267 1.575.113.574-.21 1.01-.654 1.398-1.107l.227-.533c-.615.129-1.148.5-1.714.76-.323.145-.686.153-1.034.112-.372-.048-.72-.339-.768-.719l.275-.396c.25-.048.46.049.679.146.202.089.404.186.638.145.816-.016 1.722-.436 2.029-1.244l-.114-.121c-.42.072-.8.299-1.212.412-.8.153-1.705-.017-2.278-.623l.08-.646c.372-.065.687.194 1.01.34.574.306 1.342.371 1.891-.041.316-.218.671-.525.655-.946-.477.073-.889.34-1.366.405-.573.056-1.212.04-1.705-.3-.388-.242-.76-.67-.654-1.163l.509-.186c.242.178.412.453.679.606.412.3.953.34 1.446.3.323-.041.735.023.937-.3l-.347-.46c-.962-.162-1.9-.518-2.691-1.1-.299-.21-.558-.492-.646-.848-.073-.34.137-.776.509-.792.242 0 .388.226.493.412.59.986 1.705 1.52 2.796 1.746l.226-.517c.574.266 1.172.468 1.761.686.235.097.493.202.63.429.34.42.082 1.002.235 1.487l.493.347c.364.04.72-.226.76-.598.064-.873-.372-1.81-1.172-2.198-.477-.29-1.05-.323-1.592-.412-.364-.024-.469-.525-.832-.55-.3-.024-.615-.105-.833-.323l-.218-.38.283-.072c.234.153.364.436.622.565.323.105.663.122.994.049v-.218l-.396-.09-.452.267.202-.581c.258-.146.581-.122.864-.178.235 0 .404-.194.623-.226.444-.04.872.113 1.276.299.485.266 1.059.048 1.576.016-.17.266-.428.46-.727.59l-.033.113c.259.186.542.331.833.468l-.453.275c.194.283.51.437.833.51l-.429.234.315.29.404.049-.153.396.29.016.276-.016-.154-.396.396-.048.315-.291-.428-.235c.331-.072.646-.226.84-.509l-.452-.275c.29-.137.573-.274.832-.468l-.032-.113a1.511 1.511 0 01-.72-.59c.526.04 1.091.258 1.576-.016.404-.186.833-.34 1.277-.3.226.033.388.227.622.227.283.064.606.032.865.178l.202.581-.453-.266-.396.089v.218c.332.073.671.048.994-.049.259-.129.388-.412.623-.565l.282.072-.218.38c-.218.218-.533.3-.832.323-.364.025-.469.518-.832.55-.542.089-1.115.121-1.592.412-.8.388-1.237 1.333-1.172 2.198.04.372.388.638.76.598l.493-.347c.153-.477-.106-1.067.234-1.487.137-.227.396-.332.63-.429.59-.218 1.188-.42 1.762-.686l.226.517c1.091-.227 2.206-.76 2.796-1.746.113-.186.25-.412.493-.412.372.016.582.46.51.792-.098.356-.365.638-.655.849-.792.581-1.73.937-2.691 1.099l-.348.46c.202.323.622.259.937.3.493.031 1.035 0 1.447-.3.267-.153.428-.428.67-.606l.51.186c.113.493-.259.921-.655 1.164-.493.339-1.131.355-1.705.299-.477-.057-.889-.332-1.365-.405-.017.42.339.728.654.946.55.412 1.31.34 1.891.04.323-.145.638-.412 1.01-.339l.08.646c-.573.615-1.478.784-2.278.623-.412-.113-.792-.348-1.212-.412l-.113.12c.307.809 1.212 1.229 2.036 1.245.235.033.437-.056.639-.145.21-.097.428-.194.678-.146l.275.396c-.048.38-.404.67-.776.72-.347.04-.71.032-1.034-.114-.566-.266-1.099-.63-1.713-.76l.226.534c.388.453.824.897 1.398 1.107.533.154 1.059-.089 1.584-.113l.275.388c.04.275-.146.557-.396.662-.526.243-1.164.154-1.633-.177-.622-.332-1.074-.905-1.697-1.229-.048.364.243.63.42.914.389.5.776 1.026 1.342 1.349.445.242.978.194 1.455.145.185-.024.5-.016.525.235 0 .404-.404.67-.768.735-.477.13-.961-.056-1.374-.299-.614-.363-1.09-.905-1.567-1.43l-.121.145c.307.808.743 1.592 1.39 2.19.33.259.735.477 1.18.437.258-.008.516-.114.775-.017l.202.38c-.17.315-.517.501-.873.542-.363.064-.735-.049-1.066-.202-.695-.332-1.132-.986-1.625-1.544-.38-.404-.598-.937-1.026-1.3-.275.436.016.953.226 1.349.186.412.63.582.914.897.12.38-.405.55-.687.46-.493-.25-.736-.792-.994-1.26-.178-.324-.259-.695-.445-1.002l-.412-.049c.032.267.032.542.162.776.08.234.29.388.42.598l-.315.347c-.63-.161-.89-.8-1.22-1.284-.057.452.218.856.452 1.22.453.687 1.196 1.09 1.907 1.462l-.428.534c.566.283 1.155.493 1.737.727l.3.04c.436-.226.88-.5 1.139-.945l.598-.202c.129.008.25-.008.371-.024.138-.017.275-.033.413-.017l.29.372-.598.049c-.21.072-.307.331-.55.34-.443.023-.815.274-1.155.549.413.016.825 0 1.229-.073.266-.057.493-.3.784-.226.25.064.5.097.743.177l.331.372-.638-.04c-.194.072-.356.258-.582.21a13.773 13.773 0 00-1.826-.121c.275.202.565.452.93.42.266.024.63.024.71.34.097.347.259.75.04 1.082l-.298-.566-.55-.089-.372-.428c-.242-.267-.557-.444-.872-.614l-.332.024c-.347.138-.719.283-.953.598-.097.121-.243.105-.388.09-.137-.017-.275-.041-.372.064l-.258.258.056-.55.372-.379.63-.08.55-.227c-.493-.226-1.018-.38-1.52-.598l-.549-.065c-.299.194-.598.388-.962.388-.242-.751-.646-1.438-1.09-2.085-.178-.218-.34-.581-.695-.525l-.178.525c.056.736.347 1.447.76 2.061.29.396.678.768 1.171.897.259.048.525.08.792.137.024.364-.347.655-.695.614-.444.081-.792-.258-1.18-.404-.064.283.033.582.3.712.42.185.912.161 1.325.396-.049.412-.493.67-.881.573-.558-.024-.857-.573-1.31-.8-.04.364.009.76.283 1.035.25.29.687.25.994.46l-.024.315a.83.83 0 01-.856.162c-.429-.154-.687-.533-.986-.849l.032.518.38.59c.121.67-.453 1.18-.84 1.632"
                    fill="#2D2B22"
                />
            </g>
        </svg>
    );
}

SvgAlbania.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgAlbania.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgAlbania;
