import React from 'react';
import PropTypes from 'prop-types';

function SvgAfghanistan({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M30.572 12.156C28.514 3.576 20.108-1.65 11.787.473 3.467 2.595-1.6 11.265.458 19.845c2.059 8.572 10.465 13.806 18.785 11.683 8.312-2.131 13.388-10.8 11.33-19.372"
                    fill="#FF4B55"
                />
                <path
                    d="M20.731.924c4.737 1.741 8.563 5.816 9.86 11.228 1.932 8.06-2.428 16.202-9.86 18.916V.924z"
                    fill="#73AF00"
                />
                <path
                    d="M10.315.932v30.12c-4.722-1.75-8.54-5.817-9.836-11.22-1.932-8.045 2.42-16.178 9.836-18.9"
                    fill="#464655"
                />
                <g fill="#F5F5F5">
                    <path d="M13.905 17.594h3.3l-.184-.5h-2.933zM13.905 14.42h3.3l-.184.5h-2.933z" />
                    <path d="M14.612 14.758h1.807l-.362-.5h-1.084zM16.968 16.527h-1v1h1z" />
                    <path d="M16.968 15.96h-1v1h1z" />
                    <path d="M16.968 14.988h-1v1h1z" />
                    <path d="M16.968 15.555h-1v1h1zM14.611 16.527h-1v1h1z" />
                    <path d="M14.611 15.96h-1v1h1z" />
                    <path d="M14.611 14.988h-1v1h1z" />
                    <path d="M14.611 15.555h-1v1h1zM16.811 13.529h-1v1h1zM16.311 13.462h.5v-.273a.227.227 0 00-.226-.227h-.047a.227.227 0 00-.227.227v.273zM14.611 13.529h-1v1h1zM14.112 13.462h.5v-.273a.227.227 0 00-.227-.227h-.047a.227.227 0 00-.226.227v.273zM15.445 14.987h.14c.374 0 .676.303.676.676v1.188H14.77v-1.188c0-.373.303-.676.676-.676zM16.733 16.195l1.02-1.2a.186.186 0 01-.012-.062c0-.104.084-.189.188-.189.103 0 .187.085.187.19a.188.188 0 01-.187.188c-.011 0-.021-.004-.032-.006l-.105.124.512 1.206-.563.567-.485-1.143-.38.448-.143-.123zm.912.395l.449-.452-.203-.477-.449.453.203.476z" />
                    <path d="M14.155 16.318l-.38-.448-.486 1.143-.563-.567.513-1.206-.106-.124c-.01.002-.02.006-.032.006a.188.188 0 01-.187-.189c0-.104.084-.189.187-.189.104 0 .188.085.188.19a.186.186 0 01-.012.06l1.02 1.201-.142.123zm-.567-.204l-.449-.453-.202.476.448.453.203-.476zM15.304 13.184a.25.25 0 00.144-.102c.022-.035.045-.074.067-.12.023.046.045.085.067.12a.25.25 0 00.144.102.753.753 0 01.51.912h-1.44a.753.753 0 01.509-.912zM19.718 16.002a4.581 4.581 0 00-.045-1.098 3.493 3.493 0 00-.17.13 4.387 4.387 0 01.022 1.028l-.398.123c.024-.18.042-.361.042-.547 0-.093-.006-.184-.013-.275-.208.237-.372.523-.372.84 0 .008-.604-.92.495-1.945l.007.436.634-.007c.057 0 .107.041.117.099a4.994 4.994 0 01.068 1.097l-.387.12zM18.062 12.091a.197.197 0 01-.034-.27c.063-.084.18-.099.26-.034a4.792 4.792 0 011.666 2.628l-.383.005a4.408 4.408 0 00-1.51-2.329z" />
                    <path d="M18.311 12.612c.412.414.724.9.936 1.43a2.146 2.146 0 00-.293.297 3.88 3.88 0 00-.907-1.449.198.198 0 01-.003-.275.186.186 0 01.267-.003zM19.01 18.072a4.41 4.41 0 00.621-1.346l-.218.081a4.221 4.221 0 01-.606 1.227l-.413-.077c.233-.294.425-.624.565-.98l-.244.091c-.14.31-.318.597-.53.85l-.431-.08c.17-.175.317-.372.444-.585l.25-.506a.627.627 0 01.378-.324l.59-.18.136-.041.196-.06.39-.119.208-.064-.128.393a.386.386 0 01-.16.206 4.771 4.771 0 01-.644 1.589l-.404-.075zM11.665 14.694l.008-.436c1.1 1.025.495 1.953.495 1.944 0-.316-.164-.602-.372-.84a3.481 3.481 0 00-.013.276c0 .186.017.368.042.547l-.398-.123a4.413 4.413 0 01.022-1.029 3.542 3.542 0 00-.17-.129 4.575 4.575 0 00-.045 1.098l-.387-.12a5.015 5.015 0 01.068-1.096c.01-.058.06-.1.117-.099l.633.007zM11.38 14.42l-.382-.005a4.792 4.792 0 011.665-2.628.181.181 0 01.26.034.197.197 0 01-.033.27 4.407 4.407 0 00-1.51 2.33z" />
                    <path d="M11.705 14.042a4.27 4.27 0 01.935-1.43.186.186 0 01.268.003c.073.077.072.2-.003.275-.413.415-.717.91-.907 1.45-.08-.1-.176-.2-.293-.298zM10.892 16.023l.39.12.197.059.136.042.59.18c.164.05.301.167.378.323l.249.506c.127.213.275.41.444.585l-.43.08a3.633 3.633 0 01-.53-.85l-.245-.091c.14.356.332.686.566.98l-.414.077a4.225 4.225 0 01-.606-1.227l-.218-.08c.132.486.344.94.622 1.345l-.405.075a4.772 4.772 0 01-.643-1.59.386.386 0 01-.16-.205l-.13-.393.21.064zM13.599 18.165l.01.009a3.05 3.05 0 001.906.679 3.05 3.05 0 001.907-.68l.01-.008a.287.287 0 01.275-.093l1.854.4-.412.373a.533.533 0 01-.392.138 4.649 4.649 0 01-1.13.858l.121.23a4.534 4.534 0 01-4.466 0l.12-.23a4.65 4.65 0 01-1.13-.858.533.533 0 01-.391-.138l-.412-.373 1.855-.4a.287.287 0 01.275.093zm3.853 1.34c.333-.18.639-.407.913-.668l-.178-.088c-.25.229-.524.429-.822.589l.087.167zm-4.787-.668c.275.261.58.488.913.668l.088-.167a4.076 4.076 0 01-.822-.59l-.179.09zm2.85.587c.876 0 1.679-.322 2.31-.854l-.183-.09a3.405 3.405 0 01-2.127.754c-.788 0-1.53-.278-2.127-.754l-.183.09a3.574 3.574 0 002.31.854z" />
                    <path d="M17.518 17.904c-.08.09-.162.177-.249.257h-3.586a3.487 3.487 0 01-.25-.257l.182-.243h3.722l.181.243z" />
                </g>
            </g>
        </svg>
    );
}

SvgAfghanistan.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgAfghanistan.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgAfghanistan;
