export const flightStatus = {
    request: {
        airline: {
            airline: { fs: 'AA', iata: 'AA', icao: 'AAL', name: 'American Airlines', active: true },
            requestedCode: 'AA',
        },
        flight: { requested: '2', interpreted: '2' },
        utc: { requested: 'false', interpreted: false },
        url:
            'https://api.flightstats.com/flex/flightstatus/rest/v2/json/flight/status/AA/2/arr/2021/2/7?extendedOptions=useInlinedReferences&utc=false',
        nonstopOnly: { interpreted: false },
        date: { year: '2021', month: '2', day: '7', interpreted: '2021-02-07' },
        extendedOptions: { requested: 'useInlinedReferences', interpreted: 'useInlinedReferences' },
    },
    flightStatuses: [
        {
            flightId: 1053849751,
            carrier: { fs: 'AA', iata: 'AA', icao: 'AAL', name: 'American Airlines', active: true },
            flightNumber: '2',
            departureAirport: {
                fs: 'LAX',
                iata: 'LAX',
                icao: 'KLAX',
                faa: 'LAX',
                name: 'Los Angeles International Airport',
                street1: 'One World Way',
                street2: '',
                city: 'Los Angeles',
                cityCode: 'LAX',
                stateCode: 'CA',
                postalCode: '90045-5803',
                countryCode: 'US',
                countryName: 'United States',
                regionName: 'North America',
                timeZoneRegionName: 'America/Los_Angeles',
                weatherZone: 'CAZ041',
                localTime: '2021-02-07T15:30:33.492',
                utcOffsetHours: -8,
                latitude: 33.943399,
                longitude: -118.408279,
                elevationFeet: 126,
                classification: 1,
                active: true,
                weatherUrl:
                    'https://api.flightstats.com/flex/weather/rest/v1/json/all/LAX?codeType=fs',
                delayIndexUrl:
                    'https://api.flightstats.com/flex/delayindex/rest/v1/json/airports/LAX?codeType=fs',
            },
            arrivalAirport: {
                fs: 'JFK',
                iata: 'JFK',
                icao: 'KJFK',
                faa: 'JFK',
                name: 'John F. Kennedy International Airport',
                street1: 'JFK Airport',
                city: 'New York',
                cityCode: 'NYC',
                stateCode: 'NY',
                postalCode: '11430',
                countryCode: 'US',
                countryName: 'United States',
                regionName: 'North America',
                timeZoneRegionName: 'America/New_York',
                weatherZone: 'NYZ178',
                localTime: '2021-02-07T18:30:33.492',
                utcOffsetHours: -5,
                latitude: 40.642335,
                longitude: -73.78817,
                elevationFeet: 13,
                classification: 1,
                active: true,
                weatherUrl:
                    'https://api.flightstats.com/flex/weather/rest/v1/json/all/JFK?codeType=fs',
                delayIndexUrl:
                    'https://api.flightstats.com/flex/delayindex/rest/v1/json/airports/JFK?codeType=fs',
            },
            departureDate: {
                dateUtc: '2021-02-07T16:30:00.000Z',
                dateLocal: '2021-02-07T08:30:00.000',
            },
            arrivalDate: {
                dateUtc: '2021-02-07T21:41:00.000Z',
                dateLocal: '2021-02-07T16:41:00.000',
            },
            status: 'L',
            schedule: {
                flightType: 'J',
                serviceClasses: 'RJY',
                restrictions: '',
                uplines: [],
                downlines: [],
            },
            operationalTimes: {
                publishedDeparture: {
                    dateUtc: '2021-02-07T16:30:00.000Z',
                    dateLocal: '2021-02-07T08:30:00.000',
                },
                scheduledGateDeparture: {
                    dateUtc: '2021-02-07T16:30:00.000Z',
                    dateLocal: '2021-02-07T08:30:00.000',
                },
                estimatedGateDeparture: {
                    dateUtc: '2021-02-07T16:24:00.000Z',
                    dateLocal: '2021-02-07T08:24:00.000',
                },
                actualGateDeparture: {
                    dateUtc: '2021-02-07T16:24:00.000Z',
                    dateLocal: '2021-02-07T08:24:00.000',
                },
                flightPlanPlannedDeparture: {
                    dateUtc: '2021-02-07T16:52:00.000Z',
                    dateLocal: '2021-02-07T08:52:00.000',
                },
                scheduledRunwayDeparture: {
                    dateUtc: '2021-02-07T16:52:00.000Z',
                    dateLocal: '2021-02-07T08:52:00.000',
                },
                estimatedRunwayDeparture: {
                    dateUtc: '2021-02-07T16:52:00.000Z',
                    dateLocal: '2021-02-07T08:52:00.000',
                },
                actualRunwayDeparture: {
                    dateUtc: '2021-02-07T16:52:00.000Z',
                    dateLocal: '2021-02-07T08:52:00.000',
                },
                publishedArrival: {
                    dateUtc: '2021-02-07T21:41:00.000Z',
                    dateLocal: '2021-02-07T16:41:00.000',
                },
                flightPlanPlannedArrival: {
                    dateUtc: '2021-02-07T21:27:00.000Z',
                    dateLocal: '2021-02-07T16:27:00.000',
                },
                scheduledGateArrival: {
                    dateUtc: '2021-02-07T21:41:00.000Z',
                    dateLocal: '2021-02-07T16:41:00.000',
                },
                estimatedGateArrival: {
                    dateUtc: '2021-02-07T21:38:00.000Z',
                    dateLocal: '2021-02-07T16:38:00.000',
                },
                actualGateArrival: {
                    dateUtc: '2021-02-07T21:38:00.000Z',
                    dateLocal: '2021-02-07T16:38:00.000',
                },
                scheduledRunwayArrival: {
                    dateUtc: '2021-02-07T21:27:00.000Z',
                    dateLocal: '2021-02-07T16:27:00.000',
                },
                estimatedRunwayArrival: {
                    dateUtc: '2021-02-07T21:19:00.000Z',
                    dateLocal: '2021-02-07T16:19:00.000',
                },
                actualRunwayArrival: {
                    dateUtc: '2021-02-07T21:19:00.000Z',
                    dateLocal: '2021-02-07T16:19:00.000',
                },
            },
            codeshares: [
                {
                    carrier: {
                        fs: 'BA',
                        iata: 'BA',
                        icao: 'BAW',
                        name: 'British Airways',
                        active: true,
                    },
                    flightNumber: '4311',
                    relationship: 'L',
                },
                {
                    carrier: { fs: 'GF', iata: 'GF', icao: 'GFA', name: 'Gulf Air', active: true },
                    flightNumber: '4103',
                    relationship: 'L',
                },
                {
                    carrier: { fs: 'QF', iata: 'QF', icao: 'QFA', name: 'Qantas', active: true },
                    flightNumber: '3095',
                    relationship: 'L',
                },
                {
                    carrier: {
                        fs: 'QR',
                        iata: 'QR',
                        icao: 'QTR',
                        name: 'Qatar Airways',
                        active: true,
                    },
                    flightNumber: '7947',
                    relationship: 'L',
                },
            ],
            delays: {},
            flightDurations: {
                scheduledBlockMinutes: 311,
                blockMinutes: 314,
                scheduledAirMinutes: 275,
                airMinutes: 267,
                scheduledTaxiOutMinutes: 22,
                taxiOutMinutes: 28,
                scheduledTaxiInMinutes: 14,
                taxiInMinutes: 19,
            },
            airportResources: {
                departureTerminal: '4',
                departureGate: '41',
                arrivalTerminal: '8',
                arrivalGate: '14',
                baggage: '7',
            },
            flightEquipment: {
                scheduledEquipment: {
                    iata: '772',
                    name: 'Boeing 777-200 / 200ER',
                    turboProp: false,
                    jet: true,
                    widebody: true,
                    regional: false,
                },
                actualEquipment: {
                    iata: '772',
                    name: 'Boeing 777-200 / 200ER',
                    turboProp: false,
                    jet: true,
                    widebody: true,
                    regional: false,
                },
                tailNumber: 'N774AN',
            },
        },
    ],
};

export const airlines = [
    { fs: 'AA', iata: 'AA', icao: 'AAL', name: 'American Airlines', active: true },
    { fs: 'AAB', icao: 'AAB', name: 'Abelag Aviation', active: true },
    { fs: 'ZI', icao: 'AAF', name: 'Aigle Azur', active: true },
    { fs: 'AAG', icao: 'AAG', name: 'Air Atlantique', active: true },
    { fs: 'KH', iata: 'KH', icao: 'AAH', name: 'Aloha Air Cargo', active: true },
    { fs: 'AAI', icao: 'AAI', name: 'Air Aurora', active: true },
    { fs: 'AA', iata: 'AA', icao: 'AAL', name: 'American Airlines', active: true },
    { fs: 'HB*', icao: 'AAQ', name: 'Asia Atlantic Airlines', active: true },
    { fs: 'OZ', iata: 'OZ', icao: 'AAR', name: 'Asiana Airlines', active: true },
    { fs: 'AAV', iata: '8Y', icao: 'AAV', name: 'Pan Pacific Airlines', active: true },
    { fs: '8U', iata: '8U', icao: 'AAW', name: 'Afriqiyah Airways', active: true },
    { fs: 'G4', iata: 'G4', icao: 'AAY', name: 'Allegiant Air', active: true },
    { fs: 'AAZ', icao: 'AAZ', name: 'Aeolus Air', active: true },
    { fs: 'ABB', iata: 'KF', icao: 'ABB', name: 'Air Belgium', active: true },
    { fs: 'CC', iata: 'CC', icao: 'ABD', name: 'Air Atlanta Icelandic', active: true },
    { fs: '4R*', iata: 'RL', icao: 'ABG', name: 'Royal Flight Airlines', active: true },
    { fs: 'BX', iata: 'BX', icao: 'ABL', name: 'Air Busan', active: true },
    { fs: 'ZB*', iata: 'ZB', icao: 'ABN', name: 'Air Albania', active: true },
    { fs: 'ABQ', iata: 'PA', icao: 'ABQ', name: 'Airblue', active: true },
    { fs: 'AG', icao: 'ABR', name: 'ASL Airlines Ireland', active: true },
    { fs: 'J7*', iata: 'J7', icao: 'ABS', name: 'Afrijet', active: true },
    { fs: 'ABT', icao: 'ABT', name: 'Air Taxi Benin', active: true },
    { fs: 'O4', icao: 'ABV', name: 'Antrak Air', active: true },
    { fs: 'RU', iata: 'RU', icao: 'ABW', name: 'AirBridgeCargo', active: true },
    { fs: 'GB', iata: 'GB', icao: 'ABX', name: 'ABX Air', active: true },
    { fs: 'G9', iata: 'G9', icao: 'ABY', name: 'Air Arabia', active: true },
    { fs: 'AC', iata: 'AC', icao: 'ACA', name: 'Air Canada', active: true },
    { fs: 'SB', iata: 'SB', icao: 'ACI', name: 'Aircalin', active: true },
    { fs: '3E', iata: '3E', icao: 'ACO', name: 'Air Choice One', active: true },
    { fs: 'ACP', iata: '8V', icao: 'ACP', name: 'Astral Aviation Limited', active: true },
    { fs: 'ACS', icao: 'ACS', name: 'ASSL', active: true },
    { fs: 'ACT', icao: 'ACT', name: 'Flight Line', active: true },
    { fs: '6U', icao: 'ACX', name: 'ACG', active: true },
    { fs: 'ADB', icao: 'ADB', name: 'Antonov Airlines', active: true },
    { fs: 'ADI', icao: 'ADI', name: 'Audeli Air Express', active: true },
    { fs: 'ADN', icao: 'ADN', name: 'Aero Dienst', active: true },
    { fs: 'HD', iata: 'HD', icao: 'ADO', name: 'Air Do', active: true },
    { fs: 'UX', iata: 'UX', icao: 'AEA', name: 'Air Europa', active: true },
    { fs: 'A3', iata: 'A3', icao: 'AEE', name: 'Aegean Airlines', active: true },
    { fs: 'AEG', icao: 'AEG', name: 'Airest', active: true },
    { fs: 'AEH', iata: 'NL', icao: 'AEH', name: 'Amelia International', active: true },
    { fs: 'A4', icao: 'AEK', name: 'Aerocon', active: true },
    { fs: 'AEP', icao: 'AEP', name: 'AEROTEC', active: true },
    { fs: 'KO', iata: 'KO', icao: 'AER', name: 'ACE Air Cargo', active: true },
    { fs: 'TD*', iata: 'TD', icao: 'AEU', name: 'Atlantis Armenian Airlines', active: true },
    { fs: 'AEY', icao: 'AEY', name: 'Air Italy S.p.A.', active: true },
    { fs: 'FG', iata: 'FG', icao: 'AFG', name: 'Ariana Afghan Airlines', active: true },
    { fs: 'SU', iata: 'SU', icao: 'AFL', name: 'Aeroflot', active: true },
    { fs: 'AF', iata: 'AF', icao: 'AFR', name: 'Air France', active: true },
    { fs: 'AFW', iata: 'AW', icao: 'AFW', name: 'Africa World Airlines', active: true },
    { fs: 'AGO', icao: 'AGO', name: 'Angola Air Charter', active: true },
    { fs: 'IK', iata: '2G', icao: 'AGU', name: 'Angara Airlines', active: true },
    { fs: '7T*', icao: 'AGV', name: 'Air Glaciers', active: true },
    { fs: 'AGY', icao: 'AGY', name: 'Air Go Egypt', active: true },
    { fs: 'AHC', icao: 'AHC', name: 'AZAL Avia Cargo', active: true },
    { fs: 'LD', iata: 'LD', icao: 'AHK', name: 'AHK Air Hong Kong Limited', active: true },
    { fs: 'AHO', icao: 'AHO', name: 'Air Hamburg', active: true },
    { fs: 'AHS', icao: 'AHS', name: 'AHS Air International', active: true },
    { fs: 'AHW', iata: 'S8', icao: 'AHW', name: 'Sky Air', active: true },
    { fs: 'AHX', iata: 'MZ', icao: 'AHX', name: 'Amakusa Air', active: true },
    { fs: 'J2', iata: 'J2', icao: 'AHY', name: 'AZAL Azerbaijan Airlines', active: true },
    { fs: 'AIA', icao: 'AIA', name: 'AMELIA', active: true },
    { fs: 'AIB', icao: 'AIB', name: 'Airbus Industrie', active: true },
    { fs: 'AI', iata: 'AI', icao: 'AIC', name: 'Air India', active: true },
    { fs: '3H', iata: '3H', icao: 'AIE', name: 'Air Inuit', active: true },
    { fs: 'KJ*', iata: 'KJ', icao: 'AIH', name: 'Air Incheon', active: true },
    { fs: '4O', icao: 'AIJ', name: 'Interjet', active: true },
    { fs: '5A', iata: '5A', icao: 'AIP', name: 'Alpine Air Express', active: true },
    { fs: 'FD', iata: 'FD', icao: 'AIQ', name: 'Thai AirAsia', active: true },
    { fs: 'IZ', iata: 'IZ', icao: 'AIZ', name: 'Arkia Israeli Airlines', active: true },
    { fs: 'HN', icao: 'AJA', name: 'Afghan Jet International', active: true },
    { fs: 'GT*', icao: 'AJD', name: 'Vista Georgia', active: true },
    { fs: 'AJI', iata: '7Z', icao: 'AJI', name: 'Ameristar Jet Charter', active: true },
    { fs: 'AJK', iata: '4W', icao: 'AJK', name: 'Allied Air', active: true },
    { fs: 'M6', iata: 'M6', icao: 'AJT', name: 'Amerijet International', active: true },
    { fs: 'AJU', icao: 'AJU', name: 'Air JetSul', active: true },
    { fs: 'NQ', iata: 'NQ', icao: 'AJX', name: 'Air Japan', active: true },
    { fs: 'KP*', icao: 'AKC', name: 'Asialink Cargo Express', active: true },
    { fs: 'AKK', icao: 'AKK', name: 'Sundt Air Management', active: true },
    { fs: '4A*', iata: 'IK', icao: 'AKL', name: 'Air Kiribati', active: true },
    { fs: 'EH', iata: 'EH', icao: 'AKX', name: 'ANA Wings', active: true },
    { fs: 'ALC', icao: 'ALC', name: 'Southern Jersey Airways', active: true },
    { fs: 'AL*', icao: 'ALD', name: 'Air Leisure', active: true },
    { fs: 'UL', iata: 'UL', icao: 'ALK', name: 'SriLankan Airlines', active: true },
    { fs: 'ALQ', icao: 'ALQ', name: 'Alanna Limited', active: true },
    { fs: 'ALS', icao: 'ALW', name: 'ALS', active: true },
    { fs: 'YZ*', icao: 'ALY', name: 'Alas Uruguay', active: true },
    { fs: 'AMB', iata: '1I', icao: 'AMB', name: 'Deutsche Rettungsflugwacht', active: true },
    { fs: 'KM', iata: 'KM', icao: 'AMC', name: 'Air Malta', active: true },
    { fs: 'AMF', icao: 'AMF', name: 'Ameriflight', active: true },
    { fs: 'QM', icao: 'AML', name: 'Air Malawi', active: true },
    { fs: '4A', iata: '4A', icao: 'AMP', name: 'ATSA Airlines', active: true },
    { fs: 'AMS', icao: 'AMS', name: 'ASTA', active: true },
    { fs: 'NX', iata: 'NX', icao: 'AMU', name: 'Air Macau', active: true },
    { fs: 'AMV', icao: 'AMV', name: 'AMC Airlines', active: true },
    { fs: '6A*', iata: '6A', icao: 'AMW', name: 'Armenia Airways', active: true },
    { fs: 'AM', iata: 'AM', icao: 'AMX', name: 'Aeromexico', active: true },
    { fs: '9K*', icao: 'AMZ', name: 'Amiyi Airlines', active: true },
    { fs: 'NH', iata: 'NH', icao: 'ANA', name: 'ANA', active: true },
    { fs: 'FP*', icao: 'AND', name: 'S.A.C.', active: true },
    { fs: 'YW', iata: 'YW', icao: 'ANE', name: 'Air Nostrum', active: true },
];
