import React from 'react';
import { BaseProps } from '../types';

const FolderOpen: React.FC<BaseProps> = (props: BaseProps) => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="26px"
            height="18px"
            viewBox="0 0 26 18"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace/functions-source-code/download"
                    transform="translate(-180.000000, -392.000000)"
                    fillRule="nonzero"
                >
                    <g id="folder-open" transform="translate(180.000000, 392.000000)">
                        <path
                            d="M22.5705597,3.37304348 L22.5705597,16.6392 C22.570844,16.7293155 22.5611841,16.8191947 22.5416348,16.9071652 L22.4555478,17.1942261 C22.2416828,17.6848884 21.7561419,18.0010316 21.2209043,17.9981417 L1.34953043,17.9981417 C0.726836017,17.9963931 0.185654571,17.5700625 0.0381913043,16.9650783 C0.0107762649,16.8586803 -0.00207142461,16.7490537 -0.000215820987,16.6392 L-0.000215820987,1.15826087 C-0.000583164067,0.850892582 0.121260264,0.555945447 0.338602855,0.338602855 C0.555945447,0.121260264 0.850892582,-0.000583164067 1.15826087,-2.08373685e-06 L7.06758261,-2.08373685e-06 C7.48025163,0.00143636034 7.86182484,0.219563105 8.07245217,0.574434783 L9.46987826,2.21353043 L21.4212522,2.21353043 C21.7274181,2.21485581 22.0205128,2.33777384 22.236036,2.55523443 C22.4515591,2.77269501 22.5718493,3.06687793 22.5705597,3.37304348 Z"
                            fill="#93DDFE"
                        />
                        <path
                            d="M24.4981565,5.38434783 C24.8695804,5.38434783 25.2189623,5.56062546 25.4396969,5.85934264 C25.6604315,6.15805982 25.7263307,6.54379558 25.617287,6.89885217 L22.5410087,16.9071652 L22.4549217,17.1942261 C22.2410567,17.6848884 21.7555158,18.0010316 21.2202783,17.9981417 L1.34953043,17.9981417 C0.726836017,17.9963931 0.185654571,17.5700625 0.0381913043,16.9650783 L3.26253913,6.21766957 C3.41133959,5.72333205 3.86636171,5.38479967 4.3826087,5.38434783 L24.4981565,5.38434783 Z"
                            fill="#67CAFB"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

FolderOpen.defaultProps = {
    className: undefined,
    style: undefined,
};

export default FolderOpen;
