import React from 'react';
import { BaseProps } from '../types';

const Enlarge: React.FC<BaseProps> = ({ className, style }: BaseProps) => {
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="18px"
            height="18px"
            viewBox="0 0 32 32"
        >
            <g id="developers" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g transform="translate(-568.000000, -931.000000)" fill="currentColor">
                    <path d="M598,959 C598,960.104 597.104,961 596,961 L572,961 C570.896,961 570,960.104 570,959 L570,935 C570,933.896 570.896,933 572,933 L596,933 C597.104,933 598,933.896 598,935 L598,959 L598,959 Z M596,931 L572,931 C569.791,931 568,932.791 568,935 L568,959 C568,961.209 569.791,963 572,963 L596,963 C598.209,963 600,961.209 600,959 L600,935 C600,932.791 598.209,931 596,931 L596,931 Z M594.972,935 L586,935 C585.447,935 585,935.447 585,936 C585,936.553 585.447,937 586,937 L592.629,937 L585.83,943.799 L587.244,945.213 L594.031,938.426 L594,945 C594,945.553 594.447,946 595,946 C595.553,946 596,945.553 596,945 L596,936 C596,935.704 595.878,935.465 595.685,935.301 C595.503,935.115 595.251,935 594.972,935 L594.972,935 Z M582,957 L575.371,957 L582.171,950.201 L580.756,948.787 L573.969,955.575 L574,949 C574,948.447 573.553,948 573,948 C572.447,948 572,948.447 572,949 L572,958 C572,958.297 572.122,958.535 572.315,958.699 C572.497,958.885 572.749,959 573.028,959 L582,959 C582.553,959 583,958.553 583,958 C583,957.447 582.553,957 582,957 L582,957 Z" />
                </g>
            </g>
        </svg>
    );
};

Enlarge.defaultProps = {
    style: {},
    className: undefined,
};

export default Enlarge;
