import React from 'react';
import { BaseProps } from '../types';

const Decrease: React.FC<BaseProps> = ({ className, style }: BaseProps) => {
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="18px"
            height="18px"
            viewBox="0 0 32 32"
        >
            <g id="developers" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g transform="translate(-100.000000, -983.000000)" fill="currentColor">
                    <path d="M130,1011 C130,1012.1 129.104,1013 128,1013 L104,1013 C102.896,1013 102,1012.1 102,1011 L102,987 C102,985.896 102.896,985 104,985 L128,985 C129.104,985 130,985.896 130,987 L130,1011 L130,1011 Z M128,983 L104,983 C101.791,983 100,984.791 100,987 L100,1011 C100,1013.21 101.791,1015 104,1015 L128,1015 C130.209,1015 132,1013.21 132,1011 L132,987 C132,984.791 130.209,983 128,983 L128,983 Z M127,996 L120.372,996 L127.17,989.201 L125.756,987.787 L118.969,994.575 L119,988 C119,987.447 118.552,987 118,987 C117.448,987 117,987.447 117,988 L117,997 C117,997.296 117.123,997.535 117.316,997.699 C117.497,997.885 117.749,998 118.028,998 L127,998 C127.552,998 128,997.553 128,997 C128,996.448 127.552,996 127,996 L127,996 Z M113.972,1000 L105,1000 C104.448,1000 104,1000.45 104,1001 C104,1001.55 104.448,1002 105,1002 L111.628,1002 L104.83,1008.8 L106.244,1010.21 L113.032,1003.43 L113,1010 C113,1010.55 113.448,1011 114,1011 C114.552,1011 115,1010.55 115,1010 L115,1001 C115,1000.7 114.877,1000.46 114.684,1000.3 C114.502,1000.12 114.251,1000 113.972,1000 L113.972,1000 Z" />
                </g>
            </g>
        </svg>
    );
};

Decrease.defaultProps = {
    style: {},
    className: undefined,
};

export default Decrease;
