import path from 'path';
import { screen } from '@testing-library/react';

describe('test-helpers', () => {
  describe('Should skip auto init test helpers', () => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let getPage: any;

    beforeAll(() => {
      process.env.NPT_SKIP_AUTO_SETUP = 'true';
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      const npt = require('../../../src');
      getPage = npt.getPage;
    });

    test('first', async () => {
      const { render } = await getPage({
        route: '/',
        nextRoot: path.join(__dirname, '__fixtures__'),
      });
      render();
      await screen.findByText('Index Page');
    });

    test('second', async () => {
      await screen.findByText('Index Page');
    });
  });
});
