// Copyright 2020 New Relic, Inc. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

// ------------------------------------------------------------------------------
//  <auto-generated>
//    Generated by Xsd2Code. Version 3.6.0.0
//    <NameSpace>NewRelic.Agent.Core.Config</NameSpace><Collection>List</Collection><codeType>CSharp</codeType><EnableDataBinding>False</EnableDataBinding><EnableLazyLoading>False</EnableLazyLoading><TrackingChangesEnable>False</TrackingChangesEnable><GenTrackingClasses>False</GenTrackingClasses><HidePrivateFieldInIDE>False</HidePrivateFieldInIDE><EnableSummaryComment>True</EnableSummaryComment><VirtualProp>False</VirtualProp><PascalCase>False</PascalCase><BaseClassName>EntityBase</BaseClassName><IncludeSerializeMethod>False</IncludeSerializeMethod><UseBaseClass>False</UseBaseClass><GenBaseClass>False</GenBaseClass><GenerateCloneMethod>True</GenerateCloneMethod><GenerateDataContracts>False</GenerateDataContracts><CodeBaseTag>Net20</CodeBaseTag><SerializeMethodName>Serialize</SerializeMethodName><DeserializeMethodName>Deserialize</DeserializeMethodName><SaveToFileMethodName>SaveToFile</SaveToFileMethodName><LoadFromFileMethodName>LoadFromFile</LoadFromFileMethodName><GenerateXMLAttributes>True</GenerateXMLAttributes><OrderXMLAttrib>False</OrderXMLAttrib><EnableEncoding>False</EnableEncoding><AutomaticProperties>False</AutomaticProperties><GenerateShouldSerialize>False</GenerateShouldSerialize><DisableDebug>False</DisableDebug><PropNameSpecified>Default</PropNameSpecified><Encoder>UTF8</Encoder><CustomUsings></CustomUsings><ExcludeIncludedTypes>False</ExcludeIncludedTypes><InitializeFields>All</InitializeFields><GenerateAllTypes>True</GenerateAllTypes>
//  </auto-generated>
// ------------------------------------------------------------------------------
namespace NewRelic.Agent.Core.Config
{
    using System;
    using System.Diagnostics;
    using System.Xml.Serialization;
    using System.Collections;
    using System.Xml.Schema;
    using System.ComponentModel;
    using System.Collections.Generic;
    
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace="urn:newrelic-config", IsNullable=false)]
    public partial class configuration
    {
        
        private configurationService serviceField;
        
        private configurationDiagnostics diagnosticsField;
        
        private configurationApplication applicationField;
        
        private string securityPoliciesTokenField;
        
        private configurationLog logField;
        
        private configurationInstrumentation instrumentationField;
        
        private configurationAllowAllHeaders allowAllHeadersField;
        
        private configurationAttributes attributesField;
        
        private configurationParameterGroups parameterGroupsField;
        
        private configurationRequestParameters requestParametersField;
        
        private configurationCustomParameters customParametersField;
        
        private configurationAnalyticsEvents analyticsEventsField;
        
        private configurationCustomEvents customEventsField;
        
        private configurationTransactionEvents transactionEventsField;
        
        private configurationDataTransmission dataTransmissionField;
        
        private configurationTransactionTracer transactionTracerField;
        
        private configurationDatastoreTracer datastoreTracerField;
        
        private configurationCrossApplicationTracer crossApplicationTracerField;
        
        private configurationInfiniteTracing infiniteTracingField;
        
        private configurationDistributedTracing distributedTracingField;
        
        private configurationSpanEvents spanEventsField;
        
        private configurationHighSecurity highSecurityField;
        
        private configurationCustomInstrumentationEditor customInstrumentationEditorField;
        
        private configurationStripExceptionMessages stripExceptionMessagesField;
        
        private configurationSlowSql slowSqlField;
        
        private configurationErrorCollector errorCollectorField;
        
        private configurationBrowserMonitoring browserMonitoringField;
        
        private configurationApplicationPools applicationPoolsField;
        
        private configurationAiMonitoring aiMonitoringField;
        
        private configurationApplicationLogging applicationLoggingField;
        
        private List<string> threadProfilingField;
        
        private string labelsField;
        
        private List<configurationAdd> appSettingsField;
        
        private configurationUtilization utilizationField;
        
        private configurationProcessHost processHostField;
        
        private configurationCodeLevelMetrics codeLevelMetricsField;
        
        private configurationCloud cloudField;
        
        private bool agentEnabledField;
        
        private bool rootAgentEnabledField;
        
        private int maxStackTraceLinesField;
        
        private bool debugAgentField;
        
        private int debugStartupDelaySecondsField;
        
        private bool threadProfilingEnabledField;
        
        private bool crossApplicationTracingEnabledField;
        
        private configurationTimingPrecision timingPrecisionField;
        
        private bool serverlessModeEnabledField;
        
        /// <summary>
        /// configuration class constructor
        /// </summary>
        public configuration()
        {
            this.cloudField = new configurationCloud();
            this.codeLevelMetricsField = new configurationCodeLevelMetrics();
            this.processHostField = new configurationProcessHost();
            this.utilizationField = new configurationUtilization();
            this.appSettingsField = new List<configurationAdd>();
            this.threadProfilingField = new List<string>();
            this.applicationLoggingField = new configurationApplicationLogging();
            this.aiMonitoringField = new configurationAiMonitoring();
            this.applicationPoolsField = new configurationApplicationPools();
            this.browserMonitoringField = new configurationBrowserMonitoring();
            this.errorCollectorField = new configurationErrorCollector();
            this.slowSqlField = new configurationSlowSql();
            this.stripExceptionMessagesField = new configurationStripExceptionMessages();
            this.customInstrumentationEditorField = new configurationCustomInstrumentationEditor();
            this.highSecurityField = new configurationHighSecurity();
            this.spanEventsField = new configurationSpanEvents();
            this.distributedTracingField = new configurationDistributedTracing();
            this.infiniteTracingField = new configurationInfiniteTracing();
            this.crossApplicationTracerField = new configurationCrossApplicationTracer();
            this.datastoreTracerField = new configurationDatastoreTracer();
            this.transactionTracerField = new configurationTransactionTracer();
            this.dataTransmissionField = new configurationDataTransmission();
            this.transactionEventsField = new configurationTransactionEvents();
            this.customEventsField = new configurationCustomEvents();
            this.analyticsEventsField = new configurationAnalyticsEvents();
            this.customParametersField = new configurationCustomParameters();
            this.requestParametersField = new configurationRequestParameters();
            this.parameterGroupsField = new configurationParameterGroups();
            this.attributesField = new configurationAttributes();
            this.allowAllHeadersField = new configurationAllowAllHeaders();
            this.instrumentationField = new configurationInstrumentation();
            this.logField = new configurationLog();
            this.applicationField = new configurationApplication();
            this.diagnosticsField = new configurationDiagnostics();
            this.serviceField = new configurationService();
            this.agentEnabledField = true;
            this.rootAgentEnabledField = false;
            this.maxStackTraceLinesField = 80;
            this.debugAgentField = false;
            this.debugStartupDelaySecondsField = 0;
            this.threadProfilingEnabledField = true;
            this.crossApplicationTracingEnabledField = true;
            this.timingPrecisionField = configurationTimingPrecision.low;
            this.serverlessModeEnabledField = false;
        }
        
        public configurationService service
        {
            get
            {
                return this.serviceField;
            }
            set
            {
                this.serviceField = value;
            }
        }
        
        public configurationDiagnostics diagnostics
        {
            get
            {
                return this.diagnosticsField;
            }
            set
            {
                this.diagnosticsField = value;
            }
        }
        
        public configurationApplication application
        {
            get
            {
                return this.applicationField;
            }
            set
            {
                this.applicationField = value;
            }
        }
        
        public string securityPoliciesToken
        {
            get
            {
                return this.securityPoliciesTokenField;
            }
            set
            {
                this.securityPoliciesTokenField = value;
            }
        }
        
        public configurationLog log
        {
            get
            {
                return this.logField;
            }
            set
            {
                this.logField = value;
            }
        }
        
        public configurationInstrumentation instrumentation
        {
            get
            {
                return this.instrumentationField;
            }
            set
            {
                this.instrumentationField = value;
            }
        }
        
        public configurationAllowAllHeaders allowAllHeaders
        {
            get
            {
                return this.allowAllHeadersField;
            }
            set
            {
                this.allowAllHeadersField = value;
            }
        }
        
        public configurationAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        public configurationParameterGroups parameterGroups
        {
            get
            {
                return this.parameterGroupsField;
            }
            set
            {
                this.parameterGroupsField = value;
            }
        }
        
        public configurationRequestParameters requestParameters
        {
            get
            {
                return this.requestParametersField;
            }
            set
            {
                this.requestParametersField = value;
            }
        }
        
        public configurationCustomParameters customParameters
        {
            get
            {
                return this.customParametersField;
            }
            set
            {
                this.customParametersField = value;
            }
        }
        
        public configurationAnalyticsEvents analyticsEvents
        {
            get
            {
                return this.analyticsEventsField;
            }
            set
            {
                this.analyticsEventsField = value;
            }
        }
        
        public configurationCustomEvents customEvents
        {
            get
            {
                return this.customEventsField;
            }
            set
            {
                this.customEventsField = value;
            }
        }
        
        public configurationTransactionEvents transactionEvents
        {
            get
            {
                return this.transactionEventsField;
            }
            set
            {
                this.transactionEventsField = value;
            }
        }
        
        public configurationDataTransmission dataTransmission
        {
            get
            {
                return this.dataTransmissionField;
            }
            set
            {
                this.dataTransmissionField = value;
            }
        }
        
        public configurationTransactionTracer transactionTracer
        {
            get
            {
                return this.transactionTracerField;
            }
            set
            {
                this.transactionTracerField = value;
            }
        }
        
        public configurationDatastoreTracer datastoreTracer
        {
            get
            {
                return this.datastoreTracerField;
            }
            set
            {
                this.datastoreTracerField = value;
            }
        }
        
        public configurationCrossApplicationTracer crossApplicationTracer
        {
            get
            {
                return this.crossApplicationTracerField;
            }
            set
            {
                this.crossApplicationTracerField = value;
            }
        }
        
        public configurationInfiniteTracing infiniteTracing
        {
            get
            {
                return this.infiniteTracingField;
            }
            set
            {
                this.infiniteTracingField = value;
            }
        }
        
        public configurationDistributedTracing distributedTracing
        {
            get
            {
                return this.distributedTracingField;
            }
            set
            {
                this.distributedTracingField = value;
            }
        }
        
        public configurationSpanEvents spanEvents
        {
            get
            {
                return this.spanEventsField;
            }
            set
            {
                this.spanEventsField = value;
            }
        }
        
        public configurationHighSecurity highSecurity
        {
            get
            {
                return this.highSecurityField;
            }
            set
            {
                this.highSecurityField = value;
            }
        }
        
        public configurationCustomInstrumentationEditor customInstrumentationEditor
        {
            get
            {
                return this.customInstrumentationEditorField;
            }
            set
            {
                this.customInstrumentationEditorField = value;
            }
        }
        
        public configurationStripExceptionMessages stripExceptionMessages
        {
            get
            {
                return this.stripExceptionMessagesField;
            }
            set
            {
                this.stripExceptionMessagesField = value;
            }
        }
        
        public configurationSlowSql slowSql
        {
            get
            {
                return this.slowSqlField;
            }
            set
            {
                this.slowSqlField = value;
            }
        }
        
        public configurationErrorCollector errorCollector
        {
            get
            {
                return this.errorCollectorField;
            }
            set
            {
                this.errorCollectorField = value;
            }
        }
        
        public configurationBrowserMonitoring browserMonitoring
        {
            get
            {
                return this.browserMonitoringField;
            }
            set
            {
                this.browserMonitoringField = value;
            }
        }
        
        public configurationApplicationPools applicationPools
        {
            get
            {
                return this.applicationPoolsField;
            }
            set
            {
                this.applicationPoolsField = value;
            }
        }
        
        public configurationAiMonitoring aiMonitoring
        {
            get
            {
                return this.aiMonitoringField;
            }
            set
            {
                this.aiMonitoringField = value;
            }
        }
        
        public configurationApplicationLogging applicationLogging
        {
            get
            {
                return this.applicationLoggingField;
            }
            set
            {
                this.applicationLoggingField = value;
            }
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("ignoreMethod", IsNullable=false)]
        public List<string> threadProfiling
        {
            get
            {
                return this.threadProfilingField;
            }
            set
            {
                this.threadProfilingField = value;
            }
        }
        
        public string labels
        {
            get
            {
                return this.labelsField;
            }
            set
            {
                this.labelsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("add", IsNullable=false)]
        public List<configurationAdd> appSettings
        {
            get
            {
                return this.appSettingsField;
            }
            set
            {
                this.appSettingsField = value;
            }
        }
        
        public configurationUtilization utilization
        {
            get
            {
                return this.utilizationField;
            }
            set
            {
                this.utilizationField = value;
            }
        }
        
        public configurationProcessHost processHost
        {
            get
            {
                return this.processHostField;
            }
            set
            {
                this.processHostField = value;
            }
        }
        
        public configurationCodeLevelMetrics codeLevelMetrics
        {
            get
            {
                return this.codeLevelMetricsField;
            }
            set
            {
                this.codeLevelMetricsField = value;
            }
        }
        
        public configurationCloud cloud
        {
            get
            {
                return this.cloudField;
            }
            set
            {
                this.cloudField = value;
            }
        }
        
        /// <summary>
        /// Set this to true to enable the agent.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool agentEnabled
        {
            get
            {
                return this.agentEnabledField;
            }
            set
            {
                this.agentEnabledField = value;
            }
        }
        
        /// <summary>
        /// Turns on profiling for the root w3wp process. (Experimental.)
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool rootAgentEnabled
        {
            get
            {
                return this.rootAgentEnabledField;
            }
            set
            {
                this.rootAgentEnabledField = value;
            }
        }
        
        /// <summary>
        /// The maximum number of stack frames to trace in any stack dump.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(80)]
        public int maxStackTraceLines
        {
            get
            {
                return this.maxStackTraceLinesField;
            }
            set
            {
                this.maxStackTraceLinesField = value;
            }
        }
        
        /// <summary>
        /// Turns on additional agent debugging.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool debugAgent
        {
            get
            {
                return this.debugAgentField;
            }
            set
            {
                this.debugAgentField = value;
            }
        }
        
        /// <summary>
        /// Delays Agent initialization to allow a debugger to be attached.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int debugStartupDelaySeconds
        {
            get
            {
                return this.debugStartupDelaySecondsField;
            }
            set
            {
                this.debugStartupDelaySecondsField = value;
            }
        }
        
        /// <summary>
        /// Turns on/off Thread Profiling.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool threadProfilingEnabled
        {
            get
            {
                return this.threadProfilingEnabledField;
            }
            set
            {
                this.threadProfilingEnabledField = value;
            }
        }
        
        /// <summary>
        /// Turns on/off Cross application agent metric gathering.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool crossApplicationTracingEnabled
        {
            get
            {
                return this.crossApplicationTracingEnabledField;
            }
            set
            {
                this.crossApplicationTracingEnabledField = value;
            }
        }
        
        /// <summary>
        /// Controls the precision of the timers, with a trade-off in execution speed.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(configurationTimingPrecision.low)]
        public configurationTimingPrecision timingPrecision
        {
            get
            {
                return this.timingPrecisionField;
            }
            set
            {
                this.timingPrecisionField = value;
            }
        }
        
        /// <summary>
        /// Turns on/off serverless mode.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool serverlessModeEnabled
        {
            get
            {
                return this.serverlessModeEnabledField;
            }
            set
            {
                this.serverlessModeEnabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configuration object
        /// </summary>
        public virtual configuration Clone()
        {
            return ((configuration)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationService
    {
        
        private string obscuringKeyField;
        
        private configurationServiceProxy proxyField;
        
        private bool sendEnvironmentInfoField;
        
        private string licenseKeyField;
        
        private string hostField;
        
        private System.Nullable<int> portField;
        
        private bool syncStartupField;
        
        private bool autoStartField;
        
        private bool sendDataOnExitField;
        
        private float sendDataOnExitThresholdField;
        
        private System.Nullable<int> requestTimeoutField;
        
        private bool completeTransactionsOnThreadField;
        
        private bool forceNewTransactionOnNewThreadField;
        
        private bool disableFileSystemWatcherField;
        
        /// <summary>
        /// configurationService class constructor
        /// </summary>
        public configurationService()
        {
            this.proxyField = new configurationServiceProxy();
            this.sendEnvironmentInfoField = true;
            this.syncStartupField = false;
            this.autoStartField = true;
            this.sendDataOnExitField = false;
            this.sendDataOnExitThresholdField = ((float)(60000F));
            this.completeTransactionsOnThreadField = false;
            this.forceNewTransactionOnNewThreadField = false;
            this.disableFileSystemWatcherField = false;
        }
        
        public string obscuringKey
        {
            get
            {
                return this.obscuringKeyField;
            }
            set
            {
                this.obscuringKeyField = value;
            }
        }
        
        public configurationServiceProxy proxy
        {
            get
            {
                return this.proxyField;
            }
            set
            {
                this.proxyField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool sendEnvironmentInfo
        {
            get
            {
                return this.sendEnvironmentInfoField;
            }
            set
            {
                this.sendEnvironmentInfoField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string licenseKey
        {
            get
            {
                return this.licenseKeyField;
            }
            set
            {
                this.licenseKeyField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string host
        {
            get
            {
                return this.hostField;
            }
            set
            {
                this.hostField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int port
        {
            get
            {
                if (this.portField.HasValue)
                {
                    return this.portField.Value;
                }
                else
                {
                    return default(int);
                }
            }
            set
            {
                this.portField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool portSpecified
        {
            get
            {
                return this.portField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.portField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool syncStartup
        {
            get
            {
                return this.syncStartupField;
            }
            set
            {
                this.syncStartupField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool autoStart
        {
            get
            {
                return this.autoStartField;
            }
            set
            {
                this.autoStartField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool sendDataOnExit
        {
            get
            {
                return this.sendDataOnExitField;
            }
            set
            {
                this.sendDataOnExitField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(typeof(float), "60000")]
        public float sendDataOnExitThreshold
        {
            get
            {
                return this.sendDataOnExitThresholdField;
            }
            set
            {
                this.sendDataOnExitThresholdField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int requestTimeout
        {
            get
            {
                if (this.requestTimeoutField.HasValue)
                {
                    return this.requestTimeoutField.Value;
                }
                else
                {
                    return default(int);
                }
            }
            set
            {
                this.requestTimeoutField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool requestTimeoutSpecified
        {
            get
            {
                return this.requestTimeoutField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.requestTimeoutField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool completeTransactionsOnThread
        {
            get
            {
                return this.completeTransactionsOnThreadField;
            }
            set
            {
                this.completeTransactionsOnThreadField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool forceNewTransactionOnNewThread
        {
            get
            {
                return this.forceNewTransactionOnNewThreadField;
            }
            set
            {
                this.forceNewTransactionOnNewThreadField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool disableFileSystemWatcher
        {
            get
            {
                return this.disableFileSystemWatcherField;
            }
            set
            {
                this.disableFileSystemWatcherField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationService object
        /// </summary>
        public virtual configurationService Clone()
        {
            return ((configurationService)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationServiceProxy
    {
        
        private string hostField;
        
        private string uriPathField;
        
        private int portField;
        
        private string userField;
        
        private string passwordField;
        
        private string passwordObfuscatedField;
        
        private string domainField;
        
        /// <summary>
        /// configurationServiceProxy class constructor
        /// </summary>
        public configurationServiceProxy()
        {
            this.portField = 8080;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string host
        {
            get
            {
                return this.hostField;
            }
            set
            {
                this.hostField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string uriPath
        {
            get
            {
                return this.uriPathField;
            }
            set
            {
                this.uriPathField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(8080)]
        public int port
        {
            get
            {
                return this.portField;
            }
            set
            {
                this.portField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string user
        {
            get
            {
                return this.userField;
            }
            set
            {
                this.userField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string password
        {
            get
            {
                return this.passwordField;
            }
            set
            {
                this.passwordField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string passwordObfuscated
        {
            get
            {
                return this.passwordObfuscatedField;
            }
            set
            {
                this.passwordObfuscatedField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string domain
        {
            get
            {
                return this.domainField;
            }
            set
            {
                this.domainField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationServiceProxy object
        /// </summary>
        public virtual configurationServiceProxy Clone()
        {
            return ((configurationServiceProxy)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    /// <summary>
    /// A list of fully qualified error class names to be marked as ignored/expected.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace="urn:newrelic-config")]
    public partial class ErrorClassCollection
    {
        
        private List<string> errorClassField;
        
        /// <summary>
        /// ErrorClassCollection class constructor
        /// </summary>
        public ErrorClassCollection()
        {
            this.errorClassField = new List<string>();
        }
        
        /// <summary>
        /// Fully qualified class name of an exception, such as "System.IO.FileNotFoundException".
        /// </summary>
        [System.Xml.Serialization.XmlElementAttribute("errorClass")]
        public List<string> errorClass
        {
            get
            {
                return this.errorClassField;
            }
            set
            {
                this.errorClassField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this ErrorClassCollection object
        /// </summary>
        public virtual ErrorClassCollection Clone()
        {
            return ((ErrorClassCollection)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDiagnostics
    {
        
        private bool captureAgentTimingField;
        
        private int captureAgentTimingFrequencyField;
        
        /// <summary>
        /// configurationDiagnostics class constructor
        /// </summary>
        public configurationDiagnostics()
        {
            this.captureAgentTimingField = false;
            this.captureAgentTimingFrequencyField = 1;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool captureAgentTiming
        {
            get
            {
                return this.captureAgentTimingField;
            }
            set
            {
                this.captureAgentTimingField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(1)]
        public int captureAgentTimingFrequency
        {
            get
            {
                return this.captureAgentTimingFrequencyField;
            }
            set
            {
                this.captureAgentTimingFrequencyField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDiagnostics object
        /// </summary>
        public virtual configurationDiagnostics Clone()
        {
            return ((configurationDiagnostics)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplication
    {
        
        private List<string> nameField;
        
        private bool disableSamplersField;
        
        /// <summary>
        /// configurationApplication class constructor
        /// </summary>
        public configurationApplication()
        {
            this.nameField = new List<string>();
            this.disableSamplersField = false;
        }
        
        [System.Xml.Serialization.XmlElementAttribute("name")]
        public List<string> name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool disableSamplers
        {
            get
            {
                return this.disableSamplersField;
            }
            set
            {
                this.disableSamplersField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplication object
        /// </summary>
        public virtual configurationApplication Clone()
        {
            return ((configurationApplication)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationLog
    {
        
        private string levelField;
        
        private bool enabledField;
        
        private string directoryField;
        
        private string fileNameField;
        
        private bool consoleField;
        
        private bool auditLogField;
        
        private configurationLogLogRollingStrategy logRollingStrategyField;
        
        private int maxLogFileSizeMBField;
        
        private int maxLogFilesField;
        
        /// <summary>
        /// configurationLog class constructor
        /// </summary>
        public configurationLog()
        {
            this.levelField = "info";
            this.enabledField = true;
            this.consoleField = false;
            this.auditLogField = false;
            this.logRollingStrategyField = configurationLogLogRollingStrategy.size;
            this.maxLogFileSizeMBField = 50;
            this.maxLogFilesField = 4;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("info")]
        public string level
        {
            get
            {
                return this.levelField;
            }
            set
            {
                this.levelField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string directory
        {
            get
            {
                return this.directoryField;
            }
            set
            {
                this.directoryField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string fileName
        {
            get
            {
                return this.fileNameField;
            }
            set
            {
                this.fileNameField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool console
        {
            get
            {
                return this.consoleField;
            }
            set
            {
                this.consoleField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool auditLog
        {
            get
            {
                return this.auditLogField;
            }
            set
            {
                this.auditLogField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(configurationLogLogRollingStrategy.size)]
        public configurationLogLogRollingStrategy logRollingStrategy
        {
            get
            {
                return this.logRollingStrategyField;
            }
            set
            {
                this.logRollingStrategyField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(50)]
        public int maxLogFileSizeMB
        {
            get
            {
                return this.maxLogFileSizeMBField;
            }
            set
            {
                this.maxLogFileSizeMBField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(4)]
        public int maxLogFiles
        {
            get
            {
                return this.maxLogFilesField;
            }
            set
            {
                this.maxLogFilesField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationLog object
        /// </summary>
        public virtual configurationLog Clone()
        {
            return ((configurationLog)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public enum configurationLogLogRollingStrategy
    {
        
        /// <remarks/>
        size,
        
        /// <remarks/>
        day,
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInstrumentation
    {
        
        private List<configurationInstrumentationIgnore> rulesField;
        
        private List<configurationInstrumentationApplication> applicationsField;
        
        private bool logField;
        
        /// <summary>
        /// configurationInstrumentation class constructor
        /// </summary>
        public configurationInstrumentation()
        {
            this.applicationsField = new List<configurationInstrumentationApplication>();
            this.rulesField = new List<configurationInstrumentationIgnore>();
            this.logField = false;
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("ignore", IsNullable=false)]
        public List<configurationInstrumentationIgnore> rules
        {
            get
            {
                return this.rulesField;
            }
            set
            {
                this.rulesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("application", IsNullable=false)]
        public List<configurationInstrumentationApplication> applications
        {
            get
            {
                return this.applicationsField;
            }
            set
            {
                this.applicationsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool log
        {
            get
            {
                return this.logField;
            }
            set
            {
                this.logField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInstrumentation object
        /// </summary>
        public virtual configurationInstrumentation Clone()
        {
            return ((configurationInstrumentation)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInstrumentationIgnore
    {
        
        private string assemblyNameField;
        
        private string classNameField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string assemblyName
        {
            get
            {
                return this.assemblyNameField;
            }
            set
            {
                this.assemblyNameField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string className
        {
            get
            {
                return this.classNameField;
            }
            set
            {
                this.classNameField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInstrumentationIgnore object
        /// </summary>
        public virtual configurationInstrumentationIgnore Clone()
        {
            return ((configurationInstrumentationIgnore)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInstrumentationApplication
    {
        
        private string nameField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInstrumentationApplication object
        /// </summary>
        public virtual configurationInstrumentationApplication Clone()
        {
            return ((configurationInstrumentationApplication)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAllowAllHeaders
    {
        
        private System.Nullable<bool> enabledField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAllowAllHeaders object
        /// </summary>
        public virtual configurationAllowAllHeaders Clone()
        {
            return ((configurationAllowAllHeaders)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationAttributes class constructor
        /// </summary>
        public configurationAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAttributes object
        /// </summary>
        public virtual configurationAttributes Clone()
        {
            return ((configurationAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationParameterGroups
    {
        
        private configurationParameterGroupsIdentityParameters identityParametersField;
        
        private configurationParameterGroupsResponseHeaderParameters responseHeaderParametersField;
        
        private configurationParameterGroupsCustomParameters customParametersField;
        
        private configurationParameterGroupsRequestHeaderParameters requestHeaderParametersField;
        
        /// <summary>
        /// configurationParameterGroups class constructor
        /// </summary>
        public configurationParameterGroups()
        {
            this.requestHeaderParametersField = new configurationParameterGroupsRequestHeaderParameters();
            this.customParametersField = new configurationParameterGroupsCustomParameters();
            this.responseHeaderParametersField = new configurationParameterGroupsResponseHeaderParameters();
            this.identityParametersField = new configurationParameterGroupsIdentityParameters();
        }
        
        public configurationParameterGroupsIdentityParameters identityParameters
        {
            get
            {
                return this.identityParametersField;
            }
            set
            {
                this.identityParametersField = value;
            }
        }
        
        public configurationParameterGroupsResponseHeaderParameters responseHeaderParameters
        {
            get
            {
                return this.responseHeaderParametersField;
            }
            set
            {
                this.responseHeaderParametersField = value;
            }
        }
        
        public configurationParameterGroupsCustomParameters customParameters
        {
            get
            {
                return this.customParametersField;
            }
            set
            {
                this.customParametersField = value;
            }
        }
        
        public configurationParameterGroupsRequestHeaderParameters requestHeaderParameters
        {
            get
            {
                return this.requestHeaderParametersField;
            }
            set
            {
                this.requestHeaderParametersField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationParameterGroups object
        /// </summary>
        public virtual configurationParameterGroups Clone()
        {
            return ((configurationParameterGroups)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationParameterGroupsIdentityParameters
    {
        
        private List<string> ignoreField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationParameterGroupsIdentityParameters class constructor
        /// </summary>
        public configurationParameterGroupsIdentityParameters()
        {
            this.ignoreField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("ignore")]
        public List<string> ignore
        {
            get
            {
                return this.ignoreField;
            }
            set
            {
                this.ignoreField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationParameterGroupsIdentityParameters object
        /// </summary>
        public virtual configurationParameterGroupsIdentityParameters Clone()
        {
            return ((configurationParameterGroupsIdentityParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationParameterGroupsResponseHeaderParameters
    {
        
        private List<string> ignoreField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationParameterGroupsResponseHeaderParameters class constructor
        /// </summary>
        public configurationParameterGroupsResponseHeaderParameters()
        {
            this.ignoreField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("ignore")]
        public List<string> ignore
        {
            get
            {
                return this.ignoreField;
            }
            set
            {
                this.ignoreField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationParameterGroupsResponseHeaderParameters object
        /// </summary>
        public virtual configurationParameterGroupsResponseHeaderParameters Clone()
        {
            return ((configurationParameterGroupsResponseHeaderParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationParameterGroupsCustomParameters
    {
        
        private List<string> ignoreField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationParameterGroupsCustomParameters class constructor
        /// </summary>
        public configurationParameterGroupsCustomParameters()
        {
            this.ignoreField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("ignore")]
        public List<string> ignore
        {
            get
            {
                return this.ignoreField;
            }
            set
            {
                this.ignoreField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationParameterGroupsCustomParameters object
        /// </summary>
        public virtual configurationParameterGroupsCustomParameters Clone()
        {
            return ((configurationParameterGroupsCustomParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationParameterGroupsRequestHeaderParameters
    {
        
        private List<string> ignoreField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationParameterGroupsRequestHeaderParameters class constructor
        /// </summary>
        public configurationParameterGroupsRequestHeaderParameters()
        {
            this.ignoreField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("ignore")]
        public List<string> ignore
        {
            get
            {
                return this.ignoreField;
            }
            set
            {
                this.ignoreField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationParameterGroupsRequestHeaderParameters object
        /// </summary>
        public virtual configurationParameterGroupsRequestHeaderParameters Clone()
        {
            return ((configurationParameterGroupsRequestHeaderParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationRequestParameters
    {
        
        private List<string> ignoreField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationRequestParameters class constructor
        /// </summary>
        public configurationRequestParameters()
        {
            this.ignoreField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("ignore")]
        public List<string> ignore
        {
            get
            {
                return this.ignoreField;
            }
            set
            {
                this.ignoreField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationRequestParameters object
        /// </summary>
        public virtual configurationRequestParameters Clone()
        {
            return ((configurationRequestParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCustomParameters
    {
        
        private System.Nullable<bool> enabledField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCustomParameters object
        /// </summary>
        public virtual configurationCustomParameters Clone()
        {
            return ((configurationCustomParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAnalyticsEvents
    {
        
        private configurationAnalyticsEventsTransactions transactionsField;
        
        private System.Nullable<bool> enabledField;
        
        private System.Nullable<uint> maximumSamplesPerMinuteField;
        
        private System.Nullable<int> maximumSamplesStoredField;
        
        private System.Nullable<bool> captureAttributesField;
        
        /// <summary>
        /// configurationAnalyticsEvents class constructor
        /// </summary>
        public configurationAnalyticsEvents()
        {
            this.transactionsField = new configurationAnalyticsEventsTransactions();
        }
        
        public configurationAnalyticsEventsTransactions transactions
        {
            get
            {
                return this.transactionsField;
            }
            set
            {
                this.transactionsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public uint maximumSamplesPerMinute
        {
            get
            {
                if (this.maximumSamplesPerMinuteField.HasValue)
                {
                    return this.maximumSamplesPerMinuteField.Value;
                }
                else
                {
                    return default(uint);
                }
            }
            set
            {
                this.maximumSamplesPerMinuteField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool maximumSamplesPerMinuteSpecified
        {
            get
            {
                return this.maximumSamplesPerMinuteField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.maximumSamplesPerMinuteField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int maximumSamplesStored
        {
            get
            {
                if (this.maximumSamplesStoredField.HasValue)
                {
                    return this.maximumSamplesStoredField.Value;
                }
                else
                {
                    return default(int);
                }
            }
            set
            {
                this.maximumSamplesStoredField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool maximumSamplesStoredSpecified
        {
            get
            {
                return this.maximumSamplesStoredField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.maximumSamplesStoredField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool captureAttributes
        {
            get
            {
                if (this.captureAttributesField.HasValue)
                {
                    return this.captureAttributesField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.captureAttributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool captureAttributesSpecified
        {
            get
            {
                return this.captureAttributesField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.captureAttributesField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAnalyticsEvents object
        /// </summary>
        public virtual configurationAnalyticsEvents Clone()
        {
            return ((configurationAnalyticsEvents)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAnalyticsEventsTransactions
    {
        
        private System.Nullable<bool> enabledField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAnalyticsEventsTransactions object
        /// </summary>
        public virtual configurationAnalyticsEventsTransactions Clone()
        {
            return ((configurationAnalyticsEventsTransactions)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCustomEvents
    {
        
        private configurationCustomEventsAttributes attributesField;
        
        private bool enabledField;
        
        private int maximumSamplesStoredField;
        
        /// <summary>
        /// configurationCustomEvents class constructor
        /// </summary>
        public configurationCustomEvents()
        {
            this.attributesField = new configurationCustomEventsAttributes();
            this.enabledField = true;
            this.maximumSamplesStoredField = 30000;
        }
        
        public configurationCustomEventsAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(30000)]
        public int maximumSamplesStored
        {
            get
            {
                return this.maximumSamplesStoredField;
            }
            set
            {
                this.maximumSamplesStoredField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCustomEvents object
        /// </summary>
        public virtual configurationCustomEvents Clone()
        {
            return ((configurationCustomEvents)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCustomEventsAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationCustomEventsAttributes class constructor
        /// </summary>
        public configurationCustomEventsAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCustomEventsAttributes object
        /// </summary>
        public virtual configurationCustomEventsAttributes Clone()
        {
            return ((configurationCustomEventsAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationTransactionEvents
    {
        
        private configurationTransactionEventsTransactions transactionsField;
        
        private configurationTransactionEventsAttributes attributesField;
        
        private bool enabledField;
        
        private System.Nullable<uint> maximumSamplesPerMinuteField;
        
        private int maximumSamplesStoredField;
        
        /// <summary>
        /// configurationTransactionEvents class constructor
        /// </summary>
        public configurationTransactionEvents()
        {
            this.attributesField = new configurationTransactionEventsAttributes();
            this.transactionsField = new configurationTransactionEventsTransactions();
            this.enabledField = true;
            this.maximumSamplesStoredField = 10000;
        }
        
        public configurationTransactionEventsTransactions transactions
        {
            get
            {
                return this.transactionsField;
            }
            set
            {
                this.transactionsField = value;
            }
        }
        
        public configurationTransactionEventsAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public uint maximumSamplesPerMinute
        {
            get
            {
                if (this.maximumSamplesPerMinuteField.HasValue)
                {
                    return this.maximumSamplesPerMinuteField.Value;
                }
                else
                {
                    return default(uint);
                }
            }
            set
            {
                this.maximumSamplesPerMinuteField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool maximumSamplesPerMinuteSpecified
        {
            get
            {
                return this.maximumSamplesPerMinuteField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.maximumSamplesPerMinuteField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(10000)]
        public int maximumSamplesStored
        {
            get
            {
                return this.maximumSamplesStoredField;
            }
            set
            {
                this.maximumSamplesStoredField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationTransactionEvents object
        /// </summary>
        public virtual configurationTransactionEvents Clone()
        {
            return ((configurationTransactionEvents)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationTransactionEventsTransactions
    {
        
        private System.Nullable<bool> enabledField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationTransactionEventsTransactions object
        /// </summary>
        public virtual configurationTransactionEventsTransactions Clone()
        {
            return ((configurationTransactionEventsTransactions)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationTransactionEventsAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationTransactionEventsAttributes class constructor
        /// </summary>
        public configurationTransactionEventsAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationTransactionEventsAttributes object
        /// </summary>
        public virtual configurationTransactionEventsAttributes Clone()
        {
            return ((configurationTransactionEventsAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDataTransmission
    {
        
        private bool putForDataSendField;
        
        private configurationDataTransmissionCompressedContentEncoding compressedContentEncodingField;
        
        /// <summary>
        /// configurationDataTransmission class constructor
        /// </summary>
        public configurationDataTransmission()
        {
            this.putForDataSendField = false;
            this.compressedContentEncodingField = configurationDataTransmissionCompressedContentEncoding.deflate;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool putForDataSend
        {
            get
            {
                return this.putForDataSendField;
            }
            set
            {
                this.putForDataSendField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(configurationDataTransmissionCompressedContentEncoding.deflate)]
        public configurationDataTransmissionCompressedContentEncoding compressedContentEncoding
        {
            get
            {
                return this.compressedContentEncodingField;
            }
            set
            {
                this.compressedContentEncodingField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDataTransmission object
        /// </summary>
        public virtual configurationDataTransmission Clone()
        {
            return ((configurationDataTransmission)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public enum configurationDataTransmissionCompressedContentEncoding
    {
        
        /// <remarks/>
        deflate,
        
        /// <remarks/>
        gzip,
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationTransactionTracer
    {
        
        private configurationTransactionTracerAttributes attributesField;
        
        private string transactionThresholdField;
        
        private configurationTransactionTracerRecordSql recordSqlField;
        
        private int stackTraceThresholdField;
        
        private bool explainEnabledField;
        
        private float explainThresholdField;
        
        private bool enabledField;
        
        private int maxSegmentsField;
        
        private int maxStackTraceField;
        
        private int maxExplainPlansField;
        
        private System.Nullable<bool> captureAttributesField;
        
        /// <summary>
        /// configurationTransactionTracer class constructor
        /// </summary>
        public configurationTransactionTracer()
        {
            this.attributesField = new configurationTransactionTracerAttributes();
            this.transactionThresholdField = "apdex_f";
            this.recordSqlField = configurationTransactionTracerRecordSql.obfuscated;
            this.stackTraceThresholdField = 500;
            this.explainEnabledField = false;
            this.explainThresholdField = ((float)(500F));
            this.enabledField = true;
            this.maxSegmentsField = 3000;
            this.maxStackTraceField = 0;
            this.maxExplainPlansField = 20;
        }
        
        public configurationTransactionTracerAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("apdex_f")]
        public string transactionThreshold
        {
            get
            {
                return this.transactionThresholdField;
            }
            set
            {
                this.transactionThresholdField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(configurationTransactionTracerRecordSql.obfuscated)]
        public configurationTransactionTracerRecordSql recordSql
        {
            get
            {
                return this.recordSqlField;
            }
            set
            {
                this.recordSqlField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(500)]
        public int stackTraceThreshold
        {
            get
            {
                return this.stackTraceThresholdField;
            }
            set
            {
                this.stackTraceThresholdField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool explainEnabled
        {
            get
            {
                return this.explainEnabledField;
            }
            set
            {
                this.explainEnabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(typeof(float), "500")]
        public float explainThreshold
        {
            get
            {
                return this.explainThresholdField;
            }
            set
            {
                this.explainThresholdField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(3000)]
        public int maxSegments
        {
            get
            {
                return this.maxSegmentsField;
            }
            set
            {
                this.maxSegmentsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(0)]
        public int maxStackTrace
        {
            get
            {
                return this.maxStackTraceField;
            }
            set
            {
                this.maxStackTraceField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(20)]
        public int maxExplainPlans
        {
            get
            {
                return this.maxExplainPlansField;
            }
            set
            {
                this.maxExplainPlansField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool captureAttributes
        {
            get
            {
                if (this.captureAttributesField.HasValue)
                {
                    return this.captureAttributesField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.captureAttributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool captureAttributesSpecified
        {
            get
            {
                return this.captureAttributesField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.captureAttributesField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationTransactionTracer object
        /// </summary>
        public virtual configurationTransactionTracer Clone()
        {
            return ((configurationTransactionTracer)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationTransactionTracerAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationTransactionTracerAttributes class constructor
        /// </summary>
        public configurationTransactionTracerAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationTransactionTracerAttributes object
        /// </summary>
        public virtual configurationTransactionTracerAttributes Clone()
        {
            return ((configurationTransactionTracerAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public enum configurationTransactionTracerRecordSql
    {
        
        /// <remarks/>
        obfuscated,
        
        /// <remarks/>
        raw,
        
        /// <remarks/>
        off,
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDatastoreTracer
    {
        
        private configurationDatastoreTracerInstanceReporting instanceReportingField;
        
        private configurationDatastoreTracerDatabaseNameReporting databaseNameReportingField;
        
        private configurationDatastoreTracerQueryParameters queryParametersField;
        
        /// <summary>
        /// configurationDatastoreTracer class constructor
        /// </summary>
        public configurationDatastoreTracer()
        {
            this.queryParametersField = new configurationDatastoreTracerQueryParameters();
            this.databaseNameReportingField = new configurationDatastoreTracerDatabaseNameReporting();
            this.instanceReportingField = new configurationDatastoreTracerInstanceReporting();
        }
        
        public configurationDatastoreTracerInstanceReporting instanceReporting
        {
            get
            {
                return this.instanceReportingField;
            }
            set
            {
                this.instanceReportingField = value;
            }
        }
        
        public configurationDatastoreTracerDatabaseNameReporting databaseNameReporting
        {
            get
            {
                return this.databaseNameReportingField;
            }
            set
            {
                this.databaseNameReportingField = value;
            }
        }
        
        public configurationDatastoreTracerQueryParameters queryParameters
        {
            get
            {
                return this.queryParametersField;
            }
            set
            {
                this.queryParametersField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDatastoreTracer object
        /// </summary>
        public virtual configurationDatastoreTracer Clone()
        {
            return ((configurationDatastoreTracer)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDatastoreTracerInstanceReporting
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationDatastoreTracerInstanceReporting class constructor
        /// </summary>
        public configurationDatastoreTracerInstanceReporting()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDatastoreTracerInstanceReporting object
        /// </summary>
        public virtual configurationDatastoreTracerInstanceReporting Clone()
        {
            return ((configurationDatastoreTracerInstanceReporting)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDatastoreTracerDatabaseNameReporting
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationDatastoreTracerDatabaseNameReporting class constructor
        /// </summary>
        public configurationDatastoreTracerDatabaseNameReporting()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDatastoreTracerDatabaseNameReporting object
        /// </summary>
        public virtual configurationDatastoreTracerDatabaseNameReporting Clone()
        {
            return ((configurationDatastoreTracerDatabaseNameReporting)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDatastoreTracerQueryParameters
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationDatastoreTracerQueryParameters class constructor
        /// </summary>
        public configurationDatastoreTracerQueryParameters()
        {
            this.enabledField = false;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDatastoreTracerQueryParameters object
        /// </summary>
        public virtual configurationDatastoreTracerQueryParameters Clone()
        {
            return ((configurationDatastoreTracerQueryParameters)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCrossApplicationTracer
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationCrossApplicationTracer class constructor
        /// </summary>
        public configurationCrossApplicationTracer()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCrossApplicationTracer object
        /// </summary>
        public virtual configurationCrossApplicationTracer Clone()
        {
            return ((configurationCrossApplicationTracer)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInfiniteTracing
    {
        
        private configurationInfiniteTracingTrace_observer trace_observerField;
        
        private configurationInfiniteTracingSpan_events span_eventsField;
        
        private bool compressionField;
        
        /// <summary>
        /// configurationInfiniteTracing class constructor
        /// </summary>
        public configurationInfiniteTracing()
        {
            this.span_eventsField = new configurationInfiniteTracingSpan_events();
            this.trace_observerField = new configurationInfiniteTracingTrace_observer();
            this.compressionField = true;
        }
        
        public configurationInfiniteTracingTrace_observer trace_observer
        {
            get
            {
                return this.trace_observerField;
            }
            set
            {
                this.trace_observerField = value;
            }
        }
        
        public configurationInfiniteTracingSpan_events span_events
        {
            get
            {
                return this.span_eventsField;
            }
            set
            {
                this.span_eventsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool compression
        {
            get
            {
                return this.compressionField;
            }
            set
            {
                this.compressionField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInfiniteTracing object
        /// </summary>
        public virtual configurationInfiniteTracing Clone()
        {
            return ((configurationInfiniteTracing)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInfiniteTracingTrace_observer
    {
        
        private string hostField;
        
        private string portField;
        
        /// <summary>
        /// configurationInfiniteTracingTrace_observer class constructor
        /// </summary>
        public configurationInfiniteTracingTrace_observer()
        {
            this.portField = "443";
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string host
        {
            get
            {
                return this.hostField;
            }
            set
            {
                this.hostField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("443")]
        public string port
        {
            get
            {
                return this.portField;
            }
            set
            {
                this.portField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInfiniteTracingTrace_observer object
        /// </summary>
        public virtual configurationInfiniteTracingTrace_observer Clone()
        {
            return ((configurationInfiniteTracingTrace_observer)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationInfiniteTracingSpan_events
    {
        
        private int queue_sizeField;
        
        /// <summary>
        /// configurationInfiniteTracingSpan_events class constructor
        /// </summary>
        public configurationInfiniteTracingSpan_events()
        {
            this.queue_sizeField = 100000;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(100000)]
        public int queue_size
        {
            get
            {
                return this.queue_sizeField;
            }
            set
            {
                this.queue_sizeField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationInfiniteTracingSpan_events object
        /// </summary>
        public virtual configurationInfiniteTracingSpan_events Clone()
        {
            return ((configurationInfiniteTracingSpan_events)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationDistributedTracing
    {
        
        private bool enabledField;
        
        private bool excludeNewrelicHeaderField;
        
        private bool enableSuccessMetricsField;
        
        private string account_idField;
        
        private string trusted_account_keyField;
        
        private string primary_application_idField;
        
        /// <summary>
        /// configurationDistributedTracing class constructor
        /// </summary>
        public configurationDistributedTracing()
        {
            this.enabledField = false;
            this.excludeNewrelicHeaderField = false;
            this.enableSuccessMetricsField = true;
            this.primary_application_idField = "Unknown";
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool excludeNewrelicHeader
        {
            get
            {
                return this.excludeNewrelicHeaderField;
            }
            set
            {
                this.excludeNewrelicHeaderField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enableSuccessMetrics
        {
            get
            {
                return this.enableSuccessMetricsField;
            }
            set
            {
                this.enableSuccessMetricsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string account_id
        {
            get
            {
                return this.account_idField;
            }
            set
            {
                this.account_idField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string trusted_account_key
        {
            get
            {
                return this.trusted_account_keyField;
            }
            set
            {
                this.trusted_account_keyField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("Unknown")]
        public string primary_application_id
        {
            get
            {
                return this.primary_application_idField;
            }
            set
            {
                this.primary_application_idField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationDistributedTracing object
        /// </summary>
        public virtual configurationDistributedTracing Clone()
        {
            return ((configurationDistributedTracing)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationSpanEvents
    {
        
        private configurationSpanEventsAttributes attributesField;
        
        private bool enabledField;
        
        private int maximumSamplesStoredField;
        
        /// <summary>
        /// configurationSpanEvents class constructor
        /// </summary>
        public configurationSpanEvents()
        {
            this.attributesField = new configurationSpanEventsAttributes();
            this.enabledField = true;
            this.maximumSamplesStoredField = 2000;
        }
        
        public configurationSpanEventsAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(2000)]
        public int maximumSamplesStored
        {
            get
            {
                return this.maximumSamplesStoredField;
            }
            set
            {
                this.maximumSamplesStoredField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationSpanEvents object
        /// </summary>
        public virtual configurationSpanEvents Clone()
        {
            return ((configurationSpanEvents)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationSpanEventsAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationSpanEventsAttributes class constructor
        /// </summary>
        public configurationSpanEventsAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationSpanEventsAttributes object
        /// </summary>
        public virtual configurationSpanEventsAttributes Clone()
        {
            return ((configurationSpanEventsAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationHighSecurity
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationHighSecurity class constructor
        /// </summary>
        public configurationHighSecurity()
        {
            this.enabledField = false;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationHighSecurity object
        /// </summary>
        public virtual configurationHighSecurity Clone()
        {
            return ((configurationHighSecurity)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCustomInstrumentationEditor
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationCustomInstrumentationEditor class constructor
        /// </summary>
        public configurationCustomInstrumentationEditor()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCustomInstrumentationEditor object
        /// </summary>
        public virtual configurationCustomInstrumentationEditor Clone()
        {
            return ((configurationCustomInstrumentationEditor)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationStripExceptionMessages
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationStripExceptionMessages class constructor
        /// </summary>
        public configurationStripExceptionMessages()
        {
            this.enabledField = false;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationStripExceptionMessages object
        /// </summary>
        public virtual configurationStripExceptionMessages Clone()
        {
            return ((configurationStripExceptionMessages)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationSlowSql
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationSlowSql class constructor
        /// </summary>
        public configurationSlowSql()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationSlowSql object
        /// </summary>
        public virtual configurationSlowSql Clone()
        {
            return ((configurationSlowSql)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationErrorCollector
    {
        
        private configurationErrorCollectorIgnoreErrors ignoreErrorsField;
        
        private ErrorClassCollection ignoreClassesField;
        
        private List<ErrorMessagesCollectionErrorClass> ignoreMessagesField;
        
        private configurationErrorCollectorIgnoreStatusCodes ignoreStatusCodesField;
        
        private ErrorClassCollection expectedClassesField;
        
        private List<ErrorMessagesCollectionErrorClass> expectedMessagesField;
        
        private string expectedStatusCodesField;
        
        private configurationErrorCollectorAttributes attributesField;
        
        private bool enabledField;
        
        private System.Nullable<bool> captureAttributesField;
        
        private bool captureEventsField;
        
        private int maxEventSamplesStoredField;
        
        /// <summary>
        /// configurationErrorCollector class constructor
        /// </summary>
        public configurationErrorCollector()
        {
            this.attributesField = new configurationErrorCollectorAttributes();
            this.expectedMessagesField = new List<ErrorMessagesCollectionErrorClass>();
            this.expectedClassesField = new ErrorClassCollection();
            this.ignoreStatusCodesField = new configurationErrorCollectorIgnoreStatusCodes();
            this.ignoreMessagesField = new List<ErrorMessagesCollectionErrorClass>();
            this.ignoreClassesField = new ErrorClassCollection();
            this.ignoreErrorsField = new configurationErrorCollectorIgnoreErrors();
            this.enabledField = true;
            this.captureEventsField = true;
            this.maxEventSamplesStoredField = 100;
        }
        
        public configurationErrorCollectorIgnoreErrors ignoreErrors
        {
            get
            {
                return this.ignoreErrorsField;
            }
            set
            {
                this.ignoreErrorsField = value;
            }
        }
        
        public ErrorClassCollection ignoreClasses
        {
            get
            {
                return this.ignoreClassesField;
            }
            set
            {
                this.ignoreClassesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("errorClass", IsNullable=false)]
        public List<ErrorMessagesCollectionErrorClass> ignoreMessages
        {
            get
            {
                return this.ignoreMessagesField;
            }
            set
            {
                this.ignoreMessagesField = value;
            }
        }
        
        public configurationErrorCollectorIgnoreStatusCodes ignoreStatusCodes
        {
            get
            {
                return this.ignoreStatusCodesField;
            }
            set
            {
                this.ignoreStatusCodesField = value;
            }
        }
        
        public ErrorClassCollection expectedClasses
        {
            get
            {
                return this.expectedClassesField;
            }
            set
            {
                this.expectedClassesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("errorClass", IsNullable=false)]
        public List<ErrorMessagesCollectionErrorClass> expectedMessages
        {
            get
            {
                return this.expectedMessagesField;
            }
            set
            {
                this.expectedMessagesField = value;
            }
        }
        
        public string expectedStatusCodes
        {
            get
            {
                return this.expectedStatusCodesField;
            }
            set
            {
                this.expectedStatusCodesField = value;
            }
        }
        
        public configurationErrorCollectorAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool captureAttributes
        {
            get
            {
                if (this.captureAttributesField.HasValue)
                {
                    return this.captureAttributesField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.captureAttributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool captureAttributesSpecified
        {
            get
            {
                return this.captureAttributesField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.captureAttributesField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool captureEvents
        {
            get
            {
                return this.captureEventsField;
            }
            set
            {
                this.captureEventsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(100)]
        public int maxEventSamplesStored
        {
            get
            {
                return this.maxEventSamplesStoredField;
            }
            set
            {
                this.maxEventSamplesStoredField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationErrorCollector object
        /// </summary>
        public virtual configurationErrorCollector Clone()
        {
            return ((configurationErrorCollector)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationErrorCollectorIgnoreErrors
    {
        
        private List<string> exceptionField;
        
        /// <summary>
        /// configurationErrorCollectorIgnoreErrors class constructor
        /// </summary>
        public configurationErrorCollectorIgnoreErrors()
        {
            this.exceptionField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exception")]
        public List<string> exception
        {
            get
            {
                return this.exceptionField;
            }
            set
            {
                this.exceptionField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationErrorCollectorIgnoreErrors object
        /// </summary>
        public virtual configurationErrorCollectorIgnoreErrors Clone()
        {
            return ((configurationErrorCollectorIgnoreErrors)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class ErrorMessagesCollectionErrorClass
    {
        
        private List<string> messageField;
        
        private string nameField;
        
        /// <summary>
        /// ErrorMessagesCollectionErrorClass class constructor
        /// </summary>
        public ErrorMessagesCollectionErrorClass()
        {
            this.messageField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("message")]
        public List<string> message
        {
            get
            {
                return this.messageField;
            }
            set
            {
                this.messageField = value;
            }
        }
        
        /// <summary>
        /// Fully qualified class name of an exception, such as "System.IO.FileNotFoundException".
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this ErrorMessagesCollectionErrorClass object
        /// </summary>
        public virtual ErrorMessagesCollectionErrorClass Clone()
        {
            return ((ErrorMessagesCollectionErrorClass)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationErrorCollectorIgnoreStatusCodes
    {
        
        private List<float> codeField;
        
        /// <summary>
        /// configurationErrorCollectorIgnoreStatusCodes class constructor
        /// </summary>
        public configurationErrorCollectorIgnoreStatusCodes()
        {
            this.codeField = new List<float>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("code")]
        public List<float> code
        {
            get
            {
                return this.codeField;
            }
            set
            {
                this.codeField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationErrorCollectorIgnoreStatusCodes object
        /// </summary>
        public virtual configurationErrorCollectorIgnoreStatusCodes Clone()
        {
            return ((configurationErrorCollectorIgnoreStatusCodes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationErrorCollectorAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationErrorCollectorAttributes class constructor
        /// </summary>
        public configurationErrorCollectorAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationErrorCollectorAttributes object
        /// </summary>
        public virtual configurationErrorCollectorAttributes Clone()
        {
            return ((configurationErrorCollectorAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationBrowserMonitoring
    {
        
        private List<configurationBrowserMonitoringPath> requestPathsExcludedField;
        
        private configurationBrowserMonitoringAttributes attributesField;
        
        private bool autoInstrumentField;
        
        private string loaderField;
        
        private bool sslForHttpField;
        
        private System.Nullable<bool> captureAttributesField;
        
        /// <summary>
        /// configurationBrowserMonitoring class constructor
        /// </summary>
        public configurationBrowserMonitoring()
        {
            this.attributesField = new configurationBrowserMonitoringAttributes();
            this.requestPathsExcludedField = new List<configurationBrowserMonitoringPath>();
            this.autoInstrumentField = true;
            this.loaderField = "rum";
            this.sslForHttpField = false;
        }
        
        [System.Xml.Serialization.XmlArrayItemAttribute("path", IsNullable=false)]
        public List<configurationBrowserMonitoringPath> requestPathsExcluded
        {
            get
            {
                return this.requestPathsExcludedField;
            }
            set
            {
                this.requestPathsExcludedField = value;
            }
        }
        
        public configurationBrowserMonitoringAttributes attributes
        {
            get
            {
                return this.attributesField;
            }
            set
            {
                this.attributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool autoInstrument
        {
            get
            {
                return this.autoInstrumentField;
            }
            set
            {
                this.autoInstrumentField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("rum")]
        public string loader
        {
            get
            {
                return this.loaderField;
            }
            set
            {
                this.loaderField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool sslForHttp
        {
            get
            {
                return this.sslForHttpField;
            }
            set
            {
                this.sslForHttpField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool captureAttributes
        {
            get
            {
                if (this.captureAttributesField.HasValue)
                {
                    return this.captureAttributesField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.captureAttributesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool captureAttributesSpecified
        {
            get
            {
                return this.captureAttributesField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.captureAttributesField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationBrowserMonitoring object
        /// </summary>
        public virtual configurationBrowserMonitoring Clone()
        {
            return ((configurationBrowserMonitoring)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationBrowserMonitoringPath
    {
        
        private string regexField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string regex
        {
            get
            {
                return this.regexField;
            }
            set
            {
                this.regexField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationBrowserMonitoringPath object
        /// </summary>
        public virtual configurationBrowserMonitoringPath Clone()
        {
            return ((configurationBrowserMonitoringPath)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationBrowserMonitoringAttributes
    {
        
        private List<string> includeField;
        
        private List<string> excludeField;
        
        private System.Nullable<bool> enabledField;
        
        /// <summary>
        /// configurationBrowserMonitoringAttributes class constructor
        /// </summary>
        public configurationBrowserMonitoringAttributes()
        {
            this.excludeField = new List<string>();
            this.includeField = new List<string>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("include")]
        public List<string> include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("exclude")]
        public List<string> exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool enabled
        {
            get
            {
                if (this.enabledField.HasValue)
                {
                    return this.enabledField.Value;
                }
                else
                {
                    return default(bool);
                }
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool enabledSpecified
        {
            get
            {
                return this.enabledField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.enabledField = null;
                }
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationBrowserMonitoringAttributes object
        /// </summary>
        public virtual configurationBrowserMonitoringAttributes Clone()
        {
            return ((configurationBrowserMonitoringAttributes)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationPools
    {
        
        private configurationApplicationPoolsDefaultBehavior defaultBehaviorField;
        
        private List<configurationApplicationPoolsApplicationPool> applicationPoolField;
        
        /// <summary>
        /// configurationApplicationPools class constructor
        /// </summary>
        public configurationApplicationPools()
        {
            this.applicationPoolField = new List<configurationApplicationPoolsApplicationPool>();
            this.defaultBehaviorField = new configurationApplicationPoolsDefaultBehavior();
        }
        
        public configurationApplicationPoolsDefaultBehavior defaultBehavior
        {
            get
            {
                return this.defaultBehaviorField;
            }
            set
            {
                this.defaultBehaviorField = value;
            }
        }
        
        [System.Xml.Serialization.XmlElementAttribute("applicationPool")]
        public List<configurationApplicationPoolsApplicationPool> applicationPool
        {
            get
            {
                return this.applicationPoolField;
            }
            set
            {
                this.applicationPoolField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationPools object
        /// </summary>
        public virtual configurationApplicationPools Clone()
        {
            return ((configurationApplicationPools)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationPoolsDefaultBehavior
    {
        
        private bool instrumentField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool instrument
        {
            get
            {
                return this.instrumentField;
            }
            set
            {
                this.instrumentField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationPoolsDefaultBehavior object
        /// </summary>
        public virtual configurationApplicationPoolsDefaultBehavior Clone()
        {
            return ((configurationApplicationPoolsDefaultBehavior)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationPoolsApplicationPool
    {
        
        private string nameField;
        
        private bool instrumentField;
        
        /// <summary>
        /// Fully qualified class name of an exception, such as "System.IO.FileNotFoundException".
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool instrument
        {
            get
            {
                return this.instrumentField;
            }
            set
            {
                this.instrumentField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationPoolsApplicationPool object
        /// </summary>
        public virtual configurationApplicationPoolsApplicationPool Clone()
        {
            return ((configurationApplicationPoolsApplicationPool)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAiMonitoring
    {
        
        private configurationAiMonitoringStreaming streamingField;
        
        private configurationAiMonitoringRecordContent recordContentField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationAiMonitoring class constructor
        /// </summary>
        public configurationAiMonitoring()
        {
            this.recordContentField = new configurationAiMonitoringRecordContent();
            this.streamingField = new configurationAiMonitoringStreaming();
            this.enabledField = false;
        }
        
        public configurationAiMonitoringStreaming streaming
        {
            get
            {
                return this.streamingField;
            }
            set
            {
                this.streamingField = value;
            }
        }
        
        public configurationAiMonitoringRecordContent recordContent
        {
            get
            {
                return this.recordContentField;
            }
            set
            {
                this.recordContentField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAiMonitoring object
        /// </summary>
        public virtual configurationAiMonitoring Clone()
        {
            return ((configurationAiMonitoring)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAiMonitoringStreaming
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationAiMonitoringStreaming class constructor
        /// </summary>
        public configurationAiMonitoringStreaming()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAiMonitoringStreaming object
        /// </summary>
        public virtual configurationAiMonitoringStreaming Clone()
        {
            return ((configurationAiMonitoringStreaming)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAiMonitoringRecordContent
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationAiMonitoringRecordContent class constructor
        /// </summary>
        public configurationAiMonitoringRecordContent()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAiMonitoringRecordContent object
        /// </summary>
        public virtual configurationAiMonitoringRecordContent Clone()
        {
            return ((configurationAiMonitoringRecordContent)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLogging
    {
        
        private configurationApplicationLoggingMetrics metricsField;
        
        private configurationApplicationLoggingForwarding forwardingField;
        
        private configurationApplicationLoggingLocalDecorating localDecoratingField;
        
        private bool enabledField;
        
        /// <summary>
        /// configurationApplicationLogging class constructor
        /// </summary>
        public configurationApplicationLogging()
        {
            this.localDecoratingField = new configurationApplicationLoggingLocalDecorating();
            this.forwardingField = new configurationApplicationLoggingForwarding();
            this.metricsField = new configurationApplicationLoggingMetrics();
            this.enabledField = true;
        }
        
        public configurationApplicationLoggingMetrics metrics
        {
            get
            {
                return this.metricsField;
            }
            set
            {
                this.metricsField = value;
            }
        }
        
        public configurationApplicationLoggingForwarding forwarding
        {
            get
            {
                return this.forwardingField;
            }
            set
            {
                this.forwardingField = value;
            }
        }
        
        public configurationApplicationLoggingLocalDecorating localDecorating
        {
            get
            {
                return this.localDecoratingField;
            }
            set
            {
                this.localDecoratingField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLogging object
        /// </summary>
        public virtual configurationApplicationLogging Clone()
        {
            return ((configurationApplicationLogging)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLoggingMetrics
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationApplicationLoggingMetrics class constructor
        /// </summary>
        public configurationApplicationLoggingMetrics()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLoggingMetrics object
        /// </summary>
        public virtual configurationApplicationLoggingMetrics Clone()
        {
            return ((configurationApplicationLoggingMetrics)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLoggingForwarding
    {
        
        private configurationApplicationLoggingForwardingContextData contextDataField;
        
        private configurationApplicationLoggingForwardingLabels labelsField;
        
        private bool enabledField;
        
        private int maxSamplesStoredField;
        
        private string logLevelDenyListField;
        
        /// <summary>
        /// configurationApplicationLoggingForwarding class constructor
        /// </summary>
        public configurationApplicationLoggingForwarding()
        {
            this.labelsField = new configurationApplicationLoggingForwardingLabels();
            this.contextDataField = new configurationApplicationLoggingForwardingContextData();
            this.enabledField = true;
            this.maxSamplesStoredField = 10000;
        }
        
        public configurationApplicationLoggingForwardingContextData contextData
        {
            get
            {
                return this.contextDataField;
            }
            set
            {
                this.contextDataField = value;
            }
        }
        
        public configurationApplicationLoggingForwardingLabels labels
        {
            get
            {
                return this.labelsField;
            }
            set
            {
                this.labelsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(10000)]
        public int maxSamplesStored
        {
            get
            {
                return this.maxSamplesStoredField;
            }
            set
            {
                this.maxSamplesStoredField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string logLevelDenyList
        {
            get
            {
                return this.logLevelDenyListField;
            }
            set
            {
                this.logLevelDenyListField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLoggingForwarding object
        /// </summary>
        public virtual configurationApplicationLoggingForwarding Clone()
        {
            return ((configurationApplicationLoggingForwarding)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLoggingForwardingContextData
    {
        
        private bool enabledField;
        
        private string includeField;
        
        private string excludeField;
        
        /// <summary>
        /// configurationApplicationLoggingForwardingContextData class constructor
        /// </summary>
        public configurationApplicationLoggingForwardingContextData()
        {
            this.enabledField = false;
            this.includeField = "";
            this.excludeField = "SpanId,TraceId,ParentId";
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string include
        {
            get
            {
                return this.includeField;
            }
            set
            {
                this.includeField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("SpanId,TraceId,ParentId")]
        public string exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLoggingForwardingContextData object
        /// </summary>
        public virtual configurationApplicationLoggingForwardingContextData Clone()
        {
            return ((configurationApplicationLoggingForwardingContextData)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLoggingForwardingLabels
    {
        
        private bool enabledField;
        
        private string excludeField;
        
        /// <summary>
        /// configurationApplicationLoggingForwardingLabels class constructor
        /// </summary>
        public configurationApplicationLoggingForwardingLabels()
        {
            this.enabledField = false;
            this.excludeField = "";
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string exclude
        {
            get
            {
                return this.excludeField;
            }
            set
            {
                this.excludeField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLoggingForwardingLabels object
        /// </summary>
        public virtual configurationApplicationLoggingForwardingLabels Clone()
        {
            return ((configurationApplicationLoggingForwardingLabels)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationApplicationLoggingLocalDecorating
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationApplicationLoggingLocalDecorating class constructor
        /// </summary>
        public configurationApplicationLoggingLocalDecorating()
        {
            this.enabledField = false;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationApplicationLoggingLocalDecorating object
        /// </summary>
        public virtual configurationApplicationLoggingLocalDecorating Clone()
        {
            return ((configurationApplicationLoggingLocalDecorating)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationAdd
    {
        
        private string keyField;
        
        private string valueField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string key
        {
            get
            {
                return this.keyField;
            }
            set
            {
                this.keyField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string value
        {
            get
            {
                return this.valueField;
            }
            set
            {
                this.valueField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationAdd object
        /// </summary>
        public virtual configurationAdd Clone()
        {
            return ((configurationAdd)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationUtilization
    {
        
        private bool detectAwsField;
        
        private bool detectAzureField;
        
        private bool detectGcpField;
        
        private bool detectPcfField;
        
        private bool detectDockerField;
        
        private bool detectKubernetesField;
        
        private bool detectAzureFunctionField;
        
        private System.Nullable<int> logicalProcessorsField;
        
        private System.Nullable<int> totalRamMibField;
        
        private string billingHostField;
        
        /// <summary>
        /// configurationUtilization class constructor
        /// </summary>
        public configurationUtilization()
        {
            this.detectAwsField = true;
            this.detectAzureField = true;
            this.detectGcpField = true;
            this.detectPcfField = true;
            this.detectDockerField = true;
            this.detectKubernetesField = true;
            this.detectAzureFunctionField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectAws
        {
            get
            {
                return this.detectAwsField;
            }
            set
            {
                this.detectAwsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectAzure
        {
            get
            {
                return this.detectAzureField;
            }
            set
            {
                this.detectAzureField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectGcp
        {
            get
            {
                return this.detectGcpField;
            }
            set
            {
                this.detectGcpField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectPcf
        {
            get
            {
                return this.detectPcfField;
            }
            set
            {
                this.detectPcfField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectDocker
        {
            get
            {
                return this.detectDockerField;
            }
            set
            {
                this.detectDockerField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectKubernetes
        {
            get
            {
                return this.detectKubernetesField;
            }
            set
            {
                this.detectKubernetesField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool detectAzureFunction
        {
            get
            {
                return this.detectAzureFunctionField;
            }
            set
            {
                this.detectAzureFunctionField = value;
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int logicalProcessors
        {
            get
            {
                if (this.logicalProcessorsField.HasValue)
                {
                    return this.logicalProcessorsField.Value;
                }
                else
                {
                    return default(int);
                }
            }
            set
            {
                this.logicalProcessorsField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool logicalProcessorsSpecified
        {
            get
            {
                return this.logicalProcessorsField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.logicalProcessorsField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int totalRamMib
        {
            get
            {
                if (this.totalRamMibField.HasValue)
                {
                    return this.totalRamMibField.Value;
                }
                else
                {
                    return default(int);
                }
            }
            set
            {
                this.totalRamMibField = value;
            }
        }
        
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool totalRamMibSpecified
        {
            get
            {
                return this.totalRamMibField.HasValue;
            }
            set
            {
                if (value==false)
                {
                    this.totalRamMibField = null;
                }
            }
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string billingHost
        {
            get
            {
                return this.billingHostField;
            }
            set
            {
                this.billingHostField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationUtilization object
        /// </summary>
        public virtual configurationUtilization Clone()
        {
            return ((configurationUtilization)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationProcessHost
    {
        
        private string displayNameField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string displayName
        {
            get
            {
                return this.displayNameField;
            }
            set
            {
                this.displayNameField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationProcessHost object
        /// </summary>
        public virtual configurationProcessHost Clone()
        {
            return ((configurationProcessHost)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCodeLevelMetrics
    {
        
        private bool enabledField;
        
        /// <summary>
        /// configurationCodeLevelMetrics class constructor
        /// </summary>
        public configurationCodeLevelMetrics()
        {
            this.enabledField = true;
        }
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool enabled
        {
            get
            {
                return this.enabledField;
            }
            set
            {
                this.enabledField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCodeLevelMetrics object
        /// </summary>
        public virtual configurationCodeLevelMetrics Clone()
        {
            return ((configurationCodeLevelMetrics)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCloud
    {
        
        private configurationCloudAws awsField;
        
        /// <summary>
        /// configurationCloud class constructor
        /// </summary>
        public configurationCloud()
        {
            this.awsField = new configurationCloudAws();
        }
        
        public configurationCloudAws aws
        {
            get
            {
                return this.awsField;
            }
            set
            {
                this.awsField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCloud object
        /// </summary>
        public virtual configurationCloud Clone()
        {
            return ((configurationCloud)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public partial class configurationCloudAws
    {
        
        private string accountIdField;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string accountId
        {
            get
            {
                return this.accountIdField;
            }
            set
            {
                this.accountIdField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this configurationCloudAws object
        /// </summary>
        public virtual configurationCloudAws Clone()
        {
            return ((configurationCloudAws)(this.MemberwiseClone()));
        }
        #endregion
    }
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true, Namespace="urn:newrelic-config")]
    public enum configurationTimingPrecision
    {
        
        high,
        
        low,
    }
    
    /// <summary>
    /// An optional map of fully qualified error class name to list of strings matching a substring of the message of an error to be ignored/expected.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "3.6.0.20097")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace="urn:newrelic-config")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace="urn:newrelic-config", IsNullable=true)]
    public partial class ErrorMessagesCollection
    {
        
        private List<ErrorMessagesCollectionErrorClass> errorClassField;
        
        /// <summary>
        /// ErrorMessagesCollection class constructor
        /// </summary>
        public ErrorMessagesCollection()
        {
            this.errorClassField = new List<ErrorMessagesCollectionErrorClass>();
        }
        
        [System.Xml.Serialization.XmlElementAttribute("errorClass")]
        public List<ErrorMessagesCollectionErrorClass> errorClass
        {
            get
            {
                return this.errorClassField;
            }
            set
            {
                this.errorClassField = value;
            }
        }
        
        #region Clone method
        /// <summary>
        /// Create a clone of this ErrorMessagesCollection object
        /// </summary>
        public virtual ErrorMessagesCollection Clone()
        {
            return ((ErrorMessagesCollection)(this.MemberwiseClone()));
        }
        #endregion
    }
}
