<a href="https://opensource.newrelic.com/oss-category/#community-plus"><picture><source media="(prefers-color-scheme: dark)" srcset="https://github.com/newrelic/opensource-website/raw/main/src/images/categories/dark/Community_Plus.png"><source media="(prefers-color-scheme: light)" srcset="https://github.com/newrelic/opensource-website/raw/main/src/images/categories/Community_Plus.png"><img alt="New Relic Open Source community plus project banner." src="https://github.com/newrelic/opensource-website/raw/main/src/images/categories/Community_Plus.png"></picture></a>

[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![build_status](https://github.com/newrelic/newrelic-dotnet-agent/actions/workflows/all_solutions.yml/badge.svg?event=schedule)](https://github.com/newrelic/newrelic-dotnet-agent/actions/workflows/all_solutions.yml)
[![codecov](https://codecov.io/gh/newrelic/newrelic-dotnet-agent/branch/main/graph/badge.svg?token=VKV9XDVJ2U)](https://codecov.io/gh/newrelic/newrelic-dotnet-agent)
[![OpenSSF
Scorecard](https://api.securityscorecards.dev/projects/github.com/newrelic/newrelic-dotnet-agent/badge)](https://api.securityscorecards.dev/projects/github.com/newrelic/newrelic-dotnet-agent)
# New Relic Monitoring for .NET

#### .NET Agent
New Relic's .NET agent monitors your .NET app, giving you an end-to-end view of your app's performance. It works with all .NET compatible languages, such as C#, VB.NET and CLI.

## Installation

<!-- markdown-link-check-disable-next-line -->
The latest released binaries for the .NET Agent can be found either [here](https://download.newrelic.com/dot_net_agent/latest_release/) or on [NuGet.org](https://www.nuget.org/profiles/newrelic).

See our [agent installation documentation](https://docs.newrelic.com/install/dotnet/) to understand which of these files are appropriate for your application type and hosting environment.

## Getting Started

* See our [introduction to New Relic for .NET](https://docs.newrelic.com/docs/agents/net-agent/getting-started/introduction-new-relic-net) to learn how to use the .NET agent with your application.
* See our [changelog](src/Agent/CHANGELOG.md) for release notes.

## Building and Testing

Get started by reviewing our instructions for how to [build and test](docs/development.md).

## Support

Should you need assistance with New Relic products, you are in good hands with several support diagnostic tools and support channels.

This [troubleshooting framework](https://discuss.newrelic.com/t/troubleshooting-frameworks/108787) steps you through common troubleshooting questions. 
Additional troubleshooting scenarios can be found on the New Relic [Docs](https://docs.newrelic.com/docs/agents/net-agent/troubleshooting) site.

New Relic offers NRDiag, [a client-side diagnostic utility](https://docs.newrelic.com/docs/using-new-relic/cross-product-functions/diagnostics-cli-nrdiag/diagnostics-cli-nrdiag/) that automatically detects common problems with New Relic agents. If NRDiag detects a problem, it suggests troubleshooting steps. NRDiag can also automatically attach troubleshooting data to a New Relic Support ticket.

If the issue has been confirmed as a bug or is a Feature request, please file a Github issue.

**Support Channels**

* [New Relic Documentation](https://docs.newrelic.com/docs/agents/net-agent): Comprehensive guidance for using our agent
* [New Relic Community](https://forum.newrelic.com/): The best place to engage in troubleshooting questions
* [New Relic Developer](https://developer.newrelic.com/): Resources for building a custom observability applications
* [New Relic University](https://learn.newrelic.com/): A range of online training for New Relic users of every level
* [New Relic Technical Support](https://support.newrelic.com/) 24/7/365 ticketed support. Read more about our [Technical Support Offerings](https://docs.newrelic.com/docs/licenses/license-information/general-usage-licenses/global-technical-support-offerings/). 

## Privacy
At New Relic we take your privacy and the security of your information seriously, and are committed to protecting your information. We must emphasize the importance of not sharing personal data in public forums, and ask all users to scrub logs and diagnostic information for sensitive information, whether personal, proprietary, or otherwise.

We define “Personal Data” as any information relating to an identified or identifiable individual, including, for example, your name, phone number, post code or zip code, Device ID, IP address and email address.

Please review [New Relic’s General Data Privacy Notice](https://newrelic.com/termsandconditions/privacy) for more information.

## Contributing
We encourage your contributions to improve New Relic's .NET monitoring products! Keep in mind that when you submit your pull request, you'll need to sign the CLA via the click-through using CLA-Assistant. You only have to sign the CLA one time per project.
To execute our corporate CLA, which is required if your contribution is on behalf of a company, or if you have any questions, please drop us an email at open-source@newrelic.com.

**A note about vulnerabilities**

As noted in our [security policy](https://github.com/newrelic/newrelic-dotnet-agent/security/policy), New Relic is committed to the privacy and security of our customers and their data. We believe that providing coordinated disclosure by security researchers and engaging with the security community are important means to achieve our security goals.

If you believe you have found a security vulnerability in this project or any of New Relic's products or websites, we welcome and greatly appreciate you reporting it to New Relic through [HackerOne](https://hackerone.com/newrelic).

If you would like to contribute to this project, please review [these guidelines](CONTRIBUTING.md).

To [all contributors](https://github.com/newrelic/newrelic-dotnet-agent/graphs/contributors), we thank you!  Without your contribution, this project would not be what it is today.  We also host a community project page dedicated to
the [New Relic .NET agent](https://opensource.newrelic.com/projects/newrelic/newrelic-dotnet-agent).

## License
The .NET Agent is licensed under the [Apache 2.0](https://apache.org/licenses/LICENSE-2.0.txt) License.
The .NET Agent also uses source code from third-party libraries. You can find full details on which libraries are used and the terms under which they are licensed in the third-party notices document.
