# Copyright (c) 2021 - present / Neuralmagic, Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# flake8: noqa
# isort: skip_file

import os

from sparsezoo.utils.helpers import convert_to_bool

BASE_API_URL = (
    os.getenv("SPARSEZOO_API_URL")
    if os.getenv("SPARSEZOO_API_URL")
    else "https://api.neuralmagic.com"
)
MODELS_API_URL = f"{BASE_API_URL}/v2/models"
LATEST_PACKAGE_VERSION_URL = f"{BASE_API_URL}/packages/check-latest"

from .authentication import *
from .graph_editor import *
from .onnx import *
from .calculate_ops import *
from .data import *
from .download import *
from .helpers import *
from .node_inference import *
from .numpy import *
from .task_name import *
from .constants import *
