<!--
Copyright (c) 2021 - present / Neuralmagic, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Contributing to SparseZoo

If you’re reading this, hopefully we have piqued your interest to take the next step. Join us and help make SparseZoo even better! As a contributor, here are some community guidelines we would like you to follow:

- [Code of Conduct](#code-of-conduct)
- [Ways to Contribute](#ways-to-contribute)
- [Bugs and Feature Requests](#bugs-and-feature-requests)
- [Question or Problem](#question-or-problem)
- [Developing SparseZoo](DEVELOPING.md)

## Code of Conduct

Help us keep the software inclusive. Please read and follow our [Code of Conduct](CODE_OF_CONDUCT.md) in order to promote an environment that is friendly, fair, respectful, and safe. We want to inspire collaboration, innovation, and fun!

## Ways to Contribute

Whether you’re a newbie, dabbler, or expert, we appreciate you jumping in.

### Contributing Code

- Make pull requests for addressing bugs, open issues, and documentation
- Neural Magic as the maintainer will do reviews and final merge

### Reporting In

- See something, say something: bugs, documentation
- Propose new feature requests to Neural Magic

### Helping Others

- Answer open discussion topics
- Spread the word about SparseZoo
- Teach and empower others. This is the way!

## Bugs and Feature Requests

Please search through existing issues and requests first to avoid duplicates. Neural Magic will work with you further to take next steps.

- Go to: [GitHub Issues](https://github.com/neuralmagic/sparsezoo/issues)</br>

For bugs, include:

- brief summary
- OS/Environment details
- steps to reproduce (s.t.r.)
- code snippets, screenshots/casts, log content, sample models
- add the GitHub label "bug" to your post

For feature requests, including SparseZoo model additions, include:

- problem you’re trying to solve
- community benefits
- other relevant details to support your proposal
- add the GitHub label "enhancement" to your post

For documentation edits, include:

- current state, proposed state
- if applicable, screenshots/casts
- add the GitHub label "documentation" to your post

## Question or Problem

Sign up or log in to our [**Neural Magic Community Slack**](https://neuralmagic.com/community/). We are growing the community member by member and happy to see you there. Post all other questions including support or how to contribute. Don’t forget to search through existing discussions to avoid duplication! Thanks!

## Developing SparseZoo

Made it this far? Review [Developing SparseZoo](DEVELOPING.md) to get started.
