/*
 * Copyright (c) 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.networknt.schema.regex;

import static org.junit.jupiter.api.Assertions.assertTrue;

import org.graalvm.polyglot.Context;
import org.junit.jupiter.api.Test;

/**
 * GraalJSRegularExpressionFactoryTest.
 */
class GraalJSRegularExpressionFactoryTest {

    @Test
    void constructorContext() {
        try (Context context = Context.newBuilder("js").option("engine.WarnInterpreterOnly", "false")
                .build()) {
            GraalJSRegularExpressionFactory factory = new GraalJSRegularExpressionFactory(context);
            RegularExpression regex = factory.getRegularExpression("((?<OrgOID>[^,. ]+)\\s*\\.\\s*(?<AOID>[^,. ]+))(?:\\s*,\\s*)?");
            assertTrue(regex.matches("FFFF.12645,AAAA.6456"));
        }
    }

}
