# Neslib.Xml
Neslib.Xml is an ultra light-weight and cross-platform XML library for Delphi.

See [my post on Grijjy's blog](https://blog.grijjy.com/2020/10/07/an-xml-dom-with-just-8-bytes-per-node/) for information about the design and algorithms used in this library, and how it compares to other libraries.

## Installation and Dependencies

To install:

```shell
> git clone --recursive https://github.com/neslib/Neslib.Xml
```

This library only depends on the Neslib repository, which is included as submodule with this repository. Be sure to either clone this repository recursively or clone the [Neslib](https://github.com/neslib/Neslib) repository manually and add it to the search path.

## Documentation

The source files in this library are well documented and should provide enough information to get you started. The API is very similar to many other XML libraries, so if you are already familiar with one or more of those, then you should have no problems.

You can also take a look at the unit tests and performance tests, or check [my blog post](https://blog.grijjy.com/2020/10/07/an-xml-dom-with-just-8-bytes-per-node/) for additional information.

## Notable Forks

Frederic Schenckel has a [fork](https://github.com/fschenckel/Neslib.Xml) of this repository that adds an [XMLUtils](https://github.com/fschenckel/Neslib.Xml/tree/main/Helper) unit with several utilities that aid in (de)serializing XML.

## License

Neslib.Xml is licensed under the Simplified BSD License. 

See License.txt for details.