set(SEARCH_PATHS 
    ${CMAKE_CURRENT_SOURCE_DIR}/..
    ${CMAKE_CURRENT_SOURCE_DIR}/../..
)

find_file(PRODUCT_BUILD_NUMBER_FILE_PATH ProductBuildNumber.h
    PATHS ${SEARCH_PATHS}
    PATH_SUFFIXES Build/Inc
    NO_DEFAULT_PATH
    CMAKE_FIND_ROOT_PATH_BOTH
)

if(PRODUCT_BUILD_NUMBER_FILE_PATH)
    file(READ ${PRODUCT_BUILD_NUMBER_FILE_PATH} PRODUCT_BUILD_NUMBER_FILE)
    # Parse with regexp
    set(PRODUCT_BUILD_NUMBER_REGEX "#define VERINFO_MAJOR_VERSION ([0-9]+)\n#define VERINFO_MINOR_VERSION ([0-9]+)\n#define VERINFO_MODIFICATION_NUMBER ([0-9]+)\n#define VERINFO_BUILD_NUMBER ([0-9]+)")
    
    if(NOT PRODUCT_BUILD_NUMBER_FILE MATCHES "${PRODUCT_BUILD_NUMBER_REGEX}")
        message(FATAL_ERROR "Failed to parse ${PRODUCT_BUILD_NUMBER_FILE}")
    endif()

    set(FINE_VERSION_MAJOR "${CMAKE_MATCH_1}")
    set(FINE_VERSION_MINOR "${CMAKE_MATCH_2}")
    set(FINE_VERSION_PATCH "${CMAKE_MATCH_3}")
    set(FINE_VERSION_TWEAK "${CMAKE_MATCH_4}")

endif()

unset(SEARCH_PATHS)
unset(PRODUCT_BUILD_NUMBER_FILE_PATH)
unset(PRODUCT_BUILD_NUMBER_FILE_PATH)
