/* Copyright © 2017-2020 ABBYY Production LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
--------------------------------------------------------------------------------------------------------------*/

#include <common.h>
#pragma hdrstop

#include <NeoML/Dnn/Layers/QualityControlLayer.h>

namespace NeoML {

CQualityControlLayer::CQualityControlLayer( IMathEngine& mathEngine, const char* name ) :
	CBaseLayer( mathEngine, name, false ),
	needReset( true )
{
}

void CQualityControlLayer::Reshape()
{
	CheckInputs();
	CheckLayerArchitecture( inputDescs.Size() == 2, "layer expects 2 inputs" );
	CheckLayerArchitecture( inputDescs[0].ObjectCount() == inputDescs[1].ObjectCount(),
		"Object count mismatch between inputs" );
	CheckLayerArchitecture( inputDescs[0].ObjectSize() == inputDescs[1].ObjectSize() || inputDescs[1].ObjectSize() == 1,
		"Inputs' object sizes must match or the second one must be equal to 1" );
	CheckLayerArchitecture( !outputDescs.IsEmpty(), "There is nothing connected to this layer's output" );
}

void CQualityControlLayer::BackwardOnce()
{
	// This layer is usually placed after some learnable layers.
	// In order to learn those layers are requiring for gradient from all succeeding layers (including this one).
	inputDiffBlobs[0]->Clear();
}

void CQualityControlLayer::RunOnce()
{
	if( IsResetNeeded() ) {
		OnReset();
	}
	RunOnceAfterReset();
}

static const int QualityControlLayerVersion = 2000;

void CQualityControlLayer::Serialize( CArchive& archive )
{
	archive.SerializeVersion( QualityControlLayerVersion, CDnn::ArchiveMinSupportedVersion );
	CBaseLayer::Serialize( archive );
}

} // namespace NeoML
