# Класс CUpsampling2DLayer

<!-- TOC -->

- [Класс CUpsampling2DLayer](#класс-cupsampling2dlayer)
    - [Настройки](#настройки)
        - [Множитель высоты изображений](#множитель-высоты-изображений)
        - [Множитель ширины изображений](#множитель-ширины-изображений)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, увеличивающий размеры двумерных многоканальных изображений в несколько раз путём повторения пикселей.

## Настройки

### Множитель высоты изображений

```c++
void SetHeightCopyCount( int newHeightCopyCount );
```

### Множитель ширины изображений

```c++
void SetWidthCopyCount( int newHeightCopyCount );
```

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На каждый вход слоя подаётся блоб типа `float` или `int` с набором изображений:

- `BatchLength * BatchWidth * ListSize` - количество изображений в наборе;
- `Height` - высота изображений;
- `Width` - ширина изображений;
- `Depth * Channels` - количество каналов у изображений.

## Выходы

Для каждого входа соответствующий выход содержит блоб с увеличенным изображением. Каждый пиксель исходного изображения будет размножен по вертикали и горизонтали заданное число раз.

Блоб с результатами имеет следующие размеры:

- `BatchLength`, `BatchWidth`, `ListSize`, `Depth` и `Channels` равны соответствующим размерам у входа;
- `Height` увеличен в `GetHeightCopyCount()` раз относительно `Height` блоба входа;
- `Width` увеличен в `GetWidthCopyCount()` раз относительно `Width` блоба входа.
