# Класс CTransformLayer

<!-- TOC -->

- [Класс CTransformLayer](#класс-ctransformlayer)
    - [Настройки](#настройки)
        - [Изменения размера осей блоба](#изменения-размера-осей-блоба)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, изменяющий размеры блоба входа, не перемещая данные в памяти. Общее число элементов в блобе при этом сохраняется, поэтому произведение всех размерностей после трансформации должно оставаться неизменным.

## Настройки

### Изменения размера осей блоба

```c++
// Способы задания размера измерения.
enum TOperation {
    // Приписать этому измерению оставшиеся степени свободы.
    O_Remainder,
    // Установить размер Parameter.
    O_SetSize,
    // Умножить размер на Parameter.
    O_Multiply,
    // Поделить размер на Parameter.
    O_Divide
};

// Правило вычисления размера измерения.
struct NEOML_API CDimensionRule {
    // Способ задания размера измерения.
    TOperation Operation;
    // Параметр преобразования.
    int Parameter;

    CDimensionRule();
    CDimensionRule( TOperation op, int param );

    bool operator==( const CDimensionRule& other ) const;

    // Применяет преобразование.
    int Transform( int input ) const;
};

void SetDimensionRule( TBlobDim dim, const CDimensionRule& rule );
void SetDimensionRule( TBlobDim dim, TOperation op, int param );
```

Настройка изменения соответствующей оси блоба. Если для некоторой оси операция не задана, то ее размер останется неизменным. `O_Remainder` можно задать только одной размерности.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход принимается блоб любого типа данных и размера.

## Выходы

Единственный выход содержит блоб размера, определенного заданными правилами:

- размерности с операцией `O_SetSize` будут равны соответствующим `Parameter`;
- размерности с операцией `O_Multiply` будут больше в `Parameter` раз;
- размерности с операцией `O_Divide` будут меньше в `Parameter` раз;
- размерность с операцией `O_Remainder` будет таковой, чтобы размеры блобов входа и выхода совпадали.
