# Класс CSubSequenceLayer

<!-- TOC -->

- [Класс CSubSequenceLayer](#класс-csubsequencelayer)
    - [Настройки](#настройки)
        - [Начало подпоследовательности](#начало-подпоследовательности)
        - [Длина подпоследовательности](#длина-подпоследовательности)
        - [Развернуть последовательность](#развернуть-последовательность)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, выделяющий подпоследовательности в наборе последовательностей векторов.

## Настройки

### Начало подпоследовательности

```c++
void SetStartPos(int startPos);
```

Установка номера первого элемента в подпоследовательности.

Если `startPos >= 0` то позиция отсчитывается от начала исходной последовательности, где `0` означает первый элемент.

Если `startPos < 0` то позиция отсчитывается от конца последовательности, где `-1` означает последний элемент.

### Длина подпоследовательности

```c++
void SetLength(int length);
```

Установка длины подпоследовательности.

Если `length > 0` то подпоследовательность идет в том же порядке, что и исходная.

Если `length < 0` то подпоследовательность будет идти в порядке, обратном исходному. Длина подпоследовательности будет ограничена `abs(length)`.

### Развернуть последовательность

```c++
void SetReverse();
```

Установка таких значений `GetLength()` и `GetStartPos()`, что слой будет разворачивать входящие последовательности целиком, не меняя их длину.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается набор последовательностей объектов. Последовательность нумеруется по оси `BatchLength`.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength` равен минимуму из `abs(GetLength())` и максимальной возможной длины, при которой подпоследовательность не выходит за границы исходной;
- остальные размерности равны аналогичным у блоба входа.
