# Класс CSpaceToDepthLayer

<!-- TOC -->

- [Класс CSpaceToDepthLayer](#класс-cspacetodepthlayer)
    - [Настройки](#настройки)
        - [Размер блока](#размер-блока)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, разделяющий двумерные многоканальные изображения на блоки размера `k x k x Ch`, и записывающий содержимое таких блоков в соответствующие пиксели (`1 x 1 x Ch*k*kk`) выходных изображений в порядке channel-last.
В результате изображения размера `H x W x Ch` трансформируются в изображения размера `H/k x W/k x Ch*k*k`.

Является обратной операцией [CDepthToSpaceLayer](DepthToSpaceLayer.md).

## Настройки

### Размер блока

```c++
void SetBlockSize( int blockSize );
```

Установка размера блоков, на которые будут разбиваться входные изображения (`k` из описания слоя). Ширина и высота изображений должны быть кратны этому значению. Число должно быть больше `1`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подаётся блоб с набором изображений размера:

- `BatchLength * BatchWidth * ListSize` - количество изображений в наборе;
- `Height` - высота изображений, должна быть кратна `GetBlockSize()`;
- `Width` - ширина изображений, должна быть кратна `GetBlockSize()`;
- `Depth` равен `1`;
- `Channels` - количество каналов у изображений.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength` равен `BatchLength` входа;
- `BatchWidth` равен `BatchWidth` входа;
- `ListSize` равен `ListSize` входа;
- `Height` равен `Height / GetBlockSize()` входа;
- `Width` равен `Width / GetBlockSize()` входа;
- `Depth` равен `1`;
- `Channels` равен `Channels * GetBlockSize() * GetBlockSize()` входа.
