# Класс CScatterNDLayer

<!-- TOC -->

- [Класс CScatterNDLayer](#класс-cscatterndlayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, распределяющий новые значения (`updates`) между объектами блоба с данными (`data`):

```c++
for( int updateIndex = 0; updateIndex < UpdateCount; ++updateIndex )
    data[indices[updateIndex]] = updates[updateIndex];
```

где `indices[...]` это вектор целых чисел состоящий из `IndexDims` элементов, в котором записаны координаты в первых `IndexDims` размерностях блоба с данными.

## Настройки

Слой не имеет настроек.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 3 входа:

1. Данные. Множество объектов любого типа. Произведение первых `IndexDims` размерностей обозначает количество объектов во множестве (`ObjectCount`). Произведение остальных размерностей равно размеру одного объекта в множестве (`ObjectSize`).
2. Множество индексов новых объектов. Тип данных должен быть `CT_Int`. Ожидаемая форма:
- `BD_Channels` равен `IndexDims`
- произведение остальных размерностей должно быть равно `UpdateCount`.
3. Множество новых объектов. Тип данных должен совпадать с первым входом. Всего блоб должен содержать `UpdateCount * ObjectSize` элементов вне зависимости от формы.

## Выходы

Единственный выход содержит блоб того же типа и размера, что и первый вход, с обновленными данными.
