# Класс CReorgLayer

<!-- TOC -->

- [Класс CReorgLayer](#класс-creorglayer)
    - [Настройки](#настройки)
        - [Коэффициент уменьшения размеров изображения](#коэффициент-уменьшения-размеров-изображения)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, преобразующий набор двумерных многоканальных изображений в набор изображений меньшего размера с большим числом каналов. Используется в реализации архитектуры [YOLO](https://pjreddie.com/darknet/yolo/).

## Настройки

### Коэффициент уменьшения размеров изображения

```c++
void SetStride( int stride );
```

Установка того, во сколько раз будут уменьшены изображения. Число должно быть больше `1`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подаётся блоб с набором изображений размера:

- `BatchLength * BatchWidth * ListSize` - количество изображений в наборе;
- `Height` - высота изображений, должна быть кратна `GetStride()`;
- `Width` - ширина изображений, должна быть кратна `GetStride()`;
- `Depth` равен `1`;
- `Channels` - количество каналов у изображений.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength` равен `BatchLength` входа;
- `BatchWidth` равен `BatchWidth` входа;
- `ListSize` равен `ListSize` входа;
- `Height` равен `Height / GetStride()` входа;
- `Width` равен `Width / GetStride()` входа;
- `Depth` равен `1`;
- `Channels` равен `Channels * GetStride() * GetStride()` входа.

Каждое изображение набора разбивается согласно приведённому ниже образцу.

Пусть на вход пришло 2-канальное изображение высоты `4` и ширины `6` и `GetStride()` равен `2`. И пусть в изображении записаны следующие значения:

```c++
// Содержимое первого канала
1,  2,  3,  4,  5,  6,
7,  8,  9,  10, 11, 12,
13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24,

// Содержимое второго канала
25, 26, 27, 28, 29, 30,
31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42,
43, 44, 45, 46, 47, 48
```

Такое изображение будет преобразовано слоем в 8-канальное изображение высоты `2` и ширины `3` со следующим содержимым:

```c++
// Содержимое первого канала
1,  3,  5,
7,  9,  11,

// Содержимое второго канала
25, 27, 29,
31, 33, 35,

// Содержимое третьего канала
13, 15, 17,
19, 21, 23,

// Содержимое четвертого канала
37, 39, 41,
43, 45, 47

// Содержимое пятого канала
2,  4,  6,
8,  10, 12,

// Содержимое шестого канала
26, 28, 30,
32, 34, 36,

// Содержимое седьмого канала
14, 16, 18,
20, 22, 24,

// Содержимое восьмого канала
38, 40, 42,
44, 46, 48
```
