# Класс CPrecisionRecallLayer

<!-- TOC -->

- [Класс CPrecisionRecallLayer](#класс-cprecisionrecalllayer)
    - [Настройки](#настройки)
        - [Сброс статистики](#сброс-статистики)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Получение результатов](#получение-результатов)

<!-- /TOC -->

Класс реализует слой, подсчитывающий количество правильно классифицированных объектов обоих классов для бинарной классификации.

Зная эти данные, вы можете вычислить точность (*precision*) и полноту (*recall*) обученного классификатора. 

## Настройки

### Сброс статистики

```c++
void SetReset( bool value );
```

Включает и отключает сброс статистики между запусками. По умолчанию **включен**.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 входа.

На первый вход подается блоб с ответами сети размера:

- `BatchLength * BatchWidth * ListSize` равно числу объектов;
- остальные размерности равны `1`.

На второй вход подается блоб с правильной разметкой (`+1/-1`), имеющий те же размеры, что и блоб первого входа.

## Выходы

Единственный выход содержит блоб следующего размера:

- `Channels` равен `4`;
- остальные размерности равны `1`.

Значения четырёх элементов блоба:

1. Количество правильно классифицированных объектов класса `+1`.
2. Всего объектов класса `+1`.
3. Количество правильно классифицированных объектов класса `-1`.
4. Всего объектов класса `-1`.

Если `SetReset()` выключен, то слой **накапливает** статистику между запусками.

### Получение результатов

```c++
void GetLastResult( CArray<int>& results );
```

Записывает в массив 4 элемента статистики, в том же порядке, что и у блоба [выхода](#выходы).
