# Класс CConfusionMatrixLayer

<!-- TOC -->

- [Класс CConfusionMatrixLayer](#класс-cconfusionmatrixlayer)
    - [Настройки](#настройки)
        - [Сброс статистики](#сброс-статистики)
        - [Обнуление матрицы](#обнуление-матрицы)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, подсчитывающий матрицу ошибок (`Confusion Matrix`) для результатов классификации.

`Confusion Matrix` - это квадратная матрица размера, равного числу классов, которая по одной оси содержит правильные классы, по другой - ответы сети. Каждый элемент представляет собой число объектов, принадлежащих к классу соответствующего столбца и классифицированных сетью как класс соответствующей строки. При правильной классификации всех объектов матрица должна быть диагональной (все элементы не на диагонали равны `0`).

## Настройки

### Сброс статистики

```c++
void SetReset( const bool value );
```

Включает и отключает сброс статистики между запусками. По умолчанию **включен**. Если отключить эту настройку, матрица ошибок будет содержать суммарную информацию обо всех запусках с момента последнего сброса статистики.

### Обнуление матрицы

```c++
void ResetMatrix();
```

Сбрасывает статистику вручную.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 входа.

На первый вход подается блоб с ответами сети размера:

- `BatchLength * BatchWidth * ListSize` равно числу объектов;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` равно числу классов (и должно быть больше `1`).

На второй вход подается блоб с правильной разметкой, имеющий те же размеры, что и блоб первого входа.

## Выходы

Единственный выход содержит блоб размера:

- `BatchLength`, `BatchWidth`, `ListSize`, `Depth` и `Channels` равны `1`;
- `Height` и `Width` равны `Channels` входа.

Номер столбца в этой матрице означает предсказанный сетью класс объекта.

Номер строки - правильный класс объекта.

Если `SetReset()` выключен, то слой **накапливает** статистику между запусками.
