# Класс CProjectionPoolingLayer

<!-- TOC -->

- [Класс CProjectionPoolingLayer](#класс-cprojectionpoolinglayer)
    - [Настройки](#настройки)
        - [Размерность проецирования](#размерность-проецирования)
        - [Сохранение размера блоба](#сохранение-размера-блоба)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, выполняющий `Projection Pooling` над блобом.

`Projection Pooling` вычисляет средние значения вдоль одной из размерностей блоба.

## Настройки

### Размерность проецирования

```c++
// Projection dimension
void SetDimenion( TBlobDim dimension );
```

По умолчанию `BD_Width`.

### Сохранение размера блоба

```c++
void SetRestoreOriginalImageSize( bool flag );
```

Если `true` то выходной блоб будет иметь ту же форму, что и у входа, и средние значения будут скопированы вдоль размерности проецирования.
Если `false` то размерность проецирования у выходного блоба будет равна `1`.
По умолчанию `false`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб произвольного размера.

## Выходы

Единственный выход содержит блоб с результатами.

Если `GetRestoreOriginalImageSize` равен `true` то размер выхода будет равен размеру входа.

Иначе размерность проецирования у выхода будет равна `1`, а у остальных - аналогичным у входа.
