# Класс CPixelToImageLayer

<!-- TOC -->

- [Класс CPixelToImageLayer](#класс-cpixeltoimagelayer)
    - [Настройки](#настройки)
        - [Высота итогового изображения](#высота-итогового-изображения)
        - [Ширина итогового изображения](#ширина-итогового-изображения)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, строящий набор двумерных изображений на основе набора списков пикселей и их координат.

## Настройки

### Высота итогового изображения

```c++
void SetImageHeight( int newHeight );
```

### Ширина итогового изображения

```c++
void SetImageWidth( int newWidth );
```

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 входа.

На первый вход подаётся блоб с набором списков пикселей, размера:

- `BatchLength` равен `1`;
- `BatchWidth` - количество списков в наборе;
- `ListSize` - длина списков в наборе;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` - количество каналов, в которых заданы списки пикселей (столько же каналов будет у выходных изображений).

На второй вход подаётся блоб с данными типа `int`, содержащий списки координат пикселей и имеющий размеры:

- `BatchWidth` равен `BatchWidth` первого входа;
- `Channels` равен `ListSize` первого входа;
- остальные размерности равны `1`.

Координаты одного пикселя `(col, row)` представлены в этом блобе в виде одного `int` равного `row * GetImageWidth() + col`.

## Выходы

Единственный выход содержит блоб размера:

- `BatchLength` равен `1`;
- `BatchWidth` равен `BatchWidth` входов;
- `ListSize` равен `1`;
- `Height` равен `GetImageHeight()`;
- `Width` равен `GetImageWidth()`;
- `Depth` равен `1`;
- `Channels` равен `Channels` первого входа.

Блоб содержит набор изображений, в пикселях которых записаны соответствующие значения из списков. Пиксели, для которых не передавались значения во входах, будут заполнены нулями.
