# Класс CObjectNormalizationLayer

<!-- TOC -->

- [Класс CObjectNormalizationLayer](#класс-cobjectnormalizationlayer)
    - [Настройки](#настройки)
        - [Epsilon](#epsilon)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Множители](#множители)
        - [Сдвиг](#сдвиг)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, нормализующий данные по объектам:

```c++
objectNorm(x)[i][j] = ((x[i][j] - mean[i]) / sqrt(var[i] + epsilon)) * scale[j] + bias[j]
```

где:

- `scale` и `bias` - обучаемые параметры;
- `mean` и `var` - среднее и дисперсия по каждому из объектов в батче.

## Настройки

### Epsilon

```c++
void SetEpsilon( float newEpsilon );
```

Установить значение `epsilon`, прибавляемое к дисперсии для того, чтобы избежать деления на 0.

## Обучаемые параметры

### Множители

```c++
CPtr<CDnnBlob> GetScale() const;
```

Получение вектора обучаемых множетелей. Блоб произвольной формы, суммарного размера `Height * Width * Depth * Channels` входа.

### Сдвиг

```c++
CPtr<CDnnBlob> GetBias() const;
```

Получение вектора обучаемого сдвига. Блоб произвольной формы, суммарного размера `Height * Width * Depth * Channels` входа.

## Входы

На единственный вход подаётся блоб, содержащий `BatchLength * BatchWidth * ListSize` объектов размера `Height * Width * Depth * Channels`.

## Выходы

Единственный выход содержит блоб с результатами, того же размера, что и входной блоб.
