# Класс CLstmLayer

<!-- TOC -->

- [Класс CLstmLayer](#класс-clstmlayer)
    - [Настройки](#настройки)
        - [Размер скрытого слоя](#размер-скрытого-слоя)
        - [Variational dropout](#variational-dropout)
        - [Функция активации](#функция-активации)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов](#матрица-весов)
        - [Свободные члены](#свободные-члены)
    - [Входы](#входы)
        - [Размер первого входа](#размер-первого-входа)
        - [Размеры остальных входов](#размеры-остальных-входов)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой [LSTM](https://en.wikipedia.org/wiki/Long_short-term_memory), применяющийся к набору последовательностей векторов.

Результатом операции является последовательность векторов той же длины, каждый вектор в которой имеет размер `GetHiddenSize()`.

## Настройки

### Размер скрытого слоя

```c++
void SetHiddenSize(int size);
```

Установить размер скрытого слоя. Это значение влияет на размер выхода и размер вектора состояния внутри LSTM.

### Variational dropout

```c++
void SetDropoutRate(float newDropoutRate);
```

Установить вероятность зануления входного состояния. Если это значение задано, операция будет выполнена над объединением входных данных с результатом последнего запуска, до передачи данных в полносвязный слой.

### Функция активации

```c++
void SetRecurrentActivation( TActivationFunction newActivation );
```

Установить функцию активации, используемую в `forget`, `reset` и `input` гейтах. По умолчанию используется `AF_Sigmoid`.

## Обучаемые параметры

### Матрица весов

```c++
CPtr<CDnnBlob> GetWeightsData() const;
```

Матрица весов, содержащая веса сразу для всех гейтов, представляет собой [блоб](DnnBlob.md) размеров:

- `BatchLength * BatchWidth * ListSize`, равный `4 * GetHiddenSize()`;
- `Height * Width * Depth * Channels`, равный сумме аналогичного размера у входа и `GetHiddenSize()`.

Вдоль оси `BatchLength * BatchWidth * ListSize` матрица содержит веса гейтов в следующем порядке:

```c++
G_Main = 0, // Основной выход - данные
G_Forget,   // Forget gate
G_Input,    // Input gate
G_Reset,    // Reset gate
```

Вдоль оси `Height * Width * Depth * Channels` матрица содержит следующие веса:

- от `0` до произведения размеров входа идут веса, которые перемножаются с векторами из входной последовательности;
- остальные `HiddenSize` координат отвечают за веса, которые перемножаются с результатами прошлого шага.

### Свободные члены

```c++
CPtr<CDnnBlob> GetFreeTermData() const
```

Свободные члены представляют собой блоб, имеющий суммарный размер, равный `4 * GetHiddenSize()`. Порядок относительно гейтов см. [выше](#матрица-весов).

## Входы

Слой имеет от 1 до 3 входов:

1. Набор входных последовательностей векторов.
2. *[Опционально]* Начальное состояние LSTM слоя. Будет использовано в качестве состояния слоя перед первым шагом. Если вход не задан, то будет заполнено нулями.
3. *[Опционально]* Начальное последнее возвращенное значение. Будет использовано в качестве последнего возвращенного значения перед первым шагом. Если вход не задан, то будет заполнено нулями.

### Размеры первого входа

- `BatchLength` - длина последовательности;
- `BatchWidth` - количество последовательностей в наборе;
- `ListSize` должен быть равен `1`.
- `Height * Width * Depth * Channels` - размер векторов в последовательностях.

### Размеры остальных входов

- `BatchLength` и `ListSize` должны быть равны `1`;
- `BatchWidth` должен быть равен `BatchWidth` у первого входа;
- `Height * Width * Depth * Channels` должно быть равно `GetHiddenSize()`.

## Выходы

Слой имеет 2 выхода:

1. Результат работы LSTM.
2. История состояний LSTM.

Оба выхода имеют следующие размеры:

- `BatchLength` и `BatchWidth` равный соответствующим у первого входа;
- `ListSize`, `Height`, `Width` и `Depth` равные `1`;
- `Channels` равный `GetHiddenSize()`.