# Класс CSquaredHingeLossLayer

<!-- TOC -->

- [Класс CSquaredHingeLossLayer](#класс-csquaredhingelosslayer)
    - [Настройки](#настройки)
        - [Вес слоя](#вес-слоя)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий модифицированную функцию потерь `SquaredHinge` для бинарной классификации.

Формула:

```c++
loss = -4 * x * y                при x * y < -1
loss = sqr(max(0, 1 - x * y))    при x * y >= -1
```

где:

- `x` - ответ сети;
- `y` - правильный класс (`1` или `-1`).

## Настройки

### Вес слоя

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()`, будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 или 3 входа:

1. Ответы сети, на которых необходимо вычислить функцию потерь. Содержит распределения вероятностей принадлежности `BatchLength * BatchWidth * ListSize` объектов над `Height * Width * Depth * Channels` классами. Необходимо, чтобы сумма по `Height * Width * Depth * Channels` для каждого объекта была равна `1`, и все элементы были неотрицательными.
2. Метки классов в одном из двух видов:
    * либо в виде блоба с данными типа `float`, имеющего те же размеры, что и блоб у первого входа. Этот блоб должен быть заполнен `0` и содержать `1` в координатах тех классов, к которым принадлежат соответствующие объекты.
    * либо в виде блоба с данными типа `int`, у которого `BatchLength`, `BatchWidth` и `ListSize` равны аналогичным у первого входа, а остальные размерности равны `1`. Каждый объект в блобе содержит номер класса, к которому принадлежит этот объект.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же `BatchLength`, `BatchWidth` и `ListSize`, что и у первого входа. `Height`, `Width`, `Depth` и `Channels` должны быть равны `1`.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
