# Класс CL1LossLayer

<!-- TOC -->

- [Класс CL1LossLayer](#класс-cl1losslayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию потерь, равную L1 расстоянию между объектами из ответа сети и объектами из правильных ответов.

## Настройки

Слой не имеет настроек.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 или 3 входа:

1. Ответы сети, на которых необходимо вычислить функцию потерь. Содержит `BatchLength * BatchWidth * ListSize` объектов размера `Height * Width * Depth * Channels`.
2. Правильные ответы в виде блоба того же размера, что и блоб у первого входа. Функция потерь равняется расстояниям между объектами из первого входа и второго.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же `BatchLength`, `BatchWidth` и `ListSize`, что и у первого входа. `Height`, `Width`, `Depth` и `Channels` должны быть равны `1`.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
