# Класс CFocalLossLayer

<!-- TOC -->

- [Класс CFocalLossLayer](#класс-cfocallosslayer)
    - [Настройки](#настройки)
        - [Сила фокусировки](#сила-фокусировки)
        - [Вес слоя](#вес-слоя)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию потерь `Focal` для многоклассовой классификации.

Эта функция потерь является модификацией кросс-энтропии, в которой уменьшен штраф легко разделяемым объектам. Это позволяет сконцентрировать обучение на разделении похожих примеров из разных классов.

Формула:

```c++
loss = -pow(1 - x_right, focalForce) * log(x_right)
```

где:

- `x_right` - элемент ответа сети, обозначающий вероятность принадлежности объекта классу.

## Настройки

### Сила фокусировки

```c++
void SetFocalForce( float value );
```

Установка силы фокусировки на похожих объектах. Это значение должно быть больше `0`. Чем оно больше, тем сильнее фокусировка. По умолчанию равно `2`.

### Вес слоя

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()`, будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 или 3 входа.

1. Ответы сети, на которых необходимо вычислить функцию потерь. Содержит распределения вероятностей принадлежности `BatchLength * BatchWidth * ListSize` объектов над `Height * Width * Depth * Channels` классами. Необходимо, чтобы сумма по `Height * Width * Depth * Channels` для каждого объекта была равна `1`, и все элементы были неотрицательными.
2. Метки классов в одном из двух видов:
    * либо в виде блоба с данными типа `float`, имеющий те же размеры, что и блоб у первого входа. Этот блоб должен быть заполнен `0` и содержать `1` в координатах тех классов, к которым принадлежат соответствующие объекты.
    * либо в виде блоба с данными типа `int`, имеющий `BatchLength`, `BatchWidth` и `ListSize`, равные аналогичным у первого входа, и остальные размерности, равные `1`. Каждый объект в блобе содержит номер класса, к которому принадлежит этот объект.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же `BatchLength`, `BatchWidth` и `ListSize`, что и у первого входа. `Height`, `Width`, `Depth` и `Channels` должны быть равны `1`.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
