# Класс CCenterLossLayer

<!-- TOC -->

- [Класс CCenterLossLayer](#класс-ccenterlosslayer)
    - [Настройки](#настройки)
        - [Количество классов](#количество-классов)
        - [Скорость сходимости центров классов](#скорость-сходимости-центров-классов)
        - [Вес слоя](#вес-слоя)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Центры классов](#центры-классов)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, штрафующий большой разброс внутри объектов одного класса. Более подробное описание см. в [статье](http://ydwen.github.io/papers/WenECCV16.pdf).

Слой не решает какую-либо задачу сам по себе, однако полезен как дополнительная функция потерь.

## Настройки

### Количество классов

```c++
void SetNumberOfClasses( int numberOfClasses );
```

### Скорость сходимости центров классов

```c++
void SetClassCentersConvergenceRate( float classCentersConvergenceRate );
```

Устанавливает коэффициент при скользящем среднем, с помощью которого будут вычисляться центры классов на каждой последующей итерации. Это значение должно быть в пределах от 0 до 1.

### Вес слоя

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()` будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

### Центры классов

```c++
CPtr<const CDnnBlob> GetClassCenters();
```

Получение центров классов, которые были подсчитаны во время работы слоёв. Блоб представляет собой матрицу, состоящую из `GetNumberOfClasses()` строк, длиной `Height * Width * Depth * Channels` (относительно блоба первого входа).

## Входы

Слой имеет 2 или 3 входа:

1. Ответы сети, на которых необходимо вычислить функцию потерь.
2. Метки классов в виде блоба с данными типа `int`, у которого `BatchLength`, `BatchWidth` и `ListSize` равны аналогичным у первого входа, а остальные размерности равны `1`. Каждый объект в блобе содержит номер класса, к которому принадлежит этот объект.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же `BatchLength`, `BatchWidth` и `ListSize`, что и у первого входа. `Height`, `Width`, `Depth` и `Channels` должны быть равны `1`.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
