# Класс CBinaryFocalLossLayer

<!-- TOC -->

- [Класс CBinaryFocalLossLayer](#класс-cbinaryfocallosslayer)
    - [Настройки](#настройки)
        - [Сила фокусировки](#сила-фокусировки)
        - [Вес слоя](#вес-слоя)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию потерь `Focal` для бинарной классификации.

Эта функция потерь является модификацией кросс-энтропии, уменьшающей штраф легко разделяемым объектам и позволяющей сконцентрировать обучение на разделении похожих примеров из разных классов.

Формула:

```c++
loss = -pow(sigmoid(-y*x), focalForce) * log(1 + e^(-y*x))
```

где:

- `x` - ответ сети;
- `y` - правильный класс (`1` или `-1`).

## Настройки

### Сила фокусировки

```c++
void SetFocalForce( float value );
```

Установка силы фокусировки на похожих объектах. Это значение должно быть больше `0`. Чем оно больше, тем сильнее фокусировка. По умолчанию равно `2`.

### Вес слоя

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()`, будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 или 3 входа:

1. Ответы сети, на которых необходимо вычислить функцию потерь. Размерности `Height`, `Width`, `Depth` и `Channels` у этого входа должны быть равны `1`.
2. Метки классов (`-1` или `1`). Блоб этого входа должен иметь те же размеры, что и у первого входа.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же размеры, что и у первого входа.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
