# Класс CBinaryCrossEntropyLossLayer

<!-- TOC -->

- [Класс CBinaryCrossEntropyLossLayer](#класс-cbinarycrossentropylosslayer)
    - [Настройки](#настройки)
        - [Вес положительного класса](#вес-положительного-класса)
        - [Вес слоя](#вес-слоя)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий кросс-энтропию для бинарной классификации.

Формула:

```c++
loss = y * -log(sigmoid(x)) + (1 - y) * -log(1 - sigmoid(x))
```

где:

- `x` - ответ сети;
- `y` - правильный класс (`1` или `-1`).

Обратите внимание, что внутри слоя вычисляется функция `sigmoid`, поэтому не рекомендуется подсоединять первый вход этого слоя к другой `sigmoid`.

## Настройки

### Вес положительного класса

```c++
void SetPositiveWeight( float value );
```

Настройка множителя у слагаемого, отвечающего за объекты с правильным ответом `1`. Позволяет обучать сеть с большим акцентом на `precision` (при `value < 1`) или на `recall` (при `value > 1`). По умолчанию равен `1`.

### Вес слоя

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()`, будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 или 3 входа:

1. Ответы сети, на которых необходимо вычислить функцию потерь. Размерности `Height`, `Width`, `Depth` и `Channels` у этого входа должны быть равны `1`.
2. Метки классов (`-1` или `1`). Блоб этого входа должен иметь те же размеры, что и у первого входа.
3. *[Опционально]* Веса объектов. Блоб этого входа должен иметь те же размеры, что и у первого входа.

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
