# Класс CIrnnLayer

<!-- TOC -->

- [Класс CIrnnLayer](#класс-cirnnlayer)
    - [Настройки](#настройки)
        - [Размер скрытого слоя](#размер-скрытого-слоя)
        - [Множитель единичной матрицы](#множитель-единичной-матрицы)
        - [Стандартное отклонение для FC_input](#стандартное-отклонение-для-fc_input)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов FC_input](#матрица-весов-fc_input)
        - [Свободные члены FC_input](#свободные-члены-fc_input)
        - [Матрица весов FC_recur](#матрица-весов-fc_recur)
        - [Свободные члены FC_recur](#свободные-члены-fc_recur)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой IRNN из [статьи](https://arxiv.org/pdf/1504.00941.pdf).

Это простой рекуррентный слой со следующей формулой:

```c++
    Y_t = ReLU( FC_input( X_t ) + FC_recur( Y_t-1 ) )
```

где `FC_*` - это полносвязные слои.

Основной особенностью этого слоя является инициализация весов.

Матрица весов `FC_input` инициализируется из нормального распределения `N(0, inputWeightStd)`, где `inputWeightStd` - настраиваемый параметр.

Матрица весов `FC_recur` инициализируется единичной матрицей, домноженной на настраиваемый параметр `identityScale`.

## Настройки

### Размер скрытого слоя

```c++
void SetHiddenSize( int size );
```

Установить размер скрытого слоя. Это значение влияет на размер выхода.

### Множитель единичной матрицы

```c++
void SetIdentityScale( float scale );
```

Установить множитель единичной матрицы, используемой при инициализации матрицы рекуррентной части.

### Стандартное отклонение для FC_input

```c++
void SetInputWeightStd( float var );
```

Установить стандартного отклонения нормального распределения, используемого при инициализации матрицы весов `FC_input`.

## Обучаемые параметры

### Матрица весов FC_input

```c++
CPtr<CDnnBlob> GetInputWeightsData() const;
```

Матрица весов слоя `FC_input` из формулы, представляет собой [блоб](DnnBlob.md) размеров:

- `BatchLength * BatchWidth * ListSize` равно `GetHiddenSize()`;
- `Height * Width * Depth * Channels` равно произведению аналогичных размеров у входа.

### Свободные члены FC_input

```c++
CPtr<CDnnBlob> GetInputFreeTermData() const
```

Свободные члены слоя `FC_input` представляют собой блоб, имеющий суммарный размер равный `GetHiddenSize()`.

### Матрица весов FC_recur

```c++
CPtr<CDnnBlob> GetRecurWeightsData() const;
```

Матрица весов слоя `FC_recur` из формулы, представляет собой блоб размеров:

- `BatchLength * BatchWidth * ListSize` равно `GetHiddenSize()`;
- `Height * Width * Depth * Channels` равно `GetHiddenSize()`.

### Свободные члены FC_recur

```c++
CPtr<CDnnBlob> GetRecurrentFreeTermData() const
```

Свободные члены слоя `FC_recur` представляют собой блоб, имеющий суммарный размер равный `GetHiddenSize()`.

## Входы

На единственный вход подается блоб с набором последовательностей векторов следующего размера:

- `BatchLength` - длина последовательностей в наборе;
- `BatchWidth * ListSize` - количество последовательностей в наборе;
- `Height * Width * Depth * Channels` - размер векторов в последовательностях.

## Выходы

Единственный выход содержит блоб следующего размера:

- `BatchLength`, `BatchWidth` и `ListSize` равны соответствующим размерностям у первого входа;
- `Height`, `Width` и `Depth` равны `1`.
- `Channels` равен `GetHiddenSize()`.
