# Класс CInterpolationLayer

<!-- TOC -->

- [Класс CInterpolationLayer](#класс-cinterpolationlayer)
    - [Настройки](#настройки)
        - [Размеры осей](#размеры-осей)
        - [Система координат](#система-координат)
        - [Округление координат](#округление-координат)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, который изменяет некоторые из рамерностей блоба в несколько раз.
Новые элементы заполняются на основе интерполяции значений из входного блоба.

На данный момент поддержана только линейная интерполяция.

## Настройки

### Размеры осей

```c++
void SetRule( TBlobDim dim, const CRule& rule );
```

Устанавливает правило, как будет изменена размерность блоба `dim`.

Для изменения размерности блоба рекомендуется пользоваться следующими функциями:

- `CInterpolationLayer::CRule::Resize( int newSize )` для изменения оси к фиксированному размеру `newSize`
- `CInterpolationLayer::CRule::Scale( float scale )` для домножения размера оси на коэффициент

По умолчанию размерности блоба не изменяются.

### Система координат

```c++
void SetCoords( TInterpolationCoords newCoords );
```

Задаёт режим подсчета координат новых элементов `xNew` относительно старых `xOld`.

Имеет следующие занчения:
- `TInterpolationCoords::HalfPixel` - `xOld = ( xNew + 0.5 ) / scale - 0.5`
- `TInterpolationCoords::PytorchHalfPixel` - `xOld = ( newSize > 1 ) ? ( xNew + 0.5 ) / scale - 0.5 : 0`
- `TInterpolationCoords::AlignCorners` - `xOld = xNew * ( oldSize - 1 ) / ( newSize - 1 )`
- `TInterpolationCoords::Asymmetric` - `xOld = xNew / scale`
где:
- `oldSize` и `newSize` - размеры оси до и после преобразования
- `scale` - коэффициент, на который домножается размер оси (`newSize / oldSize` в случае фиксированного размера)

По умолчанию `TInterpolationCoords::Asymmetric`.

### Округление координат

```c++
void SetRound( TInterpolationRound newRound );
```

Задает правило округления координат `xOld`. Если используется, то значения в результате всегда будут элементами из исходного массива, а не интерполяцией.

Имеет следующие значения:
- `TInterpolationRound::None` - не округлять, считать инетрполированные значения
- `TInterpolationRound::RoundPreferFloor` - значения меньше либо равные половине округляются в меньшую сторону
- `TInterpolationRound::RoundPreferCeil` - значения меньше половины округляются в меньшую стороны
- `TInterpolationRound::Floor` - ненулевая нецелая часть обнуляется
- `TInterpolationRound::Ceil` - ненулевая нецелая часть округляется вверх.

По умолчанию не используется (`TInterpolationRound::None`).

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб произвольного размера.

## Выходы

Единственный вход содержит блоб, каждая размерность `dim` которого считается в соответствии `GetRule( dim )`.
