# Класс CIndRnnLayer

<!-- TOC -->

- [Класс CIndRnnLayer](#класс-cindrnnlayer)
    - [Настройки](#настройки)
        - [Размер скрытого слоя](#размер-скрытого-слоя)
        - [Вероятность зануления](#вероятность-зануления)
        - [Порядок последовательностей](#порядок-последовательностей)
        - [Функция активации](#функция-активации)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов W](#матрица-весов-w)
        - [Вектор весов U](#вектор-весов-u)
        - [Свободные члены B](#свободные-члены-b)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой IndRNN из [статьи](https://arxiv.org/pdf/1803.04831.pdf).

Это простой рекуррентный слой со следующей формулой:

```c++
    Y_t = activation( W * X_t + B + U * Y_t-1 )
```

где:

- `W` и `B` матрица весов и вектор свободных членов полносвязного слоя (`W * X-t` это умножение матрицы на вектор)
- `U` вектор весов рекуррентной части (`U * Y_t-1` это поэлементное прозведение двух векторов одинаковой длины)
- `activation` - функция активации (`sigmoid` или `ReLU`)

## Настройки

### Размер скрытого слоя

```c++
void SetHiddenSize( int size );
```

Установить размер скрытого слоя. Это значение влияет на размер выхода.

### Вероятность зануления

```c++
void SetDropoutRate( float dropoutRate );
```

Установить вероятность зануления входа (`X_t`) и рекуррентной части (`Y_t-1`).

### Порядок последовательностей

```c++
void SetReverseSequence( bool reverse );
```

Если флаг установлен, то элементы последовательностей будут обрабатываться в обратном порядке.

### Функция активации

```c++
void SetActivation( TActivationFunction activation );
```

Устанавливает функцию активации, используемую в рекуррентной части. По умолчанию `AF_Sigmoid`.

## Обучаемые параметры

### Матрица весов W

```c++
CPtr<CDnnBlob> GetInputWeights() const;
```

Матрица весов `W` из формулы представляет собой [блоб](DnnBlob.md) размеров:

- `BatchLength * BatchWidth * ListSize` равно `GetHiddenSize()`
- `Height * Width * Depth * Channels` равно произведению аналогичных размеров у входа.

### Вектор весов U

```c++
CPtr<CDnnBlob> GetRecurrentWeights() const;
```

Вектор весов `U` из формулы представляет собой блоб, имеющий суммарный размер равный `GetHiddenSize()`.

### Свободные члены B

```c++
CPtr<CDnnBlob> GetBias() const
```

Свободные члены `B` из формулы представляют собой блоб, имеющий суммарный размер равный `GetHiddenSize()`.

## Входы

На единственный вход подается блоб с набором последовательностей векторов следующего размера:

- `BatchLength` - длина последовательностей в наборе;
- `BatchWidth * ListSize` - количество последовательностей в наборе;
- `Height * Width * Depth * Channels` - размер векторов в последовательностях.

## Выходы

Единственный выход содержит блоб следующего размера:

- `BatchLength`, `BatchWidth` и `ListSize` равный соответствующим размерностям у первого входа;
- `Height`, `Width` и `Depth` равные `1`.
- `Channels` равный `GetHiddenSize()`.
