# Класс CImageToPixelLayer

<!-- TOC -->

- [Класс CImageToPixelLayer](#класс-CImageToPixelLayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, извлекающий из набора двумерных изображений набор списков пикселей по заданным координатам.

## Настройки

Слой не имеет настроек.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет 2 входа.

На первый вход подаётся блоб с данными типа `float` или `int` с набором двумерных изображений, размера:

- `BatchLength` равен `1`;
- `BatchWidth` - количество списков в наборе;
- `ListSize` равен `1`;
- `Height` - высота изображений;
- `Width` - ширина изображений;
- `Depth` равен `1`;
- `Channels` - количество каналов у изображений.

На второй вход подаётся блоб с данными типа `int`, содержащий списки координат пикселей и имеющий размеры:

- `BatchWidth` равен `BatchWidth` первого входа;
- `Channels` - длина списков пикселей;
- остальные размерности равны `1`.

Координаты одного пикселя `(col, row)` представлены в этом блобе в виде одного `int` равного `row * GetImageWidth() + col`.

## Выходы

Единственный выход содержит блоб с данными того же типа что и первый вход, с набором списков пикселей размера:

- `BatchLength` равен `1`;
- `BatchWidth` равен `BatchWidth` входов;
- `ListSize` равен `ListSize` второго входа;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` равен `Channels` первого входа.

Блоб содержит списки пикселей из изображений, построенных на основе координат из второго входа.
