# Класс CImageResizeLayer

<!-- TOC -->

- [Класс CImageResizeLayer](#класс-cimageresizelayer)
    - [Настройки](#настройки)
        - [Изменения размера](#изменения-размера)
        - [Значения в новых пикселях](#значения-в-новых-пикселях)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, меняющий размеры в наборе двумерных многоканальных изображений.

## Настройки

### Изменения размера

```c++
// Сторона, по которой происходит изменение.
enum TImageSide {
    IS_Left = 0, // левый край
    IS_Right, // правый край
    IS_Top, // верх
    IS_Bottom, // низ

    IS_Count,
};

void SetDelta( TImageSide side, int delta );
```

Установка изменения размера относительно края изображения. Отрицательные значения удаляют соответствующее число строк/столбцов изображения. Положительные - прибавляют. По умолчанию `0`.

### Заполнение новых пикселей

```c++
// Способы заполнения новых элементов
enum class TBlobResizePadding {
	Constant, // заполнение фиксированным значением
	Edge, // заполнение значением из ближайшего пикселя оригинального изображения
	Reflect // заполнение отраженными значениями оригинального изображения
};

void SetPadding( TBlobResizePadding newPadding );
```

Установка алгоритма заполнения новых пикселей. По умолчанию `Constant`.

* `Constant` - заполняет новые элементы `GetDefaultValue()`.
* `Edge` - заполняет новые элементы значениями из ближайшего пикселия оригинального изображения
```
             1 1 2 3 3
1 2 3        1 1 2 3 3
4 5 6   ->   4 4 5 6 6
7 8 9        7 7 8 9 9
             7 7 8 9 9
```
* `Reflect` - заполняет новые элементы путём отражения оригинального изображения
```
             5 4 5 6 5
1 2 3        2 1 2 3 2
4 5 6   ->   5 4 5 6 5
7 8 9        8 7 8 9 8
             5 4 5 6 5
```

### Значения в новых пикселях

```c++
void SetDefalutValue( float value );
```

Установка значения, которым будут заполнены новые строки/столбцы изображений. По умолчанию `0`. Используется только когда `GetPadding()` равен `Constant`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с набором изображений:

- `BatchLength * BatchWidth * ListSize` - количество изображений в наборе;
- `Height` - высота изображений;
- `Width` - ширина изображений;
- `Depth * Channels` - количество каналов у изображений.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength`, `BatchWidth`, `ListSize`, `Depth` и `Channels` равны соответствующим размерностям входа;
- `Height` результата равен `Height + GetDelta( IS_Top ) + GetDelta( IS_Bottom )` относительно входа;
- `Width` результата равен `Width + GetDelta( IS_Left ) + GetDelta( IS_Right )` относительно входа.
