# Класс CProblemSourceLayer

<!-- TOC -->

- [Класс CProblemSourceLayer](#класс-cproblemsourcelayer)
    - [Настройки](#настройки)
        - [Данные, передаваемые в сеть](#данные-передаваемые-в-сеть)
        - [Количество векторов в наборе](#количество-векторов-в-наборе)
        - [Значения в пропусках](#значения-в-пропусках)
        - [Тип данных для меток](#тип-данных-для-меток)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, передающий данные из [`IProblem`](../../ClassificationAndRegression/Problems.md) в сеть.

## Настройки

### Данные, передаваемые в сеть

```c++
void SetProblem(const CPtr<const IProblem>& problem);
```

Установка `IProblem`, данные из которой будут передаваться в сеть.

### Количество векторов в наборе

```c++
void SetBatchSize(int batchSize);
```

Установка количества векторов передаваемых из `GetProblem()` в сеть при одном запуске.

На первом запуске будут переданы первые `GetBatchSize()` векторов из `IProblem`. На втором запуске - следующие `GetBatchSize()` векторов и т.д.
После передачи последнего вектора `IProblem` слой снова передаст первый вектор из `IProblem` и т.д.

### Значения в пропусках

```c++
void SetEmptyFill(float emptyFill);
```

Установка значений, которые будут записываться в пропуски в векторах данных. Это связано с тем, что в `IProblem` данные хранятся в разреженном виде. По умолчанию равен `0`.

### Тип данных для меток

```c++
void SetLabelType( TDnnType newLabelType );
```

Установка типа данных, в котором будут возвращаться классы векторов.

## Обучаемые параметры

Слой не имеет обучаемых паарметров.

## Входы

Слой не имеет входов.

## Выходы

Слой имеет 3 выхода.

Первый выход содержит блоб с векторами из `IProblem` размера:

- `BatchWidth` равен `GetBatchSize()`;
- `Chahhels` равен размеру векторов в `GetProblem()`;
- остальные размерности равны `1`.

Второй выход содержит блоб с классами векторов из `IProblem` с данными типа `GetLabelType()` размера:

- `BatchWidth` равен `GetBatchSize()`;
- `Channels` равен `1` если блоб имеет тип данных `int`, иначе `Channels` равен числу классов из `IProblem`;
- остальные размерности равны `1`.

Третий выход содержит блоб с весами векторов из `IProblem` размера:

- `BatchWidth` равен `GetBatchSize()`;
- остальные размерности равны `1`.
