# Класс CFullyConnectedSourceLayer

<!-- TOC -->

- [Класс CFullyConnectedSourceLayer](#класс-cfullyconnectedsourcelayer)
    - [Настройки](#настройки)
        - [Данные передаваемые в сеть](#данные-передаваемые-в-сеть)
        - [Количество векторов в наборе](#количество-векторов-в-наборе)
        - [Максимальное количество батчей в памяти](#максимальное-количество-батчей-в-памяти)
        - [Тип данных для меток](#тип-данных-для-меток)
        - [Число элементов](#число-элементов)
        - [Зануление свободных членов](#зануление-свободных-членов)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов](#матрица-весов)
        - [Свободные члены](#свободные-члены)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, передающий данные из [`IProblem`](../../ClassificationAndRegression/Problems.md) в сеть, домножая вектора из `IProblem` на обучаемую матрицу весов.

Слой является более эффективной реализации пары [CProblemSourceLayer](ProblemSourceLayer.md) + [CFullyConnectedLayer](../FullyConnectedLayer.md).

## Настройки

### Данные передаваемые в сеть

```c++
void SetProblem(const CPtr<const IProblem>& problem);
```

Установка `IProblem`, данные из которой будут передаваться в сеть.

### Количество векторов в наборе

```c++
void SetBatchSize(int batchSize);
```

Установка количества векторов передаваемых из `GetProblem()` в сеть при одном запуске.

На первом запуске будут переданы первые `GetBatchSize()` векторов из `IProblem`. На втором запуске - следующие `GetBatchSize()` векторов и т.д.
После передачи последнего вектора `IProblem` слой снова передаст первый вектор из `IProblem` и т.д.

### Максимальное количество батчей в памяти

```c++
void SetMaxBatchCount( int newMaxBatchCount );
```

Установка максимального количества батчей, хранимых в памяти. По умолчанию равен `0`, что означает загрузку в память всех данных из `GetProblem()`.

### Тип данных для меток

```c++
void SetLabelType( TDnnType newLabelType );
```

Установка типа данных, в котором будут возвращаться классы векторов.

### Число элементов

```c++
void SetNumberOfElements(int newNumberOfElements);
```

### Зануление свободных членов

```c++
void SetZeroFreeTerm(bool _isZeroFreeTerm);
```

Использовать ли вектор свободных членов. Если вектор не используется, то его содержимое заполняется нулями и он не обучается.

## Обучаемые параметры

### Матрица весов

```c++
CPtr<CDnnBlob> GetWeightsData() const;
```

Матрица весов представляет собой [блоб](../DnnBlob.md) размера:

- `BatchLength * BatchWidth * ListSize` равен `GetNumberOfElements()`;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` равен размеру векторов из `IProblem`.

### Свободные члены

```c++
CPtr<CDnnBlob> GetFreeTermData() const;
```

Свободные члены представляют собой блоб суммарного размера `GetNumberOfElements()`.

## Входы

Слой не имеет входов.

## Выходы

Слой имеет 3 выхода:

Первый выход содержит блоб с векторами из `IProblem` размера:

- `BatchWidth` равен `GetBatchSize()`;
- `Chahhels` равен `GetNumberOfElements()`;
- остальные размерности равны `1`.

Второй выход содержит блоб с классами векторов из `IProblem` с данными типа `GetLabelType()` размера:

- `BatchWidth` равен `GetBatchSize()`;
- `Channels` равен `1` если блоб имеет тип данных `int`, иначе `Channels` равен числу классов из `IProblem`;
- остальные размерности равны `1`.

Третий выход содержит блоб с весами векторов из `IProblem` размера:

- `BatchWidth` равен `GetBatchSize()`;
- остальные размерности равны `1`.
